/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.wikipedia.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.MasterDetailPane;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.mapton.addon.wikipedia.api.WikipediaArticle;
import org.mapton.addon.wikipedia.api.WikipediaArticleManager;
import org.mapton.api.Mapton;
import org.openide.util.Exceptions;
import se.trixon.almond.util.fx.FxHelper;

public final class WikipediaView
extends BorderPane {
    private final HashMap<String, Image> mImageCache = new HashMap();
    private ListView<WikipediaArticle> mListView;
    private WebView mWebView;
    private final WikipediaArticleManager mWikipediaArticleManager = WikipediaArticleManager.getInstance();

    public WikipediaView() {
        this.createUI();
        this.initListeners();
    }

    private void createUI() {
        this.mListView = new ListView();
        this.mListView.itemsProperty().bind((ObservableValue)this.mWikipediaArticleManager.allItemsProperty());
        this.mListView.setCellFactory(param -> new ArticleListCell());
        this.mListView.setPrefHeight((double)FxHelper.getUIScaled((int)300));
        this.mWebView = new WebView();
        this.mWebView.setZoom(FxHelper.getUIScaled((double)0.8));
        MasterDetailPane masterDetailPane = new MasterDetailPane(Side.TOP, this.mListView, (Node)this.mWebView, true);
        masterDetailPane.setDividerPosition(0.5);
        this.setCenter((Node)masterDetailPane);
    }

    private void initListeners() {
        this.mListView.getSelectionModel().selectedItemProperty().addListener((ov, oldValue, newValue) -> {
            this.mWikipediaArticleManager.setSelectedItem(newValue);
            Platform.runLater(() -> this.select((WikipediaArticle)newValue));
        });
        this.mWikipediaArticleManager.selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (this.mListView.getSelectionModel().getSelectedItem() != newValue) {
                this.mListView.getSelectionModel().select(newValue);
                this.mListView.getFocusModel().focus(this.mListView.getItems().indexOf(newValue));
                FxHelper.scrollToItemIfNotVisible(this.mListView, (Object)newValue);
            }
        });
    }

    private void select(WikipediaArticle article) {
        WebEngine engine = this.mWebView.getEngine();
        if (article == null) {
            engine.loadContent("");
        } else {
            Mapton.getEngine().panTo(article.getLatLon());
            String url = String.format(Locale.ENGLISH, "https://%s.m.wikipedia.org/wiki/%s", this.mWikipediaArticleManager.getLocale().getLanguage(), article.getTitle());
            Mapton.getLog().d("Wikipedia", url);
            Mapton.getLog().d("Wikipedia", article.getThumbnail());
            try {
                Document doc = Jsoup.connect((String)url).get();
                for (Element link : doc.select("a")) {
                    link.attr("href", link.attr("abs:href"));
                }
                for (Element link : doc.select("link")) {
                    link.attr("href", link.attr("abs:href"));
                }
                for (Element link : doc.select("img")) {
                    link.attr("src", link.attr("abs:src"));
                    link.attr("srcset", link.attr("abs:srcset"));
                }
                for (Element element : doc.getElementsByClass("header-container")) {
                    element.remove();
                }
                for (Element element : doc.getElementsByClass("page-actions-menu")) {
                    element.remove();
                }
                for (Element element : doc.select("#mw-mf-page-left")) {
                    element.remove();
                }
                engine.loadContent(doc.outerHtml());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    class ArticleListCell
    extends ListCell<WikipediaArticle> {
        private final BorderPane mBorderPane = new BorderPane();
        private final Label mDescLabel = new Label();
        private final ImageView mImageView = new ImageView();
        private final int mMaxSize = FxHelper.getUIScaled((int)50);
        private final StackPane mStackPane = new StackPane();
        private final Label mTitleLabel = new Label();

        public ArticleListCell() {
            this.createUI();
        }

        protected void updateItem(WikipediaArticle article, boolean empty) {
            super.updateItem((Object)article, empty);
            FxHelper.runLater(() -> {
                if (article == null || empty) {
                    this.clearContent();
                } else {
                    this.addContent(article);
                }
            });
        }

        private void addContent(WikipediaArticle article) {
            this.setText(null);
            this.mTitleLabel.setText(article.getTitle());
            Double distance = article.getDistance();
            String distanceString = distance >= 10000.0 ? "%.0f km".formatted(distance / 1000.0) : (distance >= 1000.0 ? "%.1f km".formatted(distance / 1000.0) : "%d m".formatted(distance.intValue()));
            if (StringUtils.isBlank((CharSequence)article.getDescription())) {
                this.mDescLabel.setText(distanceString);
            } else {
                this.mDescLabel.setText("%s, %s".formatted(distanceString, article.getDescription()));
            }
            String thumbnail = article.getThumbnail();
            if (StringUtils.isBlank((CharSequence)thumbnail)) {
                this.mStackPane.setPadding(new Insets(0.0, (double)this.mMaxSize, 0.0, 0.0));
                this.mImageView.setImage(null);
            } else {
                Image image = WikipediaView.this.mImageCache.computeIfAbsent(thumbnail, k -> new Image(article.getThumbnail(), (double)this.mMaxSize, (double)this.mMaxSize, true, true, true));
                String lowerCaseThumbnail = thumbnail.toLowerCase();
                String dim = StringUtils.containsIgnoreCase((CharSequence)lowerCaseThumbnail, (CharSequence)".jpg/") ? StringUtils.substringBetween((String)lowerCaseThumbnail, (String)".jpg/", (String)"px-") : (StringUtils.containsIgnoreCase((CharSequence)lowerCaseThumbnail, (CharSequence)".png/") ? StringUtils.substringBetween((String)lowerCaseThumbnail, (String)".png/", (String)"px-") : StringUtils.substringBetween((String)lowerCaseThumbnail, (String)".svg/", (String)"px-"));
                try {
                    double baseDim = 50.0;
                    double imgDim = Double.valueOf(dim);
                    double pad = (baseDim - imgDim) / 2.0;
                    if (pad > 0.0) {
                        this.mStackPane.setPadding(new Insets(0.0, pad, 0.0, pad));
                    } else {
                        this.mStackPane.setPadding(Insets.EMPTY);
                    }
                }
                catch (NullPointerException | NumberFormatException e) {
                    Mapton.getLog().e("Wikipedia", "Error while creating padding");
                    Mapton.getLog().v("Wikipedia", article.getTitle());
                    Mapton.getLog().v("Wikipedia", article.getThumbnail());
                }
                this.mImageView.setImage(image);
            }
            this.setGraphic((Node)this.mBorderPane);
        }

        private void clearContent() {
            this.setText(null);
            this.setGraphic(null);
            this.mImageView.setImage(null);
            this.mStackPane.setPadding(Insets.EMPTY);
        }

        private void createUI() {
            String fontFamily = Font.getDefault().getFamily();
            double fontSize = FxHelper.getScaledFontSize();
            this.mTitleLabel.setFont(Font.font((String)fontFamily, (FontWeight)FontWeight.NORMAL, (double)(fontSize * 1.2)));
            this.mDescLabel.setFont(Font.font((String)fontFamily, (FontWeight)FontWeight.NORMAL, (double)(fontSize * 0.9)));
            this.mDescLabel.setTextFill((Paint)Color.DARKGRAY.darker());
            VBox centerBox = new VBox(new Node[]{this.mTitleLabel, this.mDescLabel});
            centerBox.setAlignment(Pos.CENTER_LEFT);
            this.mStackPane.getChildren().add((Object)this.mImageView);
            this.mBorderPane.setLeft((Node)this.mStackPane);
            this.mBorderPane.setCenter((Node)centerBox);
            BorderPane.setMargin((Node)centerBox, (Insets)FxHelper.getUIScaledInsets((double)0.0, (double)0.0, (double)0.0, (double)8.0));
        }
    }
}

