/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.BasicFactory;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.util.Logging;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class BasicModel
extends WWObjectImpl
implements Model {
    private Globe globe;
    private LayerList layers;
    private boolean showWireframeInterior = false;
    private boolean showWireframeExterior = false;
    private boolean showTessellationBoundingVolumes = false;

    public BasicModel() {
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.GlobeClassName");
        if (string == null) {
            return;
        }
        this.setGlobe((Globe)WorldWind.createComponent(string));
        LayerList layerList = null;
        String string2 = Configuration.getStringValue("gov.nasa.worldwind.avkey.LayerClassNames");
        if (string2 != null) {
            layerList = this.createLayersFromProperties(string2);
        } else {
            Element element = Configuration.getElement("./LayerList");
            if (element != null) {
                layerList = this.createLayersFromElement(element);
            }
        }
        this.setLayers(layerList != null ? layerList : new LayerList());
    }

    public BasicModel(Globe globe, LayerList layerList) {
        this.setGlobe(globe);
        this.setLayers(layerList != null ? layerList : new LayerList());
    }

    protected LayerList createLayersFromElement(Element element) {
        LayerList[] layerListArray;
        Object object = BasicFactory.create("gov.nasa.worldwind.avkey.LayerFactory", element);
        if (object instanceof LayerList) {
            return (LayerList)object;
        }
        if (object instanceof Layer) {
            return new LayerList(new Layer[]{(Layer)object});
        }
        if (object instanceof LayerList[] && (layerListArray = (LayerList[])object).length > 0) {
            return LayerList.collapseLists((LayerList[])object);
        }
        return null;
    }

    protected LayerList createLayersFromProperties(String string) {
        String[] stringArray;
        LayerList layerList = new LayerList();
        if (string == null) {
            return null;
        }
        for (String string2 : stringArray = string.split(",")) {
            try {
                if (string2.length() <= 0) continue;
                Layer layer = (Layer)WorldWind.createComponent(string2);
                layerList.add(layer);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.WARNING, Logging.getMessage("BasicModel.LayerNotFound", string2), exception);
            }
        }
        return layerList;
    }

    @Override
    public void setGlobe(Globe globe) {
        if (this.globe != null) {
            this.globe.removePropertyChangeListener(this);
        }
        if (globe != null) {
            globe.addPropertyChangeListener(this);
        }
        Globe globe2 = this.globe;
        this.globe = globe;
        this.firePropertyChange("gov.nasa.worldwind.avkey.GlobeObject", globe2, this.globe);
    }

    @Override
    public void setLayers(LayerList layerList) {
        if (this.layers != null) {
            this.layers.removePropertyChangeListener(this);
        }
        if (layerList != null) {
            layerList.addPropertyChangeListener(this);
        }
        LayerList layerList2 = this.layers;
        this.layers = layerList;
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList2, this.layers);
    }

    @Override
    public Globe getGlobe() {
        return this.globe;
    }

    @Override
    public LayerList getLayers() {
        return this.layers;
    }

    @Override
    public void setShowWireframeInterior(boolean bl) {
        this.showWireframeInterior = bl;
    }

    @Override
    public void setShowWireframeExterior(boolean bl) {
        this.showWireframeExterior = bl;
    }

    @Override
    public boolean isShowWireframeInterior() {
        return this.showWireframeInterior;
    }

    @Override
    public boolean isShowWireframeExterior() {
        return this.showWireframeExterior;
    }

    @Override
    public boolean isShowTessellationBoundingVolumes() {
        return this.showTessellationBoundingVolumes;
    }

    @Override
    public void setShowTessellationBoundingVolumes(boolean bl) {
        this.showTessellationBoundingVolumes = bl;
    }

    @Override
    public Extent getExtent() {
        Extent extent;
        Object object;
        LayerList layerList = this.getLayers();
        if (layerList != null) {
            object = layerList.iterator();
            while (object.hasNext()) {
                extent = object.next();
                Layer layer = (Layer)((Object)extent);
                Extent extent2 = (Extent)layer.getValue("gov.nasa.worldwind.avkey.Extent");
                if (extent2 == null) continue;
                return extent2;
            }
        }
        if ((object = this.getGlobe()) != null && (extent = object.getExtent()) != null) {
            return extent;
        }
        return null;
    }

    @Override
    public void onMessage(Message message) {
        if (this.getLayers() != null) {
            for (Layer layer : this.getLayers()) {
                try {
                    if (layer == null) continue;
                    layer.onMessage(message);
                }
                catch (Exception exception) {
                    String string = Logging.getMessage("generic.ExceptionInvokingMessageListener");
                    Logging.logger().log(Level.SEVERE, string, exception);
                }
            }
        }
    }
}

