/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.AbstractSceneController;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe2D;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.terrain.SectorGeometryList;

public class BasicSceneController
extends AbstractSceneController {
    SectorGeometryList sglC;
    SectorGeometryList sglL;
    SectorGeometryList sglR;
    Sector visibleSectorC;
    Sector visibleSectorL;
    Sector visibleSectorR;

    @Override
    public void doRepaint(DrawContext drawContext) {
        this.initializeFrame(drawContext);
        try {
            if (drawContext.getGlobe() instanceof Globe2D && ((Globe2D)((Object)drawContext.getGlobe())).isContinuous()) {
                this.do2DContiguousRepaint(drawContext);
            } else {
                this.doNormalRepaint(drawContext);
            }
        }
        finally {
            this.finalizeFrame(drawContext);
        }
    }

    protected void doNormalRepaint(DrawContext drawContext) {
        this.applyView(drawContext);
        this.createPickFrustum(drawContext);
        this.createTerrain(drawContext);
        this.preRender(drawContext);
        if (!this.getView().isAnimating()) {
            this.clearFrame(drawContext);
            this.pick(drawContext);
        }
        this.clearFrame(drawContext);
        this.draw(drawContext);
    }

    protected void do2DContiguousRepaint(DrawContext drawContext) {
        ((Globe2D)((Object)drawContext.getGlobe())).setOffset(0);
        this.applyView(drawContext);
        this.createPickFrustum(drawContext);
        this.createTerrain2DContinuous(drawContext);
        this.preRender2DContiguous(drawContext);
        this.clearFrame(drawContext);
        this.pick2DContiguous(drawContext);
        this.clearFrame(drawContext);
        this.draw2DContiguous(drawContext);
    }

    protected void makeCurrent(DrawContext drawContext, int n) {
        ((Globe2D)((Object)drawContext.getGlobe())).setOffset(n);
        switch (n) {
            case -1: {
                drawContext.setSurfaceGeometry(this.sglL);
                drawContext.setVisibleSector(this.visibleSectorL);
                break;
            }
            case 0: {
                drawContext.setSurfaceGeometry(this.sglC);
                drawContext.setVisibleSector(this.visibleSectorC);
                break;
            }
            case 1: {
                drawContext.setSurfaceGeometry(this.sglR);
                drawContext.setVisibleSector(this.visibleSectorR);
            }
        }
    }

    protected void createTerrain2DContinuous(DrawContext drawContext) {
        this.sglC = null;
        this.visibleSectorC = null;
        ((Globe2D)((Object)drawContext.getGlobe())).setOffset(0);
        if (drawContext.getGlobe().intersects(drawContext.getView().getFrustumInModelCoordinates())) {
            this.sglC = drawContext.getModel().getGlobe().tessellate(drawContext);
            this.visibleSectorC = this.sglC.getSector();
        }
        this.sglR = null;
        this.visibleSectorR = null;
        ((Globe2D)((Object)drawContext.getGlobe())).setOffset(1);
        if (drawContext.getGlobe().intersects(drawContext.getView().getFrustumInModelCoordinates())) {
            this.sglR = drawContext.getModel().getGlobe().tessellate(drawContext);
            this.visibleSectorR = this.sglR.getSector();
        }
        this.sglL = null;
        this.visibleSectorL = null;
        ((Globe2D)((Object)drawContext.getGlobe())).setOffset(-1);
        if (drawContext.getGlobe().intersects(drawContext.getView().getFrustumInModelCoordinates())) {
            this.sglL = drawContext.getModel().getGlobe().tessellate(drawContext);
            this.visibleSectorL = this.sglL.getSector();
        }
    }

    protected void draw2DContiguous(DrawContext drawContext) {
        Object object = "";
        if (this.sglC != null) {
            object = (String)object + " 0 ";
            this.makeCurrent(drawContext, 0);
            this.setDeferOrderedRendering(this.sglL != null || this.sglR != null);
            this.draw(drawContext);
        }
        if (this.sglR != null) {
            object = (String)object + " 1 ";
            this.makeCurrent(drawContext, 1);
            this.setDeferOrderedRendering(this.sglL != null);
            this.draw(drawContext);
        }
        this.setDeferOrderedRendering(false);
        if (this.sglL != null) {
            object = (String)object + " -1 ";
            this.makeCurrent(drawContext, -1);
            this.draw(drawContext);
        }
    }

    protected void preRender2DContiguous(DrawContext drawContext) {
        if (this.sglC != null) {
            this.makeCurrent(drawContext, 0);
            this.preRender(drawContext);
        }
        if (this.sglR != null) {
            this.makeCurrent(drawContext, 1);
            this.preRender(drawContext);
        }
        if (this.sglL != null) {
            this.makeCurrent(drawContext, -1);
            this.preRender(drawContext);
        }
    }

    protected void pick2DContiguous(DrawContext drawContext) {
        if (this.sglC != null) {
            this.makeCurrent(drawContext, 0);
            this.setDeferOrderedRendering(this.sglL != null || this.sglR != null);
            this.pick(drawContext);
        }
        if (this.sglR != null) {
            this.makeCurrent(drawContext, 1);
            this.setDeferOrderedRendering(this.sglL != null);
            this.pick(drawContext);
        }
        this.setDeferOrderedRendering(false);
        if (this.sglL != null) {
            this.makeCurrent(drawContext, -1);
            this.pick(drawContext);
        }
    }
}

