/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Configuration {
    public static final String DEFAULT_LOGGER_NAME = "gov.nasa.worldwind";
    private static final String CONFIG_PROPERTIES_FILE_NAME = "config/worldwind.properties";
    private static final String CONFIG_FILE_PROPERTY_KEY = "gov.nasa.worldwind.config.file";
    private static final String CONFIG_WW_DOCUMENT_KEY = "gov.nasa.worldwind.config.document";
    private static final String CONFIG_WW_DOCUMENT_NAME = "config/worldwind.xml";
    private static final String CONFIG_APP_DOCUMENT_KEY = "gov.nasa.worldwind.app.config.document";
    private static Configuration ourInstance = new Configuration();
    private final Properties properties;
    private final ArrayList<Document> configDocs = new ArrayList();

    private static Configuration getInstance() {
        return ourInstance;
    }

    private Configuration() {
        this.properties = this.initializeDefaults();
        try {
            String string = System.getProperty(CONFIG_APP_DOCUMENT_KEY);
            if (string != null) {
                this.loadConfigDoc(System.getProperty(CONFIG_APP_DOCUMENT_KEY));
            }
        }
        catch (Exception exception) {
            Logging.logger(DEFAULT_LOGGER_NAME).log(Level.WARNING, "Configuration.ConfigNotFound", System.getProperty(CONFIG_APP_DOCUMENT_KEY));
        }
        try {
            this.loadConfigDoc(System.getProperty(CONFIG_WW_DOCUMENT_KEY, CONFIG_WW_DOCUMENT_NAME));
            for (int i = this.configDocs.size() - 1; i >= 0; --i) {
                this.loadConfigProperties(this.configDocs.get(i));
            }
        }
        catch (Exception exception) {
            Logging.logger(DEFAULT_LOGGER_NAME).log(Level.WARNING, "Configuration.ConfigNotFound", System.getProperty(CONFIG_WW_DOCUMENT_KEY));
        }
        this.initializeCustom();
    }

    private void loadConfigDoc(String string) {
        Document document;
        if (!WWUtil.isEmpty(string) && (document = WWXML.openDocument(string)) != null) {
            this.configDocs.add(document);
        }
    }

    private void insertConfigDoc(String string) {
        Document document;
        if (!WWUtil.isEmpty(string) && (document = WWXML.openDocument(string)) != null) {
            this.configDocs.add(0, document);
            this.loadConfigProperties(document);
        }
    }

    private void loadConfigProperties(Document document) {
        try {
            XPath xPath = WWXML.makeXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("/WorldWindConfiguration/Property", document, XPathConstants.NODESET);
            if (nodeList == null || nodeList.getLength() == 0) {
                return;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string = xPath.evaluate("@name", node);
                String string2 = xPath.evaluate("@value", node);
                if (WWUtil.isEmpty(string)) continue;
                this.properties.setProperty(string, string2);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            Logging.logger(DEFAULT_LOGGER_NAME).log(Level.WARNING, "XML.ParserConfigurationException");
        }
    }

    private Properties initializeDefaults() {
        Properties properties = new Properties();
        TimeZone timeZone = Calendar.getInstance().getTimeZone();
        if (timeZone != null) {
            properties.setProperty("gov.nasa.worldwind.avkey.InitialLongitude", Double.toString(Angle.fromDegrees((double)(180.0 * (double)timeZone.getOffset((long)System.currentTimeMillis()) / 4.32E7)).degrees));
        }
        return properties;
    }

    private void initializeCustom() {
        String string = System.getProperty(CONFIG_FILE_PROPERTY_KEY, CONFIG_PROPERTIES_FILE_NAME);
        try {
            InputStream inputStream = null;
            File file = new File(string);
            if (file.exists()) {
                try {
                    inputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Logging.logger(DEFAULT_LOGGER_NAME).log(Level.FINEST, "Configuration.LocalConfigFileNotFound", string);
                }
            }
            if (inputStream == null) {
                inputStream = this.getClass().getResourceAsStream("/" + string);
            }
            if (inputStream != null) {
                this.properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            Logging.logger(DEFAULT_LOGGER_NAME).log(Level.SEVERE, "Configuration.ExceptionReadingPropsFile", iOException);
        }
    }

    public static void insertConfigurationDocument(String string) {
        Configuration.getInstance().insertConfigDoc(string);
    }

    public static synchronized String getStringValue(String string, String string2) {
        String string3 = Configuration.getStringValue(string);
        return string3 != null ? string3 : string2;
    }

    public static synchronized String getStringValue(String string) {
        String string2 = Configuration.getInstance().properties.getProperty(string);
        return string2 != null ? string2.toString() : null;
    }

    public static synchronized Integer getIntegerValue(String string, Integer n) {
        Integer n2 = Configuration.getIntegerValue(string);
        return n2 != null ? n2 : n;
    }

    public static synchronized Integer getIntegerValue(String string) {
        String string2 = Configuration.getStringValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", string2);
            return null;
        }
    }

    public static synchronized Long getLongValue(String string, Long l) {
        Long l2 = Configuration.getLongValue(string);
        return l2 != null ? l2 : l;
    }

    public static synchronized Long getLongValue(String string) {
        String string2 = Configuration.getStringValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", string2);
            return null;
        }
    }

    public static synchronized Double getDoubleValue(String string, Double d) {
        Double d2 = Configuration.getDoubleValue(string);
        return d2 != null ? d2 : d;
    }

    public static synchronized Double getDoubleValue(String string) {
        String string2 = Configuration.getStringValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", string2);
            return null;
        }
    }

    public static synchronized Boolean getBooleanValue(String string, Boolean bl) {
        Boolean bl2 = Configuration.getBooleanValue(string);
        return bl2 != null ? bl2 : bl;
    }

    public static synchronized Boolean getBooleanValue(String string) {
        String string2 = Configuration.getStringValue(string);
        if (string2 == null) {
            return null;
        }
        if (string2.trim().toUpperCase().startsWith("T") || string2.trim().equals("1")) {
            return true;
        }
        if (string2.trim().toUpperCase().startsWith("F") || string2.trim().equals("0")) {
            return false;
        }
        Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", string2);
        return null;
    }

    public static synchronized boolean hasKey(String string) {
        return Configuration.getInstance().properties.contains(string);
    }

    public static synchronized void removeKey(String string) {
        Configuration.getInstance().properties.remove(string);
    }

    public static synchronized void setValue(String string, Object object) {
        Configuration.getInstance().properties.put(string, object.toString());
    }

    public static String getCurrentWorkingDirectory() {
        String string = System.getProperty("user.dir");
        return string != null ? string : ".";
    }

    public static String getUserHomeDirectory() {
        String string = System.getProperty("user.home");
        return string != null ? string : ".";
    }

    public static String getSystemTempDirectory() {
        String string = System.getProperty("java.io.tmpdir");
        return string != null ? string : ".";
    }

    public static String getCurrentUserAppDataDirectory() {
        if (Configuration.isMacOS()) {
            return Configuration.getUserHomeDirectory() + "/Library/Application Support";
        }
        if (Configuration.isWindowsOS()) {
            return Configuration.getUserHomeDirectory() + "\\Application Data";
        }
        if (Configuration.isLinuxOS() || Configuration.isUnixOS() || Configuration.isSolarisOS()) {
            return Configuration.getUserHomeDirectory();
        }
        String string = Logging.getMessage("generic.UnknownOperatingSystem");
        Logging.logger().fine(string);
        return null;
    }

    public static boolean isMacOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("mac");
    }

    public static boolean isWindowsOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("windows");
    }

    public static boolean isWindowsXPOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("windows") && string.contains("xp");
    }

    public static boolean isWindowsVistaOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("windows") && string.contains("vista");
    }

    public static boolean isWindows7OS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("windows") && string.contains("7");
    }

    public static boolean isLinuxOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("linux");
    }

    public static boolean isUnixOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("unix");
    }

    public static boolean isSolarisOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("solaris");
    }

    public static float getJavaVersion() {
        float f = 0.0f;
        String string = System.getProperty("java.specification.version");
        if (null == string || string.length() == 0) {
            string = System.getProperty("java.version");
        }
        try {
            f = Float.parseFloat(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f;
    }

    public static GLProfile getMaxCompatibleGLProfile() {
        return GLProfile.getMaxFixedFunc(true);
    }

    public static GLCapabilities getRequiredGLCapabilities() {
        GLCapabilities gLCapabilities = new GLCapabilities(Configuration.getMaxCompatibleGLProfile());
        gLCapabilities.setAlphaBits(8);
        gLCapabilities.setRedBits(8);
        gLCapabilities.setGreenBits(8);
        gLCapabilities.setBlueBits(8);
        gLCapabilities.setDepthBits(24);
        gLCapabilities.setDoubleBuffered(true);
        String string = System.getProperty("gov.nasa.worldwind.stereo.mode");
        if ("device".equals(string)) {
            gLCapabilities.setStereo(true);
        }
        return gLCapabilities;
    }

    public static Element getElement(String string) {
        XPath xPath = WWXML.makeXPath();
        for (Document document : Configuration.getInstance().configDocs) {
            try {
                Node node = (Node)xPath.evaluate(string, document.getDocumentElement(), XPathConstants.NODE);
                if (node == null) continue;
                return (Element)node;
            }
            catch (XPathExpressionException xPathExpressionException) {
                return null;
            }
        }
        return null;
    }
}

