/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.AWTGLAutoDrawable;
import com.jogamp.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.WorldWindowGLDrawable;
import gov.nasa.worldwind.WorldWindowImpl;
import gov.nasa.worldwind.cache.GpuResourceCache;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.exception.WWAbsentRequirementException;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.ScreenCreditController;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.dashboard.DashboardController;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.Timer;

public class WorldWindowGLAutoDrawable
extends WorldWindowImpl
implements WorldWindowGLDrawable,
GLEventListener {
    public static final long DEFAULT_VIEW_STOP_TIME = 1000L;
    private GLAutoDrawable drawable;
    private DashboardController dashboard;
    private boolean shuttingDown = false;
    private Timer redrawTimer = new Timer(Integer.MAX_VALUE, actionEvent -> this.redraw());
    private boolean firstInit = true;
    protected long viewStopTime = 1000L;
    protected long lastViewID;
    protected ScheduledFuture viewRefreshTask;
    protected boolean enableGpuCacheReinitialization = true;

    public WorldWindowGLAutoDrawable() {
        SceneController sceneController = this.getSceneController();
        if (sceneController != null) {
            sceneController.addPropertyChangeListener(this);
        }
        this.redrawTimer.setRepeats(false);
        this.redrawTimer.setCoalesce(true);
    }

    public long getViewStopTime() {
        return this.viewStopTime;
    }

    public void setViewStopTime(long l) {
        this.viewStopTime = l;
    }

    @Override
    public void initDrawable(GLAutoDrawable gLAutoDrawable) {
        if (gLAutoDrawable == null) {
            String string = Logging.getMessage("nullValue.DrawableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.drawable = gLAutoDrawable;
        this.drawable.setAutoSwapBufferMode(false);
        this.drawable.addGLEventListener(this);
    }

    @Override
    public boolean isEnableGpuCacheReinitialization() {
        return this.enableGpuCacheReinitialization;
    }

    @Override
    public void setEnableGpuCacheReinitialization(boolean bl) {
        this.enableGpuCacheReinitialization = bl;
    }

    @Override
    public void initGpuResourceCache(GpuResourceCache gpuResourceCache) {
        if (gpuResourceCache == null) {
            String string = Logging.getMessage("nullValue.GpuResourceCacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setGpuResourceCache(gpuResourceCache);
    }

    @Override
    public void endInitialization() {
        this.initializeCreditsController();
        this.dashboard = new DashboardController(this, (Component)((Object)this.drawable));
    }

    protected void initializeCreditsController() {
        new ScreenCreditController((WorldWindow)((Object)this.drawable));
    }

    @Override
    public void shutdown() {
        this.shuttingDown = true;
        this.redrawNow();
    }

    protected void doShutdown() {
        super.shutdown();
        this.drawable.removeGLEventListener(this);
        if (this.dashboard != null) {
            this.dashboard.dispose();
        }
        if (this.viewRefreshTask != null) {
            this.viewRefreshTask.cancel(false);
        }
        this.shuttingDown = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            String string = Logging.getMessage("nullValue.PropertyChangeEventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.redraw();
    }

    @Override
    public GLContext getContext() {
        return this.drawable.getContext();
    }

    protected boolean isGLContextCompatible(GLContext gLContext) {
        return gLContext != null && gLContext.isGL2();
    }

    protected String[] getRequiredOglFunctions() {
        return new String[]{"glActiveTexture", "glClientActiveTexture"};
    }

    protected String[] getRequiredOglExtensions() {
        return new String[0];
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        if (!this.isGLContextCompatible(gLAutoDrawable.getContext())) {
            String object = Logging.getMessage("WorldWindowGLAutoDrawable.IncompatibleGLContext", gLAutoDrawable.getContext());
            this.callRenderingExceptionListeners(new WWAbsentRequirementException(object));
        }
        for (String string : this.getRequiredOglFunctions()) {
            if (gLAutoDrawable.getGL().isFunctionAvailable(string)) continue;
            this.callRenderingExceptionListeners(new WWAbsentRequirementException(string + " not available"));
        }
        for (String string : this.getRequiredOglExtensions()) {
            if (gLAutoDrawable.getGL().isExtensionAvailable(string)) continue;
            this.callRenderingExceptionListeners(new WWAbsentRequirementException(string + " not available"));
        }
        if (this.firstInit) {
            this.firstInit = false;
        } else if (this.enableGpuCacheReinitialization) {
            this.reinitialize(gLAutoDrawable);
        }
        TextureIO.setTexRectEnabled(false);
    }

    protected void reinitialize(GLAutoDrawable gLAutoDrawable) {
        if (this.getGpuResourceCache() != null) {
            this.getGpuResourceCache().clear();
        }
        this.getSceneController().reinitialize();
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        if (this.shuttingDown) {
            try {
                this.doShutdown();
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("WorldWindowGLCanvas.ExceptionWhileShuttingDownWorldWindow"), exception);
            }
            return;
        }
        try {
            Collection<Throwable> collection;
            Double d;
            SceneController sceneController = this.getSceneController();
            if (sceneController == null) {
                String string = Logging.getMessage("WorldWindowGLCanvas.ScnCntrllerNullOnRepaint");
                Logging.logger().severe(string);
                throw new IllegalStateException(string);
            }
            this.checkForViewChange();
            Position position = this.getCurrentPosition();
            PickedObject pickedObject = this.getCurrentSelection();
            PickedObjectList pickedObjectList = this.getCurrentBoxSelection();
            try {
                this.callRenderingListeners(new RenderingEvent(this.drawable, "gov.nasa.worldwind.RenderingEvent.BeforeRendering"));
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("WorldWindowGLAutoDrawable.ExceptionDuringGLEventListenerDisplay"), exception);
            }
            int n = this.doDisplay();
            if (n > 0 && !this.redrawTimer.isRunning()) {
                this.redrawTimer.setInitialDelay(n);
                this.redrawTimer.start();
            }
            try {
                this.callRenderingListeners(new RenderingEvent(this.drawable, "gov.nasa.worldwind.RenderingEvent.BeforeBufferSwap"));
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("WorldWindowGLAutoDrawable.ExceptionDuringGLEventListenerDisplay"), exception);
            }
            this.doSwapBuffers(this.drawable);
            Double d2 = sceneController.getFrameTime();
            if (d2 != null) {
                this.setValue("gov.nasa.worldwind.perfstat.FrameTime", d2);
            }
            if ((d = Double.valueOf(sceneController.getFramesPerSecond())) != null) {
                this.setValue("gov.nasa.worldwind.perfstat.FrameRate", d);
            }
            if ((collection = sceneController.getRenderingExceptions()) != null) {
                for (Throwable object2 : collection) {
                    if (object2 == null) continue;
                    this.callRenderingExceptionListeners(object2);
                }
            }
            this.callRenderingListeners(new RenderingEvent(this.drawable, "gov.nasa.worldwind.RenderingEvent.AfterBufferSwap"));
            Position position2 = this.getCurrentPosition();
            if (position != null || position2 != null) {
                if (position != null && position2 != null) {
                    if (!position.equals(position2)) {
                        this.callPositionListeners(new PositionEvent(this.drawable, sceneController.getPickPoint(), position, position2));
                    }
                } else {
                    this.callPositionListeners(new PositionEvent(this.drawable, sceneController.getPickPoint(), position, position2));
                }
            }
            PickedObject pickedObject2 = this.getCurrentSelection();
            if (pickedObject != null || pickedObject2 != null) {
                this.callSelectListeners(new SelectEvent((Object)this.drawable, "gov.nasa.worldwind.SelectEvent.Rollover", sceneController.getPickPoint(), sceneController.getPickedObjectList()));
            }
            PickedObjectList pickedObjectList2 = this.getCurrentBoxSelection();
            if (pickedObjectList != null || pickedObjectList2 != null) {
                this.callSelectListeners(new SelectEvent((Object)this.drawable, "gov.nasa.worldwind.SelectEvent.BoxRollover", sceneController.getPickRectangle(), sceneController.getObjectsInPickRectangle()));
            }
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("WorldWindowGLCanvas.ExceptionAttemptingRepaintWorldWindow"), exception);
        }
    }

    protected void checkForViewChange() {
        long l = this.getView().getViewStateID();
        if (l != this.lastViewID) {
            this.lastViewID = l;
            this.scheduleViewStopTask(this.getViewStopTime());
        }
    }

    protected int doDisplay() {
        return this.getSceneController().repaint();
    }

    protected void doSwapBuffers(GLAutoDrawable gLAutoDrawable) {
        gLAutoDrawable.swapBuffers();
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        ((Component)((Object)gLAutoDrawable)).setMinimumSize(new Dimension(0, 0));
    }

    @Override
    public void redraw() {
        if (this.drawable != null) {
            ((AWTGLAutoDrawable)this.drawable).repaint();
        }
    }

    @Override
    public void redrawNow() {
        if (this.drawable != null) {
            this.drawable.display();
        }
    }

    protected void scheduleViewStopTask(long l) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WorldWindowGLAutoDrawable.this.onMessage(new Message("gov.nasa.worldwind.View.ViewStopped", WorldWindowGLAutoDrawable.this));
                    }
                });
            }
        };
        if (this.viewRefreshTask != null) {
            this.viewRefreshTask.cancel(false);
        }
        this.viewRefreshTask = WorldWind.getScheduledTaskService().addScheduledTask(runnable, l, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onMessage(Message message) {
        Model model = this.getModel();
        if (model != null) {
            model.onMessage(message);
        }
    }
}

