/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.animation;

import gov.nasa.worldwind.animation.BasicAnimator;
import gov.nasa.worldwind.animation.Interpolator;
import gov.nasa.worldwind.animation.ScheduledInterpolator;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PropertyAccessor;

public class AngleAnimator
extends BasicAnimator {
    protected Angle begin;
    protected Angle end;
    protected final PropertyAccessor.AngleAccessor propertyAccessor;

    public AngleAnimator(Interpolator interpolator, Angle angle, Angle angle2, PropertyAccessor.AngleAccessor angleAccessor) {
        super(interpolator);
        if (interpolator == null) {
            this.interpolator = new ScheduledInterpolator(10000L);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angleAccessor == null) {
            String string = Logging.getMessage("nullValue.ViewPropertyAccessorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.begin = angle;
        this.end = angle2;
        this.propertyAccessor = angleAccessor;
    }

    public void setBegin(Angle angle) {
        this.begin = angle;
    }

    public void setEnd(Angle angle) {
        this.end = angle;
    }

    public Angle getBegin() {
        return this.begin;
    }

    public Angle getEnd() {
        return this.end;
    }

    public PropertyAccessor.AngleAccessor getPropertyAccessor() {
        return this.propertyAccessor;
    }

    @Override
    protected void setImpl(double d) {
        Angle angle = this.nextAngle(d);
        if (angle == null) {
            return;
        }
        boolean bl = this.propertyAccessor.setAngle(angle);
        if (!bl) {
            this.flagLastStateInvalid();
        }
        if (d >= 1.0) {
            this.stop();
        }
    }

    private Angle nextAngle(double d) {
        return Angle.mix(d, this.begin, this.end);
    }
}

