/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.AbstractDataRasterReader;
import gov.nasa.worldwind.data.ByteBufferRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.formats.dted.DTED;
import gov.nasa.worldwind.util.ElevationsUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class DTEDRasterReader
extends AbstractDataRasterReader {
    protected static final String[] dtedMimeTypes = new String[]{"application/dted", "application/dt0", "application/dted-0", "application/dt1", "application/dted-1", "application/dt2", "application/dted-2"};
    protected static final String[] dtedSuffixes = new String[]{"dt0", "dt1", "dt2"};

    public DTEDRasterReader() {
        super(dtedMimeTypes, dtedSuffixes);
    }

    @Override
    protected boolean doCanRead(Object object, AVList aVList) {
        File file = this.getFile(object);
        if (null == file) {
            return false;
        }
        if (this.canReadSuffix(object)) {
            if (null != aVList) {
                aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
            }
            return true;
        }
        boolean bl = false;
        try {
            AVList aVList2 = DTED.readMetadata(file);
            if (null != aVList2) {
                if (null != aVList) {
                    aVList.setValues(aVList2);
                }
                bl = "gov.nasa.worldwind.avkey.Elevation".equals(aVList2.getValue("gov.nasa.worldwind.avkey.PixelFormat"));
            }
        }
        catch (Throwable throwable) {
            Logging.logger().finest(throwable.getMessage());
            bl = false;
        }
        return bl;
    }

    @Override
    protected DataRaster[] doRead(Object object, AVList aVList) throws IOException {
        File file = this.getFile(object);
        if (null == file) {
            String string = Logging.getMessage("generic.UnrecognizedSourceTypeOrUnavailableSource", object);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        DataRaster dataRaster = DTED.read(file, aVList);
        if (dataRaster instanceof ByteBufferRaster) {
            ElevationsUtil.rectify((ByteBufferRaster)dataRaster);
        }
        return new DataRaster[]{dataRaster};
    }

    @Override
    protected void doReadMetadata(Object object, AVList aVList) throws IOException {
        File file = this.getFile(object);
        if (null == file) {
            String string = Logging.getMessage("generic.UnrecognizedSourceTypeOrUnavailableSource", object);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        AVList aVList2 = DTED.readMetadata(file);
        if (null != aVList2 && null != aVList) {
            aVList.setValues(aVList2);
        }
    }

    protected File getFile(Object object) {
        if (null == object) {
            return null;
        }
        if (object instanceof File) {
            return (File)object;
        }
        if (object instanceof URL) {
            return WWIO.convertURLToFile((URL)object);
        }
        return null;
    }

    @Override
    protected String validateMetadata(Object object, AVList aVList) {
        return null;
    }
}

