/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.gdal.GDALUtils;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.gdal.gdal.Dataset;
import org.gdal.osr.CoordinateTransformation;
import org.gdal.osr.SpatialReference;

public class GDAL {
    public static final int GT_SIZE = 6;
    public static final int GT_0_ORIGIN_LON = 0;
    public static final int GT_1_PIXEL_WIDTH = 1;
    public static final int GT_2_ROTATION_X = 2;
    public static final int GT_3_ORIGIN_LAT = 3;
    public static final int GT_4_ROTATION_Y = 4;
    public static final int GT_5_PIXEL_HEIGHT = 5;

    private GDAL() {
    }

    public static Point2D[] computeCornersFromGeotransform(double[] dArray, int n, int n2) {
        if (null == dArray || dArray.length != 6) {
            return null;
        }
        if (dArray[5] > 0.0) {
            dArray[5] = -dArray[5];
        }
        Point2D[] point2DArray = new Point2D[]{GDAL.getGeoPointForRasterPoint(dArray, 0, n2), GDAL.getGeoPointForRasterPoint(dArray, n, n2), GDAL.getGeoPointForRasterPoint(dArray, n, 0), GDAL.getGeoPointForRasterPoint(dArray, 0, 0)};
        return point2DArray;
    }

    public static Point2D getGeoPointForRasterPoint(double[] dArray, int n, int n2) {
        Point2D.Double double_ = null;
        if (null != dArray && dArray.length == 6) {
            double d = dArray[0] + dArray[1] * (double)n + dArray[2] * (double)n2;
            double d2 = dArray[3] + dArray[4] * (double)n + dArray[5] * (double)n2;
            double_ = new Point2D.Double(d, d2);
        }
        return double_;
    }

    public static AffineTransform getAffineTransform(Dataset dataset) throws IllegalArgumentException {
        if (null == dataset) {
            String string = Logging.getMessage("nullValue.DataSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[6];
        dataset.GetGeoTransform(dArray);
        return new AffineTransform(dArray[1], dArray[4], dArray[2], dArray[5] > 0.0 ? -dArray[5] : dArray[5], dArray[0], dArray[3]);
    }

    public static AffineTransform getAffineTransform(Dataset dataset, int n, int n2) throws IllegalArgumentException {
        if (null == dataset) {
            String string = Logging.getMessage("nullValue.DataSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n <= 0) {
            String string = Logging.getMessage("generic.InvalidWidth", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 <= 0) {
            String string = Logging.getMessage("generic.InvalidHeight", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AffineTransform affineTransform = GDAL.getAffineTransform(dataset);
        if (null != affineTransform) {
            double d = (double)dataset.getRasterYSize() / (double)n2;
            double d2 = (double)dataset.getRasterXSize() / (double)n;
            affineTransform.scale(d2, d);
        }
        return affineTransform;
    }

    public static double getMinX(Point2D[] point2DArray) throws IllegalArgumentException {
        if (null == point2DArray) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = Double.MAX_VALUE;
        for (Point2D point2D : point2DArray) {
            d = point2D.getX() < d ? point2D.getX() : d;
        }
        return d;
    }

    public static double getMaxX(Point2D[] point2DArray) throws IllegalArgumentException {
        if (null == point2DArray) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = -1.7976931348623157E308;
        for (Point2D point2D : point2DArray) {
            d = point2D.getX() > d ? point2D.getX() : d;
        }
        return d;
    }

    public static double getMinY(Point2D[] point2DArray) throws IllegalArgumentException {
        if (null == point2DArray) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = Double.MAX_VALUE;
        for (Point2D point2D : point2DArray) {
            d = point2D.getY() < d ? point2D.getY() : d;
        }
        return d;
    }

    public static double getMaxY(Point2D[] point2DArray) throws IllegalArgumentException {
        if (null == point2DArray) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = -1.7976931348623157E308;
        for (Point2D point2D : point2DArray) {
            d = point2D.getY() > d ? point2D.getY() : d;
        }
        return d;
    }

    public static class Area {
        protected SpatialReference srs;
        protected Point2D[] corners = null;
        protected Sector bbox = null;

        public Area(SpatialReference spatialReference, Dataset dataset) throws IllegalArgumentException {
            Object object;
            if (null == dataset) {
                String string = Logging.getMessage("nullValue.DataSetIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (null == spatialReference) {
                object = dataset.GetProjectionRef();
                if (null != object && ((String)object).length() > 0) {
                    spatialReference = new SpatialReference((String)object);
                }
                if (null == spatialReference) {
                    String string = Logging.getMessage("nullValue.SpatialReferenceIsNull");
                    Logging.logger().severe(string);
                    throw new IllegalArgumentException(string);
                }
            }
            if (spatialReference.IsGeographic() == 0 && spatialReference.IsProjected() == 0) {
                object = Logging.getMessage("generic.UnexpectedCoordinateSystem", spatialReference.ExportToWkt());
                Logging.logger().severe((String)object);
                throw new IllegalArgumentException((String)object);
            }
            this.srs = spatialReference.Clone();
            object = new double[6];
            dataset.GetGeoTransform((double[])object);
            this.corners = GDAL.computeCornersFromGeotransform((double[])object, dataset.getRasterXSize(), dataset.getRasterYSize());
            this.bbox = Area.calcBoundingSector(spatialReference, this.corners);
        }

        public static Sector calcBoundingSector(SpatialReference spatialReference, Point2D[] point2DArray) throws IllegalArgumentException, WWRuntimeException {
            if (null == spatialReference) {
                String string = Logging.getMessage("nullValue.SpatialReferenceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (null == point2DArray) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            Sector sector = null;
            try {
                double d = Double.MAX_VALUE;
                double d2 = -1.7976931348623157E308;
                double d3 = Double.MAX_VALUE;
                double d4 = -1.7976931348623157E308;
                CoordinateTransformation coordinateTransformation = new CoordinateTransformation(spatialReference, GDALUtils.createGeographicSRS());
                for (Point2D point2D : point2DArray) {
                    double[] dArray = coordinateTransformation.TransformPoint(point2D.getX(), point2D.getY());
                    if (null == dArray) continue;
                    d = dArray[0] < d ? dArray[0] : d;
                    d2 = dArray[0] > d2 ? dArray[0] : d2;
                    d3 = dArray[1] < d3 ? dArray[1] : d3;
                    d4 = dArray[1] > d4 ? dArray[1] : d4;
                }
                sector = Sector.fromDegrees(d3, d4, d, d2);
            }
            catch (Throwable throwable) {
                String string = GDALUtils.getErrorMessage();
                String string2 = null != string && string.length() > 0 ? string : throwable.getMessage();
                String string3 = Logging.getMessage("generic.ExceptionWhileTransformation", string2);
                Logging.logger().severe(string3);
                throw new WWRuntimeException(string3);
            }
            return sector;
        }

        protected Area(SpatialReference spatialReference, double d, double d2, double d3, double d4) throws IllegalArgumentException {
            if (null == spatialReference) {
                String string = Logging.getMessage("nullValue.SpatialReferenceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (spatialReference.IsGeographic() == 0 && spatialReference.IsProjected() == 0) {
                String string = Logging.getMessage("generic.UnexpectedCoordinateSystem", spatialReference.ExportToWkt());
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.srs = spatialReference.Clone();
            this.makeCorners(d, d2, d3, d4);
            this.bbox = this.srs.IsGeographic() > 0 ? Sector.fromDegrees(d, d2, d3, d4) : Area.calcBoundingSector(this.srs, this.corners);
        }

        protected void makeCorners(double d, double d2, double d3, double d4) {
            double d5 = Math.min(d3, d4);
            double d6 = Math.max(d3, d4);
            double d7 = Math.min(d, d2);
            double d8 = Math.max(d, d2);
            this.corners = new Point2D[]{new Point2D.Double(d5, d7), new Point2D.Double(d6, d7), new Point2D.Double(d6, d8), new Point2D.Double(d5, d8)};
        }

        public Area(SpatialReference spatialReference, Sector sector) throws IllegalArgumentException {
            if (null == sector) {
                String string = Logging.getMessage("nullValue.SectorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (null == spatialReference) {
                String string = Logging.getMessage("nullValue.SpatialReferenceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (spatialReference.IsGeographic() == 0 && spatialReference.IsProjected() == 0) {
                String string = Logging.getMessage("generic.UnexpectedCoordinateSystem", spatialReference.ExportToWkt());
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.srs = spatialReference;
            this.bbox = sector;
            SpatialReference spatialReference2 = GDALUtils.createGeographicSRS();
            CoordinateTransformation coordinateTransformation = new CoordinateTransformation(spatialReference2, this.srs);
            double d = Double.MAX_VALUE;
            double d2 = -1.7976931348623157E308;
            double d3 = Double.MAX_VALUE;
            double d4 = -1.7976931348623157E308;
            for (LatLon latLon : sector.getCorners()) {
                double[] dArray = coordinateTransformation.TransformPoint(latLon.getLongitude().degrees, latLon.getLatitude().degrees);
                if (null == dArray) continue;
                d = dArray[0] < d ? dArray[0] : d;
                d2 = dArray[0] > d2 ? dArray[0] : d2;
                d3 = dArray[1] < d3 ? dArray[1] : d3;
                d4 = dArray[1] > d4 ? dArray[1] : d4;
            }
            this.makeCorners(d3, d4, d, d2);
        }

        public boolean isGeographic() {
            return null != this.srs && this.srs.IsGeographic() > 0;
        }

        public boolean isProjected() {
            return null != this.srs && this.srs.IsProjected() > 0;
        }

        public SpatialReference getSpatialReference() {
            return this.srs.Clone();
        }

        public Sector getSector() {
            return this.bbox;
        }

        public Area getBoundingArea() {
            return new Area(this.srs.Clone(), this.getMinY(), this.getMaxY(), this.getMinX(), this.getMaxX());
        }

        public Point2D[] getCorners() {
            return (Point2D[])this.corners.clone();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("Area { ");
            for (Point2D point2D : this.corners) {
                stringBuffer.append('(').append(point2D.getX()).append(',').append(point2D.getY()).append(") ");
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }

        public double getMinX() {
            return GDAL.getMinX(this.corners);
        }

        public double getMaxX() {
            return GDAL.getMaxX(this.corners);
        }

        public double getMinY() {
            return GDAL.getMinY(this.corners);
        }

        public double getMaxY() {
            return GDAL.getMaxY(this.corners);
        }

        public Area intersection(Sector sector) throws WWRuntimeException {
            return this.intersection(new Area(this.srs, sector));
        }

        public Area intersection(Area area) throws WWRuntimeException {
            double d;
            double d2;
            if (null == area) {
                return null;
            }
            if (this.srs.IsSame(area.getSpatialReference()) == 0) {
                String string = Logging.getMessage("generic.SectorMismatch", this, area);
                Logging.logger().severe(string);
                throw new WWRuntimeException(string);
            }
            double d3 = Math.max(this.getMinY(), area.getMinY());
            if (d3 > (d2 = Math.min(this.getMaxY(), area.getMaxY()))) {
                return null;
            }
            double d4 = Math.max(this.getMinX(), area.getMinX());
            if (d4 > (d = Math.min(this.getMaxX(), area.getMaxX()))) {
                return null;
            }
            return new Area(this.srs.Clone(), d3, d2, d4, d);
        }

        public boolean contains(Area area) throws WWRuntimeException {
            if (null == area) {
                return false;
            }
            if (this.srs.IsSame(area.getSpatialReference()) == 0) {
                String string = Logging.getMessage("generic.SectorMismatch", this, area);
                Logging.logger().severe(string);
                throw new WWRuntimeException(string);
            }
            if (area.getMinX() < this.getMinX()) {
                return false;
            }
            if (area.getMaxX() > this.getMaxX()) {
                return false;
            }
            if (area.getMinY() < this.getMinY()) {
                return false;
            }
            return !(area.getMaxY() > this.getMaxY());
        }

        public AffineTransform computeGeoToRasterTransform(int n, int n2) {
            double d = -this.getMaxY();
            double d2 = -this.getMinX();
            double d3 = this.getMaxX() - this.getMinX();
            double d4 = this.getMaxY() - this.getMinY();
            if (d3 == 0.0 || d4 == 0.0) {
                return null;
            }
            double d5 = -((double)n2 / d4);
            double d6 = (double)n / d3;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(d6, d5);
            affineTransform.translate(d2, d);
            return affineTransform;
        }

        public Rectangle computeClipRect(int n, int n2, Area area) throws IllegalArgumentException {
            if (null == area) {
                String string = Logging.getMessage("nullValue.AreaIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            AffineTransform affineTransform = this.computeGeoToRasterTransform(n, n2);
            Point2D.Double double_ = new Point2D.Double();
            Point2D.Double double_2 = new Point2D.Double();
            Point2D.Double double_3 = new Point2D.Double();
            ((Point2D)double_).setLocation(area.getMinX(), area.getMaxY());
            affineTransform.transform(double_, double_2);
            ((Point2D)double_).setLocation(area.getMaxX(), area.getMinY());
            affineTransform.transform(double_, double_3);
            int n3 = (int)Math.floor(((Point2D)double_2).getX());
            int n4 = (int)Math.floor(((Point2D)double_2).getY());
            int n5 = (int)Math.ceil(((Point2D)double_3).getX() - ((Point2D)double_2).getX());
            int n6 = (int)Math.ceil(((Point2D)double_3).getY() - ((Point2D)double_2).getY());
            return new Rectangle(n3, n4, n5, n6);
        }
    }
}

