/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.AttributesOnlyXMLEventParser;
import gov.nasa.worldwind.util.xml.BasicXMLEventParserContext;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class RasterServerConfiguration
extends AbstractXMLEventParser {
    protected static String namespaceURI;
    protected XMLEventReader eventReader;
    protected XMLEventParserContext parserContext;
    protected HashMap<String, String> properties = new HashMap();

    public RasterServerConfiguration(Object object) {
        super(namespaceURI);
        this.eventReader = this.createReader(object);
        this.initialize();
    }

    protected void initialize() {
        this.parserContext = this.createParserContext(this.eventReader);
    }

    protected XMLEventReader createReader(Object object) {
        return WWXML.openEventReader(object);
    }

    protected XMLEventParserContext createParserContext(XMLEventReader xMLEventReader) {
        this.parserContext = new BasicXMLEventParserContext(xMLEventReader);
        this.parserContext.setDefaultNamespaceURI(this.getNamespaceURI());
        return this.parserContext;
    }

    public XMLEventParserContext getParserContext() {
        return this.parserContext;
    }

    public String getVersion() {
        return (String)this.getField("version");
    }

    public Sector getSector() {
        RasterSector rasterSector = (RasterSector)this.getField("Sector");
        return rasterSector != null ? rasterSector.getSector() : null;
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public ArrayList<Source> getSources() {
        return ((Sources)this.getField("Sources")).getSources();
    }

    public RasterServerConfiguration parse(Object ... objectArray) throws XMLStreamException {
        XMLEventParserContext xMLEventParserContext = this.parserContext;
        QName qName = new QName(this.getNamespaceURI(), "RasterServer");
        XMLEvent xMLEvent = xMLEventParserContext.nextEvent();
        while (xMLEventParserContext.hasNext()) {
            if (xMLEvent != null && xMLEvent.isStartElement() && xMLEvent.asStartElement().getName().equals(qName)) {
                this.doParseEventAttributes(xMLEventParserContext, xMLEvent, new Object[0]);
                xMLEventParserContext.setDefaultNamespaceURI(this.getNamespaceURI());
                this.registerParsers(xMLEventParserContext);
                super.parse(xMLEventParserContext, xMLEvent, objectArray);
                return this;
            }
            xMLEvent = xMLEventParserContext.nextEvent();
        }
        return null;
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, "Property")) {
            Property property = (Property)xMLEventParserContext.getParser(xMLEvent).parse(xMLEventParserContext, xMLEvent, new Object[0]);
            this.properties.put(property.getName(), property.getValue());
        } else {
            super.doParseEventContent(xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void registerParsers(XMLEventParserContext xMLEventParserContext) {
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "Property"), new Property(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "LatLon"), new AttributesOnlyXMLEventParser(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "SouthWest"), new Corner(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "NorthEast"), new Corner(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "Sector"), new RasterSector(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "Source"), new Source(this.getNamespaceURI()));
        xMLEventParserContext.registerParser(new QName(this.getNamespaceURI(), "Sources"), new Sources(this.getNamespaceURI()));
    }

    protected static class RasterSector
    extends AbstractXMLEventParser {
        public RasterSector(String string) {
            super(string);
        }

        public Sector getSector() {
            AbstractXMLEventParser abstractXMLEventParser = (AbstractXMLEventParser)this.getField("SouthWest");
            AbstractXMLEventParser abstractXMLEventParser2 = (AbstractXMLEventParser)abstractXMLEventParser.getField("LatLon");
            Double d = Double.valueOf((String)abstractXMLEventParser2.getField("latitude"));
            Double d2 = Double.valueOf((String)abstractXMLEventParser2.getField("longitude"));
            String string = (String)abstractXMLEventParser2.getField("units");
            abstractXMLEventParser = (AbstractXMLEventParser)this.getField("NorthEast");
            abstractXMLEventParser2 = (AbstractXMLEventParser)abstractXMLEventParser.getField("LatLon");
            Double d3 = Double.valueOf((String)abstractXMLEventParser2.getField("latitude"));
            Double d4 = Double.valueOf((String)abstractXMLEventParser2.getField("longitude"));
            if (string.equals("radians")) {
                return Sector.fromRadians(d, d3, d2, d4);
            }
            return Sector.fromDegrees(d, d3, d2, d4);
        }
    }

    protected static class Sources
    extends AbstractXMLEventParser {
        protected ArrayList<Source> sources = new ArrayList();

        public Sources(String string) {
            super(string);
        }

        public ArrayList<Source> getSources() {
            return this.sources;
        }

        @Override
        protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
            if (xMLEventParserContext.isStartElement(xMLEvent, "Source")) {
                Source source = (Source)xMLEventParserContext.getParser(xMLEvent).parse(xMLEventParserContext, xMLEvent, new Object[0]);
                this.sources.add(source);
            } else {
                super.doParseEventContent(xMLEventParserContext, xMLEvent, objectArray);
            }
        }
    }

    protected static class Property
    extends AbstractXMLEventParser {
        public Property(String string) {
            super(string);
        }

        public String getName() {
            return (String)this.getField("name");
        }

        public String getValue() {
            return (String)this.getField("value");
        }
    }

    protected static class Corner
    extends AbstractXMLEventParser {
        public Corner(String string) {
            super(string);
        }
    }

    public static class Source
    extends AbstractXMLEventParser {
        public Source(String string) {
            super(string);
        }

        public String getPath() {
            return (String)this.getField("path");
        }

        public String getType() {
            return (String)this.getField("type");
        }

        public Sector getSector() {
            return ((RasterSector)this.getField("Sector")).getSector();
        }
    }
}

