/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.drag;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.Movable2;
import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.drag.DragContext;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.Globe2D;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;

public class DraggableSupport {
    public static final double DEFAULT_CONVERGENCE_THRESHOLD = 0.1;
    public static final int DEFAULT_STEP_LIMIT = 20;
    protected Vec4 initialScreenPointOffset = null;
    protected Vec4 initialEllipsoidalReferencePoint = null;
    protected Vec4 initialEllipsoidalScreenPoint = null;
    protected int stepLimit = 20;
    protected double convergenceThreshold = 0.1;
    protected final Object dragObject;
    protected int altitudeMode;

    public DraggableSupport(Object object, int n) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            String string = Logging.getMessage("generic.InvalidAltitudeMode", n);
            Logging.logger().warning(string);
        }
        this.dragObject = object;
        this.altitudeMode = n;
    }

    public void dragScreenSizeConstant(DragContext dragContext) {
        if (dragContext == null) {
            String string = Logging.getMessage("nullValue.DragContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = this.getReferencePosition();
        if (position == null) {
            return;
        }
        if (dragContext.getDragState().equals("gov.nasa.worldwind.avkey.DragBegin")) {
            this.initialScreenPointOffset = this.computeScreenOffsetFromReferencePosition(position, dragContext);
        }
        if (this.initialScreenPointOffset == null) {
            return;
        }
        double d = position.getAltitude();
        Vec4 vec4 = new Vec4(dragContext.getPoint().getX(), dragContext.getPoint().getY());
        Vec4 vec42 = vec4.subtract3(this.initialScreenPointOffset);
        Line line = dragContext.getView().computeRayFromScreenPoint(vec42.getX(), vec42.getY());
        if (line == null) {
            return;
        }
        Vec4 vec43 = this.computeGlobeIntersection(line, d, true, dragContext.getGlobe(), dragContext.getSceneController());
        if (vec43 == null) {
            return;
        }
        Position position2 = dragContext.getGlobe().computePositionFromPoint(vec43);
        this.doMove(new Position(position2, d), dragContext.getGlobe());
    }

    public void dragGlobeSizeConstant(DragContext dragContext) {
        if (dragContext == null) {
            String string = Logging.getMessage("nullValue.DragContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = this.getReferencePosition();
        if (position == null) {
            return;
        }
        if (dragContext.getDragState().equals("gov.nasa.worldwind.avkey.DragBegin")) {
            this.initialEllipsoidalReferencePoint = dragContext.getGlobe().computeEllipsoidalPointFromPosition(position);
            this.initialEllipsoidalScreenPoint = this.computeEllipsoidalPointFromScreen(dragContext, dragContext.getInitialPoint(), position.getAltitude(), false);
        }
        if (this.initialEllipsoidalReferencePoint == null || this.initialEllipsoidalScreenPoint == null) {
            return;
        }
        double d = position.getAltitude();
        Vec4 vec4 = new Vec4(dragContext.getPoint().getX(), dragContext.getPoint().getY());
        Line line = dragContext.getView().computeRayFromScreenPoint(vec4.getX(), vec4.getY());
        if (line == null) {
            return;
        }
        Vec4 vec42 = this.computeGlobeIntersection(line, d, false, dragContext.getGlobe(), dragContext.getSceneController());
        if (vec42 == null) {
            return;
        }
        Position position2 = dragContext.getGlobe().computePositionFromPoint(vec42);
        if (position2 == null) {
            return;
        }
        Vec4 vec43 = dragContext.getGlobe().computeEllipsoidalPointFromPosition(position2);
        if (vec43 == null) {
            return;
        }
        Vec4 vec44 = this.initialEllipsoidalScreenPoint.cross3(vec43).normalize3();
        Angle angle = this.initialEllipsoidalScreenPoint.angleBetween3(vec43);
        Matrix matrix = Matrix.fromAxisAngle(angle, vec44);
        Vec4 vec45 = this.initialEllipsoidalReferencePoint.transformBy3(matrix);
        Position position3 = dragContext.getGlobe().computePositionFromEllipsoidalPoint(vec45);
        if (position3 == null) {
            return;
        }
        Position position4 = new Position(position3, d);
        this.doMove(position4, dragContext.getGlobe());
    }

    public int getStepLimit() {
        return this.stepLimit;
    }

    public void setStepLimit(int n) {
        this.stepLimit = n;
    }

    public double getConvergenceThreshold() {
        return this.convergenceThreshold;
    }

    public void setConvergenceThreshold(double d) {
        this.convergenceThreshold = d;
    }

    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            String string = Logging.getMessage("generic.InvalidAltitudeMode", n);
            Logging.logger().warning(string);
        }
        this.altitudeMode = n;
    }

    protected Vec4 computeEllipsoidalPointFromScreen(DragContext dragContext, Point point, double d, boolean bl) {
        Line line = dragContext.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec4 = this.computeGlobeIntersection(line, d, bl, dragContext.getGlobe(), dragContext.getSceneController());
        if (vec4 == null) {
            return null;
        }
        Position position = dragContext.getGlobe().computePositionFromPoint(vec4);
        if (position == null) {
            return null;
        }
        return dragContext.getGlobe().computeEllipsoidalPointFromPosition(position);
    }

    protected Vec4 computeScreenOffsetFromReferencePosition(Position position, DragContext dragContext) {
        Vec4 vec4 = dragContext.getGlobe() instanceof Globe2D ? dragContext.getGlobe().computePointFromPosition(new Position(position, 0.0)) : (this.altitudeMode == 0 || this.altitudeMode != 2 && this.altitudeMode != 1 && this.altitudeMode != 3 ? dragContext.getGlobe().computePointFromPosition(position) : dragContext.getSceneController().getTerrain().getSurfacePoint(position));
        if (vec4 == null) {
            return null;
        }
        Vec4 vec42 = dragContext.getView().project(vec4);
        if (vec42 == null) {
            return null;
        }
        Vec4 vec43 = new Vec4(dragContext.getInitialPoint().getX() - vec42.getX(), dragContext.getInitialPoint().getY() - (dragContext.getView().getViewport().getHeight() - vec42.getY() - 1.0));
        return vec43;
    }

    protected Position getReferencePosition() {
        if (this.dragObject instanceof Movable2) {
            return ((Movable2)this.dragObject).getReferencePosition();
        }
        if (this.dragObject instanceof Movable) {
            return ((Movable)this.dragObject).getReferencePosition();
        }
        return null;
    }

    protected void doMove(Position position, Globe globe) {
        if (this.dragObject instanceof Movable2) {
            if (globe == null) {
                String string = Logging.getMessage("nullValue.GlobeIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            ((Movable2)this.dragObject).moveTo(globe, position);
        } else if (this.dragObject instanceof Movable) {
            ((Movable)this.dragObject).moveTo(position);
        }
    }

    protected Vec4 computeGlobeIntersection(Line line, double d, boolean bl, Globe globe, SceneController sceneController) {
        Vec4 vec4;
        Object object = globe instanceof Globe2D ? globe.intersect(line, 0.0) : (this.altitudeMode == 0 ? globe.intersect(line, d) : (this.altitudeMode == 1 || this.altitudeMode == 3 ? sceneController.getTerrain().intersect(line) : (this.altitudeMode == 2 ? (d < 1.0 ? sceneController.getTerrain().intersect(line) : (bl ? ((vec4 = this.computeRelativePoint(line, globe, sceneController, d)) != null ? new Intersection[]{new Intersection(vec4, false)} : null) : globe.intersect(line, d))) : globe.intersect(line, d))));
        if (object != null && ((Intersection[])object).length > 0) {
            return object[0].getIntersectionPoint();
        }
        return null;
    }

    protected Vec4 computeRelativePoint(Line line, Globe globe, SceneController sceneController, double d) {
        Intersection[] intersectionArray = sceneController.getTerrain().intersect(line);
        if (intersectionArray != null) {
            double d2;
            Vec4 vec4 = line.getOrigin();
            Vec4 vec42 = intersectionArray[0].getIntersectionPoint();
            double d3 = vec4.getLength3() - vec42.getLength3();
            if (d3 > 5.0 * d) {
                d2 = 5.0 * d / d3;
                vec4 = Vec4.mix3(d2, vec42, vec4);
            }
            d2 = 0.5;
            double d4 = 0.0;
            double d5 = 1.0;
            for (int i = 0; i < this.stepLimit; ++i) {
                Vec4 vec43 = Vec4.mix3(d2, vec42, vec4);
                Position position = globe.computePositionFromPoint(vec43);
                double d6 = globe.getElevation(position.getLatitude(), position.getLongitude());
                d6 = position.getElevation() - d6;
                if (Math.abs(d6 - d) < this.convergenceThreshold) {
                    return vec43;
                }
                if (d < d6) {
                    d5 = d2;
                } else {
                    d4 = d2;
                }
                d2 = (d5 + d4) / 2.0;
            }
        }
        if ((intersectionArray = globe.intersect(line, d)) != null && intersectionArray.length > 0) {
            return intersectionArray[0].getIntersectionPoint();
        }
        return null;
    }
}

