/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.geojson;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.Logging;
import java.nio.DoubleBuffer;
import java.util.Iterator;

public class GeoJSONPositionArray
implements Iterable<Position> {
    protected int positionSize;
    protected DoubleBuffer buffer;
    protected int startPos;
    protected int endPos;

    public GeoJSONPositionArray(int n, DoubleBuffer doubleBuffer, int n2, int n3) {
        if (n < 2) {
            String string = Logging.getMessage("generic.InvalidTupleSize", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (doubleBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.positionSize = n;
        this.buffer = doubleBuffer;
        this.startPos = n2;
        this.endPos = n3;
    }

    public int length() {
        return (this.endPos - this.startPos) / this.positionSize;
    }

    public Position getPosition(int n) {
        int n2 = this.startPos + this.positionSize * n;
        return this.positionSize >= 3 ? Position.fromDegrees(this.buffer.get(n2 + 1), this.buffer.get(n2), this.buffer.get(n2 + 2)) : Position.fromDegrees(this.buffer.get(n2 + 1), this.buffer.get(n2));
    }

    @Override
    public Iterator<Position> iterator() {
        return new PositionIterator(this);
    }

    protected static class PositionIterator
    implements Iterator<Position> {
        protected GeoJSONPositionArray array;
        protected int index;

        public PositionIterator(GeoJSONPositionArray geoJSONPositionArray) {
            this.array = geoJSONPositionArray;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.length();
        }

        @Override
        public Position next() {
            return this.array.getPosition(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

