/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.NITFSUtil;
import java.nio.ByteBuffer;

class RPFHeaderSection {
    public static final String DATA_TAG = "RPFHDR";
    public boolean endianIndicator;
    public short headerLength;
    public String filename;
    public short updateIndicator;
    public String govSpecNumber;
    public String govSpecDate;
    public String securityClass;
    public String securityCountryCode;
    public String securityReleaseMark;
    public int locationSectionLocation;

    public RPFHeaderSection(ByteBuffer byteBuffer) {
        this.endianIndicator = 0 != byteBuffer.get();
        this.headerLength = byteBuffer.getShort();
        this.filename = NITFSUtil.getString(byteBuffer, 12);
        this.updateIndicator = NITFSUtil.getByteAsShort(byteBuffer);
        this.govSpecNumber = NITFSUtil.getString(byteBuffer, 15);
        this.govSpecDate = NITFSUtil.getString(byteBuffer, 8);
        this.securityClass = NITFSUtil.getString(byteBuffer, 1);
        this.securityCountryCode = NITFSUtil.getString(byteBuffer, 2);
        this.securityReleaseMark = NITFSUtil.getString(byteBuffer, 2);
        this.locationSectionLocation = byteBuffer.getInt();
    }
}

