/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.rpf.RPFDataSeries;
import gov.nasa.worldwind.formats.rpf.RPFFrameStructure;
import gov.nasa.worldwind.formats.rpf.RPFZone;
import gov.nasa.worldwind.util.Logging;

class RPFNonpolarFrameStructure
extends RPFFrameStructure {
    private final int northSouthPixelConstant;
    private final int eastWestPixelConstant;
    private final double polewardExtent;
    private final double equatorwardExtent;
    private final int latitudinalFrames;
    private final int longitudinalFrames;

    private RPFNonpolarFrameStructure(int n, int n2, double d, double d2, int n3, int n4) {
        this.northSouthPixelConstant = n;
        this.eastWestPixelConstant = n2;
        this.polewardExtent = d;
        this.equatorwardExtent = d2;
        this.latitudinalFrames = n3;
        this.longitudinalFrames = n4;
    }

    public static RPFNonpolarFrameStructure computeStructure(char c, String string, double d) {
        int n;
        int n2;
        if (!RPFZone.isZoneCode(c)) {
            String string2 = Logging.getMessage("RPFZone.UnknownZoneCode", Character.valueOf(c));
            Logging.logger().fine(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null || !RPFDataSeries.isRPFDataType(string)) {
            String string3 = Logging.getMessage("RPFDataSeries.UnkownDataType", string);
            Logging.logger().fine(string3);
            throw new IllegalArgumentException(string3);
        }
        if (d < 0.0) {
            String string4 = Logging.getMessage("generic.ArgumentOutOfRange", string);
            Logging.logger().fine(string4);
            throw new IllegalArgumentException(string4);
        }
        int n3 = RPFNonpolarFrameStructure.eastWestPixelSpacingConstant(c);
        int n4 = RPFNonpolarFrameStructure.northSouthPixelSpacingConstant();
        int n5 = RPFNonpolarFrameStructure.equatorwardNominalBoundary(c);
        int n6 = RPFNonpolarFrameStructure.polewardNominalBoundary(c);
        if (RPFDataSeries.isCADRGDataType(string)) {
            n2 = RPFNonpolarFrameStructure.northSouthPixelConstant_CADRG(n4, d);
            n = RPFNonpolarFrameStructure.eastWestPixelConstant_CADRG(n3, d);
        } else if (RPFDataSeries.isCIBDataType(string)) {
            n2 = RPFNonpolarFrameStructure.northSouthPixelConstant_CIB(n4, d);
            n = RPFNonpolarFrameStructure.eastWestPixelConstant_CIB(n3, d);
        } else {
            n2 = -1;
            n = -1;
        }
        double d2 = RPFNonpolarFrameStructure.polewardExtent(n6, n2, 1536.0);
        double d3 = RPFNonpolarFrameStructure.equatorwardExtent(n5, n2, 1536.0);
        int n7 = RPFNonpolarFrameStructure.latitudinalFrames(d2, d3, n2, 1536.0);
        int n8 = RPFNonpolarFrameStructure.longitudinalFrames(n, 1536.0);
        return new RPFNonpolarFrameStructure(n2, n, d2, d3, n7, n8);
    }

    public final int getNorthSouthPixelConstant() {
        return this.northSouthPixelConstant;
    }

    public final int getEastWestPixelConstant() {
        return this.eastWestPixelConstant;
    }

    public final double getPolewardExtent() {
        return this.polewardExtent;
    }

    public final double getEquatorwardExtent() {
        return this.equatorwardExtent;
    }

    public final int getLatitudinalFrames() {
        return this.latitudinalFrames;
    }

    public final int getLongitudinalFrames() {
        return this.longitudinalFrames;
    }

    private static int northSouthPixelConstant_CADRG(double d, double d2) {
        double d3 = 1000000.0 / d2;
        double d4 = d * d3;
        d4 = 512.0 * (double)((int)Math.ceil(d4 / 512.0));
        d4 /= 4.0;
        return 256 * (int)Math.round((d4 /= 1.5) / 256.0);
    }

    private static int eastWestPixelConstant_CADRG(double d, double d2) {
        double d3 = 1000000.0 / d2;
        double d4 = d * d3;
        d4 = 512.0 * (double)((int)Math.ceil(d4 / 512.0));
        return 256 * (int)Math.round((d4 /= 1.5) / 256.0);
    }

    private static int northSouthPixelConstant_CIB(double d, double d2) {
        double d3 = 100.0 / d2;
        double d4 = d * d3;
        d4 = 512.0 * (double)((int)Math.ceil(d4 / 512.0));
        return 256 * (int)Math.round((d4 /= 4.0) / 256.0);
    }

    private static int eastWestPixelConstant_CIB(double d, double d2) {
        double d3 = 100.0 / d2;
        double d4 = d * d3;
        return 512 * (int)Math.ceil(d4 / 512.0);
    }

    private static double polewardExtent(double d, double d2, double d3) {
        double d4 = d2 / 90.0;
        return Math.signum(d) * RPFNonpolarFrameStructure.clamp(Math.ceil(d4 * Math.abs(d) / d3) * d3 / d4, 0.0, 90.0);
    }

    private static double equatorwardExtent(double d, double d2, double d3) {
        double d4 = d2 / 90.0;
        return Math.signum(d) * RPFNonpolarFrameStructure.clamp((double)((int)(d4 * Math.abs(d) / d3)) * d3 / d4, 0.0, 90.0);
    }

    private static int latitudinalFrames(double d, double d2, double d3, double d4) {
        double d5 = d3 / 90.0;
        double d6 = Math.abs(d - d2);
        return (int)Math.round(d6 * d5 / d4);
    }

    private static int longitudinalFrames(double d, double d2) {
        return (int)Math.ceil(d / d2);
    }

    private static double clamp(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }
}

