/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.formats.shapefile.ShapefileRenderable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceObjectTileBuilder;
import gov.nasa.worldwind.render.SurfaceRenderable;
import gov.nasa.worldwind.util.BasicQuadTree;
import gov.nasa.worldwind.util.ClippingTessellator;
import gov.nasa.worldwind.util.GLUTessellatorSupport;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PolygonTessellator2;
import gov.nasa.worldwind.util.PolylineGeneralizer;
import gov.nasa.worldwind.util.Range;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.VecBuffer;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.combine.Combinable;
import gov.nasa.worldwind.util.combine.CombineContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.logging.Level;

public class ShapefilePolygons
extends ShapefileRenderable
implements OrderedRenderable,
PreRenderable,
Combinable {
    protected double detailHint = 0.0;
    protected double detailHintOrigin = 2.8;
    protected int outlinePickWidth = 10;
    protected BasicQuadTree<Record> recordTree;
    protected ArrayList<ShapefileTile> topLevelTiles = new ArrayList();
    protected ArrayList<ShapefileTile> currentTiles = new ArrayList();
    protected ShapefileTile currentAncestorTile;
    protected PriorityQueue<Runnable> requestQueue = new PriorityQueue();
    protected MemoryCache cache = WorldWind.getMemoryCache(ShapefileGeometry.class.getName());
    protected long recordStateID;
    protected PickSupport pickSupport = new PickSupport();
    protected HashMap<Integer, Color> pickColorMap = new HashMap();
    protected SurfaceObjectTileBuilder pickTileBuilder = new SurfaceObjectTileBuilder(new Dimension(512, 512), 32856, false, false);
    protected ByteBuffer pickColors;
    protected Layer layer;
    protected double[] matrixArray = new double[16];
    protected double[] clipPlaneArray = new double[16];

    public ShapefilePolygons(Shapefile shapefile) {
        if (shapefile == null) {
            String string = Logging.getMessage("nullValue.ShapefileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.init(shapefile, null, null, null);
    }

    public ShapefilePolygons(Shapefile shapefile, ShapeAttributes shapeAttributes, ShapeAttributes shapeAttributes2, ShapefileRenderable.AttributeDelegate attributeDelegate) {
        if (shapefile == null) {
            String string = Logging.getMessage("nullValue.ShapefileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.init(shapefile, shapeAttributes, shapeAttributes2, attributeDelegate);
    }

    @Override
    protected void assembleRecords(Shapefile shapefile) {
        this.recordTree = new BasicQuadTree(8, this.sector, null);
        super.assembleRecords(shapefile);
    }

    @Override
    protected boolean mustAssembleRecord(ShapefileRecord shapefileRecord) {
        return super.mustAssembleRecord(shapefileRecord) && (shapefileRecord.isPolylineRecord() || shapefileRecord.isPolygonRecord());
    }

    @Override
    protected void assembleRecord(ShapefileRecord shapefileRecord) {
        Record record = this.createRecord(shapefileRecord);
        this.addRecord(shapefileRecord, record);
        this.recordTree.add(record, record.sector.asDegreesArray());
    }

    @Override
    protected void recordDidChange(ShapefileRenderable.Record record) {
        ++this.recordStateID;
    }

    protected Record createRecord(ShapefileRecord shapefileRecord) {
        return new Record(this, shapefileRecord);
    }

    public double getDetailHint() {
        return this.detailHint;
    }

    public void setDetailHint(double d) {
        this.detailHint = d;
    }

    protected double getDetailFactor() {
        return this.detailHintOrigin + this.getDetailHint();
    }

    public int getOutlinePickWidth() {
        return this.outlinePickWidth;
    }

    public void setOutlinePickWidth(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlinePickWidth = n;
    }

    @Override
    public double getDistanceFromEye() {
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.visible) {
            return;
        }
        if (this.getRecordCount() == 0) {
            return;
        }
        Box box = Sector.computeBoundingBox(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), this.sector);
        if (!drawContext.getView().getFrustumInModelCoordinates().intersects(box)) {
            return;
        }
        if (drawContext.isSmall(box, 1)) {
            return;
        }
        this.layer = drawContext.getCurrentLayer();
        this.assembleTiles(drawContext);
        for (ShapefileTile shapefileTile : this.currentTiles) {
            drawContext.addOrderedSurfaceRenderable(shapefileTile);
        }
        if (drawContext.getCurrentLayer().isPickEnabled()) {
            try {
                drawContext.enablePickingMode();
                this.pickSupport.beginPicking(drawContext);
                this.assembleTiles(drawContext);
                this.pickTileBuilder.setForceTileUpdates(true);
                this.pickTileBuilder.buildTiles(drawContext, this.currentTiles);
            }
            finally {
                this.pickColorMap.clear();
                this.pickSupport.endPicking(drawContext);
                drawContext.disablePickingMode();
            }
        }
        this.sendRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pick(DrawContext drawContext, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.visible) {
            return;
        }
        if (this.getRecordCount() == 0) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        try {
            this.pickSupport.beginPicking(drawContext);
            gL2.glEnable(2884);
            drawContext.getGeographicSurfaceTileRenderer().setUseImageTilePickColors(true);
            drawContext.getGeographicSurfaceTileRenderer().renderTiles(drawContext, this.pickTileBuilder.getTiles(drawContext));
            for (PickedObject pickedObject : this.pickTileBuilder.getPickCandidates(drawContext)) {
                this.pickSupport.addPickableObject(pickedObject);
            }
        }
        finally {
            drawContext.getGeographicSurfaceTileRenderer().setUseImageTilePickColors(false);
            gL2.glDisable(2884);
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, point, this.layer);
            this.pickTileBuilder.clearTiles(drawContext);
            this.pickTileBuilder.clearPickCandidates(drawContext);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.visible) {
            return;
        }
        if (this.getRecordCount() == 0) {
            return;
        }
        if (drawContext.isPickingMode() && this.pickTileBuilder.getTileCount(drawContext) > 0) {
            drawContext.addOrderedSurfaceRenderable(this);
        }
    }

    @Override
    public void combine(CombineContext combineContext) {
        if (combineContext == null) {
            String string = Logging.getMessage("nullValue.CombineContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (combineContext.isBoundingSectorMode()) {
            this.combineBounds(combineContext);
        } else {
            this.combineContours(combineContext);
        }
    }

    protected void assembleTiles(DrawContext drawContext) {
        this.currentTiles.clear();
        if (this.topLevelTiles.size() == 0) {
            this.createTopLevelTiles();
        }
        for (ShapefileTile shapefileTile : this.topLevelTiles) {
            this.currentAncestorTile = null;
            if (!this.isTileVisible(drawContext, shapefileTile)) continue;
            this.addTileOrDescendants(drawContext, shapefileTile);
        }
    }

    protected void createTopLevelTiles() {
        Angle angle = Angle.fromDegrees(45.0);
        Angle angle2 = Angle.fromDegrees(45.0);
        double d = angle.radians / 512.0;
        int n = Tile.computeRow(angle, this.sector.getMinLatitude(), Angle.NEG90);
        int n2 = Tile.computeRow(angle, this.sector.getMaxLatitude(), Angle.NEG90);
        int n3 = Tile.computeColumn(angle2, this.sector.getMinLongitude(), Angle.NEG180);
        int n4 = Tile.computeColumn(angle2, this.sector.getMaxLongitude(), Angle.NEG180);
        Angle angle3 = Tile.computeRowLatitude(n, angle, Angle.NEG90);
        for (int i = n; i <= n2; ++i) {
            Angle angle4 = angle3.add(angle);
            Angle angle5 = Tile.computeColumnLongitude(n3, angle2, Angle.NEG180);
            for (int j = n3; j <= n4; ++j) {
                Angle angle6 = angle5.add(angle2);
                this.topLevelTiles.add(new ShapefileTile(this, new Sector(angle3, angle4, angle5, angle6), d));
                angle5 = angle6;
            }
            angle3 = angle4;
        }
    }

    protected boolean isTileVisible(DrawContext drawContext, ShapefileTile shapefileTile) {
        Box box = Sector.computeBoundingBox(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), shapefileTile.sector);
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(box);
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersects(box);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTileOrDescendants(DrawContext drawContext, ShapefileTile shapefileTile) {
        ShapefileGeometry shapefileGeometry = this.lookupGeometry(shapefileTile);
        shapefileTile.setGeometry(shapefileGeometry);
        if (this.meetsRenderCriteria(drawContext, shapefileTile)) {
            this.addTile(drawContext, shapefileTile);
            return;
        }
        ShapefileTile shapefileTile2 = null;
        try {
            ShapefileTile[] shapefileTileArray;
            if (shapefileTile.getGeometry() != null) {
                shapefileTile2 = this.currentAncestorTile;
                this.currentAncestorTile = shapefileTile;
            }
            for (ShapefileTile shapefileTile3 : shapefileTileArray = shapefileTile.subdivide()) {
                if (!shapefileTile3.sector.intersects(this.sector) || !this.isTileVisible(drawContext, shapefileTile3)) continue;
                this.addTileOrDescendants(drawContext, shapefileTile3);
            }
        }
        finally {
            if (shapefileTile2 != null) {
                this.currentAncestorTile = shapefileTile2;
            }
        }
    }

    protected void addTile(DrawContext drawContext, ShapefileTile shapefileTile) {
        if (shapefileTile.getGeometry() == null) {
            this.requestGeometry(drawContext, shapefileTile);
            if (this.currentAncestorTile != null) {
                shapefileTile.setGeometry(this.currentAncestorTile.getGeometry());
            }
        }
        if (shapefileTile.getGeometry() == null) {
            return;
        }
        if (shapefileTile.getGeometry().vertexCount == 0) {
            return;
        }
        if (this.mustAssembleAttributeGroups(shapefileTile.getGeometry())) {
            this.assembleAttributeGroups(shapefileTile.getGeometry());
        }
        this.currentTiles.add(shapefileTile);
    }

    protected boolean meetsRenderCriteria(DrawContext drawContext, ShapefileTile shapefileTile) {
        return !this.needToSplit(drawContext, shapefileTile);
    }

    protected boolean needToSplit(DrawContext drawContext, ShapefileTile shapefileTile) {
        double d = shapefileTile.resolution;
        double d2 = drawContext.getGlobe().getRadius() * d;
        double d3 = Math.pow(10.0, -this.getDetailFactor());
        double d4 = drawContext.getView().getFieldOfView().tanHalfAngle() / Angle.fromDegrees(45.0).tanHalfAngle();
        d4 = WWMath.clamp(d4, 0.0, 1.0);
        double d5 = shapefileTile.sector.distanceTo(drawContext, drawContext.getView().getEyePoint());
        double d6 = d5 * d3 * d4;
        return d2 > d6;
    }

    protected ShapefileGeometry lookupGeometry(ShapefileTile shapefileTile) {
        return (ShapefileGeometry)this.cache.getObject(shapefileTile);
    }

    protected void requestGeometry(DrawContext drawContext, ShapefileTile shapefileTile) {
        Vec4 vec4 = drawContext.getView().getEyePoint();
        Vec4 vec42 = shapefileTile.sector.computeCenterPoint(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
        ShapefileGeometry shapefileGeometry = new ShapefileGeometry(shapefileTile.shape, shapefileTile.sector, shapefileTile.resolution);
        shapefileGeometry.memoryCache = this.cache;
        shapefileGeometry.memoryCacheKey = shapefileTile;
        shapefileGeometry.listener = this.layer;
        shapefileGeometry.priority = vec4.distanceTo3(vec42);
        this.requestQueue.offer(shapefileGeometry);
    }

    protected void sendRequests() {
        Runnable runnable;
        while ((runnable = this.requestQueue.poll()) != null && !WorldWind.getTaskService().isFull()) {
            WorldWind.getTaskService().addTask(runnable);
        }
        this.requestQueue.clear();
    }

    protected void tessellate(ShapefileGeometry shapefileGeometry) {
        Set<Record> set = this.recordTree.getItemsInRegion(shapefileGeometry.sector, null);
        if (set.isEmpty()) {
            return;
        }
        double d = 4.0 * shapefileGeometry.resolution * shapefileGeometry.resolution;
        double d2 = shapefileGeometry.sector.getCentroid().longitude.degrees;
        double d3 = shapefileGeometry.sector.getCentroid().latitude.degrees;
        PolylineGeneralizer polylineGeneralizer = new PolylineGeneralizer();
        PolygonTessellator2 polygonTessellator2 = new PolygonTessellator2();
        polygonTessellator2.setPolygonNormal(0.0, 0.0, 1.0);
        polygonTessellator2.setPolygonClipCoords(shapefileGeometry.sector.getMinLongitude().degrees, shapefileGeometry.sector.getMaxLongitude().degrees, shapefileGeometry.sector.getMinLatitude().degrees, shapefileGeometry.sector.getMaxLatitude().degrees);
        polygonTessellator2.setVertexStride(2);
        polygonTessellator2.setVertexOffset(-d2, -d3, 0.0);
        for (Record record : set) {
            double d4;
            if (!record.sector.intersects(shapefileGeometry.sector) || (d4 = record.sector.getDeltaLatRadians() * record.sector.getDeltaLonRadians()) < d) continue;
            this.computeRecordMetrics(record, polylineGeneralizer);
            this.tessellateRecord(shapefileGeometry, record, polygonTessellator2);
        }
        if (polygonTessellator2.getVertexCount() == 0 || shapefileGeometry.recordIndices.size() == 0) {
            return;
        }
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(2 * polygonTessellator2.getVertexCount());
        polygonTessellator2.getVertices(floatBuffer);
        shapefileGeometry.vertices = floatBuffer.rewind();
        shapefileGeometry.vertexStride = 2;
        shapefileGeometry.vertexCount = polygonTessellator2.getVertexCount();
        shapefileGeometry.vertexOffset = new Vec4(d2, d3, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeRecordMetrics(Record record, PolylineGeneralizer polylineGeneralizer) {
        Record record2 = record;
        synchronized (record2) {
            if (record.boundaryEffectiveArea != null) {
                return;
            }
            record.boundaryEffectiveArea = new double[record.getBoundaryCount()][];
            record.boundaryCrossesAntimeridian = new boolean[record.getBoundaryCount()];
            for (int i = 0; i < record.getBoundaryCount(); ++i) {
                VecBuffer vecBuffer = record.getBoundaryPoints(i);
                double[] dArray = new double[2];
                double[] dArray2 = new double[2];
                polylineGeneralizer.reset();
                polylineGeneralizer.beginPolyline();
                for (int j = 0; j < vecBuffer.getSize(); ++j) {
                    vecBuffer.get(j, dArray);
                    polylineGeneralizer.addVertex(dArray[0], dArray[1], 0.0);
                    if (j > 0 && Math.signum(dArray2[0]) != Math.signum(dArray[0]) && Math.abs(dArray2[0] - dArray[0]) > 180.0) {
                        record.boundaryCrossesAntimeridian[i] = true;
                    }
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                }
                record.boundaryEffectiveArea[i] = new double[vecBuffer.getSize()];
                polylineGeneralizer.endPolyline();
                polylineGeneralizer.getVertexEffectiveArea(record.boundaryEffectiveArea[i]);
            }
        }
    }

    protected void tessellateRecord(ShapefileGeometry shapefileGeometry, Record record, final PolygonTessellator2 polygonTessellator2) {
        double d = shapefileGeometry.resolution * 180.0 / Math.PI;
        double d2 = d * d;
        polygonTessellator2.resetIndices();
        polygonTessellator2.beginPolygon();
        for (int i = 0; i < record.getBoundaryCount(); ++i) {
            this.tessellateBoundary(record, i, d2, new TessBoundaryCallback(){

                @Override
                public void beginBoundary() {
                    polygonTessellator2.beginContour();
                }

                @Override
                public void vertex(double d, double d2) {
                    polygonTessellator2.addVertex(d2, d, 0.0);
                }

                @Override
                public void endBoundary() {
                    polygonTessellator2.endContour();
                }
            });
        }
        polygonTessellator2.endPolygon();
        Range range = polygonTessellator2.getPolygonVertexRange();
        if (range.length == 0) {
            return;
        }
        IntBuffer intBuffer = IntBuffer.allocate(polygonTessellator2.getInteriorIndexCount());
        IntBuffer intBuffer2 = IntBuffer.allocate(polygonTessellator2.getBoundaryIndexCount());
        polygonTessellator2.getInteriorIndices(intBuffer);
        polygonTessellator2.getBoundaryIndices(intBuffer2);
        RecordIndices recordIndices = new RecordIndices(record.ordinal);
        recordIndices.vertexRange.location = range.location;
        recordIndices.vertexRange.length = range.length;
        recordIndices.interiorIndices = intBuffer.rewind();
        recordIndices.outlineIndices = intBuffer2.rewind();
        shapefileGeometry.recordIndices.add(recordIndices);
    }

    protected boolean mustAssembleAttributeGroups(ShapefileGeometry shapefileGeometry) {
        return shapefileGeometry.attributeGroups.size() == 0 || shapefileGeometry.attributeStateID != this.recordStateID;
    }

    protected void assembleAttributeGroups(ShapefileGeometry shapefileGeometry) {
        Object object;
        shapefileGeometry.attributeGroups.clear();
        shapefileGeometry.attributeStateID = this.recordStateID;
        IdentityHashMap<Object, RecordGroup> identityHashMap = new IdentityHashMap<Object, RecordGroup>();
        for (RecordIndices object2 : shapefileGeometry.recordIndices) {
            ShapefileRenderable.Record record = this.getRecord(object2.ordinal);
            if (!record.isVisible()) continue;
            object = this.determineActiveAttributes(record);
            Object object3 = (RecordGroup)identityHashMap.get(object);
            if (object3 == null) {
                object3 = new RecordGroup((ShapeAttributes)object);
                identityHashMap.put(object, (RecordGroup)object3);
                shapefileGeometry.attributeGroups.add((RecordGroup)object3);
            }
            ((RecordGroup)object3).recordIndices.add(object2);
            ((RecordGroup)object3).interiorIndexRange.length = ((RecordGroup)object3).interiorIndexRange.length + (object2.interiorIndices != null ? object2.interiorIndices.remaining() : 0);
            ((RecordGroup)object3).outlineIndexRange.length = ((RecordGroup)object3).outlineIndexRange.length + (object2.outlineIndices != null ? object2.outlineIndices.remaining() : 0);
        }
        for (RecordGroup recordGroup : shapefileGeometry.attributeGroups) {
            int n = recordGroup.interiorIndexRange.length + recordGroup.outlineIndexRange.length;
            object = Buffers.newDirectIntBuffer(n);
            recordGroup.interiorIndexRange.location = ((Buffer)object).position();
            for (RecordIndices recordIndices : recordGroup.recordIndices) {
                ((IntBuffer)object).put(recordIndices.interiorIndices);
                recordIndices.interiorIndices.rewind();
            }
            recordGroup.outlineIndexRange.location = ((Buffer)object).position();
            for (RecordIndices recordIndices : recordGroup.recordIndices) {
                ((IntBuffer)object).put(recordIndices.outlineIndices);
                recordIndices.outlineIndices.rewind();
            }
            recordGroup.indices = ((IntBuffer)object).rewind();
            recordGroup.recordIndices.clear();
            recordGroup.recordIndices.trimToSize();
        }
    }

    protected void render(DrawContext drawContext, ShapefileTile shapefileTile) {
        try {
            this.beginDrawing(drawContext);
            this.draw(drawContext, shapefileTile);
        }
        finally {
            this.endDrawing(drawContext);
        }
    }

    protected void beginDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glDisable(2929);
        gL2.glEnableClientState(32884);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        if (!drawContext.isPickingMode()) {
            gL2.glEnable(3042);
            gL2.glEnable(2848);
            gL2.glBlendFunc(770, 771);
        }
    }

    protected void endDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glEnable(2929);
        gL2.glDisableClientState(32884);
        gL2.glDisableClientState(32886);
        gL2.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gL2.glLineWidth(1.0f);
        gL2.glPopMatrix();
        Arrays.fill(this.clipPlaneArray, 0.0);
        for (int i = 0; i < 4; ++i) {
            gL2.glDisable(12288 + i);
            gL2.glClipPlane(12288 + i, this.clipPlaneArray, 4 * i);
        }
        if (!drawContext.isPickingMode()) {
            gL2.glDisable(3042);
            gL2.glDisable(2848);
            gL2.glBlendFunc(1, 0);
        }
    }

    protected void draw(DrawContext drawContext, ShapefileTile shapefileTile) {
        GL2 gL2 = drawContext.getGL().getGL2();
        ShapefileGeometry shapefileGeometry = shapefileTile.getGeometry();
        SurfaceTileDrawContext surfaceTileDrawContext = (SurfaceTileDrawContext)drawContext.getValue("gov.nasa.worldwind.avkey.SurfaceTileDrawContext");
        Matrix matrix = surfaceTileDrawContext.getModelviewMatrix().multiply(Matrix.fromTranslation(shapefileGeometry.vertexOffset));
        matrix.toArray(this.matrixArray, 0, false);
        gL2.glLoadMatrixd(this.matrixArray, 0);
        gL2.glVertexPointer(shapefileGeometry.vertexStride, 5126, 0, shapefileGeometry.vertices);
        this.applyClipSector(drawContext, shapefileTile.sector, shapefileGeometry.vertexOffset);
        if (drawContext.isPickingMode()) {
            this.applyPickColors(drawContext, shapefileGeometry);
        }
        for (RecordGroup recordGroup : shapefileGeometry.attributeGroups) {
            this.drawAttributeGroup(drawContext, recordGroup);
        }
    }

    protected void applyClipSector(DrawContext drawContext, Sector sector, Vec4 vec4) {
        ShapefilePolygons.fillArray4(this.clipPlaneArray, 0, 1.0, 0.0, 0.0, -(sector.getMinLongitude().degrees - vec4.x));
        ShapefilePolygons.fillArray4(this.clipPlaneArray, 4, -1.0, 0.0, 0.0, sector.getMaxLongitude().degrees - vec4.x);
        ShapefilePolygons.fillArray4(this.clipPlaneArray, 8, 0.0, 1.0, 0.0, -(sector.getMinLatitude().degrees - vec4.y));
        ShapefilePolygons.fillArray4(this.clipPlaneArray, 12, 0.0, -1.0, 0.0, sector.getMaxLatitude().degrees - vec4.y);
        GL2 gL2 = drawContext.getGL().getGL2();
        for (int i = 0; i < 4; ++i) {
            gL2.glEnable(12288 + i);
            gL2.glClipPlane(12288 + i, this.clipPlaneArray, 4 * i);
        }
    }

    protected void applyPickColors(DrawContext drawContext, ShapefileGeometry shapefileGeometry) {
        SurfaceTileDrawContext surfaceTileDrawContext = (SurfaceTileDrawContext)drawContext.getValue("gov.nasa.worldwind.avkey.SurfaceTileDrawContext");
        if (this.pickColors == null || this.pickColors.capacity() < 3 * shapefileGeometry.vertexCount) {
            this.pickColors = Buffers.newDirectByteBuffer(3 * shapefileGeometry.vertexCount);
        }
        this.pickColors.clear();
        for (RecordIndices recordIndices : shapefileGeometry.recordIndices) {
            Color color = this.pickColorMap.get(recordIndices.ordinal);
            if (color == null) {
                color = drawContext.getUniquePickColor();
                this.pickColorMap.put(recordIndices.ordinal, color);
            }
            ShapefileRenderable.Record record = this.getRecord(recordIndices.ordinal);
            surfaceTileDrawContext.addPickCandidate(new PickedObject(color.getRGB(), record));
            for (int i = 0; i < recordIndices.vertexRange.length; ++i) {
                this.pickColors.put((byte)color.getRed()).put((byte)color.getGreen()).put((byte)color.getBlue());
            }
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glEnableClientState(32886);
        gL2.glColorPointer(3, 5121, 0, this.pickColors.flip());
    }

    protected void drawAttributeGroup(DrawContext drawContext, RecordGroup recordGroup) {
        double d;
        Color color;
        GL2 gL2 = drawContext.getGL().getGL2();
        ShapeAttributes shapeAttributes = recordGroup.attributes;
        if (shapeAttributes.isDrawInterior() && (drawContext.isPickingMode() || shapeAttributes.getInteriorOpacity() > 0.0)) {
            if (!drawContext.isPickingMode()) {
                color = shapeAttributes.getInteriorMaterial().getDiffuse();
                d = shapeAttributes.getInteriorOpacity() * 255.0 + 0.5;
                gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)d);
            }
            gL2.glDrawElements(4, recordGroup.interiorIndexRange.length, 5125, recordGroup.indices.position(recordGroup.interiorIndexRange.location));
            recordGroup.indices.rewind();
        }
        if (shapeAttributes.isDrawOutline() && (drawContext.isPickingMode() || shapeAttributes.getOutlineOpacity() > 0.0)) {
            if (!drawContext.isPickingMode()) {
                color = shapeAttributes.getOutlineMaterial().getDiffuse();
                d = shapeAttributes.getOutlineOpacity() * 255.0 + 0.5;
                gL2.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)d);
                gL2.glLineWidth((float)shapeAttributes.getOutlineWidth());
            } else {
                gL2.glLineWidth((float)Math.max(shapeAttributes.getOutlineWidth(), (double)this.getOutlinePickWidth()));
            }
            gL2.glDrawElements(1, recordGroup.outlineIndexRange.length, 5125, recordGroup.indices.position(recordGroup.outlineIndexRange.location));
            recordGroup.indices.rewind();
        }
    }

    protected static void fillArray4(double[] dArray, int n, double d, double d2, double d3, double d4) {
        dArray[0 + n] = d;
        dArray[1 + n] = d2;
        dArray[2 + n] = d3;
        dArray[3 + n] = d4;
    }

    protected void combineBounds(CombineContext combineContext) {
        combineContext.addBoundingSector(this.sector);
    }

    protected void combineContours(CombineContext combineContext) {
        if (!combineContext.getSector().intersects(this.sector)) {
            return;
        }
        this.doCombineContours(combineContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCombineContours(CombineContext combineContext) {
        Set<Record> set = this.recordTree.getItemsInRegion(combineContext.getSector(), null);
        if (set.isEmpty()) {
            return;
        }
        PolylineGeneralizer polylineGeneralizer = new PolylineGeneralizer();
        double d = combineContext.getResolution() * 180.0 / Math.PI;
        double d2 = d * d;
        GLUtessellator gLUtessellator = GLU.gluNewTess();
        try {
            GLUTessellatorSupport.RecursiveCallback recursiveCallback = new GLUTessellatorSupport.RecursiveCallback(combineContext.getTessellator());
            GLU.gluTessCallback(gLUtessellator, 100100, recursiveCallback);
            GLU.gluTessCallback(gLUtessellator, 100101, recursiveCallback);
            GLU.gluTessCallback(gLUtessellator, 100102, recursiveCallback);
            GLU.gluTessCallback(gLUtessellator, 100105, recursiveCallback);
            GLU.gluTessProperty(gLUtessellator, 100141, 1.0);
            GLU.gluTessProperty(gLUtessellator, 100140, 100131.0);
            GLU.gluTessNormal(gLUtessellator, 0.0, 0.0, 1.0);
            GLU.gluTessBeginPolygon(gLUtessellator, null);
            for (Record record : set) {
                double d3;
                if (!record.isVisible() || !record.sector.intersects(combineContext.getSector()) || (d3 = record.sector.getDeltaLatDegrees() * record.sector.getDeltaLonDegrees()) < d2) continue;
                this.computeRecordMetrics(record, polylineGeneralizer);
                this.doCombineRecord(gLUtessellator, combineContext.getSector(), d2, record);
            }
        }
        finally {
            GLU.gluTessEndPolygon(gLUtessellator);
            GLU.gluDeleteTess(gLUtessellator);
        }
    }

    protected void doCombineRecord(GLUtessellator gLUtessellator, Sector sector, double d, Record record) {
        for (int i = 0; i < record.getBoundaryCount(); ++i) {
            this.doCombineBoundary(gLUtessellator, sector, d, record, i);
        }
    }

    protected void doCombineBoundary(GLUtessellator gLUtessellator, Sector sector, double d, Record record, int n) {
        final ClippingTessellator clippingTessellator = new ClippingTessellator(gLUtessellator, sector);
        this.tessellateBoundary(record, n, d, new TessBoundaryCallback(){

            @Override
            public void beginBoundary() {
                clippingTessellator.beginContour();
            }

            @Override
            public void vertex(double d, double d2) {
                clippingTessellator.addVertex(d, d2);
            }

            @Override
            public void endBoundary() {
                clippingTessellator.endContour();
            }
        });
    }

    protected void tessellateBoundary(Record record, int n, double d, TessBoundaryCallback tessBoundaryCallback) {
        VecBuffer vecBuffer = record.getBoundaryPoints(n);
        double[] dArray = record.getBoundaryEffectiveArea(n);
        double[] dArray2 = new double[2];
        if (!record.isBoundaryCrossesAntimeridian(n)) {
            tessBoundaryCallback.beginBoundary();
            for (int i = 0; i < vecBuffer.getSize(); ++i) {
                if (dArray[i] < d) continue;
                vecBuffer.get(i, dArray2);
                tessBoundaryCallback.vertex(dArray2[1], dArray2[0]);
            }
            tessBoundaryCallback.endBoundary();
        } else {
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            for (int i = 0; i < vecBuffer.getSize(); ++i) {
                if (dArray[i] < d) continue;
                vecBuffer.get(i, dArray2);
                arrayList.add(LatLon.fromDegrees(dArray2[1], dArray2[0]));
            }
            String string = LatLon.locationsContainPole(arrayList);
            if (string != null) {
                tessBoundaryCallback.beginBoundary();
                for (LatLon latLon : LatLon.cutLocationsAlongDateLine(arrayList, string, null)) {
                    tessBoundaryCallback.vertex(latLon.latitude.degrees, latLon.longitude.degrees);
                }
                tessBoundaryCallback.endBoundary();
            } else {
                for (List<LatLon> list : LatLon.repeatLocationsAroundDateline(arrayList)) {
                    tessBoundaryCallback.beginBoundary();
                    for (LatLon latLon : list) {
                        tessBoundaryCallback.vertex(latLon.latitude.degrees, latLon.longitude.degrees);
                    }
                    tessBoundaryCallback.endBoundary();
                }
            }
        }
    }

    static {
        if (!WorldWind.getMemoryCacheSet().containsCache(ShapefileGeometry.class.getName())) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.ShapefileGeometryCacheSize", 50000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.8 * (double)l), l);
            basicMemoryCache.setName("Shapefile Geometry");
            WorldWind.getMemoryCacheSet().addCache(ShapefileGeometry.class.getName(), basicMemoryCache);
        }
    }

    protected static class ShapefileGeometry
    implements Runnable,
    Cacheable,
    Comparable<ShapefileGeometry> {
        protected final ShapefileRenderable shape;
        protected final Sector sector;
        protected final double resolution;
        protected MemoryCache memoryCache;
        protected Object memoryCacheKey;
        protected PropertyChangeListener listener;
        protected double priority;
        protected FloatBuffer vertices;
        protected int vertexStride;
        protected int vertexCount;
        protected Vec4 vertexOffset;
        protected ArrayList<RecordIndices> recordIndices = new ArrayList();
        protected ArrayList<RecordGroup> attributeGroups = new ArrayList();
        protected long attributeStateID;

        public ShapefileGeometry(ShapefileRenderable shapefileRenderable, Sector sector, double d) {
            this.shape = shapefileRenderable;
            this.sector = sector;
            this.resolution = d;
        }

        @Override
        public void run() {
            try {
                ((ShapefilePolygons)this.shape).tessellate(this);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhileTessellating", this.shape);
                Logging.logger().log(Level.SEVERE, string, exception);
            }
            finally {
                if (this.memoryCache != null && this.memoryCacheKey != null) {
                    this.memoryCache.add(this.memoryCacheKey, this);
                }
                if (this.listener != null) {
                    this.listener.propertyChange(new PropertyChangeEvent(this, "gov.nasa.worldwind.avkey.Repaint", null, null));
                }
                this.memoryCache = null;
                this.memoryCacheKey = null;
                this.listener = null;
            }
        }

        @Override
        public long getSizeInBytes() {
            return 244L + this.sector.getSizeInBytes() + (long)(this.vertices != null ? 4 * this.vertices.remaining() : 0);
        }

        @Override
        public int compareTo(ShapefileGeometry shapefileGeometry) {
            return Double.compare(this.priority, shapefileGeometry.priority);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ShapefileGeometry shapefileGeometry = (ShapefileGeometry)object;
            return this.shape.equals(shapefileGeometry.shape) && this.sector.equals(shapefileGeometry.sector) && this.resolution == shapefileGeometry.resolution;
        }

        public int hashCode() {
            long l = this.resolution != 0.0 ? Double.doubleToLongBits(this.resolution) : 0L;
            int n = this.shape.hashCode();
            n = 31 * n + this.sector.hashCode();
            n = 31 * n + (int)(l ^ l >>> 32);
            return n;
        }
    }

    public static class Record
    extends ShapefileRenderable.Record {
        protected double[][] boundaryEffectiveArea;
        protected boolean[] boundaryCrossesAntimeridian;

        public Record(ShapefileRenderable shapefileRenderable, ShapefileRecord shapefileRecord) {
            super(shapefileRenderable, shapefileRecord);
        }

        protected double[] getBoundaryEffectiveArea(int n) {
            return this.boundaryEffectiveArea != null ? this.boundaryEffectiveArea[n] : null;
        }

        protected boolean isBoundaryCrossesAntimeridian(int n) {
            return this.boundaryCrossesAntimeridian != null && this.boundaryCrossesAntimeridian[n];
        }
    }

    protected static class ShapefileTile
    implements OrderedRenderable,
    SurfaceRenderable {
        protected final ShapefileRenderable shape;
        protected final Sector sector;
        protected final double resolution;
        protected ShapefileTile fallbackTile;
        protected ShapefileGeometry geometry;
        protected final Object nullGeometryStateKey = new Object();

        public ShapefileTile(ShapefileRenderable shapefileRenderable, Sector sector, double d) {
            this.shape = shapefileRenderable;
            this.sector = sector;
            this.resolution = d;
        }

        public ShapefileRenderable getShape() {
            return this.shape;
        }

        public Sector getSector() {
            return this.sector;
        }

        public double getResolution() {
            return this.resolution;
        }

        public ShapefileGeometry getGeometry() {
            return this.geometry;
        }

        public void setGeometry(ShapefileGeometry shapefileGeometry) {
            this.geometry = shapefileGeometry;
        }

        public ShapefileTile[] subdivide() {
            Sector[] sectorArray = this.sector.subdivide();
            ShapefileTile[] shapefileTileArray = new ShapefileTile[]{new ShapefileTile(this.shape, sectorArray[0], this.resolution / 2.0), new ShapefileTile(this.shape, sectorArray[1], this.resolution / 2.0), new ShapefileTile(this.shape, sectorArray[2], this.resolution / 2.0), new ShapefileTile(this.shape, sectorArray[3], this.resolution / 2.0)};
            return shapefileTileArray;
        }

        @Override
        public double getDistanceFromEye() {
            return 0.0;
        }

        @Override
        public List<Sector> getSectors(DrawContext drawContext) {
            return Arrays.asList(this.sector);
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
        }

        @Override
        public Object getStateKey(DrawContext drawContext) {
            return this.geometry != null ? new ShapefileGeometryStateKey(this.geometry) : this.nullGeometryStateKey;
        }

        @Override
        public void render(DrawContext drawContext) {
            ((ShapefilePolygons)this.shape).render(drawContext, this);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ShapefileTile shapefileTile = (ShapefileTile)object;
            return this.shape.equals(shapefileTile.shape) && this.sector.equals(shapefileTile.sector) && this.resolution == shapefileTile.resolution;
        }

        public int hashCode() {
            long l = this.resolution != 0.0 ? Double.doubleToLongBits(this.resolution) : 0L;
            int n = this.shape.hashCode();
            n = 31 * n + this.sector.hashCode();
            n = 31 * n + (int)(l ^ l >>> 32);
            return n;
        }
    }

    protected static interface TessBoundaryCallback {
        public void beginBoundary();

        public void vertex(double var1, double var3);

        public void endBoundary();
    }

    protected static class RecordIndices {
        protected final int ordinal;
        protected Range vertexRange = new Range(0, 0);
        protected IntBuffer interiorIndices;
        protected IntBuffer outlineIndices;

        public RecordIndices(int n) {
            this.ordinal = n;
        }
    }

    protected static class RecordGroup {
        protected final ShapeAttributes attributes;
        protected IntBuffer indices;
        protected Range interiorIndexRange = new Range(0, 0);
        protected Range outlineIndexRange = new Range(0, 0);
        protected ArrayList<RecordIndices> recordIndices = new ArrayList();

        public RecordGroup(ShapeAttributes shapeAttributes) {
            this.attributes = shapeAttributes;
        }
    }

    protected static class ShapefileGeometryStateKey {
        protected final ShapefileGeometry geometry;
        protected final long attributeStateID;
        protected final ShapeAttributes[] attributeGroups;

        public ShapefileGeometryStateKey(ShapefileGeometry shapefileGeometry) {
            this.geometry = shapefileGeometry;
            this.attributeStateID = shapefileGeometry.attributeStateID;
            this.attributeGroups = new ShapeAttributes[shapefileGeometry.attributeGroups.size()];
            for (int i = 0; i < this.attributeGroups.length; ++i) {
                this.attributeGroups[i] = shapefileGeometry.attributeGroups.get((int)i).attributes.copy();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ShapefileGeometryStateKey shapefileGeometryStateKey = (ShapefileGeometryStateKey)object;
            return this.geometry.equals(shapefileGeometryStateKey.geometry) && this.attributeStateID == shapefileGeometryStateKey.attributeStateID && Arrays.equals(this.attributeGroups, shapefileGeometryStateKey.attributeGroups);
        }

        public int hashCode() {
            int n = this.geometry.hashCode();
            n = 31 * n + (int)(this.attributeStateID ^ this.attributeStateID >>> 32);
            n = 31 * n + Arrays.hashCode(this.attributeGroups);
            return n;
        }
    }
}

