/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.formats.shapefile.ShapefileUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ShapefileRecordMultiPoint
extends ShapefileRecord {
    protected double[] boundingRectangle;
    protected double[] zRange;
    protected double[] zValues;
    protected double[] mRange;
    protected double[] mValues;

    public ShapefileRecordMultiPoint(Shapefile shapefile, ByteBuffer byteBuffer) {
        super(shapefile, byteBuffer);
    }

    @Override
    public boolean isMultiPointRecord() {
        return true;
    }

    public Iterable<double[]> getPoints(int n) {
        return this.getPointBuffer(n).getCoords();
    }

    public double[] getZRange() {
        return this.zRange;
    }

    public double[] getZValues() {
        return this.zValues;
    }

    public double[] getMRange() {
        return this.mRange;
    }

    public double[] getMValues() {
        return this.mValues;
    }

    @Override
    public double[] getBoundingRectangle() {
        return this.boundingRectangle != null ? this.boundingRectangle : null;
    }

    @Override
    protected void doReadFromBuffer(Shapefile shapefile, ByteBuffer byteBuffer) {
        Shapefile.BoundingRectangle boundingRectangle = shapefile.readBoundingRectangle(byteBuffer);
        this.boundingRectangle = boundingRectangle.coords;
        if (boundingRectangle.isNormalized) {
            this.setNormalizePoints(true);
        }
        this.numberOfParts = 1;
        this.numberOfPoints = byteBuffer.getInt();
        this.firstPartNumber = -1;
        if (this.numberOfPoints > 0) {
            this.firstPartNumber = shapefile.addPoints(this, byteBuffer, this.numberOfPoints);
        }
        if (this.isZType()) {
            this.readZ(byteBuffer);
        }
        if (this.isMeasureType()) {
            this.readOptionalMeasures(byteBuffer);
        }
    }

    protected void readZ(ByteBuffer byteBuffer) {
        this.zRange = ShapefileUtils.readDoubleArray(byteBuffer, 2);
        this.zValues = ShapefileUtils.readDoubleArray(byteBuffer, this.getNumberOfPoints());
    }

    protected void readOptionalMeasures(ByteBuffer byteBuffer) {
        if (byteBuffer.hasRemaining() && byteBuffer.limit() - byteBuffer.position() >= this.getNumberOfPoints() * 8) {
            this.mRange = ShapefileUtils.readDoubleArray(byteBuffer, 2);
            this.mValues = ShapefileUtils.readDoubleArray(byteBuffer, this.getNumberOfPoints());
        }
    }

    @Override
    public void exportAsKML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        xMLStreamWriter.writeStartElement("Placemark");
        xMLStreamWriter.writeStartElement("name");
        xMLStreamWriter.writeCharacters(Integer.toString(this.getRecordNumber()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("MultiGeometry");
        String string = this.isZType() ? "absolute" : "clampToGround";
        Iterable<double[]> iterable = this.getPoints(0);
        double[] dArray = this.getZValues();
        int n = 0;
        for (double[] dArray2 : iterable) {
            xMLStreamWriter.writeStartElement("Point");
            double d = 0.0;
            if (dArray != null && n < dArray.length) {
                d = dArray[n];
            }
            xMLStreamWriter.writeStartElement("altitudeMode");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
            String string2 = String.format("%f,%f,%f", dArray2[0], dArray2[1], d);
            xMLStreamWriter.writeStartElement("coordinates");
            xMLStreamWriter.writeCharacters(string2);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            ++n;
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
    }
}

