/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.formats.vpf.GeoSymAbbreviationProvider;
import gov.nasa.worldwind.formats.vpf.GeoSymAssignment;
import gov.nasa.worldwind.formats.vpf.GeoSymAttributeExpression;
import gov.nasa.worldwind.formats.vpf.GeoSymAttributeExpressionProvider;
import gov.nasa.worldwind.formats.vpf.GeoSymStyleProvider;
import gov.nasa.worldwind.formats.vpf.GeoSymTable;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClass;
import gov.nasa.worldwind.formats.vpf.VPFFeatureType;
import gov.nasa.worldwind.formats.vpf.VPFSymbolAttributes;
import gov.nasa.worldwind.formats.vpf.VPFSymbolKey;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class GeoSymSupport {
    protected static final String UNKNOWN_POINT_SYMBOL = "5000";
    protected static final String UNKNOWN_LINE_SYMBOL = "5001";
    private String filePath;
    private String imageSuffix;
    private GeoSymAssignment assignment;
    private Map<FeatureKey, List<? extends VPFSymbolKey>> featureMap;
    private Map<Integer, VPFSymbolAttributes.LabelAttributes> textJoinAttributes;
    private Map<String, Integer> productTypes;
    private Map<String, Integer> deliniations;
    private Map<VPFFeatureType, String> featureName;
    private GeoSymStyleProvider styleProvider;
    private GeoSymAbbreviationProvider abbreviationProvider;
    private GeoSymAttributeExpressionProvider attributeExpressionProvider;

    public GeoSymSupport(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.ImageFomat");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.filePath = string;
        this.imageSuffix = WWIO.makeSuffixForMimeType(string2);
        this.featureMap = new HashMap<FeatureKey, List<? extends VPFSymbolKey>>();
        this.loadAssignment(string);
        if (this.assignment == null) {
            String string5 = Logging.getMessage("VPF.GeoSymSupportDisabled");
            Logging.logger().warning(string5);
        } else {
            this.loadStyleProvider();
            this.loadAbbreviationProvider();
            this.loadAttributeExpressionProvider();
            this.loadLabelAttributes();
            this.loadProductTypes();
            this.loadFeatureTypes();
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getImageSuffix() {
        return this.imageSuffix;
    }

    public GeoSymAssignment getAssignment() {
        return this.assignment;
    }

    public Iterable<? extends VPFSymbolKey> getSymbolKeys(VPFFeatureClass vPFFeatureClass, String string, AVList aVList) {
        if (vPFFeatureClass == null) {
            String string2 = Logging.getMessage("nullValue.FeatureClassIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.FeatureCodeIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (this.getAssignment() == null) {
            return null;
        }
        if (vPFFeatureClass.getType() == VPFFeatureType.TEXT) {
            return null;
        }
        FeatureKey featureKey = new FeatureKey(vPFFeatureClass, string);
        List<? extends VPFSymbolKey> list = this.featureMap.get(featureKey);
        if (list == null && !this.featureMap.containsKey(featureKey)) {
            list = this.doGetSymbolKeys(vPFFeatureClass, string);
            this.featureMap.put(featureKey, list);
        }
        if (list != null && aVList != null) {
            list = this.doEvaluateSymbolKeys(list, aVList);
        }
        List<? extends VPFSymbolKey> list2 = list;
        if (list != null && list.size() == 0) {
            list2 = this.doGetUnknownSymbolKeys();
        }
        return list2;
    }

    public Iterable<? extends VPFSymbolAttributes> getSymbolAttributes(VPFFeatureClass vPFFeatureClass, VPFSymbolKey vPFSymbolKey) {
        if (vPFSymbolKey == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.getAssignment() == null) {
            return null;
        }
        if (vPFFeatureClass.getType() == VPFFeatureType.TEXT) {
            return null;
        }
        if (vPFSymbolKey == VPFSymbolKey.UNKNOWN_SYMBOL_KEY) {
            return this.doGetUnknownSymbolAttributes(vPFFeatureClass, vPFSymbolKey);
        }
        return this.doGetSymbolAttributes(vPFFeatureClass, vPFSymbolKey);
    }

    public Object getSymbolSource(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.SymbolIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.getAssignment() == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.filePath);
        stringBuilder.append("/");
        stringBuilder.append("graphics");
        stringBuilder.append("/");
        stringBuilder.append("bin");
        stringBuilder.append("/");
        stringBuilder.append(string);
        if (this.imageSuffix != null) {
            stringBuilder.append(this.imageSuffix);
        }
        return stringBuilder.toString();
    }

    public String getAbbreviation(int n, int n2) {
        return this.abbreviationProvider.getAbbreviation(n, n2);
    }

    protected void loadAssignment(String string) {
        String string2 = this.getAssignmentPath(string);
        if (!GeoSymAssignment.isGeoSymAssignment(string2)) {
            String string3 = Logging.getMessage("VPF.GeoSymNotFound");
            Logging.logger().warning(string3);
            return;
        }
        try {
            this.assignment = GeoSymAssignment.fromFile(string2);
        }
        catch (Exception exception) {
            String string4 = Logging.getMessage("generic.ExceptionWhileReading", string);
            Logging.logger().log(Level.SEVERE, string4, exception);
        }
    }

    protected void loadStyleProvider() {
        String string = this.getPathForAssignmentFile(this.filePath, "geosym-line-area-attr.csv");
        try {
            this.styleProvider = new GeoSymStyleProvider(string);
        }
        catch (Exception exception) {
            String string2 = Logging.getMessage("generic.ExceptionWhileReading", string);
            Logging.logger().log(Level.SEVERE, string2, exception);
        }
    }

    protected void loadAbbreviationProvider() {
        String string = this.getPathForAssignmentFile(this.filePath, "textabbr.txt");
        try {
            this.abbreviationProvider = new GeoSymAbbreviationProvider(string);
        }
        catch (Exception exception) {
            String string2 = Logging.getMessage("generic.ExceptionWhileReading", string);
            Logging.logger().log(Level.SEVERE, string2, exception);
        }
    }

    protected void loadAttributeExpressionProvider() {
        GeoSymTable geoSymTable = this.getAssignment().getTable("attexp.txt");
        try {
            this.attributeExpressionProvider = new GeoSymAttributeExpressionProvider(geoSymTable);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileReading", "attexp.txt");
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    protected void loadLabelAttributes() {
        GeoSymTable geoSymTable = this.getAssignment().getTable("color.txt");
        GeoSymTable geoSymTable2 = this.getAssignment().getTable("textchar.txt");
        GeoSymTable geoSymTable3 = this.getAssignment().getTable("textloc.txt");
        HashMap<Integer, VPFSymbolAttributes.LabelAttributes> hashMap = GeoSymSupport.getTextLabelCharacteristics(geoSymTable2, geoSymTable);
        HashMap<Integer, VPFSymbolAttributes.LabelAttributes> hashMap2 = GeoSymSupport.getTextLabelLocations(geoSymTable3);
        this.textJoinAttributes = new HashMap<Integer, VPFSymbolAttributes.LabelAttributes>();
        GeoSymTable geoSymTable4 = this.getAssignment().getTable("textjoin.txt");
        for (AVList aVList : geoSymTable4.getRecords()) {
            VPFSymbolAttributes.LabelAttributes labelAttributes;
            int n = (Integer)aVList.getValue("id");
            int n2 = (Integer)aVList.getValue("textcharid");
            int n3 = (Integer)aVList.getValue("textlocid");
            VPFSymbolAttributes.LabelAttributes labelAttributes2 = new VPFSymbolAttributes.LabelAttributes();
            VPFSymbolAttributes.LabelAttributes labelAttributes3 = (VPFSymbolAttributes.LabelAttributes)hashMap.get(n2);
            if (labelAttributes3 != null) {
                labelAttributes2.setFont(labelAttributes3.getFont());
                labelAttributes2.setColor(labelAttributes3.getColor());
                labelAttributes2.setBackgroundColor(labelAttributes3.getBackgroundColor());
                labelAttributes2.setPrepend(labelAttributes3.getPrepend());
                labelAttributes2.setAppend(labelAttributes3.getAppend());
                labelAttributes2.setAbbreviationTableId(labelAttributes3.getAbbreviationTableId());
            }
            if ((labelAttributes = (VPFSymbolAttributes.LabelAttributes)hashMap2.get(n3)) != null) {
                labelAttributes2.setOffset(labelAttributes.getOffset());
                labelAttributes2.setOffsetAngle(labelAttributes.getOffsetAngle());
            }
            this.textJoinAttributes.put(n, labelAttributes2);
        }
    }

    protected void loadProductTypes() {
        GeoSymTable geoSymTable = this.getAssignment().getTable("code.txt");
        ArrayList<AVList> arrayList = new ArrayList<AVList>(Arrays.asList(geoSymTable.getRecords()));
        GeoSymTable.selectMatchingRows("file", "fullsym.txt", false, arrayList);
        GeoSymTable.selectMatchingRows("attribute", "pid", false, arrayList);
        this.productTypes = new HashMap<String, Integer>();
        for (AVList aVList : arrayList) {
            Integer n = (Integer)aVList.getValue("value");
            String string = (String)aVList.getValue("description");
            if (n == null || string == null) continue;
            this.productTypes.put(string.toUpperCase(), n);
        }
    }

    protected void loadFeatureTypes() {
        GeoSymTable geoSymTable = this.getAssignment().getTable("code.txt");
        ArrayList<AVList> arrayList = new ArrayList<AVList>(Arrays.asList(geoSymTable.getRecords()));
        GeoSymTable.selectMatchingRows("file", "fullsym.txt", false, arrayList);
        GeoSymTable.selectMatchingRows("attribute", "delin", false, arrayList);
        this.deliniations = new HashMap<String, Integer>();
        for (AVList aVList : arrayList) {
            Integer n = (Integer)aVList.getValue("value");
            String string = (String)aVList.getValue("description");
            if (n == null || string == null) continue;
            this.deliniations.put(string.toUpperCase(), n);
        }
        this.featureName = new HashMap<VPFFeatureType, String>();
        this.featureName.put(VPFFeatureType.POINT, "POINT");
        this.featureName.put(VPFFeatureType.LINE, "LINE");
        this.featureName.put(VPFFeatureType.AREA, "AREA");
    }

    protected String getAssignmentPath(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("/");
        stringBuilder.append("symasgn");
        stringBuilder.append("/");
        stringBuilder.append("ascii");
        return stringBuilder.toString();
    }

    protected String getPathForAssignmentFile(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getAssignmentPath(string));
        stringBuilder.append("/");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    protected static HashMap<Integer, VPFSymbolAttributes.LabelAttributes> getTextLabelCharacteristics(GeoSymTable geoSymTable, GeoSymTable geoSymTable2) {
        HashMap<Integer, VPFSymbolAttributes.LabelAttributes> hashMap = new HashMap<Integer, VPFSymbolAttributes.LabelAttributes>();
        for (AVList aVList : geoSymTable.getRecords()) {
            Integer n = (Integer)aVList.getValue("id");
            VPFSymbolAttributes.LabelAttributes labelAttributes = GeoSymSupport.getTextLabelCharacteristics(aVList, geoSymTable2);
            hashMap.put(n, labelAttributes);
        }
        return hashMap;
    }

    protected static VPFSymbolAttributes.LabelAttributes getTextLabelCharacteristics(AVList aVList, GeoSymTable geoSymTable) {
        VPFSymbolAttributes.LabelAttributes labelAttributes = new VPFSymbolAttributes.LabelAttributes();
        Integer n = (Integer)aVList.getValue("tfont");
        Integer n2 = (Integer)aVList.getValue("tstyle");
        Integer n3 = (Integer)aVList.getValue("tsize");
        Color color = GeoSymSupport.selectColor(geoSymTable, (Integer)aVList.getValue("tcolor"));
        String string = (String)aVList.getValue("tprepend");
        String string2 = (String)aVList.getValue("tappend");
        Integer n4 = (Integer)aVList.getValue("abindexid");
        if (n != null && n2 != null && n3 != null) {
            Object object;
            Object object2 = object = n == 0 ? "Arial-" : "Serif-";
            object = n2 == 0 || n2 == 4 ? (String)object + "PLAIN" : (n2 == 1 || n2 == 5 ? (String)object + "BOLD" : (n2 == 2 || n2 == 6 ? (String)object + "ITALIC" : (n2 == 3 || n2 == 7 ? (String)object + "BOLDITALIC" : (String)object + "PLAIN")));
            object = (String)object + "-" + n3;
            labelAttributes.setFont(Font.decode((String)object));
        }
        if (color != null) {
            labelAttributes.setColor(color);
            labelAttributes.setBackgroundColor(WWUtil.computeContrastingColor(color));
        }
        if (string != null) {
            labelAttributes.setPrepend("" + Character.toChars(Integer.parseInt(string, 16))[0]);
        }
        if (string2 != null) {
            labelAttributes.setAppend("" + Character.toChars(Integer.parseInt(string2, 16))[0]);
        }
        if (n4 != null) {
            labelAttributes.setAbbreviationTableId(n4);
        }
        return labelAttributes;
    }

    protected static HashMap<Integer, VPFSymbolAttributes.LabelAttributes> getTextLabelLocations(GeoSymTable geoSymTable) {
        HashMap<Integer, VPFSymbolAttributes.LabelAttributes> hashMap = new HashMap<Integer, VPFSymbolAttributes.LabelAttributes>();
        for (AVList aVList : geoSymTable.getRecords()) {
            Integer n = (Integer)aVList.getValue("id");
            VPFSymbolAttributes.LabelAttributes labelAttributes = GeoSymSupport.getTextLabelLocation(aVList);
            hashMap.put(n, labelAttributes);
        }
        return hashMap;
    }

    protected static VPFSymbolAttributes.LabelAttributes getTextLabelLocation(AVList aVList) {
        VPFSymbolAttributes.LabelAttributes labelAttributes = new VPFSymbolAttributes.LabelAttributes();
        Integer n = (Integer)aVList.getValue("tdist");
        if (n != null) {
            labelAttributes.setOffset(n.intValue());
        }
        if ((n = (Integer)aVList.getValue("tdir")) != null) {
            labelAttributes.setOffsetAngle(Angle.fromDegrees(n.intValue()));
        }
        return labelAttributes;
    }

    protected List<? extends VPFSymbolKey> doGetSymbolKeys(VPFFeatureClass vPFFeatureClass, String string) {
        Collection<AVList> collection = this.selectSymbolRows(vPFFeatureClass, string);
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VPFSymbolKey> arrayList = new ArrayList<VPFSymbolKey>();
        for (AVList aVList : collection) {
            Integer n;
            if (aVList == null || (n = AVListImpl.getIntegerValue(aVList, "id")) == null) continue;
            arrayList.add(new VPFSymbolKey(n));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    protected List<? extends VPFSymbolKey> doGetUnknownSymbolKeys() {
        return Arrays.asList(VPFSymbolKey.UNKNOWN_SYMBOL_KEY);
    }

    protected List<VPFSymbolKey> doEvaluateSymbolKeys(Iterable<? extends VPFSymbolKey> iterable, AVList aVList) {
        ArrayList<VPFSymbolKey> arrayList = new ArrayList<VPFSymbolKey>();
        for (VPFSymbolKey vPFSymbolKey : iterable) {
            GeoSymAttributeExpression geoSymAttributeExpression = this.attributeExpressionProvider.getAttributeExpression(vPFSymbolKey.getSymbolCode());
            if (geoSymAttributeExpression != null && !geoSymAttributeExpression.evaluate(aVList)) continue;
            arrayList.add(vPFSymbolKey);
        }
        return arrayList;
    }

    protected Collection<AVList> selectSymbolRows(VPFFeatureClass vPFFeatureClass, String string) {
        Object object;
        Integer n;
        int n2 = -1;
        String string2 = this.getProductName(vPFFeatureClass);
        if (string2 != null && (n = this.productTypes.get(string2.toUpperCase())) != null) {
            n2 = n;
        }
        int n3 = -1;
        String string3 = this.featureName.get((Object)vPFFeatureClass.getType());
        if (string3 != null && (object = this.deliniations.get(string3.toUpperCase())) != null) {
            n3 = (Integer)object;
        }
        object = vPFFeatureClass.getCoverage().getName();
        GeoSymTable geoSymTable = this.getAssignment().getTable("fullsym.txt");
        return GeoSymSupport.selectSymbolAssignments(geoSymTable, n2, string, n3, (String)object);
    }

    protected static Collection<AVList> selectSymbolAssignments(GeoSymTable geoSymTable, int n, String string, int n2, String string2) {
        ArrayList<AVList> arrayList = new ArrayList<AVList>(Arrays.asList(geoSymTable.getRecords()));
        GeoSymTable.selectMatchingStringRows("fcode", string, false, arrayList);
        if (n > 0) {
            GeoSymTable.selectMatchingRows("pid", n, true, arrayList);
        }
        if (n2 > 0) {
            GeoSymTable.selectMatchingRows("delin", n2, true, arrayList);
        }
        if (string2 != null) {
            GeoSymSupport.selectMatchingCoverages("cov", string2, true, arrayList);
        }
        return arrayList;
    }

    protected String getProductName(VPFFeatureClass vPFFeatureClass) {
        String string = vPFFeatureClass.getCoverage().getLibrary().getProductType();
        if (string != null && string.equals("TADS")) {
            string = "VITD";
        }
        return string;
    }

    protected static void selectMatchingCoverages(String string, String string2, boolean bl, List<AVList> list) {
        Iterator<AVList> iterator = list.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        while (iterator.hasNext()) {
            Object object;
            AVList aVList = iterator.next();
            if (aVList == null || (object = aVList.getValue(string)) != null && !(object instanceof String)) continue;
            String string3 = (String)object;
            if (string3 == null || string3.length() == 0) {
                if (bl) continue;
                iterator.remove();
                continue;
            }
            int n = string3.indexOf("<>");
            if (n >= 0) {
                string3 = string3.substring(n + 1, string3.length());
            }
            boolean bl2 = string3.equalsIgnoreCase(string2);
            if ((n >= 0 || bl2) && (n < 0 || !bl2)) continue;
            iterator.remove();
        }
    }

    protected static int selectCodeValue(GeoSymTable geoSymTable, String string, String string2, String string3) {
        ArrayList<AVList> arrayList = new ArrayList<AVList>(Arrays.asList(geoSymTable.getRecords()));
        GeoSymTable.selectMatchingStringRows("file", string, false, arrayList);
        GeoSymTable.selectMatchingStringRows("attribute", string2, false, arrayList);
        GeoSymTable.selectMatchingStringRows("description", string3, false, arrayList);
        if (arrayList.size() == 0) {
            return -1;
        }
        Integer n = (Integer)arrayList.get(0).getValue("value");
        return n != null ? n : -1;
    }

    protected static String selectCodeDescription(GeoSymTable geoSymTable, String string, String string2, int n) {
        ArrayList<AVList> arrayList = new ArrayList<AVList>(Arrays.asList(geoSymTable.getRecords()));
        GeoSymTable.selectMatchingStringRows("file", string, false, arrayList);
        GeoSymTable.selectMatchingStringRows("attribute", string2, false, arrayList);
        GeoSymTable.selectMatchingRows("value", n, false, arrayList);
        if (arrayList.size() == 0) {
            return null;
        }
        return (String)arrayList.get(0).getValue("description");
    }

    protected static Color selectColor(GeoSymTable geoSymTable, int n) {
        ArrayList<AVList> arrayList = new ArrayList<AVList>(Arrays.asList(geoSymTable.getRecords()));
        GeoSymTable.selectMatchingRows("index", n, false, arrayList);
        if (arrayList.size() == 0) {
            return null;
        }
        AVList aVList = arrayList.get(0);
        Integer n2 = (Integer)aVList.getValue("red");
        Integer n3 = (Integer)aVList.getValue("green");
        Integer n4 = (Integer)aVList.getValue("blue");
        return n2 != null && n3 != null && n4 != null ? new Color(n2, n3, n4) : null;
    }

    protected static AVList selectTextLabelCharacteristics(GeoSymTable geoSymTable, int n) {
        ArrayList<AVList> arrayList = new ArrayList<AVList>(Arrays.asList(geoSymTable.getRecords()));
        GeoSymTable.selectMatchingRows("id", n, false, arrayList);
        return arrayList.size() == 0 ? null : arrayList.get(0);
    }

    protected Iterable<? extends VPFSymbolAttributes> doGetSymbolAttributes(VPFFeatureClass vPFFeatureClass, VPFSymbolKey vPFSymbolKey) {
        GeoSymTable geoSymTable = this.getAssignment().getTable("fullsym.txt");
        AVList aVList = geoSymTable.getRecord(vPFSymbolKey.getSymbolCode());
        if (aVList == null) {
            return null;
        }
        VPFSymbolAttributes vPFSymbolAttributes = null;
        String string = aVList.getStringValue("pointsym");
        if (string != null && string.length() > 0) {
            vPFSymbolAttributes = new VPFSymbolAttributes(VPFFeatureType.POINT, vPFSymbolKey);
            this.assemblePointSymbolAttributes(string, vPFSymbolAttributes);
        } else {
            string = aVList.getStringValue("linesym");
            if (string != null && string.length() > 0) {
                vPFSymbolAttributes = new VPFSymbolAttributes(VPFFeatureType.LINE, vPFSymbolKey);
                this.assembleLineSymbolAttributes(string, vPFSymbolAttributes);
            } else {
                string = aVList.getStringValue("areasym");
                if (string != null && string.length() > 0) {
                    vPFSymbolAttributes = new VPFSymbolAttributes(VPFFeatureType.AREA, vPFSymbolKey);
                    this.assembleAreaSymbolAttributes(string, vPFSymbolAttributes);
                } else {
                    string = aVList.getStringValue("labatt");
                    if (string != null && string.length() > 0) {
                        vPFSymbolAttributes = new VPFSymbolAttributes(VPFFeatureType.LABEL, vPFSymbolKey);
                        this.assembleTextLabelAttributes(aVList, vPFSymbolAttributes);
                    }
                }
            }
        }
        if (vPFSymbolAttributes != null) {
            this.assembleCommonSymbolAttributes(aVList, vPFSymbolAttributes);
        }
        return Arrays.asList(vPFSymbolAttributes);
    }

    protected Iterable<? extends VPFSymbolAttributes> doGetUnknownSymbolAttributes(VPFFeatureClass vPFFeatureClass, VPFSymbolKey vPFSymbolKey) {
        VPFSymbolAttributes vPFSymbolAttributes;
        ArrayList<VPFSymbolAttributes> arrayList = new ArrayList<VPFSymbolAttributes>();
        if (vPFFeatureClass.getType() == VPFFeatureType.POINT || vPFFeatureClass.getType() == VPFFeatureType.AREA) {
            vPFSymbolAttributes = new VPFSymbolAttributes(vPFFeatureClass.getType(), vPFSymbolKey);
            this.assemblePointSymbolAttributes(UNKNOWN_POINT_SYMBOL, vPFSymbolAttributes);
            arrayList.add(vPFSymbolAttributes);
        }
        if (vPFFeatureClass.getType() == VPFFeatureType.LINE || vPFFeatureClass.getType() == VPFFeatureType.AREA) {
            vPFSymbolAttributes = new VPFSymbolAttributes(vPFFeatureClass.getType(), vPFSymbolKey);
            this.assembleLineSymbolAttributes(UNKNOWN_LINE_SYMBOL, vPFSymbolAttributes);
            arrayList.add(vPFSymbolAttributes);
        }
        return arrayList;
    }

    protected void assembleCommonSymbolAttributes(AVList aVList, VPFSymbolAttributes vPFSymbolAttributes) {
        String string;
        Integer n = AVListImpl.getIntegerValue(aVList, "dispri");
        if (n != null) {
            vPFSymbolAttributes.setDisplayPriority(n.intValue());
        }
        if ((string = AVListImpl.getStringValue(aVList, "orient")) != null) {
            vPFSymbolAttributes.setOrientationAttributeName(string);
        }
        if ((string = AVListImpl.getStringValue(aVList, "feadesc")) != null) {
            vPFSymbolAttributes.setDescription(string);
        }
    }

    protected void assemblePointSymbolAttributes(String string, VPFSymbolAttributes vPFSymbolAttributes) {
        Object object = this.getSymbolSource(string);
        vPFSymbolAttributes.setIconImageSource(object);
    }

    protected void assembleLineSymbolAttributes(String string, VPFSymbolAttributes vPFSymbolAttributes) {
        VPFSymbolAttributes vPFSymbolAttributes2;
        VPFSymbolAttributes vPFSymbolAttributes3 = vPFSymbolAttributes2 = this.styleProvider != null ? this.styleProvider.getAttributes(string) : null;
        if (vPFSymbolAttributes2 != null) {
            vPFSymbolAttributes.setDrawInterior(false);
            vPFSymbolAttributes.setDrawOutline(true);
            vPFSymbolAttributes.setOutlineMaterial(vPFSymbolAttributes2.getOutlineMaterial());
            vPFSymbolAttributes.setOutlineWidth(vPFSymbolAttributes2.getOutlineWidth());
            vPFSymbolAttributes.setOutlineStipplePattern(vPFSymbolAttributes2.getOutlineStipplePattern());
            vPFSymbolAttributes.setOutlineStippleFactor(vPFSymbolAttributes2.getOutlineStippleFactor());
        }
    }

    protected void assembleAreaSymbolAttributes(String string, VPFSymbolAttributes vPFSymbolAttributes) {
        VPFSymbolAttributes vPFSymbolAttributes2;
        VPFSymbolAttributes vPFSymbolAttributes3 = vPFSymbolAttributes2 = this.styleProvider != null ? this.styleProvider.getAttributes(string) : null;
        if (vPFSymbolAttributes2 != null) {
            vPFSymbolAttributes.setDrawInterior(true);
            vPFSymbolAttributes.setDrawOutline(false);
            vPFSymbolAttributes.setInteriorMaterial(vPFSymbolAttributes2.getInteriorMaterial());
            if (vPFSymbolAttributes2.getImageSource() != null && vPFSymbolAttributes2.getImageSource() instanceof String) {
                Object object = this.getSymbolSource((String)vPFSymbolAttributes2.getImageSource());
                vPFSymbolAttributes.setImageSource(object);
            }
        }
    }

    protected void assembleTextLabelAttributes(AVList aVList, VPFSymbolAttributes vPFSymbolAttributes) {
        String[] stringArray;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String string = (String)aVList.getValue("labatt");
        if (string != null && string.length() > 0 && (stringArray = string.split(",")) != null && stringArray.length > 0) {
            stringArray2 = stringArray;
        }
        if ((string = (String)aVList.getValue("txrowid")) != null && string.length() > 0 && (stringArray = string.split(",")) != null && stringArray.length > 0) {
            stringArray3 = stringArray;
        }
        if (stringArray2 == null || stringArray3 == null) {
            return;
        }
        int n = stringArray2.length;
        if (n > stringArray3.length) {
            n = stringArray3.length;
        }
        VPFSymbolAttributes.LabelAttributes[] labelAttributesArray = new VPFSymbolAttributes.LabelAttributes[n];
        for (int i = 0; i < n; ++i) {
            VPFSymbolAttributes.LabelAttributes labelAttributes;
            labelAttributesArray[i] = new VPFSymbolAttributes.LabelAttributes();
            labelAttributesArray[i].setAttributeName(stringArray2[i]);
            Integer n2 = WWUtil.convertStringToInteger(stringArray3[i]);
            if (n2 == null || (labelAttributes = this.textJoinAttributes.get(n2)) == null) continue;
            labelAttributesArray[i].setFont(labelAttributes.getFont());
            labelAttributesArray[i].setColor(labelAttributes.getColor());
            labelAttributesArray[i].setBackgroundColor(labelAttributes.getBackgroundColor());
            labelAttributesArray[i].setOffset(labelAttributes.getOffset());
            labelAttributesArray[i].setOffsetAngle(labelAttributes.getOffsetAngle());
            labelAttributesArray[i].setPrepend(labelAttributes.getPrepend());
            labelAttributesArray[i].setAppend(labelAttributes.getAppend());
            labelAttributesArray[i].setAbbreviationTableId(labelAttributes.getAbbreviationTableId());
        }
        vPFSymbolAttributes.setLabelAttributes(labelAttributesArray);
    }

    protected static class FeatureKey {
        private VPFFeatureClass featureClass;
        private String featureCode;

        public FeatureKey(VPFFeatureClass vPFFeatureClass, String string) {
            this.featureClass = vPFFeatureClass;
            this.featureCode = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FeatureKey featureKey = (FeatureKey)object;
            if (this.featureCode != null ? !this.featureCode.equals(featureKey.featureCode) : featureKey.featureCode != null) {
                return false;
            }
            return !(this.featureClass != null ? !this.featureClass.equals(featureKey.featureClass) : featureKey.featureClass != null);
        }

        public int hashCode() {
            int n = this.featureClass != null ? this.featureClass.hashCode() : 0;
            n = 31 * n + (this.featureCode != null ? this.featureCode.hashCode() : 0);
            return n;
        }
    }
}

