/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.formats.vpf.VPFBoundingBox;
import gov.nasa.worldwind.formats.vpf.VPFBufferedRecordData;
import gov.nasa.worldwind.formats.vpf.VPFFeature;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClass;
import gov.nasa.worldwind.formats.vpf.VPFFeatureFactory;
import gov.nasa.worldwind.formats.vpf.VPFPrimitiveData;
import gov.nasa.worldwind.formats.vpf.VPFRecord;
import gov.nasa.worldwind.formats.vpf.VPFRelation;
import gov.nasa.worldwind.formats.vpf.VPFTile;
import gov.nasa.worldwind.formats.vpf.VPFUtils;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class VPFBasicFeatureFactory
implements VPFFeatureFactory {
    private VPFTile tile;
    private VPFPrimitiveData primitiveData;

    public VPFBasicFeatureFactory(VPFTile vPFTile, VPFPrimitiveData vPFPrimitiveData) {
        this.tile = vPFTile;
        this.primitiveData = vPFPrimitiveData;
    }

    public VPFTile getTile() {
        return this.tile;
    }

    public VPFPrimitiveData getPrimitiveData() {
        return this.primitiveData;
    }

    @Override
    public Collection<? extends VPFFeature> createPointFeatures(VPFFeatureClass vPFFeatureClass) {
        if (vPFFeatureClass == null) {
            String string = Logging.getMessage("nullValue.FeatureClassIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.doCreateSimpleFeatures(vPFFeatureClass);
    }

    @Override
    public Collection<? extends VPFFeature> createLineFeatures(VPFFeatureClass vPFFeatureClass) {
        if (vPFFeatureClass == null) {
            String string = Logging.getMessage("nullValue.FeatureClassIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.doCreateSimpleFeatures(vPFFeatureClass);
    }

    @Override
    public Collection<? extends VPFFeature> createAreaFeatures(VPFFeatureClass vPFFeatureClass) {
        if (vPFFeatureClass == null) {
            String string = Logging.getMessage("nullValue.FeatureClassIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.doCreateSimpleFeatures(vPFFeatureClass);
    }

    @Override
    public Collection<? extends VPFFeature> createTextFeatures(VPFFeatureClass vPFFeatureClass) {
        if (vPFFeatureClass == null) {
            String string = Logging.getMessage("nullValue.FeatureClassIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.doCreateSimpleFeatures(vPFFeatureClass);
    }

    @Override
    public Collection<? extends VPFFeature> createComplexFeatures(VPFFeatureClass vPFFeatureClass) {
        if (vPFFeatureClass == null) {
            String string = Logging.getMessage("nullValue.FeatureClassIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.doCreateComplexFeatures(vPFFeatureClass);
    }

    protected Collection<? extends VPFFeature> doCreateSimpleFeatures(VPFFeatureClass vPFFeatureClass) {
        if (this.primitiveData == null) {
            String string = Logging.getMessage("VPF.NoPrimitiveData");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        ArrayList<VPFFeature> arrayList = new ArrayList<VPFFeature>();
        VPFBufferedRecordData vPFBufferedRecordData = this.createFeatureTable(vPFFeatureClass);
        if (vPFBufferedRecordData == null) {
            return null;
        }
        VPFBufferedRecordData vPFBufferedRecordData2 = this.createJoinTable(vPFFeatureClass);
        Iterable<String> iterable = this.getFeatureAttributeKeys(vPFBufferedRecordData);
        for (VPFRecord vPFRecord : vPFBufferedRecordData) {
            VPFFeature vPFFeature = this.doCreateSimpleFeature(vPFFeatureClass, vPFRecord, vPFBufferedRecordData2, iterable);
            if (vPFFeature == null) continue;
            arrayList.add(vPFFeature);
        }
        return arrayList;
    }

    protected VPFFeature doCreateSimpleFeature(VPFFeatureClass vPFFeatureClass, VPFRecord vPFRecord, VPFBufferedRecordData vPFBufferedRecordData, Iterable<String> iterable) {
        if (vPFBufferedRecordData != null) {
            return this.createCompoundSimpleFeature(vPFFeatureClass, vPFRecord, vPFBufferedRecordData, iterable);
        }
        return this.createSimpleFeature(vPFFeatureClass, vPFRecord, iterable);
    }

    protected VPFFeature createSimpleFeature(VPFFeatureClass vPFFeatureClass, VPFRecord vPFRecord, Iterable<String> iterable) {
        if (this.tile != null && !VPFBasicFeatureFactory.matchesTile(vPFRecord, this.tile)) {
            return null;
        }
        VPFRelation vPFRelation = this.getFeatureToPrimitiveRelation(vPFFeatureClass);
        if (vPFRelation == null) {
            return null;
        }
        int n = VPFBasicFeatureFactory.asInt(vPFRecord.getValue(vPFRelation.getTable1Key()));
        VPFPrimitiveData.PrimitiveInfo primitiveInfo = this.primitiveData.getPrimitiveInfo(vPFRelation.getTable2(), n);
        return this.createFeature(vPFFeatureClass, vPFRecord, iterable, primitiveInfo.getBounds(), new int[]{n});
    }

    protected VPFFeature createCompoundSimpleFeature(VPFFeatureClass vPFFeatureClass, VPFRecord vPFRecord, VPFBufferedRecordData vPFBufferedRecordData, Iterable<String> iterable) {
        Object object = this.getPrimitiveIds(vPFFeatureClass, vPFRecord, vPFBufferedRecordData, null, true);
        if (object == null || !(object instanceof Integer)) {
            return null;
        }
        int n = (Integer)object;
        if (n < 1) {
            return null;
        }
        int[] nArray = new int[n];
        VPFBoundingBox vPFBoundingBox = (VPFBoundingBox)this.getPrimitiveIds(vPFFeatureClass, vPFRecord, vPFBufferedRecordData, nArray, false);
        return this.createFeature(vPFFeatureClass, vPFRecord, iterable, vPFBoundingBox, nArray);
    }

    protected VPFFeature createFeature(VPFFeatureClass vPFFeatureClass, VPFRecord vPFRecord, Iterable<String> iterable, VPFBoundingBox vPFBoundingBox, int[] nArray) {
        VPFFeature vPFFeature = new VPFFeature(vPFFeatureClass, vPFRecord.getId(), vPFBoundingBox, nArray);
        this.setFeatureAttributes(vPFRecord, iterable, vPFFeature);
        return vPFFeature;
    }

    protected Collection<? extends VPFFeature> doCreateComplexFeatures(VPFFeatureClass vPFFeatureClass) {
        throw new UnsupportedOperationException();
    }

    protected Object getPrimitiveIds(VPFFeatureClass vPFFeatureClass, VPFRecord vPFRecord, VPFBufferedRecordData vPFBufferedRecordData, int[] nArray, boolean bl) {
        VPFRelation vPFRelation = this.getFeatureToJoinRelation(vPFFeatureClass);
        if (vPFRelation == null) {
            return null;
        }
        VPFRelation vPFRelation2 = this.getJoinToPrimitiveRelation(vPFFeatureClass);
        if (vPFRelation2 == null) {
            return null;
        }
        int n = vPFRecord.getId();
        String string = vPFRelation.getTable2Key();
        String string2 = vPFRelation2.getTable1Key();
        String string3 = vPFRelation2.getTable2();
        int n2 = 0;
        Object object = null;
        for (VPFRecord vPFRecord2 : vPFBufferedRecordData) {
            int n3;
            if (this.tile != null && !VPFBasicFeatureFactory.matchesTile(vPFRecord2, this.tile) || n != (n3 = VPFBasicFeatureFactory.asInt(vPFRecord2.getValue(string)))) continue;
            if (!bl) {
                int n4;
                nArray[n2] = n4 = VPFBasicFeatureFactory.asInt(vPFRecord2.getValue(string2));
                VPFPrimitiveData.PrimitiveInfo primitiveInfo = this.primitiveData.getPrimitiveInfo(string3, n4);
                object = object != null ? ((VPFBoundingBox)object).union(primitiveInfo.getBounds()) : primitiveInfo.getBounds();
            }
            ++n2;
        }
        return bl ? Integer.valueOf(n2) : object;
    }

    protected Iterable<String> getFeatureAttributeKeys(VPFBufferedRecordData vPFBufferedRecordData) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : vPFBufferedRecordData.getRecordParameterNames()) {
            if (string.equalsIgnoreCase("id") || string.equalsIgnoreCase("tile_id") || string.equalsIgnoreCase("from_to") || string.equalsIgnoreCase("nod_id") || string.equalsIgnoreCase("end_id") || string.equalsIgnoreCase("cnd_id") || string.equalsIgnoreCase("edg_id") || string.equalsIgnoreCase("fac_id") || string.equalsIgnoreCase("txt_id")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    protected void setFeatureAttributes(VPFRecord vPFRecord, Iterable<String> iterable, AVList aVList) {
        for (String string : iterable) {
            VPFUtils.checkAndSetValue(vPFRecord, string, string, aVList);
        }
    }

    protected VPFBufferedRecordData createFeatureTable(VPFFeatureClass vPFFeatureClass) {
        StringBuilder stringBuilder = new StringBuilder(vPFFeatureClass.getCoverage().getFilePath());
        stringBuilder.append(File.separator);
        stringBuilder.append(vPFFeatureClass.getFeatureTableName());
        return VPFUtils.readTable(new File(stringBuilder.toString()));
    }

    protected VPFBufferedRecordData createJoinTable(VPFFeatureClass vPFFeatureClass) {
        if (vPFFeatureClass.getJoinTableName() == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(vPFFeatureClass.getCoverage().getFilePath());
        stringBuilder.append(File.separator);
        stringBuilder.append(vPFFeatureClass.getJoinTableName());
        return VPFUtils.readTable(new File(stringBuilder.toString()));
    }

    protected VPFRelation getFeatureToPrimitiveRelation(VPFFeatureClass vPFFeatureClass) {
        return VPFBasicFeatureFactory.findFirstRelation(vPFFeatureClass.getFeatureTableName(), vPFFeatureClass.getPrimitiveTableName(), vPFFeatureClass.getRelations());
    }

    protected VPFRelation getFeatureToJoinRelation(VPFFeatureClass vPFFeatureClass) {
        return VPFBasicFeatureFactory.findFirstRelation(vPFFeatureClass.getFeatureTableName(), vPFFeatureClass.getJoinTableName(), vPFFeatureClass.getRelations());
    }

    protected VPFRelation getJoinToPrimitiveRelation(VPFFeatureClass vPFFeatureClass) {
        return VPFBasicFeatureFactory.findFirstRelation(vPFFeatureClass.getJoinTableName(), vPFFeatureClass.getPrimitiveTableName(), vPFFeatureClass.getRelations());
    }

    protected static VPFRelation findFirstRelation(String string, String string2, VPFRelation[] vPFRelationArray) {
        if (vPFRelationArray == null) {
            return null;
        }
        for (VPFRelation vPFRelation : vPFRelationArray) {
            if (!vPFRelation.getTable1().equalsIgnoreCase(string) || !vPFRelation.getTable2().equalsIgnoreCase(string2)) continue;
            return vPFRelation;
        }
        return null;
    }

    protected static boolean matchesTile(VPFRecord vPFRecord, VPFTile vPFTile) {
        Object object = vPFRecord.getValue("tile_id");
        return object != null && vPFTile.getId() == VPFBasicFeatureFactory.asInt(object);
    }

    protected static int asInt(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return -1;
    }
}

