/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.VPFBoundingBox;
import gov.nasa.worldwind.formats.vpf.VPFBufferedRecordData;
import gov.nasa.worldwind.formats.vpf.VPFCoverage;
import gov.nasa.worldwind.formats.vpf.VPFPrimitiveData;
import gov.nasa.worldwind.formats.vpf.VPFPrimitiveDataFactory;
import gov.nasa.worldwind.formats.vpf.VPFRecord;
import gov.nasa.worldwind.formats.vpf.VPFTile;
import gov.nasa.worldwind.formats.vpf.VPFTripletId;
import gov.nasa.worldwind.formats.vpf.VPFUtils;
import gov.nasa.worldwind.formats.vpf.VPFWingedEdgeTraverser;
import gov.nasa.worldwind.util.CompoundStringBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.VecBufferSequence;
import java.io.File;
import java.util.ArrayList;

public class VPFBasicPrimitiveDataFactory
implements VPFPrimitiveDataFactory {
    private VPFTile tile;

    public VPFBasicPrimitiveDataFactory(VPFTile vPFTile) {
        this.tile = vPFTile;
    }

    public VPFTile getTile() {
        return this.tile;
    }

    @Override
    public VPFPrimitiveData createPrimitiveData(VPFCoverage vPFCoverage) {
        if (vPFCoverage == null) {
            String string = Logging.getMessage("nullValue.CoverageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = VPFBasicPrimitiveDataFactory.getPrimitiveTablePath(vPFCoverage, this.tile, "");
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        return this.doCreatePrimitives(vPFCoverage);
    }

    protected VPFPrimitiveData doCreatePrimitives(VPFCoverage vPFCoverage) {
        VPFPrimitiveData vPFPrimitiveData = new VPFPrimitiveData();
        this.buildNodePrimitives(vPFCoverage, this.tile, vPFPrimitiveData);
        this.buildEdgePrimitives(vPFCoverage, this.tile, vPFPrimitiveData);
        this.buildFacePrimitives(vPFCoverage, this.tile, vPFPrimitiveData);
        this.buildTextPrimitives(vPFCoverage, this.tile, vPFPrimitiveData);
        return vPFPrimitiveData;
    }

    protected void buildNodePrimitives(VPFCoverage vPFCoverage, VPFTile vPFTile, VPFPrimitiveData vPFPrimitiveData) {
        VPFBufferedRecordData vPFBufferedRecordData;
        VPFBufferedRecordData vPFBufferedRecordData2;
        VPFBufferedRecordData vPFBufferedRecordData3 = this.createPrimitiveTable(vPFCoverage, vPFTile, "nod");
        if (vPFBufferedRecordData3 != null && vPFBufferedRecordData3.getNumRecords() > 0) {
            this.buildNodePrimitives(vPFBufferedRecordData3, "nod", vPFPrimitiveData);
        }
        if ((vPFBufferedRecordData2 = this.createPrimitiveTable(vPFCoverage, vPFTile, "end")) != null && vPFBufferedRecordData2.getNumRecords() > 0) {
            this.buildNodePrimitives(vPFBufferedRecordData2, "end", vPFPrimitiveData);
        }
        if ((vPFBufferedRecordData = this.createPrimitiveTable(vPFCoverage, vPFTile, "cnd")) != null && vPFBufferedRecordData.getNumRecords() > 0) {
            this.buildNodePrimitives(vPFBufferedRecordData, "cnd", vPFPrimitiveData);
        }
    }

    protected boolean buildNodePrimitives(VPFBufferedRecordData vPFBufferedRecordData, String string, VPFPrimitiveData vPFPrimitiveData) {
        int n = vPFBufferedRecordData.getNumRecords();
        VPFPrimitiveData.PrimitiveInfo[] primitiveInfoArray = new VPFPrimitiveData.BasicPrimitiveInfo[n];
        VecBufferSequence vecBufferSequence = (VecBufferSequence)vPFBufferedRecordData.getRecordData("coordinate").getBackingData();
        for (VPFRecord vPFRecord : vPFBufferedRecordData) {
            int n2 = vPFRecord.getId();
            primitiveInfoArray[VPFBufferedRecordData.indexFromId((int)n2)] = new VPFPrimitiveData.BasicPrimitiveInfo(VPFBoundingBox.fromVecBuffer(vecBufferSequence.subBuffer(n2)));
        }
        vPFPrimitiveData.setPrimitiveInfo(string, primitiveInfoArray);
        vPFPrimitiveData.setPrimitiveCoords(string, vecBufferSequence);
        return true;
    }

    protected void buildEdgePrimitives(VPFCoverage vPFCoverage, VPFTile vPFTile, VPFPrimitiveData vPFPrimitiveData) {
        VPFBufferedRecordData vPFBufferedRecordData = this.createPrimitiveTable(vPFCoverage, vPFTile, "edg");
        if (vPFBufferedRecordData == null || vPFBufferedRecordData.getNumRecords() == 0) {
            return;
        }
        VPFBufferedRecordData vPFBufferedRecordData2 = this.createPrimitiveTable(vPFCoverage, vPFTile, "ebr");
        if (vPFBufferedRecordData2 == null) {
            return;
        }
        int n = vPFBufferedRecordData.getNumRecords();
        VPFPrimitiveData.PrimitiveInfo[] primitiveInfoArray = new VPFPrimitiveData.EdgeInfo[n];
        VecBufferSequence vecBufferSequence = (VecBufferSequence)vPFBufferedRecordData.getRecordData("coordinates").getBackingData();
        for (VPFRecord vPFRecord : vPFBufferedRecordData) {
            int n2 = vPFRecord.getId();
            VPFRecord vPFRecord2 = vPFBufferedRecordData2.getRecord(n2);
            primitiveInfoArray[VPFBufferedRecordData.indexFromId((int)n2)] = new VPFPrimitiveData.EdgeInfo(VPFBasicPrimitiveDataFactory.getNumber(vPFRecord.getValue("edge_type")), VPFBasicPrimitiveDataFactory.getId(vPFRecord.getValue("start_node")), VPFBasicPrimitiveDataFactory.getNumber(vPFRecord.getValue("end_node")), VPFBasicPrimitiveDataFactory.getId(vPFRecord.getValue("left_face")), VPFBasicPrimitiveDataFactory.getId(vPFRecord.getValue("right_face")), VPFBasicPrimitiveDataFactory.getId(vPFRecord.getValue("left_edge")), VPFBasicPrimitiveDataFactory.getId(vPFRecord.getValue("right_edge")), VPFBasicPrimitiveDataFactory.isEdgeOnTileBoundary(vPFRecord), VPFUtils.getExtent(vPFRecord2));
        }
        vPFPrimitiveData.setPrimitiveInfo("edg", primitiveInfoArray);
        vPFPrimitiveData.setPrimitiveCoords("edg", vecBufferSequence);
    }

    protected void buildFacePrimitives(VPFCoverage vPFCoverage, VPFTile vPFTile, VPFPrimitiveData vPFPrimitiveData) {
        VPFBufferedRecordData vPFBufferedRecordData = this.createPrimitiveTable(vPFCoverage, vPFTile, "fac");
        if (vPFBufferedRecordData == null) {
            return;
        }
        VPFBufferedRecordData vPFBufferedRecordData2 = this.createPrimitiveTable(vPFCoverage, vPFTile, "fbr");
        if (vPFBufferedRecordData2 == null) {
            return;
        }
        VPFBufferedRecordData vPFBufferedRecordData3 = this.createPrimitiveTable(vPFCoverage, vPFTile, "rng");
        if (vPFBufferedRecordData3 == null) {
            return;
        }
        VPFPrimitiveData.PrimitiveInfo[] primitiveInfoArray = vPFPrimitiveData.getPrimitiveInfo("edg");
        int n = vPFBufferedRecordData.getNumRecords();
        VPFPrimitiveData.PrimitiveInfo[] primitiveInfoArray2 = new VPFPrimitiveData.FaceInfo[n];
        for (VPFRecord vPFRecord : vPFBufferedRecordData) {
            Object object;
            int n2 = vPFRecord.getId();
            VPFRecord vPFRecord2 = vPFBufferedRecordData2.getRecord(n2);
            if (n2 == 1) continue;
            int n3 = ((Number)vPFRecord.getValue("ring_ptr")).intValue();
            VPFRecord vPFRecord3 = vPFBufferedRecordData3.getRecord(n3);
            VPFPrimitiveData.Ring ring = this.buildRing(vPFRecord3, primitiveInfoArray);
            ArrayList<VPFPrimitiveData.Ring[]> arrayList = new ArrayList<VPFPrimitiveData.Ring[]>();
            ++n3;
            while (n3 <= vPFBufferedRecordData3.getNumRecords() && n2 == VPFBasicPrimitiveDataFactory.getId((vPFRecord3 = vPFBufferedRecordData3.getRecord(n3)).getValue("face_id"))) {
                object = this.buildRing(vPFRecord3, primitiveInfoArray);
                if (object != null) {
                    arrayList.add((VPFPrimitiveData.Ring[])object);
                }
                ++n3;
            }
            object = new VPFPrimitiveData.Ring[arrayList.size()];
            arrayList.toArray((T[])object);
            primitiveInfoArray2[VPFBufferedRecordData.indexFromId((int)n2)] = new VPFPrimitiveData.FaceInfo(ring, (VPFPrimitiveData.Ring[])object, VPFUtils.getExtent(vPFRecord2));
        }
        vPFPrimitiveData.setPrimitiveInfo("fac", primitiveInfoArray2);
    }

    protected void buildTextPrimitives(VPFCoverage vPFCoverage, VPFTile vPFTile, VPFPrimitiveData vPFPrimitiveData) {
        VPFBufferedRecordData vPFBufferedRecordData = this.createPrimitiveTable(vPFCoverage, vPFTile, "txt");
        if (vPFBufferedRecordData == null || vPFBufferedRecordData.getNumRecords() == 0) {
            return;
        }
        int n = vPFBufferedRecordData.getNumRecords();
        VPFPrimitiveData.PrimitiveInfo[] primitiveInfoArray = new VPFPrimitiveData.BasicPrimitiveInfo[n];
        VecBufferSequence vecBufferSequence = (VecBufferSequence)vPFBufferedRecordData.getRecordData("shape_line").getBackingData();
        CompoundStringBuilder compoundStringBuilder = (CompoundStringBuilder)vPFBufferedRecordData.getRecordData("string").getBackingData();
        for (VPFRecord vPFRecord : vPFBufferedRecordData) {
            int n2 = vPFRecord.getId();
            primitiveInfoArray[VPFBufferedRecordData.indexFromId((int)n2)] = new VPFPrimitiveData.BasicPrimitiveInfo(VPFBoundingBox.fromVecBuffer(vecBufferSequence.subBuffer(n2)));
        }
        vPFPrimitiveData.setPrimitiveInfo("txt", primitiveInfoArray);
        vPFPrimitiveData.setPrimitiveCoords("txt", vecBufferSequence);
        vPFPrimitiveData.setPrimitiveStrings("txt", compoundStringBuilder);
    }

    protected VPFPrimitiveData.Ring buildRing(VPFRecord vPFRecord, VPFPrimitiveData.PrimitiveInfo[] primitiveInfoArray) {
        int n = ((Number)vPFRecord.getValue("face_id")).intValue();
        int n2 = ((Number)vPFRecord.getValue("start_edge")).intValue();
        VPFWingedEdgeTraverser vPFWingedEdgeTraverser = new VPFWingedEdgeTraverser();
        int n3 = vPFWingedEdgeTraverser.traverseRing(n, n2, primitiveInfoArray, null);
        final int[] nArray = new int[n3];
        final int[] nArray2 = new int[n3];
        vPFWingedEdgeTraverser.traverseRing(n, n2, primitiveInfoArray, new VPFWingedEdgeTraverser.EdgeTraversalListener(){

            @Override
            public void nextEdge(int n, int n2, boolean bl) {
                nArray[n] = n2;
                nArray2[n] = bl ? -1 : 1;
            }
        });
        return new VPFPrimitiveData.Ring(n3, nArray, nArray2);
    }

    protected VPFBufferedRecordData createPrimitiveTable(VPFCoverage vPFCoverage, VPFTile vPFTile, String string) {
        String string2 = VPFBasicPrimitiveDataFactory.getPrimitiveTablePath(vPFCoverage, vPFTile, string);
        File file = new File(string2);
        if (!file.exists()) {
            return null;
        }
        return VPFUtils.readTable(file);
    }

    protected static String getPrimitiveTablePath(VPFCoverage vPFCoverage, VPFTile vPFTile, String string) {
        StringBuilder stringBuilder = new StringBuilder(vPFCoverage.getFilePath());
        stringBuilder.append(File.separator);
        if (vPFTile != null) {
            stringBuilder.append(vPFTile.getName());
            stringBuilder.append(File.separator);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    protected static boolean isEdgeOnTileBoundary(VPFRecord vPFRecord) {
        VPFTripletId vPFTripletId = null;
        Object object = vPFRecord.getValue("left_face");
        if (object instanceof VPFTripletId) {
            vPFTripletId = (VPFTripletId)object;
        }
        if (vPFTripletId == null && (object = vPFRecord.getValue("right_face")) instanceof VPFTripletId) {
            vPFTripletId = (VPFTripletId)object;
        }
        return vPFTripletId != null && vPFTripletId.getExtId() > 0;
    }

    protected static int getNumber(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return -1;
    }

    protected static int getId(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof VPFTripletId) {
            return ((VPFTripletId)object).getId();
        }
        return -1;
    }
}

