/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.formats.vpf.VPFBasicFeatureFactory;
import gov.nasa.worldwind.formats.vpf.VPFBoundingBox;
import gov.nasa.worldwind.formats.vpf.VPFFeature;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClass;
import gov.nasa.worldwind.formats.vpf.VPFFeatureFactory;
import gov.nasa.worldwind.formats.vpf.VPFLibrary;
import gov.nasa.worldwind.formats.vpf.VPFPrimitiveData;
import gov.nasa.worldwind.formats.vpf.VPFSurfaceArea;
import gov.nasa.worldwind.formats.vpf.VPFSurfaceLine;
import gov.nasa.worldwind.formats.vpf.VPFSymbol;
import gov.nasa.worldwind.formats.vpf.VPFSymbolAttributes;
import gov.nasa.worldwind.formats.vpf.VPFSymbolFactory;
import gov.nasa.worldwind.formats.vpf.VPFSymbolKey;
import gov.nasa.worldwind.formats.vpf.VPFSymbolSupport;
import gov.nasa.worldwind.formats.vpf.VPFTile;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.render.SurfaceIcon;
import gov.nasa.worldwind.render.SurfaceIcons;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.UserFacingText;
import gov.nasa.worldwind.util.CompoundStringBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.VecBuffer;
import gov.nasa.worldwind.util.VecBufferSequence;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VPFBasicSymbolFactory
implements VPFSymbolFactory {
    private static final double DEFAULT_ICON_MAX_SIZE = 10000.0;
    protected VPFPrimitiveData primitiveData;
    protected VPFFeatureFactory featureFactory;
    protected VPFSymbolSupport symbolSupport;

    public VPFBasicSymbolFactory(VPFTile vPFTile, VPFPrimitiveData vPFPrimitiveData) {
        this.primitiveData = vPFPrimitiveData;
        this.featureFactory = new VPFBasicFeatureFactory(vPFTile, vPFPrimitiveData);
    }

    public VPFSymbolSupport getStyleSupport() {
        return this.symbolSupport;
    }

    public void setStyleSupport(VPFSymbolSupport vPFSymbolSupport) {
        this.symbolSupport = vPFSymbolSupport;
    }

    @Override
    public Collection<? extends VPFSymbol> createPointSymbols(VPFFeatureClass vPFFeatureClass) {
        if (vPFFeatureClass == null) {
            String string = Logging.getMessage("nullValue.FeatureClassIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FeatureMap featureMap = this.createFeatureMap(vPFFeatureClass);
        if (featureMap == null) {
            return null;
        }
        ArrayList<VPFSymbol> arrayList = new ArrayList<VPFSymbol>();
        this.doCreatePointSymbols(featureMap, arrayList);
        return arrayList;
    }

    @Override
    public Collection<? extends VPFSymbol> createLineSymbols(VPFFeatureClass vPFFeatureClass) {
        if (vPFFeatureClass == null) {
            String string = Logging.getMessage("nullValue.FeatureClassIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FeatureMap featureMap = this.createFeatureMap(vPFFeatureClass);
        if (featureMap == null) {
            return null;
        }
        ArrayList<VPFSymbol> arrayList = new ArrayList<VPFSymbol>();
        this.doCreateLineSymbols(featureMap, arrayList);
        return arrayList;
    }

    @Override
    public Collection<? extends VPFSymbol> createAreaSymbols(VPFFeatureClass vPFFeatureClass) {
        if (vPFFeatureClass == null) {
            String string = Logging.getMessage("nullValue.FeatureClassIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FeatureMap featureMap = this.createFeatureMap(vPFFeatureClass);
        if (featureMap == null) {
            return null;
        }
        ArrayList<VPFSymbol> arrayList = new ArrayList<VPFSymbol>();
        this.doCreateAreaSymbols(featureMap, arrayList);
        return arrayList;
    }

    @Override
    public Collection<? extends VPFSymbol> createTextSymbols(VPFFeatureClass vPFFeatureClass) {
        if (vPFFeatureClass == null) {
            String string = Logging.getMessage("nullValue.FeatureClassIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FeatureMap featureMap = this.createFeatureMap(vPFFeatureClass);
        if (featureMap == null) {
            return null;
        }
        ArrayList<VPFSymbol> arrayList = new ArrayList<VPFSymbol>();
        this.doCreateTextSymbols(featureMap, arrayList);
        return arrayList;
    }

    @Override
    public Collection<? extends VPFSymbol> createComplexSymbols(VPFFeatureClass vPFFeatureClass) {
        if (vPFFeatureClass == null) {
            String string = Logging.getMessage("nullValue.FeatureClassIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        throw new UnsupportedOperationException();
    }

    protected FeatureMap createFeatureMap(VPFFeatureClass vPFFeatureClass) {
        Collection<? extends VPFFeature> collection = vPFFeatureClass.createFeatures(this.featureFactory);
        if (collection == null) {
            return null;
        }
        FeatureMap featureMap = new FeatureMap();
        for (VPFFeature vPFFeature : collection) {
            Iterable<? extends VPFSymbolKey> iterable = this.getSymbolKeys(vPFFeature);
            if (iterable == null) continue;
            for (VPFSymbolKey vPFSymbolKey : iterable) {
                featureMap.addFeature(vPFSymbolKey, vPFFeature);
            }
        }
        return featureMap;
    }

    protected void doCreatePointSymbols(FeatureMap featureMap, Collection<VPFSymbol> collection) {
        for (Map.Entry entry : featureMap.entrySet()) {
            CombinedFeature combinedFeature = (CombinedFeature)entry.getValue();
            for (VPFSymbolAttributes vPFSymbolAttributes : this.getSymbolAttributes(combinedFeature, (VPFSymbolKey)entry.getKey())) {
                switch (vPFSymbolAttributes.getFeatureType()) {
                    case POINT: {
                        this.addPointSymbol(combinedFeature, vPFSymbolAttributes, collection);
                        break;
                    }
                    case LABEL: {
                        this.addTextLabel(combinedFeature, vPFSymbolAttributes, collection);
                    }
                }
            }
        }
    }

    protected void doCreateLineSymbols(FeatureMap featureMap, Collection<VPFSymbol> collection) {
        for (Map.Entry entry : featureMap.entrySet()) {
            CombinedFeature combinedFeature = (CombinedFeature)entry.getValue();
            for (VPFSymbolAttributes vPFSymbolAttributes : this.getSymbolAttributes(combinedFeature, (VPFSymbolKey)entry.getKey())) {
                switch (vPFSymbolAttributes.getFeatureType()) {
                    case LINE: {
                        this.addLineSymbol(combinedFeature, vPFSymbolAttributes, collection);
                        break;
                    }
                    case LABEL: {
                        this.addTextLabel(combinedFeature, vPFSymbolAttributes, collection);
                    }
                }
            }
        }
    }

    protected void doCreateAreaSymbols(FeatureMap featureMap, Collection<VPFSymbol> collection) {
        for (Map.Entry entry : featureMap.entrySet()) {
            CombinedFeature combinedFeature = (CombinedFeature)entry.getValue();
            for (VPFSymbolAttributes vPFSymbolAttributes : this.getSymbolAttributes(combinedFeature, (VPFSymbolKey)entry.getKey())) {
                switch (vPFSymbolAttributes.getFeatureType()) {
                    case AREA: {
                        this.addAreaSymbol(combinedFeature, vPFSymbolAttributes, collection);
                        break;
                    }
                    case LINE: {
                        this.addAreaSymbol(combinedFeature, vPFSymbolAttributes, collection);
                        break;
                    }
                    case POINT: {
                        this.addPointLabel(combinedFeature, vPFSymbolAttributes, collection);
                        break;
                    }
                    case LABEL: {
                        this.addTextLabel(combinedFeature, vPFSymbolAttributes, collection);
                    }
                }
            }
        }
    }

    protected void doCreateTextSymbols(FeatureMap featureMap, Collection<VPFSymbol> collection) {
        for (Map.Entry entry : featureMap.entrySet()) {
            CombinedFeature combinedFeature = (CombinedFeature)entry.getValue();
            for (VPFSymbolAttributes vPFSymbolAttributes : this.getSymbolAttributes(combinedFeature, (VPFSymbolKey)entry.getKey())) {
                switch (vPFSymbolAttributes.getFeatureType()) {
                    case TEXT: {
                        this.addTextSymbol(combinedFeature, vPFSymbolAttributes, collection);
                    }
                }
            }
        }
    }

    protected void addPointSymbol(CombinedFeature combinedFeature, VPFSymbolAttributes vPFSymbolAttributes, Collection<VPFSymbol> collection) {
        int n = 0;
        boolean bl = false;
        ArrayList<Position> arrayList = new ArrayList<Position>();
        ArrayList<Angle> arrayList2 = new ArrayList<Angle>();
        for (AVListImpl aVListImpl : combinedFeature) {
            String string = combinedFeature.getFeatureClass().getPrimitiveTableName();
            Angle angle = this.getPointSymbolHeading(vPFSymbolAttributes, aVListImpl);
            for (int n2 : ((VPFFeature)aVListImpl).getPrimitiveIds()) {
                VecBuffer vecBuffer;
                VecBufferSequence vecBufferSequence = this.primitiveData.getPrimitiveCoords(string);
                if (vecBufferSequence == null || (vecBuffer = vecBufferSequence.subBuffer(n2)) == null) continue;
                if (!bl) {
                    bl = arrayList2.size() > 0 && !arrayList2.contains(angle);
                }
                arrayList.add(vecBuffer.getPosition(0));
                arrayList2.add(angle);
                ++n;
            }
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                AVListImpl aVListImpl;
                aVListImpl = new SurfaceIcon("", (LatLon)arrayList.get(i));
                ((SurfaceIcon)aVListImpl).setHeading((Angle)arrayList2.get(i));
                this.applyPointSymbolAttributes(vPFSymbolAttributes, (SurfaceIcon)aVListImpl);
                collection.add(new VPFSymbol(combinedFeature, vPFSymbolAttributes, aVListImpl));
            }
        } else {
            SurfaceIcons surfaceIcons = new SurfaceIcons((Object)"", arrayList);
            if (arrayList2.get(0) != null) {
                surfaceIcons.setHeading((Angle)arrayList2.get(0));
            }
            this.applyPointSymbolAttributes(vPFSymbolAttributes, surfaceIcons);
            collection.add(new VPFSymbol(combinedFeature, vPFSymbolAttributes, surfaceIcons));
        }
    }

    protected void addLineSymbol(CombinedFeature combinedFeature, VPFSymbolAttributes vPFSymbolAttributes, Collection<VPFSymbol> collection) {
        VPFSurfaceLine vPFSurfaceLine = new VPFSurfaceLine(combinedFeature, this.primitiveData);
        this.applySymbolAttributes(vPFSymbolAttributes, vPFSurfaceLine);
        collection.add(new VPFSymbol(combinedFeature, vPFSymbolAttributes, vPFSurfaceLine));
    }

    protected void addAreaSymbol(CombinedFeature combinedFeature, VPFSymbolAttributes vPFSymbolAttributes, Collection<VPFSymbol> collection) {
        VPFSurfaceArea vPFSurfaceArea = new VPFSurfaceArea(combinedFeature, this.primitiveData);
        this.applySymbolAttributes(vPFSymbolAttributes, vPFSurfaceArea);
        collection.add(new VPFSymbol(combinedFeature, vPFSymbolAttributes, vPFSurfaceArea));
    }

    protected void addTextSymbol(CombinedFeature combinedFeature, VPFSymbolAttributes vPFSymbolAttributes, Collection<VPFSymbol> collection) {
        String string = combinedFeature.getFeatureClass().getPrimitiveTableName();
        VecBufferSequence vecBufferSequence = this.primitiveData.getPrimitiveCoords(string);
        CompoundStringBuilder compoundStringBuilder = this.primitiveData.getPrimitiveStrings(string);
        for (int n : combinedFeature.getPrimitiveIds()) {
            VecBuffer vecBuffer = vecBufferSequence.subBuffer(n);
            CharSequence charSequence = compoundStringBuilder.subSequence(n);
            if (charSequence != null) {
                charSequence = WWUtil.trimCharSequence(charSequence);
            }
            UserFacingText userFacingText = new UserFacingText(charSequence, vecBuffer.getPosition(0));
            this.applyTextAttributes(vPFSymbolAttributes, userFacingText);
            collection.add(new VPFSymbol(combinedFeature, vPFSymbolAttributes, userFacingText));
        }
    }

    protected void addTextLabel(CombinedFeature combinedFeature, VPFSymbolAttributes vPFSymbolAttributes, Collection<VPFSymbol> collection) {
        for (VPFFeature vPFFeature : combinedFeature) {
            this.addTextLabel(vPFFeature, vPFSymbolAttributes, collection);
        }
    }

    protected void addTextLabel(VPFFeature vPFFeature, VPFSymbolAttributes vPFSymbolAttributes, Collection<VPFSymbol> collection) {
        VPFSymbolAttributes.LabelAttributes[] labelAttributesArray = vPFSymbolAttributes.getLabelAttributes();
        if (labelAttributesArray == null || labelAttributesArray.length == 0) {
            return;
        }
        for (VPFSymbolAttributes.LabelAttributes labelAttributes : labelAttributesArray) {
            UserFacingText userFacingText = new UserFacingText("", null);
            this.applyLabelAttributes(labelAttributes, vPFFeature, userFacingText);
            collection.add(new VPFSymbol(vPFFeature, null, userFacingText));
        }
    }

    protected void addPointLabel(CombinedFeature combinedFeature, VPFSymbolAttributes vPFSymbolAttributes, Collection<VPFSymbol> collection) {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (VPFFeature vPFFeature : combinedFeature) {
            if (vPFFeature.getBounds() == null) continue;
            arrayList.add(vPFFeature.getBounds().toSector().getCentroid());
        }
        SurfaceIcons surfaceIcons = new SurfaceIcons((Object)"", arrayList);
        this.applyPointSymbolAttributes(vPFSymbolAttributes, surfaceIcons);
        collection.add(new VPFSymbol(combinedFeature, vPFSymbolAttributes, surfaceIcons));
    }

    protected Iterable<? extends VPFSymbolKey> getSymbolKeys(VPFFeature vPFFeature) {
        String string = vPFFeature.getStringValue("f_code");
        return this.symbolSupport.getSymbolKeys(vPFFeature.getFeatureClass(), string, vPFFeature);
    }

    protected Iterable<? extends VPFSymbolAttributes> getSymbolAttributes(VPFFeature vPFFeature, VPFSymbolKey vPFSymbolKey) {
        return this.symbolSupport.getSymbolAttributes(vPFFeature.getFeatureClass(), vPFSymbolKey);
    }

    protected void applyPointSymbolAttributes(VPFSymbolAttributes vPFSymbolAttributes, SurfaceIcon surfaceIcon) {
        if (vPFSymbolAttributes.getIconImageSource() != null) {
            surfaceIcon.setImageSource(vPFSymbolAttributes.getIconImageSource());
        }
        surfaceIcon.setUseMipMaps(vPFSymbolAttributes.isMipMapIconImage());
        surfaceIcon.setScale(vPFSymbolAttributes.getIconImageScale());
        surfaceIcon.setMaxSize(10000.0);
    }

    protected Angle getPointSymbolHeading(VPFSymbolAttributes vPFSymbolAttributes, AVList aVList) {
        Double d;
        if (vPFSymbolAttributes.getOrientationAttributeName() == null) {
            return null;
        }
        Object object = aVList.getValue(vPFSymbolAttributes.getOrientationAttributeName());
        if (object instanceof Number) {
            Double d2 = ((Number)object).doubleValue();
            return Angle.fromDegrees(d2);
        }
        if (object instanceof String && (d = WWUtil.convertStringToDouble((String)object)) != null) {
            return Angle.fromDegrees(d);
        }
        return null;
    }

    protected void applySymbolAttributes(VPFSymbolAttributes vPFSymbolAttributes, SurfaceShape surfaceShape) {
        surfaceShape.setAttributes(vPFSymbolAttributes);
    }

    public void applyTextAttributes(VPFSymbolAttributes vPFSymbolAttributes, GeographicText geographicText) {
        VPFSymbolAttributes.LabelAttributes[] labelAttributesArray = vPFSymbolAttributes.getLabelAttributes();
        if (labelAttributesArray != null && labelAttributesArray.length > 0) {
            geographicText.setFont(labelAttributesArray[0].getFont());
            geographicText.setColor(labelAttributesArray[0].getColor());
            geographicText.setBackgroundColor(labelAttributesArray[0].getBackgroundColor());
        } else {
            geographicText.setFont(Font.decode("Arial-PLAIN-12"));
            geographicText.setColor(vPFSymbolAttributes.getInteriorMaterial().getDiffuse());
            geographicText.setBackgroundColor(WWUtil.computeContrastingColor(vPFSymbolAttributes.getInteriorMaterial().getDiffuse()));
        }
    }

    protected void applyLabelAttributes(VPFSymbolAttributes.LabelAttributes labelAttributes, VPFFeature vPFFeature, GeographicText geographicText) {
        String string;
        geographicText.setFont(labelAttributes.getFont());
        geographicText.setColor(labelAttributes.getColor());
        geographicText.setBackgroundColor(labelAttributes.getBackgroundColor());
        LatLon latLon = this.computeLabelLocation(labelAttributes, vPFFeature);
        if (latLon != null) {
            geographicText.setPosition(new Position(latLon, 0.0));
        }
        if ((string = this.symbolSupport.getSymbolLabelText(labelAttributes, vPFFeature)) != null) {
            geographicText.setText(string);
        }
    }

    protected LatLon computeLabelLocation(VPFSymbolAttributes.LabelAttributes labelAttributes, VPFFeature vPFFeature) {
        LatLon latLon = vPFFeature.getBounds().toSector().getCentroid();
        if (labelAttributes.getOffset() != 0.0) {
            VPFLibrary vPFLibrary = vPFFeature.getFeatureClass().getCoverage().getLibrary();
            Angle angle = labelAttributes.getOffsetAngle();
            Angle angle2 = vPFLibrary.computeArcLengthFromMapDistance(labelAttributes.getOffset());
            if (angle != null && angle2 != null) {
                latLon = LatLon.greatCircleEndPosition(latLon, angle, angle2);
            }
        }
        return latLon;
    }

    protected static VPFBoundingBox combineBounds(Iterable<? extends VPFFeature> iterable) {
        VPFBoundingBox vPFBoundingBox = null;
        for (VPFFeature vPFFeature : iterable) {
            vPFBoundingBox = vPFBoundingBox != null ? vPFFeature.getBounds().union(vPFBoundingBox) : vPFFeature.getBounds();
        }
        return vPFBoundingBox;
    }

    /*
     * WARNING - void declaration
     */
    protected static int[] combinePrimitiveIds(Iterable<? extends VPFFeature> iterable) {
        int n = 0;
        for (VPFFeature vPFFeature : iterable) {
            if (vPFFeature.getPrimitiveIds() == null) continue;
            n += vPFFeature.getPrimitiveIds().length;
        }
        Object object = new int[n];
        boolean n2 = false;
        for (VPFFeature vPFFeature : iterable) {
            void var3_5;
            if (vPFFeature.getPrimitiveIds() == null) continue;
            int[] nArray = vPFFeature.getPrimitiveIds();
            System.arraycopy(nArray, 0, object, (int)var3_5, nArray.length);
            var3_5 += nArray.length;
        }
        return object;
    }

    protected static class FeatureMap
    extends HashMap<VPFSymbolKey, CombinedFeature> {
        protected FeatureMap() {
        }

        public void addFeature(VPFSymbolKey vPFSymbolKey, VPFFeature vPFFeature) {
            CombinedFeature combinedFeature = (CombinedFeature)this.get(vPFSymbolKey);
            if (combinedFeature == null) {
                combinedFeature = new CombinedFeature(vPFFeature.getFeatureClass());
                this.put(vPFSymbolKey, combinedFeature);
            }
            combinedFeature.add(vPFFeature);
        }
    }

    protected static class CombinedFeature
    extends VPFFeature
    implements Iterable<VPFFeature> {
        private ArrayList<VPFFeature> featureList = new ArrayList();

        public CombinedFeature(VPFFeatureClass vPFFeatureClass) {
            super(vPFFeatureClass, -1, new VPFBoundingBox(0.0, 0.0, 0.0, 0.0), null);
        }

        @Override
        public VPFBoundingBox getBounds() {
            return VPFBasicSymbolFactory.combineBounds(this.featureList);
        }

        @Override
        public int[] getPrimitiveIds() {
            return VPFBasicSymbolFactory.combinePrimitiveIds(this.featureList);
        }

        public void add(VPFFeature vPFFeature) {
            this.featureList.add(vPFFeature);
        }

        @Override
        public Iterator<VPFFeature> iterator() {
            return this.featureList.iterator();
        }
    }
}

