/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.VPFBoundingBox;
import gov.nasa.worldwind.formats.vpf.VPFBufferedRecordData;
import gov.nasa.worldwind.util.CompoundStringBuilder;
import gov.nasa.worldwind.util.VecBufferSequence;
import java.util.HashMap;
import java.util.Map;

public class VPFPrimitiveData {
    protected Map<String, PrimitiveInfo[]> primitiveInfo = new HashMap<String, PrimitiveInfo[]>();
    protected Map<String, VecBufferSequence> primitiveCoords = new HashMap<String, VecBufferSequence>();
    protected Map<String, CompoundStringBuilder> primitiveStrings = new HashMap<String, CompoundStringBuilder>();

    public PrimitiveInfo[] getPrimitiveInfo(String string) {
        return this.primitiveInfo.get(string);
    }

    public void setPrimitiveInfo(String string, PrimitiveInfo[] primitiveInfoArray) {
        this.primitiveInfo.put(string, primitiveInfoArray);
    }

    public PrimitiveInfo getPrimitiveInfo(String string, int n) {
        return this.primitiveInfo.get(string)[VPFBufferedRecordData.indexFromId(n)];
    }

    public VecBufferSequence getPrimitiveCoords(String string) {
        return this.primitiveCoords.get(string);
    }

    public void setPrimitiveCoords(String string, VecBufferSequence vecBufferSequence) {
        this.primitiveCoords.put(string, vecBufferSequence);
    }

    public CompoundStringBuilder getPrimitiveStrings(String string) {
        return this.primitiveStrings.get(string);
    }

    public void setPrimitiveStrings(String string, CompoundStringBuilder compoundStringBuilder) {
        this.primitiveStrings.put(string, compoundStringBuilder);
    }

    public static interface PrimitiveInfo {
        public VPFBoundingBox getBounds();
    }

    public static class Ring {
        protected int numEdges;
        protected int[] edgeId;
        protected int[] edgeOrientation;

        public Ring(int n, int[] nArray, int[] nArray2) {
            this.numEdges = n;
            this.edgeId = nArray;
            this.edgeOrientation = nArray2;
        }

        public int getNumEdges() {
            return this.numEdges;
        }

        public int getEdgeId(int n) {
            return this.edgeId[n];
        }

        public int getEdgeOrientation(int n) {
            return this.edgeOrientation[n];
        }
    }

    public static class FaceInfo
    extends BasicPrimitiveInfo {
        protected Ring outerRing;
        protected Ring[] innerRings;
        protected VPFBoundingBox bounds;

        public FaceInfo(Ring ring, Ring[] ringArray, VPFBoundingBox vPFBoundingBox) {
            super(vPFBoundingBox);
            this.outerRing = ring;
            this.innerRings = ringArray;
        }

        public Ring getOuterRing() {
            return this.outerRing;
        }

        public Ring[] getInnerRings() {
            return this.innerRings;
        }
    }

    public static class EdgeInfo
    extends BasicPrimitiveInfo {
        protected int edgeType;
        protected int startNode;
        protected int endNode;
        protected int leftFace;
        protected int rightFace;
        protected int leftEdge;
        protected int rightEdge;
        protected boolean isOnTileBoundary;

        public EdgeInfo(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, VPFBoundingBox vPFBoundingBox) {
            super(vPFBoundingBox);
            this.edgeType = n;
            this.startNode = n2;
            this.endNode = n3;
            this.leftFace = n4;
            this.rightFace = n5;
            this.leftEdge = n6;
            this.rightEdge = n7;
            this.isOnTileBoundary = bl;
        }

        public int getEdgeType() {
            return this.edgeType;
        }

        public int getStartNode() {
            return this.startNode;
        }

        public int getEndNode() {
            return this.endNode;
        }

        public int getLeftFace() {
            return this.leftFace;
        }

        public int getRightFace() {
            return this.rightFace;
        }

        public int getLeftEdge() {
            return this.leftEdge;
        }

        public int getRightEdge() {
            return this.rightEdge;
        }

        public boolean isOnTileBoundary() {
            return this.isOnTileBoundary;
        }
    }

    public static class BasicPrimitiveInfo
    implements PrimitiveInfo {
        protected VPFBoundingBox bounds;

        public BasicPrimitiveInfo(VPFBoundingBox vPFBoundingBox) {
            this.bounds = vPFBoundingBox;
        }

        @Override
        public VPFBoundingBox getBounds() {
            return this.bounds;
        }
    }
}

