/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.VPFBufferedRecordData;
import gov.nasa.worldwind.formats.vpf.VPFPrimitiveData;

public class VPFWingedEdgeTraverser {
    public int traverseRing(int n, int n2, VPFPrimitiveData.PrimitiveInfo[] primitiveInfoArray, EdgeTraversalListener edgeTraversalListener) {
        int n3;
        int n4 = 0;
        int n5 = -1;
        int n6 = n2;
        do {
            n3 = n5;
            n5 = n6;
            if (edgeTraversalListener != null) {
                edgeTraversalListener.nextEdge(n4, n5, this.getMustReverseCoordinates(n, n3, n5, primitiveInfoArray));
            }
            ++n4;
        } while ((n6 = this.nextEdgeId(n, n3, n5, primitiveInfoArray)) > 0 && n6 != n2);
        return n4;
    }

    protected int nextEdgeId(int n, int n2, int n3, VPFPrimitiveData.PrimitiveInfo[] primitiveInfoArray) {
        Orientation orientation = this.getOrientation(n, n3, primitiveInfoArray);
        if (orientation == null) {
            return -1;
        }
        switch (orientation) {
            case LEFT: {
                return VPFWingedEdgeTraverser.getEdgeInfo(primitiveInfoArray, n3).getLeftEdge();
            }
            case RIGHT: {
                return VPFWingedEdgeTraverser.getEdgeInfo(primitiveInfoArray, n3).getRightEdge();
            }
            case LEFT_AND_RIGHT: {
                return n2 > 0 ? this.auxiliaryNextEdgeId(n2, n3, primitiveInfoArray) : -1;
            }
        }
        return -1;
    }

    protected Orientation getOrientation(int n, int n2, VPFPrimitiveData.PrimitiveInfo[] primitiveInfoArray) {
        boolean bl;
        VPFPrimitiveData.EdgeInfo edgeInfo = VPFWingedEdgeTraverser.getEdgeInfo(primitiveInfoArray, n2);
        boolean bl2 = edgeInfo.getLeftFace() == n;
        boolean bl3 = bl = edgeInfo.getRightFace() == n;
        if (bl2 && bl) {
            return Orientation.LEFT_AND_RIGHT;
        }
        if (bl2) {
            return Orientation.LEFT;
        }
        if (bl) {
            return Orientation.RIGHT;
        }
        return null;
    }

    protected boolean getMustReverseCoordinates(int n, int n2, int n3, VPFPrimitiveData.PrimitiveInfo[] primitiveInfoArray) {
        Orientation orientation = this.getOrientation(n, n3, primitiveInfoArray);
        if (orientation == null) {
            return false;
        }
        switch (orientation) {
            case LEFT: {
                return true;
            }
            case RIGHT: {
                return false;
            }
            case LEFT_AND_RIGHT: {
                return n2 > 0 && this.auxiliaryMustReverseCoordinates(n2, n3, primitiveInfoArray);
            }
        }
        return false;
    }

    protected int auxiliaryNextEdgeId(int n, int n2, VPFPrimitiveData.PrimitiveInfo[] primitiveInfoArray) {
        VPFPrimitiveData.EdgeInfo edgeInfo = VPFWingedEdgeTraverser.getEdgeInfo(primitiveInfoArray, n);
        VPFPrimitiveData.EdgeInfo edgeInfo2 = VPFWingedEdgeTraverser.getEdgeInfo(primitiveInfoArray, n2);
        if (edgeInfo2.getStartNode() == edgeInfo.getStartNode() || edgeInfo2.getStartNode() == edgeInfo.getEndNode()) {
            return edgeInfo2.getRightEdge() != n2 ? edgeInfo2.getRightEdge() : edgeInfo2.getLeftEdge();
        }
        if (edgeInfo2.getEndNode() == edgeInfo.getStartNode() || edgeInfo2.getEndNode() == edgeInfo.getEndNode()) {
            return edgeInfo2.getLeftEdge() != n2 ? edgeInfo2.getLeftEdge() : edgeInfo2.getRightEdge();
        }
        return -1;
    }

    protected boolean auxiliaryMustReverseCoordinates(int n, int n2, VPFPrimitiveData.PrimitiveInfo[] primitiveInfoArray) {
        VPFPrimitiveData.EdgeInfo edgeInfo = VPFWingedEdgeTraverser.getEdgeInfo(primitiveInfoArray, n);
        VPFPrimitiveData.EdgeInfo edgeInfo2 = VPFWingedEdgeTraverser.getEdgeInfo(primitiveInfoArray, n2);
        return edgeInfo2.getEndNode() == edgeInfo.getStartNode() || edgeInfo2.getEndNode() == edgeInfo.getEndNode();
    }

    protected static VPFPrimitiveData.EdgeInfo getEdgeInfo(VPFPrimitiveData.PrimitiveInfo[] primitiveInfoArray, int n) {
        return (VPFPrimitiveData.EdgeInfo)primitiveInfoArray[VPFBufferedRecordData.indexFromId(n)];
    }

    public static interface EdgeTraversalListener {
        public void nextEdge(int var1, int var2, boolean var3);
    }

    protected static enum Orientation {
        LEFT,
        RIGHT,
        LEFT_AND_RIGHT;

    }
}

