/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;

public class Frustum {
    protected final Plane left;
    protected final Plane right;
    protected final Plane bottom;
    protected final Plane top;
    protected final Plane near;
    protected final Plane far;
    protected final Plane[] allPlanes;

    public Frustum() {
        this(new Plane(1.0, 0.0, 0.0, 1.0), new Plane(-1.0, 0.0, 0.0, 1.0), new Plane(0.0, 1.0, 0.0, 1.0), new Plane(0.0, -1.0, 0.0, 1.0), new Plane(0.0, 0.0, -1.0, 1.0), new Plane(0.0, 0.0, 1.0, 1.0));
    }

    public Frustum(Plane plane, Plane plane2, Plane plane3, Plane plane4, Plane plane5, Plane plane6) {
        if (plane == null || plane2 == null || plane3 == null || plane4 == null || plane5 == null || plane6 == null) {
            String string = Logging.getMessage("nullValue.PlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.left = plane;
        this.right = plane2;
        this.bottom = plane3;
        this.top = plane4;
        this.near = plane5;
        this.far = plane6;
        this.allPlanes = new Plane[]{this.left, this.right, this.bottom, this.top, this.near, this.far};
    }

    public final Plane getLeft() {
        return this.left;
    }

    public final Plane getRight() {
        return this.right;
    }

    public final Plane getBottom() {
        return this.bottom;
    }

    public final Plane getTop() {
        return this.top;
    }

    public final Plane getNear() {
        return this.near;
    }

    public final Plane getFar() {
        return this.far;
    }

    public Plane[] getAllPlanes() {
        return this.allPlanes;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Frustum frustum = (Frustum)object;
        return this.left.equals(frustum.left) && this.right.equals(frustum.right) && this.bottom.equals(frustum.bottom) && this.top.equals(frustum.top) && this.near.equals(frustum.near) && this.far.equals(frustum.far);
    }

    public int hashCode() {
        int n = this.left.hashCode();
        n = 31 * n + this.right.hashCode();
        n = 19 * n + this.bottom.hashCode();
        n = 23 * n + this.top.hashCode();
        n = 17 * n + this.near.hashCode();
        n = 19 * n + this.far.hashCode();
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append("left=").append(this.left);
        stringBuilder.append(", right=").append(this.right);
        stringBuilder.append(", bottom=").append(this.bottom);
        stringBuilder.append(", top=").append(this.top);
        stringBuilder.append(", near=").append(this.near);
        stringBuilder.append(", far=").append(this.far);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static Frustum fromProjectionMatrix(Matrix matrix) {
        Matrix matrix2 = matrix;
        if (matrix2 == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = matrix2.m41 + matrix2.m11;
        double d2 = matrix2.m42 + matrix2.m12;
        double d3 = matrix2.m43 + matrix2.m13;
        double d4 = matrix2.m44 + matrix2.m14;
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        Plane plane = new Plane(d / d5, d2 / d5, d3 / d5, d4 / d5);
        d = matrix2.m41 - matrix2.m11;
        d2 = matrix2.m42 - matrix2.m12;
        d3 = matrix2.m43 - matrix2.m13;
        d4 = matrix2.m44 - matrix2.m14;
        d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        Plane plane2 = new Plane(d / d5, d2 / d5, d3 / d5, d4 / d5);
        d = matrix2.m41 + matrix2.m21;
        d2 = matrix2.m42 + matrix2.m22;
        d3 = matrix2.m43 + matrix2.m23;
        d4 = matrix2.m44 + matrix2.m23;
        d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        Plane plane3 = new Plane(d / d5, d2 / d5, d3 / d5, d4 / d5);
        d = matrix2.m41 - matrix2.m21;
        d2 = matrix2.m42 - matrix2.m22;
        d3 = matrix2.m43 - matrix2.m23;
        d4 = matrix2.m44 - matrix2.m23;
        d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        Plane plane4 = new Plane(d / d5, d2 / d5, d3 / d5, d4 / d5);
        d = matrix2.m41 + matrix2.m31;
        d2 = matrix2.m42 + matrix2.m32;
        d3 = matrix2.m43 + matrix2.m33;
        d4 = matrix2.m44 + matrix2.m34;
        d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        Plane plane5 = new Plane(d / d5, d2 / d5, d3 / d5, d4 / d5);
        d = matrix2.m41 - matrix2.m31;
        d2 = matrix2.m42 - matrix2.m32;
        d3 = matrix2.m43 - matrix2.m33;
        d4 = matrix2.m44 - matrix2.m34;
        d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        Plane plane6 = new Plane(d / d5, d2 / d5, d3 / d5, d4 / d5).normalize();
        return new Frustum(plane, plane2, plane3, plane4, plane5, plane6);
    }

    public static Frustum fromPerspective(Angle angle, int n, int n2, double d, double d2) {
        if (angle == null) {
            String string = Logging.getMessage("Geom.ViewFrustum.FieldOfViewIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        double d3 = angle.getDegrees();
        double d4 = d2 - d;
        String string = null;
        if (d3 <= 0.0 || d3 > 180.0) {
            string = Logging.getMessage("Geom.ViewFrustum.FieldOfViewOutOfRange", d3);
        }
        if (d <= 0.0 || d4 <= 0.0) {
            string = Logging.getMessage("Geom.ViewFrustum.ClippingDistanceOutOfRange");
        }
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d5 = 1.0 / angle.tanHalfAngle();
        double d6 = (double)n2 / (double)n;
        double d7 = Math.sqrt(d5 * d5 + 1.0);
        double d8 = Math.sqrt(d5 * d5 + d6 * d6);
        Plane plane = new Plane(d5 / d7, 0.0, 0.0 - 1.0 / d7, 0.0);
        Plane plane2 = new Plane(0.0 - d5 / d7, 0.0, 0.0 - 1.0 / d7, 0.0);
        Plane plane3 = new Plane(0.0, d5 / d8, 0.0 - d6 / d8, 0.0);
        Plane plane4 = new Plane(0.0, 0.0 - d5 / d8, 0.0 - d6 / d8, 0.0);
        Plane plane5 = new Plane(0.0, 0.0, -1.0, 0.0 - d);
        Plane plane6 = new Plane(0.0, 0.0, 1.0, d2);
        return new Frustum(plane, plane2, plane3, plane4, plane5, plane6);
    }

    public static Frustum fromPerspective(double d, double d2, double d3, double d4) {
        double d5 = d4 - d3;
        if (d5 <= 0.0 || d <= 0.0 || d2 <= 0.0) {
            String string = Logging.getMessage("Geom.ViewFrustum.ClippingDistanceOutOfRange");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        double d6 = d / 2.0;
        double d7 = d2 / 2.0;
        Plane plane = new Plane(1.0, 0.0, 0.0, d6);
        Plane plane2 = new Plane(-1.0, 0.0, 0.0, d6);
        Plane plane3 = new Plane(0.0, 1.0, 0.0, d7);
        Plane plane4 = new Plane(0.0, -1.0, 0.0, d7);
        Plane plane5 = new Plane(0.0, 0.0, -1.0, d3 < 0.0 ? d3 : -d3);
        Plane plane6 = new Plane(0.0, 0.0, 1.0, d4 < 0.0 ? -d4 : d4);
        return new Frustum(plane, plane2, plane3, plane4, plane5, plane6);
    }

    public static Frustum fromPerspectiveVecs(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44, double d, double d2) {
        if (vec4 == null || vec42 == null || vec43 == null || vec44 == null) {
            String string = Logging.getMessage("Geom.ViewFrustum.EdgeVectorIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        double d3 = d2 - d;
        if (d <= 0.0 || d3 <= 0.0) {
            String string = Logging.getMessage("Geom.ViewFrustum.ClippingDistanceOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec45 = vec43.cross3(vec4).normalize3();
        Plane plane = new Plane(vec45.x, vec45.y, vec45.z, 0.0);
        Vec4 vec46 = vec42.cross3(vec44).normalize3();
        Plane plane2 = new Plane(vec46.x, vec46.y, vec46.z, 0.0);
        Vec4 vec47 = vec44.cross3(vec43).normalize3();
        Plane plane3 = new Plane(vec47.x, vec47.y, vec47.z, 0.0);
        Vec4 vec48 = vec4.cross3(vec42).normalize3();
        Plane plane4 = new Plane(vec48.x, vec48.y, vec48.z, 0.0);
        Plane plane5 = new Plane(0.0, 0.0, -1.0, 0.0 - d);
        Plane plane6 = new Plane(0.0, 0.0, 1.0, d2);
        return new Frustum(plane, plane2, plane3, plane4, plane5, plane6);
    }

    public boolean intersects(Extent extent) {
        if (extent == null) {
            String string = Logging.getMessage("nullValue.ExtentIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        return extent.intersects(this);
    }

    public boolean intersectsSegment(Vec4 vec4, Vec4 vec42) {
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.contains(vec4) || this.contains(vec42)) {
            return true;
        }
        if (vec4.equals(vec42)) {
            return false;
        }
        for (Plane plane : this.getAllPlanes()) {
            if (plane.onSameSide(vec4, vec42) < 0) {
                return false;
            }
            if (plane.clip(vec4, vec42) == null) continue;
            return true;
        }
        return false;
    }

    public final boolean contains(Extent extent) {
        if (extent == null) {
            String string = Logging.getMessage("nullValue.ExtentIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = extent.getCenter();
        double d = extent.getRadius();
        if (this.far.dot(vec4) <= d) {
            return false;
        }
        if (this.left.dot(vec4) <= d) {
            return false;
        }
        if (this.right.dot(vec4) <= d) {
            return false;
        }
        if (this.top.dot(vec4) <= d) {
            return false;
        }
        if (this.bottom.dot(vec4) <= d) {
            return false;
        }
        return !(this.near.dot(vec4) <= d);
    }

    public final boolean contains(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (this.far.dot(vec4) <= 0.0) {
            return false;
        }
        if (this.left.dot(vec4) <= 0.0) {
            return false;
        }
        if (this.right.dot(vec4) <= 0.0) {
            return false;
        }
        if (this.top.dot(vec4) <= 0.0) {
            return false;
        }
        if (this.bottom.dot(vec4) <= 0.0) {
            return false;
        }
        return !(this.near.dot(vec4) <= 0.0);
    }

    public Frustum transformBy(Matrix matrix) {
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        Plane plane = new Plane(this.left.getVector().transformBy4(matrix));
        Plane plane2 = new Plane(this.right.getVector().transformBy4(matrix));
        Plane plane3 = new Plane(this.bottom.getVector().transformBy4(matrix));
        Plane plane4 = new Plane(this.top.getVector().transformBy4(matrix));
        Plane plane5 = new Plane(this.near.getVector().transformBy4(matrix));
        Plane plane6 = new Plane(this.far.getVector().transformBy4(matrix));
        return new Frustum(plane, plane2, plane3, plane4, plane5, plane6);
    }

    public Corners getCorners() {
        Corners corners = new Corners();
        corners.nbl = Plane.intersect(this.near, this.bottom, this.left);
        corners.nbr = Plane.intersect(this.near, this.bottom, this.right);
        corners.ntl = Plane.intersect(this.near, this.top, this.left);
        corners.ntr = Plane.intersect(this.near, this.top, this.right);
        corners.fbl = Plane.intersect(this.far, this.bottom, this.left);
        corners.fbr = Plane.intersect(this.far, this.bottom, this.right);
        corners.ftl = Plane.intersect(this.far, this.top, this.left);
        corners.ftr = Plane.intersect(this.far, this.top, this.right);
        return corners;
    }

    public static class Corners {
        public Vec4 nbl;
        public Vec4 nbr;
        public Vec4 ntl;
        public Vec4 ntr;
        public Vec4 fbl;
        public Vec4 fbr;
        public Vec4 ftl;
        public Vec4 ftr;
    }
}

