/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLUquadric;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;

public final class Sphere
implements Extent,
Renderable {
    public static final Sphere UNIT_SPHERE = new Sphere(Vec4.ZERO, 1.0);
    protected final Vec4 center;
    protected final double radius;

    public static Sphere createBoundingSphere(Vec4[] vec4Array) {
        if (vec4Array == null) {
            String string = Logging.getMessage("nullValue.PointsArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array.length < 1) {
            String string = Logging.getMessage("Geom.Sphere.NoPointsSpecified");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4[] vec4Array2 = Vec4.computeExtrema(vec4Array);
        Vec4 vec4 = new Vec4((vec4Array2[0].x + vec4Array2[1].x) / 2.0, (vec4Array2[0].y + vec4Array2[1].y) / 2.0, (vec4Array2[0].z + vec4Array2[1].z) / 2.0);
        double d = vec4Array2[0].distanceTo3(vec4Array2[1]) / 2.0;
        return new Sphere(vec4, d);
    }

    public static Sphere createBoundingSphere(BufferWrapper bufferWrapper) {
        if (bufferWrapper == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferWrapper.getBackingBuffer().position() > bufferWrapper.getBackingBuffer().limit() - 3) {
            String string = Logging.getMessage("Geom.Sphere.NoPointsSpecified");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4[] vec4Array = Vec4.computeExtrema(bufferWrapper);
        Vec4 vec4 = new Vec4((vec4Array[0].x + vec4Array[1].x) / 2.0, (vec4Array[0].y + vec4Array[1].y) / 2.0, (vec4Array[0].z + vec4Array[1].z) / 2.0);
        double d = vec4Array[0].distanceTo3(vec4Array[1]) / 2.0;
        return new Sphere(vec4, d);
    }

    public static Sphere createBoundingSphere(Iterable<? extends Extent> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = null;
        double d = 0.0;
        int n = 0;
        for (Extent extent : iterable) {
            if (extent == null) continue;
            vec4 = vec4 != null ? extent.getCenter().add3(vec4) : extent.getCenter();
            ++n;
        }
        if (vec4 == null) {
            return null;
        }
        vec4 = vec4.divide3(n);
        for (Extent extent : iterable) {
            double d2;
            if (extent == null || !(d < (d2 = extent.getCenter().distanceTo3(vec4) + extent.getRadius()))) continue;
            d = d2;
        }
        return new Sphere(vec4, d);
    }

    public Sphere(Vec4 vec4, double d) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("Geom.Sphere.RadiusIsZeroOrNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = vec4;
        this.radius = d;
    }

    @Override
    public final double getRadius() {
        return this.radius;
    }

    @Override
    public final double getDiameter() {
        return 2.0 * this.radius;
    }

    @Override
    public final Vec4 getCenter() {
        return this.center;
    }

    @Override
    public double getEffectiveRadius(Plane plane) {
        return this.getRadius();
    }

    public Vec4 getPointOnSphere(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LocationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = latLon.getLatitude().sin();
        double d2 = this.center.x + this.getRadius() * d * latLon.getLongitude().cos();
        double d3 = this.center.y + this.getRadius() * d * latLon.getLongitude().sin();
        double d4 = this.center.z + this.getRadius() * latLon.getLatitude().cos();
        return new Vec4(d2, d3, d4);
    }

    @Override
    public final Intersection[] intersect(Line line) {
        double d;
        double d2;
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d3 = line.getDirection().getLengthSquared3();
        double d4 = Sphere.discriminant(d3, d2 = 2.0 * line.selfDot(), d = line.getOrigin().getLengthSquared3() - this.radius * this.radius);
        if (d4 < 0.0) {
            return null;
        }
        double d5 = Math.sqrt(d4);
        if (d4 == 0.0) {
            Vec4 vec4 = line.getPointAt((-d2 - d5) / (2.0 * d3));
            return new Intersection[]{new Intersection(vec4, true)};
        }
        Vec4 vec4 = line.getPointAt((-d2 - d5) / (2.0 * d3));
        Vec4 vec42 = line.getPointAt((-d2 + d5) / (2.0 * d3));
        return new Intersection[]{new Intersection(vec4, false), new Intersection(vec42, false)};
    }

    private static double discriminant(double d, double d2, double d3) {
        return d2 * d2 - 4.0 * d * d3;
    }

    @Override
    public final boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = Logging.getMessage("nullValue.FrustumIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = this.getCenter();
        double d = -this.getRadius();
        if (frustum.getFar().dot(vec4) <= d) {
            return false;
        }
        if (frustum.getLeft().dot(vec4) <= d) {
            return false;
        }
        if (frustum.getRight().dot(vec4) <= d) {
            return false;
        }
        if (frustum.getTop().dot(vec4) <= d) {
            return false;
        }
        if (frustum.getBottom().dot(vec4) <= d) {
            return false;
        }
        return !(frustum.getNear().dot(vec4) <= d);
    }

    @Override
    public boolean intersects(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return line.distanceTo(this.center) <= this.radius;
    }

    @Override
    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = Logging.getMessage("nullValue.PlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = plane.dot(this.center);
        return d <= this.radius;
    }

    @Override
    public double getProjectedArea(View view) {
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return WWMath.computeSphereProjectedArea(view, this.getCenter(), this.getRadius());
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glPushAttrib(8193);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glTranslated(this.center.x, this.center.y, this.center.z);
        GLUquadric gLUquadric = drawContext.getGLU().gluNewQuadric();
        drawContext.getGLU().gluQuadricDrawStyle(gLUquadric, 100011);
        drawContext.getGLU().gluSphere(gLUquadric, this.radius, 10, 10);
        gL2.glPopMatrix();
        drawContext.getGLU().gluDeleteQuadric(gLUquadric);
        gL2.glPopAttrib();
    }

    public String toString() {
        return "Sphere: center = " + this.center.toString() + " radius = " + Double.toString(this.radius);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Sphere sphere = (Sphere)object;
        if (Double.compare(sphere.radius, this.radius) != 0) {
            return false;
        }
        return this.center.equals(sphere.center);
    }

    public int hashCode() {
        int n = this.center.hashCode();
        long l = this.radius != 0.0 ? Double.doubleToLongBits(this.radius) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }
}

