/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

public class PolarCoordConverter {
    private static final long POLAR_NO_ERROR = 0L;
    private static final long POLAR_LAT_ERROR = 1L;
    private static final long POLAR_LON_ERROR = 2L;
    private static final long POLAR_ORIGIN_LAT_ERROR = 4L;
    private static final long POLAR_ORIGIN_LON_ERROR = 8L;
    public static final long POLAR_EASTING_ERROR = 16L;
    public static final long POLAR_NORTHING_ERROR = 32L;
    private static final long POLAR_A_ERROR = 64L;
    private static final long POLAR_INV_F_ERROR = 128L;
    public static final long POLAR_RADIUS_ERROR = 256L;
    private static final double PI = Math.PI;
    private static final double PI_OVER_2 = 1.5707963267948966;
    private static final double PI_Over_4 = 0.7853981633974483;
    private static final double TWO_PI = Math.PI * 2;
    private double Polar_a = 6378137.0;
    private double Polar_f = 0.0033528106647474805;
    private double es = 0.08181919084262188;
    private double es_OVER_2 = 0.040909595421311;
    private double Southern_Hemisphere = 0.0;
    private double mc = 1.0;
    private double tc = 1.0;
    private double e4 = 1.0033565552493;
    private double Polar_a_mc = 6378137.0;
    private double two_Polar_a = 1.2756274E7;
    private double Polar_Origin_Lat = 1.5707963267948966;
    private double Polar_Origin_Long = 0.0;
    private double Polar_False_Easting = 0.0;
    private double Polar_False_Northing = 0.0;
    private double Polar_Delta_Easting = 1.2713601E7;
    private double Polar_Delta_Northing = 1.2713601E7;
    private double Easting;
    private double Northing;
    private double Latitude;
    private double Longitude;

    PolarCoordConverter() {
    }

    public long setPolarStereographicParameters(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 1.0 / d2;
        long l = 0L;
        if (d <= 0.0) {
            l |= 0x40L;
        }
        if (d7 < 250.0 || d7 > 350.0) {
            l |= 0x80L;
        }
        if (d3 < -1.5707963267948966 || d3 > 1.5707963267948966) {
            l |= 4L;
        }
        if (d4 < -Math.PI || d4 > Math.PI * 2) {
            l |= 8L;
        }
        if (l == 0L) {
            this.Polar_a = d;
            this.two_Polar_a = 2.0 * this.Polar_a;
            this.Polar_f = d2;
            if (d4 > Math.PI) {
                d4 -= Math.PI * 2;
            }
            if (d3 < 0.0) {
                this.Southern_Hemisphere = 1.0;
                this.Polar_Origin_Lat = -d3;
                this.Polar_Origin_Long = -d4;
            } else {
                this.Southern_Hemisphere = 0.0;
                this.Polar_Origin_Lat = d3;
                this.Polar_Origin_Long = d4;
            }
            this.Polar_False_Easting = d5;
            this.Polar_False_Northing = d6;
            double d8 = 2.0 * this.Polar_f - this.Polar_f * this.Polar_f;
            this.es = Math.sqrt(d8);
            this.es_OVER_2 = this.es / 2.0;
            if (Math.abs(Math.abs(this.Polar_Origin_Lat) - 1.5707963267948966) > 1.0E-10) {
                double d9 = Math.sin(this.Polar_Origin_Lat);
                double d10 = this.es * d9;
                double d11 = Math.pow((1.0 - d10) / (1.0 + d10), this.es_OVER_2);
                double d12 = Math.cos(this.Polar_Origin_Lat);
                this.mc = d12 / Math.sqrt(1.0 - d10 * d10);
                this.Polar_a_mc = this.Polar_a * this.mc;
                this.tc = Math.tan(0.7853981633974483 - this.Polar_Origin_Lat / 2.0) / d11;
            } else {
                double d13 = 1.0 + this.es;
                double d14 = 1.0 - this.es;
                this.e4 = Math.sqrt(Math.pow(d13, d13) * Math.pow(d14, d14));
            }
        }
        this.convertGeodeticToPolarStereographic(0.0, this.Polar_Origin_Long);
        this.Polar_Delta_Northing = this.Northing * 2.0;
        this.Polar_Delta_Easting = this.Polar_Delta_Northing = Math.abs(this.Polar_Delta_Northing) + 0.01;
        return l;
    }

    public long convertGeodeticToPolarStereographic(double d, double d2) {
        long l = 0L;
        if (d < -1.5707963267948966 || d > 1.5707963267948966) {
            l |= 1L;
        }
        if (d < 0.0 && this.Southern_Hemisphere == 0.0) {
            l |= 1L;
        }
        if (d > 0.0 && this.Southern_Hemisphere == 1.0) {
            l |= 1L;
        }
        if (d2 < -Math.PI || d2 > Math.PI * 2) {
            l |= 2L;
        }
        if (l == 0L) {
            if (Math.abs(Math.abs(d) - 1.5707963267948966) < 1.0E-10) {
                this.Easting = 0.0;
                this.Northing = 0.0;
            } else {
                double d3;
                if (this.Southern_Hemisphere != 0.0) {
                    d2 *= -1.0;
                    d *= -1.0;
                }
                if ((d3 = d2 - this.Polar_Origin_Long) > Math.PI) {
                    d3 -= Math.PI * 2;
                }
                if (d3 < -Math.PI) {
                    d3 += Math.PI * 2;
                }
                double d4 = Math.sin(d);
                double d5 = this.es * d4;
                double d6 = Math.pow((1.0 - d5) / (1.0 + d5), this.es_OVER_2);
                double d7 = Math.tan(0.7853981633974483 - d / 2.0) / d6;
                double d8 = Math.abs(Math.abs(this.Polar_Origin_Lat) - 1.5707963267948966) > 1.0E-10 ? this.Polar_a_mc * d7 / this.tc : this.two_Polar_a * d7 / this.e4;
                if (this.Southern_Hemisphere != 0.0) {
                    this.Easting = -(d8 * Math.sin(d3) - this.Polar_False_Easting);
                    this.Northing = d8 * Math.cos(d3) + this.Polar_False_Northing;
                } else {
                    this.Easting = d8 * Math.sin(d3) + this.Polar_False_Easting;
                }
                this.Northing = -d8 * Math.cos(d3) + this.Polar_False_Northing;
            }
        }
        return l;
    }

    public double getEasting() {
        return this.Easting;
    }

    public double getNorthing() {
        return this.Northing;
    }

    public long convertPolarStereographicToGeodetic(double d, double d2) {
        double d3;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        long l = 0L;
        double d8 = this.Polar_False_Easting - this.Polar_Delta_Easting;
        double d9 = this.Polar_False_Easting + this.Polar_Delta_Easting;
        double d10 = this.Polar_False_Northing - this.Polar_Delta_Northing;
        double d11 = this.Polar_False_Northing + this.Polar_Delta_Northing;
        if (d > d9 || d < d8) {
            l |= 0x10L;
        }
        if (d2 > d11 || d2 < d10) {
            l |= 0x20L;
        }
        if (l == 0L && (d6 = Math.sqrt((d5 = d - this.Polar_False_Easting) * d5 + (d4 = d2 - this.Polar_False_Northing) * d4)) > (d3 = Math.sqrt(this.Polar_Delta_Easting * this.Polar_Delta_Easting + this.Polar_Delta_Northing * this.Polar_Delta_Northing))) {
            l |= 0x100L;
        }
        if (l == 0L) {
            if (d4 == 0.0 && d5 == 0.0) {
                this.Latitude = 1.5707963267948966;
                this.Longitude = this.Polar_Origin_Long;
            } else {
                if (this.Southern_Hemisphere != 0.0) {
                    d4 *= -1.0;
                    d5 *= -1.0;
                }
                double d12 = Math.abs(Math.abs(this.Polar_Origin_Lat) - 1.5707963267948966) > 1.0E-10 ? d6 * this.tc / this.Polar_a_mc : d6 * this.e4 / this.two_Polar_a;
                double d13 = 1.5707963267948966 - 2.0 * Math.atan(d12);
                while (Math.abs(d13 - d7) > 1.0E-10) {
                    d7 = d13;
                    double d14 = Math.sin(d13);
                    double d15 = this.es * d14;
                    double d16 = Math.pow((1.0 - d15) / (1.0 + d15), this.es_OVER_2);
                    d13 = 1.5707963267948966 - 2.0 * Math.atan(d12 * d16);
                }
                this.Latitude = d13;
                this.Longitude = this.Polar_Origin_Long + Math.atan2(d5, -d4);
                if (this.Longitude > Math.PI) {
                    this.Longitude -= Math.PI * 2;
                } else if (this.Longitude < -Math.PI) {
                    this.Longitude += Math.PI * 2;
                }
                if (this.Latitude > 1.5707963267948966) {
                    this.Latitude = 1.5707963267948966;
                } else if (this.Latitude < -1.5707963267948966) {
                    this.Latitude = -1.5707963267948966;
                }
                if (this.Longitude > Math.PI) {
                    this.Longitude = Math.PI;
                } else if (this.Longitude < -Math.PI) {
                    this.Longitude = -Math.PI;
                }
            }
            if (this.Southern_Hemisphere != 0.0) {
                this.Latitude *= -1.0;
                this.Longitude *= -1.0;
            }
        }
        return l;
    }

    public double getLatitude() {
        return this.Latitude;
    }

    public double getLongitude() {
        return this.Longitude;
    }
}

