/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.EllipsoidalGlobe;
import gov.nasa.worldwind.globes.GeographicProjection;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.Globe2D;
import gov.nasa.worldwind.globes.GlobeStateKey;
import gov.nasa.worldwind.globes.projections.ProjectionEquirectangular;
import gov.nasa.worldwind.globes.projections.ProjectionMercator;
import gov.nasa.worldwind.globes.projections.ProjectionModifiedSinusoidal;
import gov.nasa.worldwind.globes.projections.ProjectionSinusoidal;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;

public class FlatGlobe
extends EllipsoidalGlobe
implements Globe2D {
    public static final String PROJECTION_LAT_LON = "gov.nasa.worldwind.globes.projectionLatLon";
    public static final String PROJECTION_MERCATOR = "gov.nasa.worldwind.globes.projectionMercator";
    public static final String PROJECTION_SINUSOIDAL = "gov.nasa.worldwind.globes.projectionSinusoidal";
    public static final String PROJECTION_MODIFIED_SINUSOIDAL = "gov.nasa.worldwind.globes.projectionModifiedSinusoidal";
    protected GeographicProjection projection = (GeographicProjection)WorldWind.createComponent(Configuration.getStringValue("gov.nasa.worldwind.globes.GeographicProjectionClassName", "gov.nasa.worldwind.globes.projections.ProjectionEquirectangular"));
    protected boolean continuous;
    protected int offset;
    protected Vec4 offsetVector = Vec4.ZERO;

    public FlatGlobe(double d, double d2, double d3, ElevationModel elevationModel) {
        super(d, d2, d3, elevationModel);
    }

    @Override
    public Object getStateKey(DrawContext drawContext) {
        return this.getGlobeStateKey(drawContext);
    }

    @Override
    public GlobeStateKey getGlobeStateKey(DrawContext drawContext) {
        return new FlatStateKey(drawContext);
    }

    @Override
    public GlobeStateKey getGlobeStateKey() {
        return new FlatStateKey((Globe)this);
    }

    public void setProjection(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.GeographicProjectionIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.equals(PROJECTION_LAT_LON)) {
            this.setProjection(new ProjectionEquirectangular());
        } else if (string.equals(PROJECTION_MERCATOR)) {
            this.setProjection(new ProjectionMercator());
        } else if (string.equals(PROJECTION_SINUSOIDAL)) {
            this.setProjection(new ProjectionSinusoidal());
        } else if (string.equals(PROJECTION_MODIFIED_SINUSOIDAL)) {
            this.setProjection(new ProjectionModifiedSinusoidal());
        } else {
            this.setProjection(new ProjectionEquirectangular());
        }
    }

    @Override
    public void setProjection(GeographicProjection geographicProjection) {
        if (geographicProjection == null) {
            String string = Logging.getMessage("nullValue.GeographicProjectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.projection = geographicProjection;
    }

    @Override
    public GeographicProjection getProjection() {
        return this.projection;
    }

    @Override
    public void setContinuous(boolean bl) {
        this.continuous = bl;
    }

    @Override
    public boolean isContinuous() {
        return this.continuous || this.projection != null && this.projection.isContinuous();
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int n) {
        this.offset = n;
        this.offsetVector = new Vec4(Math.PI * 2 * this.equatorialRadius * (double)this.offset, 0.0, 0.0);
    }

    @Override
    public boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = Logging.getMessage("nullValue.FrustumIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Sector.computeBoundingBox(this, 1.0, Sector.FULL_SPHERE, this.getMinElevation(), this.getMaxElevation()).intersects(frustum);
    }

    @Override
    protected Intersection[] intersect(Line line, double d, double d2) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Plane plane = new Plane(0.0, 0.0, 1.0, -(d - this.equatorialRadius));
        Vec4 vec4 = plane.intersect(line);
        if (vec4 == null) {
            return null;
        }
        Position position = this.computePositionFromPoint(vec4);
        if (position == null) {
            return null;
        }
        if (position.getLatitude().degrees < -90.0 || position.getLatitude().degrees > 90.0) {
            return null;
        }
        if (!this.isContinuous() && (position.getLongitude().degrees < -180.0 || position.getLongitude().degrees > 180.0)) {
            return null;
        }
        return new Intersection[]{new Intersection(vec4, false)};
    }

    @Override
    public boolean intersects(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.intersect(line) != null;
    }

    @Override
    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = Logging.getMessage("nullValue.PlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = plane.getNormal();
        return vec4.x != 0.0 || vec4.y != 0.0 || vec4.z != 1.0;
    }

    @Override
    public Vec4 computeSurfaceNormalAtLocation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Vec4.UNIT_Z;
    }

    @Override
    public Vec4 computeSurfaceNormalAtPoint(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Vec4.UNIT_Z;
    }

    @Override
    public Vec4 computeNorthPointingTangentAtLocation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.projection.northPointingTangent(this, angle, angle2);
    }

    @Override
    public Matrix computeSurfaceOrientationAtPosition(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = this.geodeticToCartesian(angle, angle2, d);
        Vec4 vec42 = this.computeSurfaceNormalAtLocation(angle, angle2);
        Vec4 vec43 = this.computeNorthPointingTangentAtLocation(angle, angle2);
        Vec4 vec44 = vec43.cross3(vec42);
        Vec4[] vec4Array = new Vec4[]{vec44, vec43, vec42};
        return Matrix.fromLocalOrientation(vec4, vec4Array);
    }

    @Override
    public double getElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees < -90.0 || angle.degrees > 90.0 || angle2.degrees < -180.0 || angle2.degrees > 180.0) {
            return 0.0;
        }
        return super.getElevation(angle, angle2);
    }

    @Override
    protected Vec4 geodeticToCartesian(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.projection.geographicToCartesian(this, angle, angle2, d, this.offsetVector);
    }

    @Override
    protected void geodeticToCartesian(Sector sector, int n, int n2, double[] dArray, Vec4[] vec4Array) {
        this.projection.geographicToCartesian(this, sector, n, n2, dArray, this.offsetVector, vec4Array);
    }

    @Override
    protected Position cartesianToGeodetic(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = this.projection.cartesianToGeographic(this, vec4, this.offsetVector);
        if (this.isContinuous()) {
            if (position.getLongitude().degrees < -180.0) {
                position = Position.fromDegrees(position.getLatitude().degrees, position.getLongitude().degrees + 360.0, position.getAltitude());
            } else if (position.getLongitude().degrees > 180.0) {
                position = Position.fromDegrees(position.getLatitude().degrees, position.getLongitude().degrees - 360.0, position.getAltitude());
            }
        }
        return position;
    }

    @Override
    public boolean isPointAboveElevation(Vec4 vec4, double d) {
        if (vec4 == null) {
            return false;
        }
        return vec4.z() > d;
    }

    private class FlatStateKey
    extends EllipsoidalGlobe.StateKey {
        protected GeographicProjection projection;
        protected double verticalExaggeration;
        protected int offset;

        public FlatStateKey(DrawContext drawContext) {
            super(drawContext);
            this.projection = FlatGlobe.this.getProjection();
            this.offset = FlatGlobe.this.offset;
        }

        public FlatStateKey(Globe globe) {
            super(globe);
            this.projection = FlatGlobe.this.getProjection();
            this.offset = FlatGlobe.this.offset;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            FlatStateKey flatStateKey = (FlatStateKey)object;
            if (this.offset != flatStateKey.offset) {
                return false;
            }
            if (Double.compare(flatStateKey.verticalExaggeration, this.verticalExaggeration) != 0) {
                return false;
            }
            return !(this.projection != null ? !this.projection.equals(flatStateKey.projection) : flatStateKey.projection != null);
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.projection != null ? this.projection.hashCode() : 0);
            long l = this.verticalExaggeration != 0.0 ? Double.doubleToLongBits(this.verticalExaggeration) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            n = 31 * n + this.offset;
            return n;
        }
    }
}

