/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes.projections;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.GeographicProjection;
import gov.nasa.worldwind.util.Logging;

public abstract class AbstractGeographicProjection
implements GeographicProjection {
    protected Sector projectionLimits;

    public AbstractGeographicProjection(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.projectionLimits = sector;
    }

    @Override
    public Sector getProjectionLimits() {
        return this.projectionLimits;
    }

    @Override
    public void setProjectionLimits(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!sector.isWithinLatLonLimits()) {
            String string = Logging.getMessage("generic.AngleOutOfRange", sector);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.projectionLimits = sector;
    }
}

