/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes.projections;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.projections.AbstractGeographicProjection;

public class ProjectionEquirectangular
extends AbstractGeographicProjection {
    public ProjectionEquirectangular() {
        super(Sector.FULL_SPHERE);
    }

    @Override
    public String getName() {
        return "Equirectangular";
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Vec4 geographicToCartesian(Globe globe, Angle angle, Angle angle2, double d, Vec4 vec4) {
        return new Vec4(globe.getEquatorialRadius() * angle2.radians + vec4.x, globe.getEquatorialRadius() * angle.radians, d);
    }

    @Override
    public void geographicToCartesian(Globe globe, Sector sector, int n, int n2, double[] dArray, Vec4 vec4, Vec4[] vec4Array) {
        double d = globe.getEquatorialRadius();
        double d2 = sector.getMinLatitude().radians;
        double d3 = sector.getMaxLatitude().radians;
        double d4 = sector.getMinLongitude().radians;
        double d5 = sector.getMaxLongitude().radians;
        double d6 = (d3 - d2) / (double)(n > 1 ? n - 1 : 1);
        double d7 = (d5 - d4) / (double)(n2 > 1 ? n2 - 1 : 1);
        double d8 = vec4.x;
        int n3 = 0;
        double d9 = d2;
        int n4 = 0;
        while (n4 < n) {
            if (n4 == n - 1) {
                d9 = d3;
            }
            double d10 = d * d9;
            double d11 = d4;
            int n5 = 0;
            while (n5 < n2) {
                if (n5 == n2 - 1) {
                    d11 = d5;
                }
                double d12 = d * d11 + d8;
                double d13 = dArray[n3];
                vec4Array[n3++] = new Vec4(d12, d10, d13);
                ++n5;
                d11 += d7;
            }
            ++n4;
            d9 += d6;
        }
    }

    @Override
    public Position cartesianToGeographic(Globe globe, Vec4 vec4, Vec4 vec42) {
        return Position.fromRadians(vec4.y / globe.getEquatorialRadius(), (vec4.x - vec42.x) / globe.getEquatorialRadius(), vec4.z);
    }

    @Override
    public Vec4 northPointingTangent(Globe globe, Angle angle, Angle angle2) {
        return Vec4.UNIT_Y;
    }
}

