/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes.projections;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.projections.AbstractGeographicProjection;
import gov.nasa.worldwind.util.WWMath;

public class ProjectionModifiedSinusoidal
extends AbstractGeographicProjection {
    public ProjectionModifiedSinusoidal() {
        super(Sector.FULL_SPHERE);
    }

    @Override
    public String getName() {
        return "Modified Sinusoidal";
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public Vec4 geographicToCartesian(Globe globe, Angle angle, Angle angle2, double d, Vec4 vec4) {
        double d2 = angle.cos();
        double d3 = d2 > 0.0 ? globe.getEquatorialRadius() * angle2.radians * Math.pow(d2, 0.3) : 0.0;
        double d4 = globe.getEquatorialRadius() * angle.radians;
        return new Vec4(d3, d4, d);
    }

    @Override
    public void geographicToCartesian(Globe globe, Sector sector, int n, int n2, double[] dArray, Vec4 vec4, Vec4[] vec4Array) {
        double d = globe.getEquatorialRadius();
        double d2 = sector.getMinLatitude().radians;
        double d3 = sector.getMaxLatitude().radians;
        double d4 = sector.getMinLongitude().radians;
        double d5 = sector.getMaxLongitude().radians;
        double d6 = (d3 - d2) / (double)(n > 1 ? n - 1 : 1);
        double d7 = (d5 - d4) / (double)(n2 > 1 ? n2 - 1 : 1);
        int n3 = 0;
        double d8 = d2;
        int n4 = 0;
        while (n4 < n) {
            if (n4 == n - 1) {
                d8 = d3;
            }
            double d9 = d * d8;
            double d10 = Math.cos(d8);
            double d11 = d10 > 0.0 ? Math.pow(d10, 0.3) : 0.0;
            double d12 = d4;
            int n5 = 0;
            while (n5 < n2) {
                if (n5 == n2 - 1) {
                    d12 = d5;
                }
                double d13 = d * d12 * d11;
                double d14 = dArray[n3];
                vec4Array[n3++] = new Vec4(d13, d9, d14);
                ++n5;
                d12 += d7;
            }
            ++n4;
            d8 += d6;
        }
    }

    @Override
    public Position cartesianToGeographic(Globe globe, Vec4 vec4, Vec4 vec42) {
        double d = vec4.y / globe.getEquatorialRadius();
        double d2 = Math.cos(d = WWMath.clamp(d, -1.5707963267948966, 1.5707963267948966));
        double d3 = d2 > 0.0 ? vec4.x / globe.getEquatorialRadius() / Math.pow(d2, 0.3) : 0.0;
        d3 = WWMath.clamp(d3, -Math.PI, Math.PI);
        return Position.fromRadians(d, d3, vec4.z);
    }

    @Override
    public Vec4 northPointingTangent(Globe globe, Angle angle, Angle angle2) {
        double d = globe.getEquatorialRadius() * angle2.radians * 0.3 * Math.pow(angle.cos(), -0.7) * -angle.sin();
        double d2 = globe.getEquatorialRadius();
        return new Vec4(d, d2, 0.0).normalize3();
    }
}

