/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes.projections;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.globes.projections.ProjectionTransverseMercator;
import gov.nasa.worldwind.util.Logging;

public class ProjectionUTM
extends ProjectionTransverseMercator {
    protected static final int DEFAULT_ZONE = 1;
    protected int zone = 1;

    public ProjectionUTM() {
        super(ProjectionUTM.centralMeridianForZone(1));
    }

    public ProjectionUTM(int n) {
        super(ProjectionUTM.centralMeridianForZone(n));
    }

    @Override
    protected double getScale() {
        return 0.9996;
    }

    public int getZone() {
        return this.zone;
    }

    public void setZone(int n) {
        if (n < 1 || n > 60) {
            String string = Logging.getMessage("UTM.InvalidZone", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.zone = n;
        this.setCentralMeridian(ProjectionUTM.centralMeridianForZone(this.zone));
    }

    public static Angle centralMeridianForZone(int n) {
        if (n < 1 || n > 60) {
            String string = Logging.getMessage("UTM.InvalidZone", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Angle.fromDegrees(3 + (n - 1) * 6 - (n > 30 ? 360 : 0));
    }
}

