/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.GeographicProjection;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.Globe2D;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.GraticuleRenderingParams;
import gov.nasa.worldwind.layers.GraticuleSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.view.orbit.OrbitView;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Map;

public class AbstractGraticuleLayer
extends AbstractLayer {
    public static final String LINE_STYLE_SOLID = "LineStyleSolid";
    public static final String LINE_STYLE_DASHED = "LineStyleDashed";
    public static final String LINE_STYLE_DOTTED = "LineStyleDotted";
    protected ArrayList<GridElement> gridElements;
    protected GraticuleSupport graticuleSupport = new GraticuleSupport();
    protected double terrainConformance = 50.0;
    protected Globe globe;
    protected Vec4 lastEyePoint;
    protected double lastViewHeading = 0.0;
    protected double lastViewPitch = 0.0;
    protected double lastViewFOV = 0.0;
    protected double lastVerticalExaggeration = 1.0;
    protected GeographicProjection lastProjection;
    protected long frameTimeStamp;

    public boolean isDrawGraticule(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).isDrawLines();
    }

    public void setDrawGraticule(boolean bl, String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.getRenderingParams(string).setDrawLines(bl);
    }

    public Color getGraticuleLineColor(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLineColor();
    }

    public void setGraticuleLineColor(Color color, String string) {
        if (color == null) {
            String string2 = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.getRenderingParams(string).setLineColor(color);
    }

    public double getGraticuleLineWidth(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLineWidth();
    }

    public void setGraticuleLineWidth(double d, String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.getRenderingParams(string).setLineWidth(d);
    }

    public String getGraticuleLineStyle(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLineStyle();
    }

    public void setGraticuleLineStyle(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.getRenderingParams(string2).setLineStyle(string);
    }

    public boolean isDrawLabels(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).isDrawLabels();
    }

    public void setDrawLabels(boolean bl, String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.getRenderingParams(string).setDrawLabels(bl);
    }

    public Color getLabelColor(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLabelColor();
    }

    public void setLabelColor(Color color, String string) {
        if (color == null) {
            String string2 = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.getRenderingParams(string).setLabelColor(color);
    }

    public Font getLabelFont(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLabelFont();
    }

    public void setLabelFont(Font font, String string) {
        if (font == null) {
            String string2 = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.getRenderingParams(string).setLabelFont(font);
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        RestorableSupport.StateObject stateObject = restorableSupport.addStateObject("renderingParams");
        for (Map.Entry<String, GraticuleRenderingParams> entry : this.graticuleSupport.getAllRenderingParams()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, entry.getKey());
            AbstractGraticuleLayer.makeRestorableState(entry.getValue(), restorableSupport, stateObject2);
        }
        return restorableSupport.getStateAsXml();
    }

    private static void makeRestorableState(GraticuleRenderingParams graticuleRenderingParams, RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (graticuleRenderingParams != null && restorableSupport != null) {
            for (Map.Entry<String, Object> entry : graticuleRenderingParams.getEntries()) {
                if (entry.getValue() instanceof Color) {
                    restorableSupport.addStateValueAsInteger(stateObject, entry.getKey() + ".Red", ((Color)entry.getValue()).getRed());
                    restorableSupport.addStateValueAsInteger(stateObject, entry.getKey() + ".Green", ((Color)entry.getValue()).getGreen());
                    restorableSupport.addStateValueAsInteger(stateObject, entry.getKey() + ".Blue", ((Color)entry.getValue()).getBlue());
                    restorableSupport.addStateValueAsInteger(stateObject, entry.getKey() + ".Alpha", ((Color)entry.getValue()).getAlpha());
                    continue;
                }
                if (entry.getValue() instanceof Font) {
                    restorableSupport.addStateValueAsString(stateObject, entry.getKey() + ".Name", ((Font)entry.getValue()).getName());
                    restorableSupport.addStateValueAsInteger(stateObject, entry.getKey() + ".Style", ((Font)entry.getValue()).getStyle());
                    restorableSupport.addStateValueAsInteger(stateObject, entry.getKey() + ".Size", ((Font)entry.getValue()).getSize());
                    continue;
                }
                graticuleRenderingParams.getRestorableStateForAVPair(entry.getKey(), entry.getValue(), restorableSupport, stateObject);
            }
        }
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        RestorableSupport.StateObject stateObject = restorableSupport.getStateObject("renderingParams");
        if (stateObject != null) {
            RestorableSupport.StateObject[] stateObjectArray;
            for (RestorableSupport.StateObject stateObject2 : stateObjectArray = restorableSupport.getAllStateObjects(stateObject)) {
                if (stateObject2 == null) continue;
                GraticuleRenderingParams graticuleRenderingParams = this.getRenderingParams(stateObject2.getName());
                if (graticuleRenderingParams == null) {
                    graticuleRenderingParams = new GraticuleRenderingParams();
                }
                AbstractGraticuleLayer.restorableStateToParams(graticuleRenderingParams, restorableSupport, stateObject2);
                this.setRenderingParams(stateObject2.getName(), graticuleRenderingParams);
            }
        }
    }

    private static void restorableStateToParams(AVList aVList, RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (aVList != null && restorableSupport != null) {
            String string;
            Double d;
            Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "DrawGraticule");
            if (bl != null) {
                aVList.setValue("DrawGraticule", bl);
            }
            Integer n = restorableSupport.getStateValueAsInteger(stateObject, "GraticuleLineColor.Red");
            Integer n2 = restorableSupport.getStateValueAsInteger(stateObject, "GraticuleLineColor.Green");
            Integer n3 = restorableSupport.getStateValueAsInteger(stateObject, "GraticuleLineColor.Blue");
            Integer n4 = restorableSupport.getStateValueAsInteger(stateObject, "GraticuleLineColor.Alpha");
            if (n != null && n2 != null && n3 != null && n4 != null) {
                aVList.setValue("GraticuleLineColor", new Color(n, n2, n3, n4));
            }
            if ((d = restorableSupport.getStateValueAsDouble(stateObject, "GraticuleLineWidth")) != null) {
                aVList.setValue("GraticuleLineWidth", d);
            }
            if ((string = restorableSupport.getStateValueAsString(stateObject, "GraticuleLineStyle")) != null) {
                aVList.setValue("GraticuleLineStyle", string);
            }
            if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "DrawLabels")) != null) {
                aVList.setValue("DrawLabels", bl);
            }
            n = restorableSupport.getStateValueAsInteger(stateObject, "LabelColor.Red");
            n2 = restorableSupport.getStateValueAsInteger(stateObject, "LabelColor.Green");
            n3 = restorableSupport.getStateValueAsInteger(stateObject, "LabelColor.Blue");
            n4 = restorableSupport.getStateValueAsInteger(stateObject, "LabelColor.Alpha");
            if (n != null && n2 != null && n3 != null && n4 != null) {
                aVList.setValue("LabelColor", new Color(n, n2, n3, n4));
            }
            String string2 = restorableSupport.getStateValueAsString(stateObject, "LabelFont.Name");
            Integer n5 = restorableSupport.getStateValueAsInteger(stateObject, "LabelFont.Style");
            Integer n6 = restorableSupport.getStateValueAsInteger(stateObject, "LabelFont.Size");
            if (string2 != null && n5 != null && n6 != null) {
                aVList.setValue("LabelFont", new Font(string2, (int)n5, n6));
            }
        }
    }

    protected GraticuleRenderingParams getRenderingParams(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.graticuleSupport.getRenderingParams(string);
    }

    protected void setRenderingParams(String string, GraticuleRenderingParams graticuleRenderingParams) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.graticuleSupport.setRenderingParams(string, graticuleRenderingParams);
    }

    protected void addRenderable(Object object, String string) {
        if (object == null) {
            String string2 = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.graticuleSupport.addRenderable(object, string);
    }

    protected void removeAllRenderables() {
        this.graticuleSupport.removeAllRenderables();
    }

    @Override
    public void doPreRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.isContinuous2DGlobe()) {
            if (this.needsToUpdate(drawContext)) {
                this.clear(drawContext);
                this.selectRenderables(drawContext);
            }
            if (drawContext.getFrameTimeStamp() == this.frameTimeStamp) {
                this.selectRenderables(drawContext);
            }
            this.frameTimeStamp = drawContext.getFrameTimeStamp();
        } else if (this.needsToUpdate(drawContext)) {
            this.clear(drawContext);
            this.selectRenderables(drawContext);
        }
    }

    @Override
    public void doRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.renderGraticule(drawContext);
    }

    protected void renderGraticule(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.graticuleSupport.render(drawContext, this.getOpacity());
    }

    protected void selectRenderables(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    protected boolean needsToUpdate(DrawContext drawContext) {
        if (this.lastEyePoint == null) {
            return true;
        }
        View view = drawContext.getView();
        double d = this.computeAltitudeAboveGround(drawContext);
        if (view.getEyePoint().distanceTo3(this.lastEyePoint) > d / 100.0) {
            return true;
        }
        if (this.lastVerticalExaggeration != drawContext.getVerticalExaggeration()) {
            return true;
        }
        if (Math.abs(this.lastViewHeading - view.getHeading().degrees) > 1.0) {
            return true;
        }
        if (Math.abs(this.lastViewPitch - view.getPitch().degrees) > 1.0) {
            return true;
        }
        if (Math.abs(this.lastViewFOV - view.getFieldOfView().degrees) > 1.0) {
            return true;
        }
        if (drawContext.getGlobe() != this.globe) {
            return true;
        }
        return drawContext.is2DGlobe() && ((Globe2D)((Object)drawContext.getGlobe())).getProjection() != this.lastProjection;
    }

    protected void clear(DrawContext drawContext) {
        this.removeAllRenderables();
        this.terrainConformance = this.computeTerrainConformance(drawContext);
        this.globe = drawContext.getGlobe();
        this.lastEyePoint = drawContext.getView().getEyePoint();
        this.lastViewFOV = drawContext.getView().getFieldOfView().degrees;
        this.lastViewHeading = drawContext.getView().getHeading().degrees;
        this.lastViewPitch = drawContext.getView().getPitch().degrees;
        this.lastVerticalExaggeration = drawContext.getVerticalExaggeration();
        if (drawContext.is2DGlobe()) {
            this.lastProjection = ((Globe2D)((Object)drawContext.getGlobe())).getProjection();
        }
    }

    protected double computeTerrainConformance(DrawContext drawContext) {
        int n = 100;
        double d = drawContext.getView().getEyePosition().getElevation();
        if (d < 10000.0) {
            n = 20;
        } else if (d < 50000.0) {
            n = 30;
        } else if (d < 100000.0) {
            n = 40;
        } else if (d < 1000000.0) {
            n = 60;
        }
        return n;
    }

    protected LatLon computeLabelOffset(DrawContext drawContext) {
        LatLon latLon;
        if (drawContext.getView() instanceof OrbitView) {
            OrbitView orbitView = (OrbitView)drawContext.getView();
            Position position = orbitView.getCenterPosition();
            Double d = Angle.fromRadians((double)(orbitView.computePixelSizeAtDistance((double)orbitView.getZoom()) / drawContext.getGlobe().getEquatorialRadius())).degrees;
            Double d2 = d * orbitView.getViewport().getWidth() / 4.0;
            latLon = LatLon.fromDegrees(position.getLatitude().degrees - d2, position.getLongitude().degrees - d2);
            Double d3 = latLon.getLatitude().normalizedLatitude().degrees;
            d3 = Math.min(Math.max(d3, -70.0), 70.0);
            latLon = new LatLon(Angle.fromDegrees(d3), latLon.getLongitude().normalizedLongitude());
        } else {
            latLon = drawContext.getView().getEyePosition();
        }
        return latLon;
    }

    protected Object createLineRenderable(Iterable<? extends Position> iterable, String string) {
        Path path = new Path(iterable);
        path.setPathType(string);
        path.setFollowTerrain(true);
        path.setTerrainConformance(1.0);
        path.setAltitudeMode(1);
        return path;
    }

    protected Vec4 getSurfacePoint(DrawContext drawContext, Angle angle, Angle angle2) {
        Vec4 vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(angle, angle2);
        if (vec4 == null) {
            vec4 = drawContext.getGlobe().computePointFromPosition(new Position(angle, angle2, drawContext.getGlobe().getElevation(angle, angle2)));
        }
        return vec4;
    }

    protected double computeAltitudeAboveGround(DrawContext drawContext) {
        View view = drawContext.getView();
        Position position = view.getEyePosition();
        Vec4 vec4 = this.getSurfacePoint(drawContext, position.getLatitude(), position.getLongitude());
        return view.getEyePoint().distanceTo3(vec4);
    }

    protected void computeTruncatedSegment(Position position, Position position2, Sector sector, ArrayList<Position> arrayList) {
        if (position == null || position2 == null) {
            return;
        }
        boolean bl = sector.contains(position);
        boolean bl2 = sector.contains(position2);
        if (!bl && !bl2) {
            return;
        }
        if (bl && bl2) {
            arrayList.add(position);
            arrayList.add(position2);
        } else {
            Position position3 = !bl ? position : position2;
            Position position4 = bl ? position : position2;
            for (int i = 1; i <= 2; ++i) {
                LatLon latLon = null;
                if (position3.getLongitude().degrees > sector.getMaxLongitude().degrees || sector.getMaxLongitude().degrees == 180.0 && position3.getLongitude().degrees < 0.0) {
                    latLon = this.greatCircleIntersectionAtLongitude(position4, position3, sector.getMaxLongitude());
                } else if (position3.getLongitude().degrees < sector.getMinLongitude().degrees || sector.getMinLongitude().degrees == -180.0 && position3.getLongitude().degrees > 0.0) {
                    latLon = this.greatCircleIntersectionAtLongitude(position4, position3, sector.getMinLongitude());
                } else if (position3.getLatitude().degrees > sector.getMaxLatitude().degrees) {
                    latLon = this.greatCircleIntersectionAtLatitude(position4, position3, sector.getMaxLatitude());
                } else if (position3.getLatitude().degrees < sector.getMinLatitude().degrees) {
                    latLon = this.greatCircleIntersectionAtLatitude(position4, position3, sector.getMinLatitude());
                }
                if (latLon == null) break;
                position3 = new Position(latLon, position3.getElevation());
            }
            arrayList.add(position4);
            arrayList.add(position3);
        }
    }

    protected LatLon greatCircleIntersectionAtLongitude(LatLon latLon, LatLon latLon2, Angle angle) {
        if (latLon.getLongitude().degrees == angle.degrees) {
            return latLon;
        }
        if (latLon2.getLongitude().degrees == angle.degrees) {
            return latLon2;
        }
        LatLon latLon3 = null;
        Double d = this.getDeltaLongitude((LatLon)latLon, (Angle)latLon2.getLongitude()).degrees;
        if (this.getDeltaLongitude((LatLon)latLon, (Angle)angle).degrees < d && this.getDeltaLongitude((LatLon)latLon2, (Angle)angle).degrees < d) {
            int n = 0;
            double d2 = 1.567855942887398E-7;
            LatLon latLon4 = latLon;
            LatLon latLon5 = latLon2;
            LatLon latLon6 = this.greatCircleMidPoint(latLon4, latLon5);
            while (this.getDeltaLongitude((LatLon)latLon6, (Angle)angle).radians > d2 && n <= 20) {
                ++n;
                if (this.getDeltaLongitude((LatLon)latLon4, (Angle)angle).degrees < this.getDeltaLongitude((LatLon)latLon5, (Angle)angle).degrees) {
                    latLon5 = latLon6;
                } else {
                    latLon4 = latLon6;
                }
                latLon6 = this.greatCircleMidPoint(latLon4, latLon5);
            }
            latLon3 = latLon6;
        }
        if (latLon3 != null) {
            latLon3 = new LatLon(latLon3.getLatitude(), angle);
        }
        return latLon3;
    }

    protected LatLon greatCircleIntersectionAtLatitude(LatLon latLon, LatLon latLon2, Angle angle) {
        LatLon latLon3 = null;
        if (Math.signum(latLon.getLatitude().degrees - angle.degrees) != Math.signum(latLon2.getLatitude().degrees - angle.degrees)) {
            int n = 0;
            double d = 1.567855942887398E-7;
            LatLon latLon4 = latLon;
            LatLon latLon5 = latLon2;
            LatLon latLon6 = this.greatCircleMidPoint(latLon4, latLon5);
            while (Math.abs(latLon6.getLatitude().radians - angle.radians) > d && n <= 20) {
                ++n;
                if (Math.signum(latLon4.getLatitude().degrees - angle.degrees) != Math.signum(latLon6.getLatitude().degrees - angle.degrees)) {
                    latLon5 = latLon6;
                } else {
                    latLon4 = latLon6;
                }
                latLon6 = this.greatCircleMidPoint(latLon4, latLon5);
            }
            latLon3 = latLon6;
        }
        if (latLon3 != null) {
            latLon3 = new LatLon(angle, latLon3.getLongitude());
        }
        return latLon3;
    }

    protected LatLon greatCircleMidPoint(LatLon latLon, LatLon latLon2) {
        Angle angle = LatLon.greatCircleAzimuth(latLon, latLon2);
        Angle angle2 = LatLon.greatCircleDistance(latLon, latLon2);
        return LatLon.greatCircleEndPosition(latLon, angle.radians, angle2.radians / 2.0);
    }

    protected Angle getDeltaLongitude(LatLon latLon, Angle angle) {
        double d = Math.abs(latLon.getLongitude().degrees - angle.degrees);
        return Angle.fromDegrees(d < 180.0 ? d : 360.0 - d);
    }

    protected class GridElement {
        public static final String TYPE_LINE = "GridElement_Line";
        public static final String TYPE_LINE_NORTH = "GridElement_LineNorth";
        public static final String TYPE_LINE_SOUTH = "GridElement_LineSouth";
        public static final String TYPE_LINE_WEST = "GridElement_LineWest";
        public static final String TYPE_LINE_EAST = "GridElement_LineEast";
        public static final String TYPE_LINE_NORTHING = "GridElement_LineNorthing";
        public static final String TYPE_LINE_EASTING = "GridElement_LineEasting";
        public static final String TYPE_GRIDZONE_LABEL = "GridElement_GridZoneLabel";
        public static final String TYPE_LONGITUDE_LABEL = "GridElement_LongitudeLabel";
        public static final String TYPE_LATITUDE_LABEL = "GridElement_LatitudeLabel";
        public final Sector sector;
        public final Object renderable;
        public final String type;
        public double value;

        public GridElement(Sector sector, Object object, String string) {
            if (sector == null) {
                String string2 = Logging.getMessage("nullValue.SectorIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            if (object == null) {
                String string3 = Logging.getMessage("nullValue.ObjectIsNull");
                Logging.logger().severe(string3);
                throw new IllegalArgumentException(string3);
            }
            if (string == null) {
                String string4 = Logging.getMessage("nullValue.StringIsNull");
                Logging.logger().severe(string4);
                throw new IllegalArgumentException(string4);
            }
            this.sector = sector;
            this.renderable = object;
            this.type = string;
        }

        public void setValue(double d) {
            this.value = d;
        }

        public boolean isInView(DrawContext drawContext) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.isInView(drawContext, drawContext.getVisibleSector());
        }

        public boolean isInView(DrawContext drawContext, Sector sector) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (sector == null) {
                String string = Logging.getMessage("nullValue.SectorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.sector.intersects(sector);
        }
    }
}

