/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;

public class AirspaceLayer
extends AbstractLayer {
    private final Collection<Airspace> airspaces = new ConcurrentLinkedQueue<Airspace>();
    private Iterable<Airspace> airspacesOverride;

    public void addAirspace(Airspace airspace) {
        if (airspace == null) {
            String string = "nullValue.AirspaceIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.airspacesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.airspaces.add(airspace);
    }

    public void addAirspaces(Iterable<Airspace> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.airspacesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        for (Airspace airspace : iterable) {
            if (airspace == null) continue;
            this.airspaces.add(airspace);
        }
    }

    public void removeAirspace(Airspace airspace) {
        if (airspace == null) {
            String string = "nullValue.AirspaceIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.airspacesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.airspaces.remove(airspace);
    }

    public void removeAllAirspaces() {
        if (this.airspacesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.clearAirspaces();
    }

    private void clearAirspaces() {
        if (this.airspaces != null && this.airspaces.size() > 0) {
            this.airspaces.clear();
        }
    }

    public Iterable<Airspace> getAirspaces() {
        if (this.airspacesOverride != null) {
            return this.airspacesOverride;
        }
        return Collections.unmodifiableCollection(this.airspaces);
    }

    private Iterable<Airspace> getActiveAirspaces() {
        if (this.airspacesOverride != null) {
            return this.airspacesOverride;
        }
        return this.airspaces;
    }

    public void setAirspaces(Iterable<Airspace> iterable) {
        this.airspacesOverride = iterable;
        this.clearAirspaces();
    }

    public boolean isEnableAntialiasing() {
        return false;
    }

    public void setEnableAntialiasing(boolean bl) {
    }

    public boolean isEnableBlending() {
        return false;
    }

    public void setEnableBlending(boolean bl) {
    }

    public boolean isEnableDepthOffset() {
        return false;
    }

    public void setEnableDepthOffset(boolean bl) {
    }

    public boolean isEnableLighting() {
        return false;
    }

    public void setEnableLighting(boolean bl) {
    }

    public boolean isDrawExtents() {
        return false;
    }

    public void setDrawExtents(boolean bl) {
    }

    public boolean isDrawWireframe() {
        return false;
    }

    public void setDrawWireframe(boolean bl) {
    }

    public Double getDepthOffsetFactor() {
        return 0.0;
    }

    public void setDepthOffsetFactor(Double d) {
    }

    public Double getDepthOffsetUnits() {
        return 0.0;
    }

    public void setDepthOffsetUnits(Double d) {
    }

    public boolean isEnableBatchRendering() {
        return false;
    }

    public void setEnableBatchRendering(boolean bl) {
    }

    public boolean isEnableBatchPicking() {
        return false;
    }

    public void setEnableBatchPicking(boolean bl) {
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        for (Airspace airspace : this.getActiveAirspaces()) {
            try {
                if (airspace == null) continue;
                airspace.render(drawContext);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhileRenderingAirspace");
                Logging.logger().log(Level.SEVERE, string, exception);
            }
        }
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        for (Airspace airspace : this.getActiveAirspaces()) {
            try {
                if (airspace == null) continue;
                airspace.render(drawContext);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhileRenderingAirspace");
                Logging.logger().log(Level.SEVERE, string, exception);
            }
        }
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.AirspaceLayer.Name");
    }
}

