/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.BasicFactory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.exception.WWUnrecognizedException;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.LocalRasterServerLayer;
import gov.nasa.worldwind.ogc.OGCCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSLayerCapabilities;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.wms.WMSTiledImageLayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class BasicLayerFactory
extends BasicFactory {
    @Override
    public Object createFromConfigSource(Object object, AVList aVList) {
        Object object2 = super.createFromConfigSource(object, aVList);
        if (object2 == null) {
            String string = Logging.getMessage("generic.UnrecognizedDocument", object);
            throw new WWUnrecognizedException(string);
        }
        return object2;
    }

    @Override
    protected Layer doCreateFromCapabilities(OGCCapabilities oGCCapabilities, AVList aVList) {
        String string = oGCCapabilities.getServiceInformation().getServiceName();
        if (string == null || !string.equalsIgnoreCase("OGC:WMS") && !string.contains("WMS")) {
            String string2 = Logging.getMessage("WMS.NotWMSService", string != null ? string : "null");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames") == null) {
            List<WMSLayerCapabilities> list = ((WMSCapabilities)oGCCapabilities).getNamedLayers();
            if (list == null || list.size() == 0 || list.get(0) == null) {
                String string3 = Logging.getMessage("WMS.NoLayersFound");
                Logging.logger().severe(string3);
                throw new IllegalStateException(string3);
            }
            aVList.setValue("gov.nasa.worldwind.avkey.LayerNames", list.get(0).getName());
        }
        return new WMSTiledImageLayer((WMSCapabilities)oGCCapabilities, aVList);
    }

    @Override
    protected Object doCreateFromElement(Element element, AVList aVList) throws Exception {
        Element[] elementArray = WWXML.getElements(element, "//LayerList", null);
        if (elementArray != null && elementArray.length > 0) {
            return this.createLayerLists(elementArray, aVList);
        }
        elementArray = WWXML.getElements(element, "./Layer", null);
        if (elementArray != null && elementArray.length > 1) {
            return this.createLayerList(elementArray, aVList);
        }
        if (elementArray != null && elementArray.length == 1) {
            return this.createFromLayerDocument(elementArray[0], aVList);
        }
        String string = WWXML.getUnqualifiedName(element);
        if (string != null && string.equals("Layer")) {
            return this.createFromLayerDocument(element, aVList);
        }
        return null;
    }

    protected LayerList[] createLayerLists(Element[] elementArray, AVList aVList) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Element element : elementArray) {
            try {
                LayerList layerList;
                Object object;
                Object object2;
                String string = WWXML.getText(element, "@href");
                if (string != null && string.length() > 0) {
                    object2 = this.createFromConfigSource(string, aVList);
                    if (object2 == null) continue;
                    if (object2 instanceof Layer) {
                        object = new LayerList();
                        object.add((Layer)object2);
                        object2 = object;
                    }
                    if (object2 instanceof LayerList) {
                        object = (LayerList)object2;
                        if (object == null || object.size() <= 0) continue;
                        arrayList.add(object);
                        continue;
                    }
                    if (object2 instanceof LayerList[]) {
                        object = (LayerList[])object2;
                        if (object == null || ((Element[])object).length <= 0) continue;
                        arrayList.addAll(Arrays.asList(object));
                        continue;
                    }
                    object = Logging.getMessage("LayerFactory.UnexpectedTypeForLayer", object2.getClass().getName());
                    Logging.logger().log(Level.WARNING, (String)object);
                    continue;
                }
                object2 = WWXML.getText(element, "@title");
                object = WWXML.getElements(element, "./Layer", null);
                if (object == null || ((Element[])object).length <= 0 || (layerList = this.createLayerList((Element[])object, aVList)) == null || layerList.size() <= 0) continue;
                arrayList.add(layerList);
                if (object2 == null || ((String)object2).length() <= 0) continue;
                layerList.setValue("gov.nasa.worldwind.avkey.DisplayName", object2);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return arrayList.toArray(new LayerList[arrayList.size()]);
    }

    protected LayerList createLayerList(Element[] elementArray, AVList aVList) {
        LayerList layerList = new LayerList();
        for (Element element : elementArray) {
            try {
                layerList.add(this.createFromLayerDocument(element, aVList));
            }
            catch (Exception exception) {
                Logging.logger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return layerList;
    }

    protected Layer createFromLayerDocument(Element element, AVList aVList) {
        Layer layer;
        Object object;
        String string;
        String string2 = WWXML.getText(element, "@className");
        if (string2 != null && string2.length() > 0) {
            Layer layer2 = (Layer)WorldWind.createComponent(string2);
            String string3 = WWXML.getText(element, "@actuate");
            layer2.setEnabled(WWUtil.isEmpty(string3) || string3.equals("onLoad"));
            WWXML.invokePropertySetters(layer2, element);
            return layer2;
        }
        AVList aVList2 = WWXML.copyProperties(element, null);
        if (aVList2 != null) {
            if (aVList != null) {
                aVList2.setValues(aVList);
            }
            aVList = aVList2;
        }
        if ((string = WWXML.getText(element, "@href")) != null && string.length() > 0) {
            object = this.createFromConfigSource(string, aVList);
            if (object == null) {
                return null;
            }
            if (!(object instanceof Layer)) {
                String string4 = Logging.getMessage("LayerFactory.UnexpectedTypeForLayer", object.getClass().getName());
                throw new WWRuntimeException(string4);
            }
            layer = (Layer)object;
        } else {
            object = WWXML.getText(element, "@layerType");
            if (object != null && ((String)object).equals("TiledImageLayer")) {
                layer = this.createTiledImageLayer(element, aVList);
            } else if (object != null && ((String)object).equals("ShapefileLayer")) {
                layer = this.createShapefileLayer(element, aVList);
            } else {
                String string5 = Logging.getMessage("generic.UnrecognizedLayerType", (String)object);
                throw new WWUnrecognizedException(string5);
            }
        }
        if (layer != null) {
            object = WWXML.getText(element, "@actuate");
            layer.setEnabled(object != null && ((String)object).equals("onLoad"));
            WWXML.invokePropertySetters(layer, element);
        }
        return layer;
    }

    protected Layer createTiledImageLayer(Element element, AVList aVList) {
        BasicTiledImageLayer basicTiledImageLayer;
        String string = WWXML.getText(element, "Service/@serviceName");
        if ("Offline".equals(string)) {
            basicTiledImageLayer = new BasicTiledImageLayer(element, aVList);
        } else if ("WWTileService".equals(string)) {
            basicTiledImageLayer = new BasicTiledImageLayer(element, aVList);
        } else if ("OGC:WMS".equals(string)) {
            basicTiledImageLayer = new WMSTiledImageLayer(element, aVList);
        } else if ("LocalRasterServer".equals(string)) {
            basicTiledImageLayer = new LocalRasterServerLayer(element, aVList);
        } else {
            String string2 = Logging.getMessage("generic.UnrecognizedServiceName", string);
            throw new WWUnrecognizedException(string2);
        }
        String string3 = WWXML.getText(element, "@actuate");
        basicTiledImageLayer.setEnabled(string3 != null && string3.equals("onLoad"));
        return basicTiledImageLayer;
    }

    protected Layer createShapefileLayer(Element element, AVList aVList) {
        return (Layer)BasicFactory.create("gov.nasa.worldwind.avkey.ShapefileLayerFactory", element, aVList);
    }
}

