/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameService;
import gov.nasa.worldwind.layers.placename.PlaceNameServiceSet;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;

public class NASAWFSPlaceNameLayer
extends PlaceNameLayer {
    public static final String OCEANS = "topp:wpl_oceans";
    public static final String CONTINENTS = "topp:wpl_continents";
    public static final String WATERBODIES = "topp:wpl_waterbodies";
    public static final String TRENCHESRIDGES = "topp:wpl_trenchesridges";
    public static final String DESERTSPLAINS = "topp:wpl_desertsplains";
    public static final String LAKESRIVERS = "topp:wpl_lakesrivers";
    public static final String MOUNTAINSVALLEYS = "topp:wpl_mountainsvalleys";
    public static final String COUNTRIES = "topp:wpl_countries";
    public static final String GEONET_P_PPC = "topp:wpl_geonet_p_pplc";
    public static final String CITIESOVER500K = "topp:citiesover500k";
    public static final String CITIESOVER100K = "topp:citiesover100k";
    public static final String CITIESOVER50K = "topp:citiesover50k";
    public static final String CITIESOVER10K = "topp:citiesover10k";
    public static final String CITIESOVER1K = "topp:citiesover1k";
    public static final String USCITIESOVER0 = "topp:wpl_uscitiesover0";
    public static final String USCITIES0 = "topp:wpl_uscities0";
    public static final String US_ANTHROPOGENIC = "topp:wpl_us_anthropogenic";
    public static final String US_WATER = "topp:wpl_us_water";
    public static final String US_TERRAIN = "topp:wpl_us_terrain";
    public static final String GEONET_A_ADM1 = "topp:wpl_geonet_a_adm1";
    public static final String GEONET_A_ADM2 = "topp:wpl_geonet_a_adm2";
    public static final String GEONET_P_PPLA = "topp:wpl_geonet_p_ppla";
    public static final String GEONET_P_PPL = "topp:wpl_geonet_p_ppl";
    public static final String GEONET_P_PPLC = "topp:wpl_geonet_p_pplC";
    private static final String[] allNameSets = new String[]{"topp:wpl_oceans", "topp:wpl_continents", "topp:wpl_waterbodies", "topp:wpl_trenchesridges", "topp:wpl_desertsplains", "topp:wpl_lakesrivers", "topp:wpl_mountainsvalleys", "topp:wpl_countries", "topp:wpl_geonet_p_pplc", "topp:citiesover500k", "topp:citiesover100k", "topp:citiesover50k", "topp:citiesover10k", "topp:citiesover1k", "topp:wpl_uscitiesover0", "topp:wpl_uscities0", "topp:wpl_us_anthropogenic", "topp:wpl_us_water", "topp:wpl_us_terrain", "topp:wpl_geonet_a_adm1", "topp:wpl_geonet_a_adm2", "topp:wpl_geonet_p_ppla", "topp:wpl_geonet_p_ppl"};
    private static List activeNamesList = Arrays.asList(allNameSets);

    public NASAWFSPlaceNameLayer() {
        super(NASAWFSPlaceNameLayer.makePlaceNameServiceSet());
    }

    public void setPlaceNameSetsVisible(List list) {
        activeNamesList = list;
        NASAWFSPlaceNameLayer.makePlaceNameServiceSet();
    }

    private static PlaceNameServiceSet makePlaceNameServiceSet() {
        Sector sector;
        PlaceNameService placeNameService;
        PlaceNameServiceSet placeNameServiceSet = new PlaceNameServiceSet();
        placeNameServiceSet.setExpiryTime(new GregorianCalendar(2008, 1, 11).getTimeInMillis());
        if (activeNamesList.contains(OCEANS)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", OCEANS, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_1x1, Font.decode("Arial-BOLDITALIC-12"), true);
            placeNameService.setColor(new Color(200, 200, 200));
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(6.7108864E7);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(CONTINENTS)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", CONTINENTS, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_1x1, Font.decode("Arial-BOLD-12"), true);
            placeNameService.setColor(new Color(255, 255, 240));
            placeNameService.setMinDisplayDistance(524288.0);
            placeNameService.setMaxDisplayDistance(6.7108864E7);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(WATERBODIES)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", WATERBODIES, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_4x8, Font.decode("Arial-ITALIC-10"), true);
            placeNameService.setColor(Color.cyan);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(1.6777216E7);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(TRENCHESRIDGES)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", TRENCHESRIDGES, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_4x8, Font.decode("Arial-BOLDITALIC-10"), true);
            placeNameService.setColor(Color.cyan);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(1.6777216E7);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(DESERTSPLAINS)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", DESERTSPLAINS, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_4x8, Font.decode("Arial-BOLDITALIC-10"), true);
            placeNameService.setColor(Color.orange);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(1.6777216E7);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(LAKESRIVERS)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", LAKESRIVERS, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_8x16, Font.decode("Arial-ITALIC-10"), true);
            placeNameService.setColor(Color.cyan);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(8388608.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(MOUNTAINSVALLEYS)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", MOUNTAINSVALLEYS, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_8x16, Font.decode("Arial-BOLDITALIC-10"), true);
            placeNameService.setColor(Color.orange);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(8388608.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(COUNTRIES)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", "topp:countries", "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_4x8, Font.decode("Arial-BOLD-10"), true);
            placeNameService.setColor(Color.white);
            placeNameService.setMinDisplayDistance(524288.0);
            placeNameService.setMaxDisplayDistance(4194304.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(GEONET_P_PPLC)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", GEONET_P_PPC, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_16x32, Font.decode("Arial-BOLD-10"), true);
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(4194304.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(CITIESOVER500K)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", CITIESOVER500K, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_8x16, Font.decode("Arial-BOLD-10"), true);
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(4194304.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(CITIESOVER100K)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", CITIESOVER100K, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_16x32, Font.decode("Arial-PLAIN-10"), true);
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(4096.0);
            placeNameService.setMaxDisplayDistance(1048576.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(CITIESOVER50K)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", CITIESOVER50K, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_16x32, Font.decode("Arial-PLAIN-10"), true);
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(4096.0);
            placeNameService.setMaxDisplayDistance(262144.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(CITIESOVER10K)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", CITIESOVER10K, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_36x72, Font.decode("Arial-PLAIN-10"), true);
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(131072.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(CITIESOVER1K)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", CITIESOVER1K, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_36x72, Font.decode("Arial-PLAIN-10"), true);
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(32768.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(USCITIESOVER0)) {
            sector = new Sector(Angle.fromDegrees(18.0), Angle.fromDegrees(70.7), Angle.fromDegrees(-176.66), Angle.fromDegrees(-66.0));
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", USCITIESOVER0, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", sector, GRID_36x72, Font.decode("Arial-PLAIN-10"), true);
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(4096.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(USCITIES0)) {
            sector = new Sector(Angle.fromDegrees(-14.4), Angle.fromDegrees(71.3), Angle.fromDegrees(-176.66), Angle.fromDegrees(178.88));
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", USCITIES0, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", sector, GRID_288x576, Font.decode("Arial-PLAIN-10"), true);
            placeNameService.setColor(Color.orange);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(4096.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(US_ANTHROPOGENIC)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", US_ANTHROPOGENIC, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_288x576, Font.decode("Arial-PLAIN-10"), true);
            placeNameService.setColor(Color.orange);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(1024.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(US_WATER)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", US_WATER, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_144x288, Font.decode("Arial-PLAIN-10"), true);
            placeNameService.setColor(Color.cyan);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(8192.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(US_TERRAIN)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", US_TERRAIN, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_72x144, Font.decode("Arial-PLAIN-10"), true);
            placeNameService.setColor(Color.orange);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(2048.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(GEONET_A_ADM1)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", GEONET_A_ADM1, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_36x72, Font.decode("Arial-BOLD-10"), true);
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(4096.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(GEONET_A_ADM2)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", GEONET_A_ADM2, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_36x72, Font.decode("Arial-BOLD-10"), true);
            placeNameService.setColor(Color.yellow);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(4096.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(GEONET_P_PPLA)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", GEONET_P_PPLA, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_36x72, Font.decode("Arial-BOLD-10"), true);
            placeNameService.setColor(Color.pink);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(4096.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        if (activeNamesList.contains(GEONET_P_PPL)) {
            placeNameService = new PlaceNameService("https://worldwind22.arc.nasa.gov/geoserver/wfs", GEONET_P_PPL, "Earth/PlaceNames/WFSPlaceNamesVersion1.0", Sector.FULL_SPHERE, GRID_36x72, Font.decode("Arial-PLAIN-10"), true);
            placeNameService.setColor(Color.pink);
            placeNameService.setMinDisplayDistance(0.0);
            placeNameService.setMaxDisplayDistance(2048.0);
            placeNameServiceSet.addService(placeNameService, false);
        }
        return placeNameServiceSet;
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.Earth.PlaceName.Name");
    }
}

