/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.layers.GraticuleRenderingParams;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.render.GeographicTextRenderer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class GraticuleSupport {
    private Collection<Pair> renderables = new HashSet<Pair>();
    private Map<String, GraticuleRenderingParams> namedParams = new HashMap<String, GraticuleRenderingParams>();
    private Map<String, ShapeAttributes> namedShapeAttributes = new HashMap<String, ShapeAttributes>();
    private AVList defaultParams;
    private GeographicTextRenderer textRenderer = new GeographicTextRenderer();

    public GraticuleSupport() {
        this.textRenderer.setEffect("gov.nasa.worldwind.avkey.TextEffectShadow");
        this.textRenderer.setCullTextEnabled(true);
        this.textRenderer.setCullTextMargin(1);
        this.textRenderer.setDistanceMinScale(0.5);
        this.textRenderer.setDistanceMinOpacity(0.5);
    }

    public void addRenderable(Object object, String string) {
        if (object == null) {
            String string2 = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.renderables.add(new Pair(object, string));
    }

    public void removeAllRenderables() {
        this.renderables.clear();
    }

    public void render(DrawContext drawContext) {
        this.render(drawContext, 1.0);
    }

    public void render(DrawContext drawContext, double d) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.namedShapeAttributes.clear();
        ArrayList<GeographicText> arrayList = new ArrayList<GeographicText>();
        for (Pair pair : this.renderables) {
            GraticuleRenderingParams graticuleRenderingParams;
            Object object = pair.a;
            String string = pair.b != null && pair.b instanceof String ? (String)pair.b : null;
            GraticuleRenderingParams graticuleRenderingParams2 = graticuleRenderingParams = string != null ? this.namedParams.get(string) : null;
            if (object != null && object instanceof Path) {
                if (graticuleRenderingParams != null && !graticuleRenderingParams.isDrawLines()) continue;
                this.applyRenderingParams(string, graticuleRenderingParams, (Path)object, d);
                ((Path)object).render(drawContext);
                continue;
            }
            if (object == null || !(object instanceof GeographicText) || graticuleRenderingParams != null && !graticuleRenderingParams.isDrawLabels()) continue;
            this.applyRenderingParams(graticuleRenderingParams, (GeographicText)object, d);
            arrayList.add((GeographicText)object);
        }
        this.textRenderer.render(drawContext, arrayList);
    }

    public GraticuleRenderingParams getRenderingParams(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        GraticuleRenderingParams graticuleRenderingParams = this.namedParams.get(string);
        if (graticuleRenderingParams == null) {
            graticuleRenderingParams = new GraticuleRenderingParams();
            this.initRenderingParams(graticuleRenderingParams);
            if (this.defaultParams != null) {
                graticuleRenderingParams.setValues(this.defaultParams);
            }
            this.namedParams.put(string, graticuleRenderingParams);
        }
        return graticuleRenderingParams;
    }

    public Collection<Map.Entry<String, GraticuleRenderingParams>> getAllRenderingParams() {
        return this.namedParams.entrySet();
    }

    public void setRenderingParams(String string, GraticuleRenderingParams graticuleRenderingParams) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.initRenderingParams(graticuleRenderingParams);
        this.namedParams.put(string, graticuleRenderingParams);
    }

    public AVList getDefaultParams() {
        return this.defaultParams;
    }

    public void setDefaultParams(AVList aVList) {
        this.defaultParams = aVList;
    }

    private AVList initRenderingParams(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.AVListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList.getValue("DrawGraticule") == null) {
            aVList.setValue("DrawGraticule", Boolean.TRUE);
        }
        if (aVList.getValue("GraticuleLineColor") == null) {
            aVList.setValue("GraticuleLineColor", Color.WHITE);
        }
        if (aVList.getValue("GraticuleLineWidth") == null) {
            aVList.setValue("GraticuleLineWidth", new Double(1.0));
        }
        if (aVList.getValue("GraticuleLineStyle") == null) {
            aVList.setValue("GraticuleLineStyle", "LineStyleSolid");
        }
        if (aVList.getValue("DrawLabels") == null) {
            aVList.setValue("DrawLabels", Boolean.TRUE);
        }
        if (aVList.getValue("LabelColor") == null) {
            aVList.setValue("LabelColor", Color.WHITE);
        }
        if (aVList.getValue("LabelFont") == null) {
            aVList.setValue("LabelFont", Font.decode("Arial-Bold-12"));
        }
        return aVList;
    }

    private void applyRenderingParams(AVList aVList, GeographicText geographicText, double d) {
        if (aVList != null && geographicText != null) {
            Object object = aVList.getValue("LabelColor");
            if (object != null && object instanceof Color) {
                Color color = this.applyOpacity((Color)object, d);
                float[] fArray = new float[4];
                Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
                int n = fArray[2] < 0.5f ? 255 : 0;
                geographicText.setColor(color);
                geographicText.setBackgroundColor(new Color(n, n, n, color.getAlpha()));
            }
            if ((object = aVList.getValue("LabelFont")) != null && object instanceof Font) {
                geographicText.setFont((Font)object);
            }
        }
    }

    private void applyRenderingParams(String string, AVList aVList, Path path, double d) {
        if (string != null && aVList != null && path != null) {
            path.setAttributes(this.getLineShapeAttributes(string, aVList, d));
        }
    }

    private ShapeAttributes getLineShapeAttributes(String string, AVList aVList, double d) {
        ShapeAttributes shapeAttributes = this.namedShapeAttributes.get(string);
        if (shapeAttributes == null) {
            shapeAttributes = this.createLineShapeAttributes(aVList, d);
            this.namedShapeAttributes.put(string, shapeAttributes);
        }
        return shapeAttributes;
    }

    private ShapeAttributes createLineShapeAttributes(AVList aVList, double d) {
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setDrawInterior(false);
        basicShapeAttributes.setDrawOutline(true);
        if (aVList != null) {
            String string;
            Double d2;
            Object object = aVList.getValue("GraticuleLineColor");
            if (object != null && object instanceof Color) {
                basicShapeAttributes.setOutlineMaterial(new Material(this.applyOpacity((Color)object, d)));
                basicShapeAttributes.setOutlineOpacity(d);
            }
            if ((d2 = AVListImpl.getDoubleValue(aVList, "GraticuleLineWidth")) != null) {
                basicShapeAttributes.setOutlineWidth(d2);
            }
            if ("LineStyleSolid".equalsIgnoreCase(string = aVList.getStringValue("GraticuleLineStyle"))) {
                basicShapeAttributes.setOutlineStipplePattern((short)-21846);
                basicShapeAttributes.setOutlineStippleFactor(0);
            } else if ("LineStyleDashed".equalsIgnoreCase(string)) {
                int n = (int)(d2 != null ? (double)Math.round(d2) : 1.0);
                basicShapeAttributes.setOutlineStipplePattern((short)-21846);
                basicShapeAttributes.setOutlineStippleFactor(3 * n);
            } else if ("LineStyleDotted".equalsIgnoreCase(string)) {
                int n = (int)(d2 != null ? (double)Math.round(d2) : 1.0);
                basicShapeAttributes.setOutlineStipplePattern((short)-21846);
                basicShapeAttributes.setOutlineStippleFactor(n);
            }
        }
        return basicShapeAttributes;
    }

    private Color applyOpacity(Color color, double d) {
        if (d >= 1.0) {
            return color;
        }
        float[] fArray = color.getRGBComponents(null);
        return new Color(fArray[0], fArray[1], fArray[2], fArray[3] * (float)d);
    }

    private static class Pair {
        final Object a;
        final Object b;

        Pair(Object object, Object object2) {
            this.a = object;
            this.b = object2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Pair pair = (Pair)object;
            if (this.a != null ? !this.a.equals(pair.a) : pair.a != null) {
                return false;
            }
            return !(this.b != null ? !this.b.equals(pair.b) : pair.b != null);
        }

        public int hashCode() {
            int n = this.a != null ? this.a.hashCode() : 0;
            n = 31 * n + (this.b != null ? this.b.hashCode() : 0);
            return n;
        }
    }
}

