/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.TextureTile;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.TextRenderer;
import gov.nasa.worldwind.retrieve.AbstractRetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.RetrieverFactory;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileKey;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWXML;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.xml.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class TiledImageLayer
extends AbstractLayer {
    protected static final LevelComparer levelComparer = new LevelComparer();
    protected final LevelSet levels;
    protected ArrayList<TextureTile> topLevels;
    protected boolean forceLevelZeroLoads = false;
    protected boolean levelZeroLoaded = false;
    protected boolean retainLevelZeroTiles = false;
    protected String tileCountName;
    protected double detailHintOrigin = 2.8;
    protected double detailHint = 0.0;
    protected boolean useMipMaps = true;
    protected boolean useTransparentTextures = false;
    protected ArrayList<String> supportedImageFormats = new ArrayList();
    protected String textureFormat;
    protected boolean drawTileBoundaries = false;
    private boolean drawTileIDs = false;
    protected boolean drawBoundingVolumes = false;
    protected ArrayList<TextureTile> currentTiles = new ArrayList();
    protected TextureTile currentResourceTile;
    protected boolean atMaxResolution = false;
    protected PriorityBlockingQueue<Runnable> requestQ = new PriorityBlockingQueue(200);

    protected abstract void requestTexture(DrawContext var1, TextureTile var2);

    protected abstract void forceTextureLoad(TextureTile var1);

    public TiledImageLayer(LevelSet levelSet) {
        if (levelSet == null) {
            String string = Logging.getMessage("nullValue.LevelSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.levels = new LevelSet(levelSet);
        this.setValue("gov.nasa.worldwind.avKey.Sector", this.levels.getSector());
        this.setPickEnabled(false);
        this.tileCountName = this.getName() + " Tiles";
    }

    @Override
    public Object setValue(String string, Object object) {
        if (this.getLevels() != null) {
            this.getLevels().setValue(string, object);
        }
        return super.setValue(string, object);
    }

    @Override
    public Object getValue(String string) {
        Object object = super.getValue(string);
        return object != null ? object : this.getLevels().getValue(string);
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.tileCountName = this.getName() + " Tiles";
    }

    public boolean isForceLevelZeroLoads() {
        return this.forceLevelZeroLoads;
    }

    public void setForceLevelZeroLoads(boolean bl) {
        this.forceLevelZeroLoads = bl;
    }

    public boolean isRetainLevelZeroTiles() {
        return this.retainLevelZeroTiles;
    }

    public void setRetainLevelZeroTiles(boolean bl) {
        this.retainLevelZeroTiles = bl;
    }

    public boolean isDrawTileIDs() {
        return this.drawTileIDs;
    }

    public void setDrawTileIDs(boolean bl) {
        this.drawTileIDs = bl;
    }

    public boolean isDrawTileBoundaries() {
        return this.drawTileBoundaries;
    }

    public void setDrawTileBoundaries(boolean bl) {
        this.drawTileBoundaries = bl;
    }

    public boolean isDrawBoundingVolumes() {
        return this.drawBoundingVolumes;
    }

    public void setDrawBoundingVolumes(boolean bl) {
        this.drawBoundingVolumes = bl;
    }

    public double getDetailHint() {
        return this.detailHint;
    }

    public void setDetailHint(double d) {
        this.detailHint = d;
    }

    public LevelSet getLevels() {
        return this.levels;
    }

    protected PriorityBlockingQueue<Runnable> getRequestQ() {
        return this.requestQ;
    }

    @Override
    public boolean isMultiResolution() {
        return this.getLevels() != null && this.getLevels().getNumLevels() > 1;
    }

    @Override
    public boolean isAtMaxResolution() {
        return this.atMaxResolution;
    }

    public String getTextureFormat() {
        return this.textureFormat;
    }

    public void setTextureFormat(String string) {
        this.textureFormat = string;
    }

    public boolean isUseMipMaps() {
        return this.useMipMaps;
    }

    public void setUseMipMaps(boolean bl) {
        this.useMipMaps = bl;
    }

    public boolean isUseTransparentTextures() {
        return this.useTransparentTextures;
    }

    public void setUseTransparentTextures(boolean bl) {
        this.useTransparentTextures = bl;
    }

    @Override
    public void setExpiryTime(long l) {
        super.setExpiryTime(l);
        if (l > 0L) {
            this.levels.setExpiryTime(l);
        }
    }

    public List<TextureTile> getTopLevels() {
        if (this.topLevels == null) {
            this.createTopLevelTiles();
        }
        return this.topLevels;
    }

    protected void createTopLevelTiles() {
        Sector sector = this.levels.getSector();
        gov.nasa.worldwind.util.Level level = this.levels.getFirstLevel();
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = this.levels.getTileOrigin().getLatitude();
        Angle angle4 = this.levels.getTileOrigin().getLongitude();
        int n = Tile.computeRow(angle, sector.getMinLatitude(), angle3);
        int n2 = Tile.computeColumn(angle2, sector.getMinLongitude(), angle4);
        int n3 = Tile.computeRow(angle, sector.getMaxLatitude(), angle3);
        int n4 = Tile.computeColumn(angle2, sector.getMaxLongitude(), angle4);
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        this.topLevels = new ArrayList(n5 * n6);
        Angle angle5 = Tile.computeRowLatitude(n, angle, angle3);
        for (int i = n; i <= n3; ++i) {
            Angle angle6 = angle5.add(angle);
            Angle angle7 = Tile.computeColumnLongitude(n2, angle2, angle4);
            for (int j = n2; j <= n4; ++j) {
                Angle angle8 = angle7.add(angle2);
                this.topLevels.add(new TextureTile(new Sector(angle5, angle6, angle7, angle8), level, i, j));
                angle7 = angle8;
            }
            angle5 = angle6;
        }
    }

    protected void loadAllTopLevelTextures(DrawContext drawContext) {
        for (TextureTile textureTile : this.getTopLevels()) {
            if (textureTile.isTextureInMemory(drawContext.getTextureCache())) continue;
            this.forceTextureLoad(textureTile);
        }
        this.levelZeroLoaded = true;
    }

    protected void assembleTiles(DrawContext drawContext) {
        this.currentTiles.clear();
        for (TextureTile textureTile : this.getTopLevels()) {
            if (!this.isTileVisible(drawContext, textureTile)) continue;
            this.currentResourceTile = null;
            this.addTileOrDescendants(drawContext, textureTile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTileOrDescendants(DrawContext drawContext, TextureTile textureTile) {
        if (this.meetsRenderCriteria(drawContext, textureTile)) {
            this.addTile(drawContext, textureTile);
            return;
        }
        TextureTile textureTile2 = null;
        try {
            TextureTile[] textureTileArray;
            if (textureTile.isTextureInMemory(drawContext.getTextureCache()) || textureTile.getLevelNumber() == 0) {
                textureTile2 = this.currentResourceTile;
                this.currentResourceTile = textureTile;
            } else if (!textureTile.getLevel().isEmpty()) {
                // empty if block
            }
            for (TextureTile textureTile3 : textureTileArray = textureTile.createSubTiles(this.levels.getLevel(textureTile.getLevelNumber() + 1))) {
                if (!this.getLevels().getSector().intersects(textureTile3.getSector()) || !this.isTileVisible(drawContext, textureTile3)) continue;
                this.addTileOrDescendants(drawContext, textureTile3);
            }
        }
        finally {
            if (textureTile2 != null) {
                this.currentResourceTile = textureTile2;
            }
        }
    }

    protected void addTile(DrawContext drawContext, TextureTile textureTile) {
        textureTile.setFallbackTile(null);
        if (textureTile.isTextureInMemory(drawContext.getTextureCache())) {
            this.addTileToCurrent(textureTile);
            return;
        }
        if (textureTile.getLevelNumber() == 0 && this.forceLevelZeroLoads && !textureTile.isTextureInMemory(drawContext.getTextureCache())) {
            this.forceTextureLoad(textureTile);
            if (textureTile.isTextureInMemory(drawContext.getTextureCache())) {
                this.addTileToCurrent(textureTile);
                return;
            }
        }
        if (textureTile.getLevelNumber() < this.levels.getNumLevels() && !this.levels.isResourceAbsent(textureTile)) {
            this.requestTexture(drawContext, textureTile);
        }
        if (this.currentResourceTile != null) {
            if (this.currentResourceTile.getLevelNumber() == 0 && this.forceLevelZeroLoads && !this.currentResourceTile.isTextureInMemory(drawContext.getTextureCache()) && !this.currentResourceTile.isTextureInMemory(drawContext.getTextureCache())) {
                this.forceTextureLoad(this.currentResourceTile);
            }
            if (this.currentResourceTile.isTextureInMemory(drawContext.getTextureCache())) {
                textureTile.setFallbackTile(this.currentResourceTile);
                this.addTileToCurrent(textureTile);
            }
        }
    }

    protected void addTileToCurrent(TextureTile textureTile) {
        this.currentTiles.add(textureTile);
    }

    protected boolean isTileVisible(DrawContext drawContext, TextureTile textureTile) {
        return textureTile.getExtent(drawContext).intersects(drawContext.getView().getFrustumInModelCoordinates()) && (drawContext.getVisibleSector() == null || drawContext.getVisibleSector().intersects(textureTile.getSector()));
    }

    protected boolean meetsRenderCriteria(DrawContext drawContext, TextureTile textureTile) {
        return this.levels.isFinalLevel(textureTile.getLevelNumber()) || !this.needToSplit(drawContext, textureTile.getSector(), textureTile.getLevel());
    }

    protected double getDetailFactor() {
        return this.detailHintOrigin + this.getDetailHint();
    }

    protected boolean needToSplit(DrawContext drawContext, Sector sector, gov.nasa.worldwind.util.Level level) {
        double d = level.getTexelSize();
        double d2 = drawContext.getGlobe().getRadius() * d;
        double d3 = this.getDetailFactor();
        if (sector.getMinLatitude().degrees >= 75.0 || sector.getMaxLatitude().degrees <= -75.0) {
            d3 *= 0.9;
        }
        double d4 = Math.pow(10.0, -d3);
        double d5 = drawContext.getView().getFieldOfView().tanHalfAngle() / Angle.fromDegrees(45.0).tanHalfAngle();
        d5 = WWMath.clamp(d5, 0.0, 1.0);
        double d6 = sector.distanceTo(drawContext, drawContext.getView().getEyePoint());
        double d7 = d6 * d4 * d5;
        return d2 > d7;
    }

    @Override
    public Double getMinEffectiveAltitude(Double d) {
        if (d == null) {
            d = 6378137.0;
        }
        double d2 = this.getLevels().getLastLevel().getTexelSize();
        double d3 = d * d2;
        return d3 * Math.pow(10.0, this.getDetailFactor());
    }

    @Override
    public Double getMaxEffectiveAltitude(Double d) {
        if (d == null) {
            d = 6378137.0;
        }
        for (int i = 0; i < this.getLevels().getLastLevel().getLevelNumber(); ++i) {
            if (this.levels.isLevelEmpty(i)) continue;
            double d2 = this.levels.getLevel(i).getTexelSize();
            double d3 = 2.0 * d * d2;
            return d3 * Math.pow(10.0, this.getDetailFactor());
        }
        return null;
    }

    protected boolean atMaxLevel(DrawContext drawContext) {
        Position position = drawContext.getViewportCenterPosition();
        if (drawContext.getView() == null || this.getLevels() == null || position == null) {
            return false;
        }
        if (!this.getLevels().getSector().contains(position.getLatitude(), position.getLongitude())) {
            return true;
        }
        gov.nasa.worldwind.util.Level level = this.getLevels().getNextToLastLevel();
        if (level == null) {
            return true;
        }
        Sector sector = level.computeSectorForPosition(position.getLatitude(), position.getLongitude(), this.levels.getTileOrigin());
        return this.needToSplit(drawContext, sector, level);
    }

    @Override
    public void render(DrawContext drawContext) {
        this.atMaxResolution = this.atMaxLevel(drawContext);
        super.render(drawContext);
    }

    @Override
    protected final void doRender(DrawContext drawContext) {
        if (this.forceLevelZeroLoads && !this.levelZeroLoaded) {
            this.loadAllTopLevelTextures(drawContext);
        }
        if (drawContext.getSurfaceGeometry() == null || drawContext.getSurfaceGeometry().size() < 1) {
            return;
        }
        drawContext.getGeographicSurfaceTileRenderer().setShowImageTileOutlines(this.isDrawTileBoundaries());
        this.draw(drawContext);
    }

    protected void draw(DrawContext drawContext) {
        this.assembleTiles(drawContext);
        if (this.currentTiles.size() >= 1) {
            this.setValue("gov.nasa.worldwind.avkey.FrameTimestamp", drawContext.getFrameTimeStamp());
            if (this.getScreenCredit() != null) {
                drawContext.addScreenCredit(this.getScreenCredit());
            }
            TextureTile[] textureTileArray = new TextureTile[this.currentTiles.size()];
            textureTileArray = this.currentTiles.toArray(textureTileArray);
            Arrays.sort(textureTileArray, levelComparer);
            GL2 gL2 = drawContext.getGL().getGL2();
            if (this.isUseTransparentTextures() || this.getOpacity() < 1.0) {
                gL2.glPushAttrib(16393);
                this.setBlendingFunction(drawContext);
            } else {
                gL2.glPushAttrib(16392);
            }
            gL2.glPolygonMode(1028, 6914);
            gL2.glEnable(2884);
            gL2.glCullFace(1029);
            drawContext.setPerFrameStatistic("gov.nasa.worldwind.perfstat.ImageTileCount", this.tileCountName, this.currentTiles.size());
            drawContext.getGeographicSurfaceTileRenderer().renderTiles(drawContext, this.currentTiles);
            gL2.glPopAttrib();
            if (this.drawTileIDs) {
                this.drawTileIDs(drawContext, this.currentTiles);
            }
            if (this.drawBoundingVolumes) {
                this.drawBoundingVolumes(drawContext, this.currentTiles);
            }
            if (this.getExpiryTime() > 0L && this.getExpiryTime() <= System.currentTimeMillis()) {
                this.checkTextureExpiration(drawContext, this.currentTiles);
            }
            this.currentTiles.clear();
        }
        this.sendRequests();
        this.requestQ.clear();
    }

    protected void checkTextureExpiration(DrawContext drawContext, List<TextureTile> list) {
        for (TextureTile textureTile : list) {
            if (!textureTile.isTextureExpired()) continue;
            this.requestTexture(drawContext, textureTile);
        }
    }

    protected void setBlendingFunction(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        double d = this.getOpacity();
        gL2.glColor4d(d, d, d, d);
        gL2.glEnable(3042);
        gL2.glBlendFunc(1, 771);
    }

    protected void sendRequests() {
        Runnable runnable = this.requestQ.poll();
        while (runnable != null) {
            if (!WorldWind.getTaskService().isFull()) {
                WorldWind.getTaskService().addTask(runnable);
            }
            runnable = this.requestQ.poll();
        }
    }

    @Override
    public boolean isLayerInView(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext.getView() == null) {
            String string = Logging.getMessage("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        return drawContext.getVisibleSector() == null || this.levels.getSector().intersects(drawContext.getVisibleSector());
    }

    protected Vec4 computeReferencePoint(DrawContext drawContext) {
        if (drawContext.getViewportCenterPosition() != null) {
            return drawContext.getGlobe().computePointFromPosition(drawContext.getViewportCenterPosition());
        }
        Rectangle rectangle = drawContext.getView().getViewport();
        int n = (int)((RectangularShape)rectangle).getWidth() / 2;
        for (int i = (int)(0.5 * ((RectangularShape)rectangle).getHeight()); i >= 0; --i) {
            Position position = drawContext.getView().computePositionFromScreenPoint(n, i);
            if (position == null) continue;
            return drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), 0.0);
        }
        return null;
    }

    protected Vec4 getReferencePoint(DrawContext drawContext) {
        return this.computeReferencePoint(drawContext);
    }

    protected void drawTileIDs(DrawContext drawContext, ArrayList<TextureTile> arrayList) {
        Rectangle rectangle = drawContext.getView().getViewport();
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), Font.decode("Arial-Plain-13"));
        GL gL = drawContext.getGL();
        gL.glDisable(2929);
        gL.glDisable(3042);
        gL.glDisable(3553);
        textRenderer.beginRendering(rectangle.width, rectangle.height);
        textRenderer.setColor(Color.YELLOW);
        for (TextureTile textureTile : arrayList) {
            Object object = textureTile.getLabel();
            if (textureTile.getFallbackTile() != null) {
                object = (String)object + "/" + textureTile.getFallbackTile().getLabel();
            }
            LatLon latLon = textureTile.getSector().getCentroid();
            Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), drawContext.getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude()));
            vec4 = drawContext.getView().project(vec4);
            textRenderer.draw((String)object, (int)vec4.x, (int)vec4.y);
        }
        textRenderer.setColor(Color.WHITE);
        textRenderer.endRendering();
    }

    protected void drawBoundingVolumes(DrawContext drawContext, ArrayList<TextureTile> arrayList) {
        GL2 gL2 = drawContext.getGL().getGL2();
        float[] fArray = new float[4];
        gL2.glGetFloatv(2816, fArray, 0);
        gL2.glColor3d(0.0, 1.0, 0.0);
        for (TextureTile textureTile : arrayList) {
            if (!(textureTile.getExtent(drawContext) instanceof Renderable)) continue;
            ((Renderable)((Object)textureTile.getExtent(drawContext))).render(drawContext);
        }
        Box box = Sector.computeBoundingBox(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), this.levels.getSector());
        gL2.glColor3d(1.0, 1.0, 0.0);
        box.render(drawContext);
        gL2.glColor4fv(fArray, 0);
    }

    public static Document createTiledImageLayerConfigDocument(AVList aVList) {
        Document document = WWXML.createDocumentBuilder(true).newDocument();
        Element element = WWXML.setDocumentElement(document, "Layer");
        WWXML.setIntegerAttribute(element, "version", 1);
        WWXML.setTextAttribute(element, "layerType", "TiledImageLayer");
        TiledImageLayer.createTiledImageLayerConfigElements(aVList, element);
        return document;
    }

    public static Element createTiledImageLayerConfigElements(AVList aVList, Element element) {
        Object object;
        Object object2;
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (element == null) {
            String string = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        XPath xPath = WWXML.makeXPath();
        AbstractLayer.createLayerConfigElements(aVList, element);
        DataConfigurationUtils.createLevelSetConfigElements(aVList, element);
        String string = AVListImpl.getStringValue(aVList, "gov.nasa.worldwind.avkey.ServiceName", "WWTileService");
        if (string != null && string.length() > 0) {
            object2 = WWXML.getElement(element, "Service", xPath);
            if (object2 == null) {
                object2 = WWXML.appendElementPath(element, "Service");
            }
            WWXML.setTextAttribute((Element)object2, "serviceName", string);
        }
        WWXML.checkAndAppendBooleanElement(aVList, "gov.nasa.worldwind.avkey.RetrievePropertiesFromService", element, "RetrievePropertiesFromService");
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.ImageFormat", element, "ImageFormat");
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.TextureFormat", element, "TextureFormat");
        object2 = aVList.getValue("gov.nasa.worldwind.avkey.AvailableImageFormats");
        if (object2 != null && object2 instanceof String[] && ((String[])(object = (String[])object2)).length > 0) {
            Element element2 = WWXML.getElement(element, "AvailableImageFormats", xPath);
            if (element2 == null) {
                element2 = WWXML.appendElementPath(element, "AvailableImageFormats");
            }
            WWXML.appendTextArray(element2, "ImageFormat", object);
        }
        WWXML.checkAndAppendBooleanElement(aVList, "gov.nasa.worldwind.avkey.ForceLevelZeroLoads", element, "ForceLevelZeroLoads");
        WWXML.checkAndAppendBooleanElement(aVList, "gov.nasa.worldwind.avkey.RetainLevelZeroTiles", element, "RetainLevelZeroTiles");
        WWXML.checkAndAppendBooleanElement(aVList, "gov.nasa.worldwind.avkey.UseMipMaps", element, "UseMipMaps");
        WWXML.checkAndAppendBooleanElement(aVList, "gov.nasa.worldwind.avkey.UseTransparentTextures", element, "UseTransparentTextures");
        WWXML.checkAndAppendDoubleElement(aVList, "gov.nasa.worldwind.avkey.DetailHint", element, "DetailHint");
        if (aVList.getValue("gov.nasa.worldwind.avkey.URLConnectTimeout") != null || aVList.getValue("gov.nasa.worldwind.avkey.URLReadTimeout") != null || aVList.getValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit") != null) {
            object = WWXML.getElement(element, "RetrievalTimeouts", xPath);
            if (object == null) {
                object = WWXML.appendElementPath(element, "RetrievalTimeouts");
            }
            WWXML.checkAndAppendTimeElement(aVList, "gov.nasa.worldwind.avkey.URLConnectTimeout", (Element)object, "ConnectTimeout/Time");
            WWXML.checkAndAppendTimeElement(aVList, "gov.nasa.worldwind.avkey.URLReadTimeout", (Element)object, "ReadTimeout/Time");
            WWXML.checkAndAppendTimeElement(aVList, "gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", (Element)object, "StaleRequestLimit/Time");
        }
        return element;
    }

    public static AVList getTiledImageLayerConfigParams(Element element, AVList aVList) {
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        XPath xPath = WWXML.makeXPath();
        AbstractLayer.getLayerConfigParams(element, aVList);
        DataConfigurationUtils.getLevelSetConfigParams(element, aVList);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.ServiceName", "Service/@serviceName", xPath);
        WWXML.checkAndSetBooleanParam(element, aVList, "gov.nasa.worldwind.avkey.RetrievePropertiesFromService", "RetrievePropertiesFromService", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.ImageFormat", "ImageFormat", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.TextureFormat", "TextureFormat", xPath);
        WWXML.checkAndSetUniqueStringsParam(element, aVList, "gov.nasa.worldwind.avkey.AvailableImageFormats", "AvailableImageFormats/ImageFormat", xPath);
        WWXML.checkAndSetBooleanParam(element, aVList, "gov.nasa.worldwind.avkey.ForceLevelZeroLoads", "ForceLevelZeroLoads", xPath);
        WWXML.checkAndSetBooleanParam(element, aVList, "gov.nasa.worldwind.avkey.RetainLevelZeroTiles", "RetainLevelZeroTiles", xPath);
        WWXML.checkAndSetBooleanParam(element, aVList, "gov.nasa.worldwind.avkey.UseMipMaps", "UseMipMaps", xPath);
        WWXML.checkAndSetBooleanParam(element, aVList, "gov.nasa.worldwind.avkey.UseTransparentTextures", "UseTransparentTextures", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.DetailHint", "DetailHint", xPath);
        WWXML.checkAndSetColorArrayParam(element, aVList, "gov.nasa.worldwind.avkey.TransparencyColors", "TransparencyColors/Color", xPath);
        WWXML.checkAndSetTimeParamAsInteger(element, aVList, "gov.nasa.worldwind.avkey.URLConnectTimeout", "RetrievalTimeouts/ConnectTimeout/Time", xPath);
        WWXML.checkAndSetTimeParamAsInteger(element, aVList, "gov.nasa.worldwind.avkey.URLReadTimeout", "RetrievalTimeouts/ReadTimeout/Time", xPath);
        WWXML.checkAndSetTimeParamAsInteger(element, aVList, "gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", "RetrievalTimeouts/StaleRequestLimit/Time", xPath);
        TiledImageLayer.getLegacyTiledImageLayerConfigParams(element, aVList);
        return aVList;
    }

    protected static AVList getLegacyTiledImageLayerConfigParams(Element element, AVList aVList) {
        Boolean bl;
        if (element == null) {
            String string = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        XPath xPath = WWXML.makeXPath();
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.TextureFormat");
        if (object == null && (bl = WWXML.getBoolean(element, "CompressTextures", xPath)) != null && bl.booleanValue()) {
            aVList.setValue("gov.nasa.worldwind.avkey.TextureFormat", "image/dds");
        }
        return aVList;
    }

    public List<String> getAvailableImageFormats() {
        return new ArrayList<String>(this.supportedImageFormats);
    }

    public boolean isImageFormatAvailable(String string) {
        return string != null && this.supportedImageFormats.contains(string);
    }

    public String getDefaultImageFormat() {
        return this.supportedImageFormats.size() > 0 ? this.supportedImageFormats.get(0) : null;
    }

    protected void setAvailableImageFormats(String[] stringArray) {
        this.supportedImageFormats.clear();
        if (stringArray != null) {
            this.supportedImageFormats.addAll(Arrays.asList(stringArray));
        }
    }

    protected BufferedImage requestImage(TextureTile textureTile, String string) throws URISyntaxException, InterruptedIOException, MalformedURLException {
        String string2;
        String string3 = textureTile.getPathBase();
        String string4 = string3 + (string2 = WWIO.makeSuffixForMimeType(string));
        File file = new File(string4);
        URL uRL = file.isAbsolute() && file.exists() ? file.toURI().toURL() : this.getDataFileStore().findFile(string4, false);
        if (uRL == null) {
            return null;
        }
        if (WWIO.isFileOutOfDate(uRL, textureTile.getLevel().getExpiryTime())) {
            this.getDataFileStore().removeFile(uRL);
            String string5 = Logging.getMessage("generic.DataFileExpired", uRL);
            Logging.logger().fine(string5);
        } else {
            try {
                File file2 = new File(uRL.toURI());
                BufferedImage bufferedImage = ImageIO.read(file2);
                if (bufferedImage == null) {
                    String string6 = Logging.getMessage("generic.ImageReadFailed", file2);
                    throw new RuntimeException(string6);
                }
                this.levels.unmarkResourceAbsent(textureTile);
                return bufferedImage;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                this.getDataFileStore().removeFile(uRL);
                this.levels.markResourceAbsent(textureTile);
                String string7 = Logging.getMessage("generic.DeletedCorruptDataFile", uRL);
                Logging.logger().info(string7);
            }
        }
        return null;
    }

    protected void downloadImage(TextureTile textureTile, String string, int n) throws Exception {
        if (this.getValue("gov.nasa.worldwind.avkey.RetrieverFactoryLocal") != null) {
            this.retrieveLocalImage(textureTile, string, n);
        } else {
            this.retrieveRemoteImage(textureTile, string, n);
        }
    }

    protected void retrieveRemoteImage(TextureTile textureTile, String string, int n) throws Exception {
        URL uRL = textureTile.getResourceURL(string);
        if (uRL == null) {
            return;
        }
        String string2 = uRL.getProtocol();
        if (!"http".equalsIgnoreCase(string2) && !"https".equalsIgnoreCase(string2)) {
            String string3 = Logging.getMessage("layers.TextureLayer.UnknownRetrievalProtocol", uRL);
            throw new RuntimeException(string3);
        }
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, new CompositionRetrievalPostProcessor(textureTile));
        hTTPRetriever.setValue("URLRetriever.ExtractZipEntry", "true");
        Logging.logger().log(Level.FINE, "Retrieving " + uRL.toString());
        hTTPRetriever.setConnectTimeout(10000);
        hTTPRetriever.setReadTimeout(n);
        hTTPRetriever.call();
    }

    protected void retrieveLocalImage(TextureTile textureTile, String string, int n) throws Exception {
        if (!WorldWind.getLocalRetrievalService().isAvailable()) {
            return;
        }
        RetrieverFactory retrieverFactory = (RetrieverFactory)this.getValue("gov.nasa.worldwind.avkey.RetrieverFactoryLocal");
        if (retrieverFactory == null) {
            return;
        }
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", textureTile.getSector());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.Width", textureTile.getWidth());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.Height", textureTile.getHeight());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FileName", textureTile.getPath());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ImageFormat", string);
        Retriever retriever = retrieverFactory.createRetriever(aVListImpl, new CompositionRetrievalPostProcessor(textureTile));
        Logging.logger().log(Level.FINE, "Locally retrieving " + textureTile.getPath());
        retriever.setReadTimeout(n);
        retriever.call();
    }

    public int computeLevelForResolution(Sector sector, double d) {
        double d2;
        gov.nasa.worldwind.util.Level level;
        double d3;
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        gov.nasa.worldwind.util.Level level2 = this.levels.getLastLevel();
        for (int i = 0; i < this.getLevels().getLastLevel().getLevelNumber(); ++i) {
            double d4;
            if (this.levels.isLevelEmpty(i) || (d4 = this.levels.getLevel(i).getTexelSize()) > d) continue;
            level2 = this.levels.getLevel(i);
            break;
        }
        if (level2.getLevelNumber() != 0 && !this.levels.isLevelEmpty(level2.getLevelNumber() - 1) && (d3 = Math.abs((level = this.levels.getLevel(level2.getLevelNumber() - 1)).getTexelSize() - d)) < (d2 = Math.abs(level2.getTexelSize() - d))) {
            level2 = level;
        }
        Logging.logger().fine(Logging.getMessage("layers.TiledImageLayer.LevelSelection", level2.getLevelNumber(), Double.toString(level2.getTexelSize())));
        return level2.getLevelNumber();
    }

    public BufferedImage composeImageForSector(Sector sector, int n, int n2, double d, int n3, String string, boolean bl, BufferedImage bufferedImage, int n4) throws Exception {
        TextureTile[][] textureTileArray;
        if (sector == null) {
            String string2 = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!this.levels.getSector().intersects(sector)) {
            Logging.logger().severe(Logging.getMessage("generic.SectorRequestedOutsideCoverageArea", sector, this.levels.getSector()));
            return bufferedImage;
        }
        Sector sector2 = this.levels.getSector().intersection(sector);
        if (n3 < 0) {
            n3 = this.levels.getLastLevel().getLevelNumber();
        } else if (n3 > this.levels.getLastLevel().getLevelNumber()) {
            Logging.logger().warning(Logging.getMessage("generic.LevelRequestedGreaterThanMaxLevel", n3, this.levels.getLastLevel().getLevelNumber()));
            n3 = this.levels.getLastLevel().getLevelNumber();
        }
        int n5 = 0;
        for (TextureTile[] textureTileArray2 : textureTileArray = this.getTilesInSector(sector2, n3)) {
            n5 += textureTileArray2.length;
        }
        if (textureTileArray.length == 0 || textureTileArray[0].length == 0) {
            Logging.logger().severe(Logging.getMessage("layers.TiledImageLayer.NoImagesAvailable"));
            return bufferedImage;
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(n, n2, 1);
        }
        double d2 = 0.0;
        TextureTile[][] textureTileArray3 = textureTileArray;
        int n6 = textureTileArray3.length;
        for (int i = 0; i < n6; ++i) {
            TextureTile[] textureTileArray4;
            for (TextureTile textureTile : textureTileArray4 = textureTileArray3[i]) {
                if (textureTile == null) continue;
                try {
                    BufferedImage bufferedImage2 = this.getImage(textureTile, string, n4);
                    Thread.sleep(1L);
                    if (bufferedImage2 != null) {
                        ImageUtil.mergeImage(sector, textureTile.getSector(), d, bufferedImage2, bufferedImage);
                    }
                    this.firePropertyChange("gov.nasa.worldwind.avkey.Progress", d2 / (double)n5, (d2 += 1.0) / (double)n5);
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (InterruptedIOException interruptedIOException) {
                    throw interruptedIOException;
                }
                catch (Exception exception) {
                    if (bl) {
                        throw exception;
                    }
                    String string3 = Logging.getMessage("generic.ExceptionWhileRequestingImage", textureTile.getPath());
                    Logging.logger().log(Level.WARNING, string3, exception);
                }
            }
        }
        return bufferedImage;
    }

    public long countImagesInSector(Sector sector) {
        long l = 0L;
        for (int i = 0; i <= this.getLevels().getLastLevel().getLevelNumber(); ++i) {
            if (this.levels.isLevelEmpty(i)) continue;
            l += this.countImagesInSector(sector, i);
        }
        return l;
    }

    public long countImagesInSector(Sector sector, int n) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel();
        if (n >= 0) {
            for (int i = n; i < this.getLevels().getLastLevel().getLevelNumber(); ++i) {
                if (this.levels.isLevelEmpty(i)) continue;
                level = this.levels.getLevel(i);
                break;
            }
        }
        LatLon latLon = level.getTileDelta();
        LatLon latLon2 = this.levels.getTileOrigin();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude(), latLon2.getLatitude());
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude(), latLon2.getLongitude());
        int n4 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude(), latLon2.getLatitude());
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude(), latLon2.getLongitude());
        long l = n2 - n4 + 1;
        long l2 = n5 - n3 + 1;
        return l * l2;
    }

    public TextureTile[][] getTilesInSector(Sector sector, int n) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel();
        if (n >= 0) {
            for (int i = n; i < this.getLevels().getLastLevel().getLevelNumber(); ++i) {
                if (this.levels.isLevelEmpty(i)) continue;
                level = this.levels.getLevel(i);
                break;
            }
        }
        LatLon latLon = level.getTileDelta();
        LatLon latLon2 = this.levels.getTileOrigin();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude(), latLon2.getLatitude());
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude(), latLon2.getLongitude());
        int n4 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude(), latLon2.getLatitude());
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude(), latLon2.getLongitude());
        int n6 = n2 - n4 + 1;
        int n7 = n5 - n3 + 1;
        TextureTile[][] textureTileArray = new TextureTile[n6][n7];
        for (int i = n2; i >= n4; --i) {
            for (int j = n3; j <= n5; ++j) {
                TileKey tileKey = new TileKey(level.getLevelNumber(), i, j, level.getCacheName());
                Sector sector2 = this.levels.computeSectorForKey(tileKey);
                textureTileArray[n2 - i][j - n3] = new TextureTile(sector2, level, i, j);
            }
        }
        return textureTileArray;
    }

    protected BufferedImage getImage(TextureTile textureTile, String string, int n) throws Exception {
        BufferedImage bufferedImage = this.requestImage(textureTile, string);
        Thread.sleep(1L);
        if (bufferedImage != null) {
            return bufferedImage;
        }
        this.downloadImage(textureTile, string, n);
        bufferedImage = this.requestImage(textureTile, string);
        Thread.sleep(1L);
        if (bufferedImage == null) {
            String string2 = Logging.getMessage("layers.TiledImageLayer.ImageUnavailable", textureTile.getPath());
            throw new RuntimeException(string2);
        }
        return bufferedImage;
    }

    protected static class LevelComparer
    implements Comparator<TextureTile> {
        protected LevelComparer() {
        }

        @Override
        public int compare(TextureTile textureTile, TextureTile textureTile2) {
            int n;
            int n2 = textureTile.getFallbackTile() == null ? textureTile.getLevelNumber() : textureTile.getFallbackTile().getLevelNumber();
            int n3 = n = textureTile2.getFallbackTile() == null ? textureTile2.getLevelNumber() : textureTile2.getFallbackTile().getLevelNumber();
            return n2 < n ? -1 : (n2 == n ? 0 : 1);
        }
    }

    protected class CompositionRetrievalPostProcessor
    extends AbstractRetrievalPostProcessor {
        protected TextureTile tile;

        public CompositionRetrievalPostProcessor(TextureTile textureTile) {
            this.tile = textureTile;
        }

        @Override
        protected File doGetOutputFile() {
            File file;
            String string = WWIO.makeSuffixForMimeType(this.getRetriever().getContentType());
            if (string == null) {
                Logging.logger().severe(Logging.getMessage("generic.UnknownContentType", this.getRetriever().getContentType()));
                return null;
            }
            Object object = this.tile.getPathBase();
            File file2 = new File((String)(object = (String)object + string));
            File file3 = file = file2.isAbsolute() ? file2 : TiledImageLayer.this.getDataFileStore().newFile((String)object);
            if (file == null) {
                return null;
            }
            return file;
        }

        @Override
        protected boolean isDeleteOnExit(File file) {
            return file.getPath().contains("WWJDeleteOnExit");
        }

        @Override
        protected boolean overwriteExistingFile() {
            return true;
        }

        @Override
        protected void markResourceAbsent() {
            TiledImageLayer.this.levels.markResourceAbsent(this.tile);
        }

        @Override
        protected void handleUnsuccessfulRetrieval() {
        }
    }
}

