/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.mercator;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;

public class MercatorSector
extends Sector {
    private double minLatPercent;
    private double maxLatPercent;

    public MercatorSector(double d, double d2, Angle angle, Angle angle2) {
        super(MercatorSector.gudermannian(d), MercatorSector.gudermannian(d2), angle, angle2);
        this.minLatPercent = d;
        this.maxLatPercent = d2;
    }

    public static MercatorSector fromDegrees(double d, double d2, double d3, double d4) {
        return new MercatorSector(d, d2, Angle.fromDegrees(d3), Angle.fromDegrees(d4));
    }

    public static MercatorSector fromSector(Sector sector) {
        return new MercatorSector(MercatorSector.gudermannianInverse(sector.getMinLatitude()), MercatorSector.gudermannianInverse(sector.getMaxLatitude()), new Angle(sector.getMinLongitude()), new Angle(sector.getMaxLongitude()));
    }

    public static double gudermannianInverse(Angle angle) {
        return Math.log(Math.tan(0.7853981633974483 + angle.radians / 2.0)) / Math.PI;
    }

    public static double gudermannianInverse(double d) {
        return Math.log(Math.tan(0.7853981633974483 + d / 2.0)) / Math.PI;
    }

    public static Angle gudermannian(double d) {
        return Angle.fromRadians(Math.atan(Math.sinh(d * Math.PI)));
    }

    public double getMinLatPercent() {
        return this.minLatPercent;
    }

    public double getMaxLatPercent() {
        return this.maxLatPercent;
    }
}

