/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.rpf.wizard;

public class TimeFormatter {
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_SECOND = 1000L;

    public String formatPrecise(long l) {
        long[] lArray = TimeFormatter.millisToHMS(l);
        return String.format("%02d:%02d:%02d", lArray[0], lArray[1], lArray[2]);
    }

    public String formatEstimate(long l) {
        Object object;
        if (l < 60000L) {
            object = "less than 1 minute";
        } else if (l < 600000L) {
            long l2;
            object = "about " + l2 + ((l2 = (l = 60000L * Math.round((double)l / 60000.0)) / 60000L) > 1L ? " minutes" : " minute");
        } else if (l < 3300000L) {
            l = 600000L * Math.round((double)l / 600000.0);
            long l3 = l / 60000L;
            object = "about " + l3 + " minutes";
        } else {
            long l4;
            object = "about " + l4 + ((l4 = (l = 1800000L * Math.round((double)l / 1800000.0)) / 3600000L) > 1L ? " hours" : " hour");
            long l5 = l / 60000L % 60L;
            if (l5 > 0L) {
                object = (String)object + " " + l5 + " minutes";
            }
        }
        return object;
    }

    private static long[] millisToHMS(long l) {
        return new long[]{(long)(Math.floor((double)l / 3600000.0) % 60.0), (long)(Math.floor((double)l / 60000.0) % 60.0), (long)(Math.floor((double)l / 1000.0) % 60.0)};
    }
}

