/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.gml;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import java.util.logging.Level;

public class GMLPos
extends AbstractXMLEventParser {
    public GMLPos(String string) {
        super(string);
    }

    public String getDimension() {
        return (String)this.getField("dimension");
    }

    public String getPosString() {
        return (String)this.getField("CharactersContent");
    }

    public double[] getPos2() {
        String[] stringArray = this.getPosString().split(" ");
        if (stringArray.length < 2) {
            return null;
        }
        try {
            return new double[]{Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1])};
        }
        catch (NumberFormatException numberFormatException) {
            String string = Logging.getMessage("generic.NumberFormatException");
            Logging.logger().log(Level.WARNING, string, numberFormatException);
            return null;
        }
    }
}

