/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.gml;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.ogc.gml.GMLGrid;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class GMLRectifiedGrid
extends GMLGrid {
    protected List<String> axisNames = new ArrayList<String>(2);
    protected List<String> offsetVectors = new ArrayList<String>(2);

    public GMLRectifiedGrid(String string) {
        super(string);
    }

    public List<String> getAxisNames() {
        return this.axisNames;
    }

    public List<String> getOffsetVectorStrings() {
        return this.offsetVectors;
    }

    public List<Vec4> getOffsetVectors() {
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>(this.offsetVectors.size());
        for (String string : this.offsetVectors) {
            double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
            String[] stringArray = string.split(" ");
            for (int i = 0; i < Math.min(stringArray.length, 4); ++i) {
                try {
                    dArray[i] = Double.parseDouble(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = Logging.getMessage("generic.NumberFormatException");
                    Logging.logger().log(Level.WARNING, string2, numberFormatException);
                    return Collections.emptyList();
                }
            }
            arrayList.add(new Vec4(dArray[0], dArray[1], dArray[2], dArray[3]));
        }
        return arrayList;
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, "axisName")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.axisNames.add(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "offsetVector")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.offsetVectors.add(string);
            }
        } else {
            super.doParseEventContent(xMLEventParserContext, xMLEvent, objectArray);
        }
    }
}

