/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.StringListXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OWSServiceIdentification
extends AbstractXMLEventParser {
    protected List<String> abstracts = new ArrayList<String>(1);
    protected List<String> accessConstraints = new ArrayList<String>(1);
    protected List<String> profiles = new ArrayList<String>(1);
    protected List<String> titles = new ArrayList<String>(1);
    protected List<String> serviceTypeVersions = new ArrayList<String>(1);

    public OWSServiceIdentification(String string) {
        super(string);
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public List<String> getAbstracts() {
        return this.abstracts;
    }

    public List<String> getKeywords() {
        return ((StringListXMLEventParser)this.getField("Keywords")).getStrings();
    }

    public String getServiceType() {
        return (String)this.getField("ServiceType");
    }

    public List<String> getServiceTypeVersions() {
        return this.serviceTypeVersions;
    }

    public String getFees() {
        return (String)this.getField("Fees");
    }

    public List<String> getAccessConstraints() {
        return this.accessConstraints;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, "ServiceTypeVersion")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.serviceTypeVersions.add(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "Abstract")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.abstracts.add(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "AccessConstraints")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.accessConstraints.add(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "Title")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.titles.add(string);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, "Profile")) {
            String string = xMLEventParserContext.getStringParser().parseString(xMLEventParserContext, xMLEvent, new Object[0]);
            if (!WWUtil.isEmpty(string)) {
                this.profiles.add(string);
            }
        } else {
            super.doParseEventContent(xMLEventParserContext, xMLEvent, objectArray);
        }
    }
}

