/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.pick;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectFactory;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Range;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class PickSupport {
    protected Map<Integer, PickedObject> pickableObjects = new HashMap<Integer, PickedObject>();
    protected Map<Range, PickedObjectFactory> pickableObjectRanges = new HashMap<Range, PickedObjectFactory>();
    protected int[] minAndMaxColorCodes;

    public void clearPickList() {
        this.getPickableObjects().clear();
        this.getPickableObjectRanges().clear();
        this.minAndMaxColorCodes = null;
    }

    public void addPickableObject(int n, Object object, Position position, boolean bl) {
        this.getPickableObjects().put(n, new PickedObject(n, object, position, bl));
        this.adjustExtremeColorCodes(n);
    }

    public void addPickableObject(int n, Object object, Position position) {
        this.getPickableObjects().put(n, new PickedObject(n, object, position, false));
        this.adjustExtremeColorCodes(n);
    }

    public void addPickableObject(int n, Object object) {
        this.getPickableObjects().put(n, new PickedObject(n, object));
        this.adjustExtremeColorCodes(n);
    }

    public void addPickableObject(PickedObject pickedObject) {
        this.getPickableObjects().put(pickedObject.getColorCode(), pickedObject);
        this.adjustExtremeColorCodes(pickedObject.getColorCode());
    }

    public void addPickableObjectRange(int n, int n2, PickedObjectFactory pickedObjectFactory) {
        Range range = new Range(n, n2);
        this.pickableObjectRanges.put(range, pickedObjectFactory);
        this.adjustExtremeColorCodes(n);
        this.adjustExtremeColorCodes(n + n2 - 1);
    }

    public PickedObject getTopObject(DrawContext drawContext, Point point) {
        if (!this.hasPickableObjects()) {
            return null;
        }
        int n = this.getTopColor(drawContext, point);
        if (n == 0) {
            return null;
        }
        PickedObject pickedObject = this.lookupPickableObject(n);
        if (pickedObject == null) {
            return null;
        }
        return pickedObject;
    }

    public PickedObject resolvePick(DrawContext drawContext, Point point, Layer layer) {
        if (!this.hasPickableObjects()) {
            return null;
        }
        PickedObject pickedObject = null;
        if (point != null) {
            pickedObject = this.doResolvePick(drawContext, point, layer);
        }
        if (drawContext.getPickRectangle() != null && !drawContext.getPickRectangle().isEmpty()) {
            this.doResolvePick(drawContext, drawContext.getPickRectangle(), layer);
        }
        this.clearPickList();
        return pickedObject;
    }

    protected PickedObject doResolvePick(DrawContext drawContext, Point point, Layer layer) {
        PickedObject pickedObject = this.getTopObject(drawContext, point);
        if (pickedObject != null) {
            if (layer != null) {
                pickedObject.setParentLayer(layer);
            }
            drawContext.addPickedObject(pickedObject);
        }
        return pickedObject;
    }

    protected void doResolvePick(DrawContext drawContext, Rectangle rectangle, Layer layer) {
        int[] nArray = drawContext.getPickColorsInRectangle(rectangle, this.minAndMaxColorCodes);
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int n : nArray) {
            PickedObject pickedObject;
            if (n == 0 || (pickedObject = this.lookupPickableObject(n)) == null) continue;
            if (layer != null) {
                pickedObject.setParentLayer(layer);
            }
            drawContext.addObjectInPickRectangle(pickedObject);
        }
    }

    public int getTopColor(DrawContext drawContext, Point point) {
        return point != null ? drawContext.getPickColorAtPoint(point) : 0;
    }

    public void beginPicking(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glPushAttrib(8193);
        gL2.glDisable(3024);
        gL2.glDisable(2896);
        gL2.glDisable(2912);
        gL2.glDisable(3042);
        gL2.glDisable(3553);
        if (drawContext.isDeepPickingEnabled()) {
            gL2.glDisable(2929);
        }
    }

    public void endPicking(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glPopAttrib();
        gL2.glColor3ub((byte)-1, (byte)-1, (byte)-1);
    }

    protected Map<Integer, PickedObject> getPickableObjects() {
        return this.pickableObjects;
    }

    protected Map<Range, PickedObjectFactory> getPickableObjectRanges() {
        return this.pickableObjectRanges;
    }

    protected boolean hasPickableObjects() {
        return this.getPickableObjects().size() > 0 || this.getPickableObjectRanges().size() > 0;
    }

    protected PickedObject lookupPickableObject(int n) {
        PickedObject pickedObject = this.getPickableObjects().get(n);
        if (pickedObject != null) {
            return pickedObject;
        }
        for (Map.Entry<Range, PickedObjectFactory> entry : this.getPickableObjectRanges().entrySet()) {
            Range range = entry.getKey();
            PickedObjectFactory pickedObjectFactory = entry.getValue();
            if (!range.contains(n) || pickedObjectFactory == null) continue;
            return pickedObjectFactory.createPickedObject(n);
        }
        return null;
    }

    protected void adjustExtremeColorCodes(int n) {
        if (this.minAndMaxColorCodes == null) {
            this.minAndMaxColorCodes = new int[]{n, n};
        } else {
            if (this.minAndMaxColorCodes[0] > n) {
                this.minAndMaxColorCodes[0] = n;
            }
            if (this.minAndMaxColorCodes[1] < n) {
                this.minAndMaxColorCodes[1] = n;
            }
        }
    }

    public static boolean areSelectionsTheSame(PickedObject pickedObject, PickedObject pickedObject2) {
        return pickedObject != null && pickedObject2 != null && pickedObject.getObject() == pickedObject2.getObject();
    }
}

