/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.AbstractAnnotationLayout;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class AnnotationNullLayout
extends AbstractAnnotationLayout {
    protected Map<Annotation, Object> constraintMap = new HashMap<Annotation, Object>();

    public Object getConstraint(Annotation annotation) {
        if (annotation == null) {
            String string = Logging.getMessage("nullValue.AnnotationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.constraintMap.get(annotation);
    }

    public void setConstraint(Annotation annotation, Object object) {
        if (annotation == null) {
            String string = Logging.getMessage("nullValue.AnnotationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.constraintMap.put(annotation, object);
    }

    @Override
    public Dimension getPreferredSize(DrawContext drawContext, Iterable<? extends Annotation> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Rectangle rectangle = new Rectangle();
        for (Annotation annotation : iterable) {
            Rectangle rectangle2 = this.getAnnotationBounds(drawContext, annotation);
            if (rectangle2 == null) continue;
            rectangle = rectangle.union(rectangle2);
        }
        return rectangle.getSize();
    }

    @Override
    public void drawAnnotations(DrawContext drawContext, Rectangle rectangle, Iterable<? extends Annotation> iterable, double d, Position position) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        for (Annotation annotation : iterable) {
            Rectangle rectangle2 = this.getAnnotationBounds(drawContext, annotation);
            rectangle2 = this.adjustAnnotationBounds(drawContext, rectangle, annotation, rectangle2);
            oGLStackHandler.pushModelview(gL2);
            gL2.glTranslated(rectangle.getMinX(), rectangle.getMinY(), 0.0);
            gL2.glTranslated(rectangle2.getMinX(), rectangle2.getMinY(), 0.0);
            this.drawAnnotation(drawContext, annotation, rectangle2.width, rectangle2.height, d, position);
            oGLStackHandler.pop(gL2);
        }
    }

    protected Rectangle getAnnotationBounds(DrawContext drawContext, Annotation annotation) {
        Dimension dimension = this.getAnnotationSize(drawContext, annotation);
        if (dimension == null) {
            return null;
        }
        Point point = annotation.getAttributes().getDrawOffset();
        if (point == null) {
            point = new Point();
        }
        return new Rectangle(point, dimension);
    }

    protected Rectangle adjustAnnotationBounds(DrawContext drawContext, Rectangle rectangle, Annotation annotation, Rectangle rectangle2) {
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        Object object = this.getConstraint(annotation);
        if (object == "gov.nasa.worldwind.avkey.West") {
            n2 += rectangle.height / 2 - rectangle2.height / 2;
        } else if (object == "gov.nasa.worldwind.layers.ViewControlsLayer.NorthWest") {
            n2 += rectangle.height - rectangle2.height;
        } else if (object == "gov.nasa.worldwind.avkey.North") {
            n += rectangle.width / 2 - rectangle2.width / 2;
            n2 += rectangle.height - rectangle2.height;
        } else if (object == "gov.nasa.worldwind.layers.ViewControlsLayer.NorthEast") {
            n += rectangle.width - rectangle2.width;
            n2 += rectangle.height - rectangle2.height;
        } else if (object == "gov.nasa.worldwind.avkey.East") {
            n += rectangle.width - rectangle2.width;
            n2 += rectangle.height / 2 - rectangle2.height / 2;
        } else if (object == "gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast") {
            n += rectangle.width - rectangle2.width;
        } else if (object == "gov.nasa.worldwdind.avkey.South") {
            n += rectangle.width / 2 - rectangle2.width / 2;
        } else if (object == "gov.nasa.worldwind.avkey.Center") {
            n += rectangle.width / 2 - rectangle2.width / 2;
            n2 += rectangle.height / 2 - rectangle2.height / 2;
        }
        return new Rectangle(n, n2, rectangle2.width, rectangle2.height);
    }
}

