/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.LightingModel;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;

public class BasicLightingModel
implements LightingModel {
    protected OGLStackHandler lightingStackHandler = new OGLStackHandler();
    protected Vec4 lightDirection = new Vec4(1.0, 0.5, 1.0);
    protected Material lightMaterial = Material.WHITE;
    protected long frameID;

    @Override
    public void beginLighting(DrawContext drawContext) {
        if (this.lightingStackHandler.isActive()) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        this.lightingStackHandler.pushAttrib(gL2, 64);
        this.apply(drawContext);
    }

    @Override
    public void endLighting(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        this.lightingStackHandler.pop(gL2);
        this.lightingStackHandler.clear();
    }

    public Vec4 getLightDirection() {
        return this.lightDirection;
    }

    public void setLightDirection(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.LightDirectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.lightDirection = vec4;
    }

    public Material getLightMaterial() {
        return this.lightMaterial;
    }

    public void setLightMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.LightMaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.lightMaterial = material;
    }

    protected void apply(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glEnable(2896);
        this.applyStandardLightModel(gL2);
        this.applyStandardShadeModel(gL2);
        gL2.glEnable(16384);
        BasicLightingModel.applyStandardLightMaterial(gL2, 16384, this.lightMaterial);
        this.applyStandardLightDirection(gL2, 16384, this.lightDirection);
    }

    protected void applyStandardLightModel(GL2 gL2) {
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
        gL2.glLightModelfv(2899, fArray, 0);
        gL2.glLightModeli(2897, 1);
        gL2.glLightModeli(2898, 1);
    }

    protected void applyStandardShadeModel(GL2 gL2) {
        gL2.glShadeModel(7425);
    }

    protected static void applyStandardLightMaterial(GL2 gL2, int n, Material material) {
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[4];
        material.getDiffuse().getRGBColorComponents(fArray2);
        material.getSpecular().getRGBColorComponents(fArray3);
        fArray3[3] = 0.0f;
        fArray2[3] = 0.0f;
        fArray[3] = 0.0f;
        gL2.glLightfv(n, 4608, fArray, 0);
        gL2.glLightfv(n, 4609, fArray2, 0);
        gL2.glLightfv(n, 4610, fArray3, 0);
    }

    protected void applyStandardLightDirection(GL2 gL2, int n, Vec4 vec4) {
        Vec4 vec42 = vec4.normalize3();
        float[] fArray = new float[]{(float)vec42.x, (float)vec42.y, (float)vec42.z, 0.0f};
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        gL2.glLightfv(n, 4611, fArray, 0);
        gL2.glPopMatrix();
    }
}

