/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.gl2.GLUgl2;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe2D;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.TextRenderer;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;

public class GeographicTextRenderer {
    private TextRenderer lastTextRenderer = null;
    private final GLU glu = new GLUgl2();
    private static final Font DEFAULT_FONT = Font.decode("Arial-PLAIN-12");
    private static final Color DEFAULT_COLOR = Color.white;
    private boolean cullText = false;
    private int cullTextMargin = 0;
    private String effect = "gov.nasa.worldwind.avkey.TextEffectShadow";
    private double distanceMinScale = 1.0;
    private double distanceMaxScale = 1.0;
    private double distanceMinOpacity = 1.0;
    private boolean isDistanceScaling = false;
    private double lookAtDistance = 0.0;
    private boolean hasJOGLv111Bug = false;

    public boolean isCullTextEnabled() {
        return this.cullText;
    }

    public void setCullTextEnabled(boolean bl) {
        this.cullText = bl;
    }

    public int getCullTextMargin() {
        return this.cullTextMargin;
    }

    public void setCullTextMargin(int n) {
        this.cullTextMargin = n;
    }

    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().fine(string2);
            throw new IllegalArgumentException(string2);
        }
        this.effect = string;
    }

    public double getDistanceMinScale() {
        return this.distanceMinScale;
    }

    public void setDistanceMinScale(double d) {
        this.distanceMinScale = d;
    }

    public double getDistanceMaxScale() {
        return this.distanceMaxScale;
    }

    public void setDistanceMaxScale(double d) {
        this.distanceMaxScale = d;
    }

    public double getDistanceMinOpacity() {
        return this.distanceMinOpacity;
    }

    public void setDistanceMinOpacity(double d) {
        this.distanceMinOpacity = d;
    }

    public void render(DrawContext drawContext, Iterable<GeographicText> iterable) {
        this.drawMany(drawContext, iterable);
    }

    public void render(DrawContext drawContext, GeographicText geographicText, Vec4 vec4) {
        if (!GeographicTextRenderer.isTextValid(geographicText, false)) {
            return;
        }
        this.drawOne(drawContext, geographicText, vec4);
    }

    private void drawMany(DrawContext drawContext, Iterable<GeographicText> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        Iterator<GeographicText> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        Frustum frustum = drawContext.getView().getFrustumInModelCoordinates();
        double d = drawContext.getView().getHorizonDistance();
        while (iterator.hasNext()) {
            Vec4 vec4;
            Comparable<Angle> comparable;
            GeographicText geographicText = iterator.next();
            if (!GeographicTextRenderer.isTextValid(geographicText, true) || !geographicText.isVisible() || drawContext.is2DGlobe() && (comparable = ((Globe2D)((Object)drawContext.getGlobe())).getProjection().getProjectionLimits()) != null && !((Sector)comparable).contains(geographicText.getPosition())) continue;
            comparable = geographicText.getPosition().getLatitude();
            Angle angle = geographicText.getPosition().getLongitude();
            if (!drawContext.getVisibleSector().contains((Angle)comparable, angle) || (vec4 = sectorGeometryList.getSurfacePoint((Angle)comparable, angle, geographicText.getPosition().getElevation() * drawContext.getVerticalExaggeration())) == null) continue;
            double d2 = drawContext.getView().getEyePoint().distanceTo3(vec4);
            if (!drawContext.is2DGlobe() && d2 > d || !frustum.contains(vec4)) continue;
            drawContext.addOrderedRenderable(new OrderedText(geographicText, vec4, d2));
        }
    }

    private void drawOne(DrawContext drawContext, GeographicText geographicText, Vec4 vec4) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getView() == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (!geographicText.isVisible()) {
            return;
        }
        if (vec4 == null) {
            if (geographicText.getPosition() == null) {
                return;
            }
            Angle angle = geographicText.getPosition().getLatitude();
            Angle angle2 = geographicText.getPosition().getLongitude();
            if (!drawContext.getVisibleSector().contains(angle, angle2)) {
                return;
            }
            vec4 = sectorGeometryList.getSurfacePoint(angle, angle2, geographicText.getPosition().getElevation() * drawContext.getVerticalExaggeration());
            if (vec4 == null) {
                return;
            }
        }
        double d = drawContext.getView().getHorizonDistance();
        double d2 = drawContext.getView().getEyePoint().distanceTo3(vec4);
        if (!drawContext.is2DGlobe() && d2 > d) {
            return;
        }
        if (!drawContext.getView().getFrustumInModelCoordinates().contains(vec4)) {
            return;
        }
        drawContext.addOrderedRenderable(new OrderedText(geographicText, vec4, d2));
    }

    protected static boolean isTextValid(GeographicText geographicText, boolean bl) {
        if (geographicText == null || geographicText.getText() == null) {
            return false;
        }
        return !bl || geographicText.getPosition() != null;
    }

    protected Rectangle2D computeTextBounds(DrawContext drawContext, OrderedText orderedText, double d) throws Exception {
        GeographicText geographicText = orderedText.text;
        CharSequence charSequence = geographicText.getText();
        if (charSequence == null) {
            return null;
        }
        Vec4 vec4 = drawContext.getView().project(orderedText.point);
        if (vec4 == null) {
            return null;
        }
        Font font = geographicText.getFont();
        if (font == null) {
            font = DEFAULT_FONT;
        }
        try {
            TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
            if (textRenderer != this.lastTextRenderer) {
                if (this.lastTextRenderer != null) {
                    this.lastTextRenderer.end3DRendering();
                }
                textRenderer.begin3DRendering();
                this.lastTextRenderer = textRenderer;
            }
            Rectangle2D rectangle2D = textRenderer.getBounds(charSequence);
            double d2 = vec4.x - rectangle2D.getWidth() / 2.0;
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            ((Rectangle2D)float_).setRect(d2, vec4.y, rectangle2D.getWidth(), rectangle2D.getHeight());
            return this.computeScaledBounds(float_, d);
        }
        catch (Exception exception) {
            this.handleTextRendererExceptions(exception);
            return null;
        }
    }

    protected Rectangle2D computeScaledBounds(Rectangle2D rectangle2D, double d) {
        if (d == 1.0) {
            return rectangle2D;
        }
        double d2 = rectangle2D.getWidth() / 2.0;
        rectangle2D.setRect(rectangle2D.getX() + d2 - d2 * d, rectangle2D.getY(), rectangle2D.getWidth() * d, rectangle2D.getHeight() * d);
        return rectangle2D;
    }

    protected Rectangle2D computeExpandedBounds(Rectangle2D rectangle2D, int n) {
        if (n == 0) {
            return rectangle2D;
        }
        rectangle2D.setRect(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)(n * 2), rectangle2D.getHeight() + (double)(n * 2));
        return rectangle2D;
    }

    protected double[] computeDistanceScaleAndOpacity(DrawContext drawContext, OrderedText orderedText) {
        if (!this.isDistanceScaling) {
            return new double[]{1.0, 1.0};
        }
        double d = this.lookAtDistance;
        double d2 = orderedText.getDistanceFromEye();
        double d3 = Math.sqrt(d / d2);
        double d4 = WWMath.clamp(d3, this.getDistanceMinScale(), this.getDistanceMaxScale());
        double d5 = WWMath.clamp(d3, this.getDistanceMinOpacity(), 1.0);
        return new double[]{d4, d5};
    }

    protected double computeLookAtDistance(DrawContext drawContext) {
        View view = drawContext.getView();
        Position position = view.computePositionFromScreenPoint(view.getViewport().getCenterX(), view.getViewport().getCenterY());
        if (position != null) {
            this.lookAtDistance = view.getEyePoint().distanceTo3(drawContext.getGlobe().computePointFromPosition(position));
        }
        return this.lookAtDistance;
    }

    protected void beginRendering(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        int n = 30977;
        gL2.glPushAttrib(n);
        gL2.glMatrixMode(5889);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        this.glu.gluOrtho2D(0.0f, drawContext.getView().getViewport().width, 0.0f, drawContext.getView().getViewport().height);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        gL2.glMatrixMode(5890);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        gL2.glMatrixMode(5888);
        gL2.glEnable(2929);
        gL2.glDepthMask(false);
        gL2.glDisable(2884);
        gL2.glEnable(3008);
        gL2.glAlphaFunc(516, 0.001f);
        this.isDistanceScaling = this.getDistanceMinScale() != 1.0 || this.getDistanceMaxScale() != 1.0 || this.distanceMinOpacity != 1.0;
        this.computeLookAtDistance(drawContext);
    }

    protected void endRendering(DrawContext drawContext) {
        if (this.lastTextRenderer != null) {
            this.lastTextRenderer.end3DRendering();
            this.lastTextRenderer = null;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glMatrixMode(5889);
        gL2.glPopMatrix();
        gL2.glMatrixMode(5888);
        gL2.glPopMatrix();
        gL2.glMatrixMode(5890);
        gL2.glPopMatrix();
        gL2.glPopAttrib();
    }

    protected Vec4 drawText(DrawContext drawContext, OrderedText orderedText, double d, double d2) throws Exception {
        if (orderedText.point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().fine(string);
            return null;
        }
        GeographicText geographicText = orderedText.text;
        GL2 gL2 = drawContext.getGL().getGL2();
        CharSequence charSequence = geographicText.getText();
        if (charSequence == null) {
            return null;
        }
        Vec4 vec4 = drawContext.getView().project(orderedText.point);
        if (vec4 == null) {
            return null;
        }
        Font font = geographicText.getFont();
        if (font == null) {
            font = DEFAULT_FONT;
        }
        try {
            TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
            if (textRenderer != this.lastTextRenderer) {
                if (this.lastTextRenderer != null) {
                    this.lastTextRenderer.end3DRendering();
                }
                textRenderer.begin3DRendering();
                this.lastTextRenderer = textRenderer;
            }
            this.setDepthFunc(drawContext, orderedText, vec4);
            Rectangle2D rectangle2D = textRenderer.getBounds(charSequence);
            rectangle2D = this.computeScaledBounds(rectangle2D, d);
            Point2D.Float float_ = this.computeDrawPoint(drawContext, rectangle2D, vec4);
            if (float_ != null) {
                Color color;
                if (d != 1.0) {
                    gL2.glScaled(d, d, 1.0);
                    float_.setLocation(float_.x / (float)d, float_.y / (float)d);
                }
                if ((color = geographicText.getColor()) == null) {
                    color = DEFAULT_COLOR;
                }
                color = this.applyOpacity(color, d2);
                Color color2 = geographicText.getBackgroundColor();
                if (color2 != null) {
                    color2 = this.applyOpacity(color2, d2);
                    textRenderer.setColor(color2);
                    if (this.effect.equals("gov.nasa.worldwind.avkey.TextEffectShadow")) {
                        textRenderer.draw3D(charSequence, float_.x + 1.0f, float_.y - 1.0f, 0.0f, 1.0f);
                    } else if (this.effect.equals("gov.nasa.worldwind.avkey.TextEffectOutline")) {
                        textRenderer.draw3D(charSequence, float_.x + 1.0f, float_.y - 1.0f, 0.0f, 1.0f);
                        textRenderer.draw3D(charSequence, float_.x + 1.0f, float_.y + 1.0f, 0.0f, 1.0f);
                        textRenderer.draw3D(charSequence, float_.x - 1.0f, float_.y - 1.0f, 0.0f, 1.0f);
                        textRenderer.draw3D(charSequence, float_.x - 1.0f, float_.y + 1.0f, 0.0f, 1.0f);
                    }
                }
                textRenderer.setColor(color);
                textRenderer.draw3D(charSequence, float_.x, float_.y, 0.0f, 1.0f);
                textRenderer.flush();
                if (d != 1.0) {
                    gL2.glLoadIdentity();
                }
            }
        }
        catch (Exception exception) {
            this.handleTextRendererExceptions(exception);
        }
        return vec4;
    }

    protected Color applyOpacity(Color color, double d) {
        if (d >= 1.0) {
            return color;
        }
        float[] fArray = color.getRGBComponents(null);
        return new Color(fArray[0], fArray[1], fArray[2], fArray[3] * (float)d);
    }

    private void handleTextRendererExceptions(Exception exception) throws Exception {
        if (exception instanceof IOException) {
            if (!this.hasJOGLv111Bug) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingText", exception);
                this.hasJOGLv111Bug = true;
            }
        } else {
            throw exception;
        }
    }

    protected Point2D.Float computeDrawPoint(DrawContext drawContext, Rectangle2D rectangle2D, Vec4 vec4) {
        return new Point2D.Float((float)(vec4.x - rectangle2D.getWidth() / 2.0), (float)vec4.y);
    }

    protected void setDepthFunc(DrawContext drawContext, OrderedText orderedText, Vec4 vec4) {
        GL gL = drawContext.getGL();
        Position position = drawContext.getView().getEyePosition();
        if (position == null) {
            gL.glDepthFunc(519);
            return;
        }
        double d = position.getElevation();
        if (d < drawContext.getGlobe().getMaxElevation() * drawContext.getVerticalExaggeration()) {
            double d2 = vec4.z - 0.00391006472;
            d2 = d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2);
            gL.glDepthFunc(513);
            gL.glDepthRange(d2, d2);
        } else {
            gL.glDepthFunc(519);
        }
    }

    protected class OrderedText
    implements OrderedRenderable,
    Comparable<OrderedText> {
        GeographicText text;
        Vec4 point;
        double eyeDistance;

        OrderedText(GeographicText geographicText, Vec4 vec4, double d) {
            this.text = geographicText;
            this.point = vec4;
            this.eyeDistance = d;
        }

        @Override
        public int compareTo(OrderedText orderedText) {
            if (orderedText.text.getPriority() - this.text.getPriority() == 0.0) {
                return (int)(this.eyeDistance - orderedText.eyeDistance);
            }
            return (int)(orderedText.text.getPriority() - this.text.getPriority());
        }

        @Override
        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        private GeographicTextRenderer getRenderer() {
            return GeographicTextRenderer.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void render(DrawContext drawContext) {
            block13: {
                GeographicTextRenderer.this.beginRendering(drawContext);
                try {
                    if (GeographicTextRenderer.this.cullText) {
                        Object object;
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(this);
                        OrderedRenderable orderedRenderable = drawContext.peekOrderedRenderables();
                        while (orderedRenderable != null && orderedRenderable instanceof OrderedText && super.getRenderer() == GeographicTextRenderer.this) {
                            arrayList.add(object);
                            drawContext.pollOrderedRenderables();
                            orderedRenderable = drawContext.peekOrderedRenderables();
                        }
                        Collections.sort(arrayList);
                        object = new ArrayList();
                        for (OrderedText orderedText : arrayList) {
                            double[] dArray;
                            Rectangle2D rectangle2D = GeographicTextRenderer.this.computeTextBounds(drawContext, orderedText, (dArray = GeographicTextRenderer.this.computeDistanceScaleAndOpacity(drawContext, orderedText))[0]);
                            if (rectangle2D == null) continue;
                            boolean bl = false;
                            rectangle2D = GeographicTextRenderer.this.computeExpandedBounds(rectangle2D, GeographicTextRenderer.this.cullTextMargin);
                            Iterator iterator = ((ArrayList)object).iterator();
                            while (iterator.hasNext()) {
                                Rectangle2D rectangle2D2 = (Rectangle2D)iterator.next();
                                if (!rectangle2D2.intersects(rectangle2D)) continue;
                                bl = true;
                            }
                            if (bl) continue;
                            ((ArrayList)object).add(rectangle2D);
                            GeographicTextRenderer.this.drawText(drawContext, orderedText, dArray[0], dArray[1]);
                        }
                        break block13;
                    }
                    double[] dArray = GeographicTextRenderer.this.computeDistanceScaleAndOpacity(drawContext, this);
                    GeographicTextRenderer.this.drawText(drawContext, this, dArray[0], dArray[1]);
                    OrderedRenderable orderedRenderable = drawContext.peekOrderedRenderables();
                    while (orderedRenderable != null && orderedRenderable instanceof OrderedText) {
                        OrderedText orderedText = (OrderedText)orderedRenderable;
                        if (orderedText.getRenderer() != GeographicTextRenderer.this) {
                            break;
                        }
                        dArray = GeographicTextRenderer.this.computeDistanceScaleAndOpacity(drawContext, orderedText);
                        GeographicTextRenderer.this.drawText(drawContext, orderedText, dArray[0], dArray[1]);
                        drawContext.pollOrderedRenderables();
                        orderedRenderable = drawContext.peekOrderedRenderables();
                    }
                }
                catch (WWRuntimeException wWRuntimeException) {
                    Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingText", wWRuntimeException);
                }
                catch (Exception exception) {
                    Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingText", exception);
                }
                finally {
                    GeographicTextRenderer.this.endRendering(drawContext);
                }
            }
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
        }
    }
}

