/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.GL;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.AbstractBrowserBalloon;
import gov.nasa.worldwind.render.BalloonAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GlobeBalloon;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;

public class GlobeBrowserBalloon
extends AbstractBrowserBalloon
implements GlobeBalloon {
    protected Position position;
    protected int altitudeMode;

    public GlobeBrowserBalloon(String string, Position position) {
        super(string);
        if (position == null) {
            String string2 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.position = position;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
    }

    @Override
    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    @Override
    public void setAltitudeMode(int n) {
        this.altitudeMode = n;
    }

    @Override
    protected AbstractBrowserBalloon.OrderedBrowserBalloon createOrderedRenderable() {
        return new OrderedGlobeBrowserBalloon();
    }

    @Override
    protected void computeBalloonPoints(DrawContext drawContext, AbstractBrowserBalloon.OrderedBrowserBalloon orderedBrowserBalloon) {
        OrderedGlobeBrowserBalloon orderedGlobeBrowserBalloon = (OrderedGlobeBrowserBalloon)orderedBrowserBalloon;
        orderedGlobeBrowserBalloon.placePoint = null;
        orderedGlobeBrowserBalloon.screenPlacePoint = null;
        this.screenOffset = null;
        orderedBrowserBalloon.screenRect = null;
        orderedBrowserBalloon.screenExtent = null;
        orderedBrowserBalloon.screenPickExtent = null;
        orderedBrowserBalloon.webViewRect = null;
        orderedBrowserBalloon.eyeDistance = 0.0;
        if (this.altitudeMode == 1 || drawContext.is2DGlobe()) {
            orderedGlobeBrowserBalloon.placePoint = drawContext.computeTerrainPoint(this.position.getLatitude(), this.position.getLongitude(), 0.0);
        } else if (this.altitudeMode == 2) {
            orderedGlobeBrowserBalloon.placePoint = drawContext.computeTerrainPoint(this.position.getLatitude(), this.position.getLongitude(), this.position.getAltitude());
        } else {
            double d = this.position.getElevation() * drawContext.getVerticalExaggeration();
            orderedGlobeBrowserBalloon.placePoint = drawContext.getGlobe().computePointFromPosition(this.position.getLatitude(), this.position.getLongitude(), d);
        }
        if (orderedGlobeBrowserBalloon.placePoint == null) {
            return;
        }
        BalloonAttributes balloonAttributes = this.getActiveAttributes();
        Dimension dimension = this.computeSize(drawContext, balloonAttributes);
        orderedGlobeBrowserBalloon.screenPlacePoint = drawContext.getView().project(orderedGlobeBrowserBalloon.placePoint);
        this.screenOffset = this.computeOffset(drawContext, balloonAttributes, dimension.width, dimension.height);
        orderedBrowserBalloon.screenRect = new Rectangle((int)(orderedGlobeBrowserBalloon.screenPlacePoint.x - (double)this.screenOffset.x), (int)(orderedGlobeBrowserBalloon.screenPlacePoint.y - (double)this.screenOffset.y), dimension.width, dimension.height);
        orderedBrowserBalloon.screenExtent = new Rectangle(orderedBrowserBalloon.screenRect);
        orderedBrowserBalloon.screenExtent.add(orderedGlobeBrowserBalloon.screenPlacePoint.x, orderedGlobeBrowserBalloon.screenPlacePoint.y);
        orderedBrowserBalloon.screenPickExtent = this.computeFramePickRect(orderedBrowserBalloon.screenExtent);
        orderedBrowserBalloon.webViewRect = this.computeWebViewRectForFrameRect(balloonAttributes, orderedBrowserBalloon.screenRect);
        orderedBrowserBalloon.eyeDistance = this.isAlwaysOnTop() ? 0.0 : drawContext.getView().getEyePoint().distanceTo3(orderedGlobeBrowserBalloon.placePoint);
    }

    @Override
    protected void setupDepthTest(DrawContext drawContext, AbstractBrowserBalloon.OrderedBrowserBalloon orderedBrowserBalloon) {
        OrderedGlobeBrowserBalloon orderedGlobeBrowserBalloon = (OrderedGlobeBrowserBalloon)orderedBrowserBalloon;
        GL gL = drawContext.getGL();
        if (!this.isAlwaysOnTop() && orderedGlobeBrowserBalloon.screenPlacePoint != null && drawContext.getView().getEyePosition().getElevation() < drawContext.getGlobe().getMaxElevation() * drawContext.getVerticalExaggeration()) {
            gL.glEnable(2929);
            gL.glDepthMask(false);
            double d = orderedGlobeBrowserBalloon.screenPlacePoint.z - 0.00391006472;
            d = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
            gL.glDepthFunc(513);
            gL.glDepthRange(d, d);
        } else {
            gL.glDisable(2929);
        }
    }

    @Override
    protected boolean intersectsFrustum(DrawContext drawContext, AbstractBrowserBalloon.OrderedBrowserBalloon orderedBrowserBalloon) {
        OrderedGlobeBrowserBalloon orderedGlobeBrowserBalloon = (OrderedGlobeBrowserBalloon)orderedBrowserBalloon;
        View view = drawContext.getView();
        Frustum frustum = view.getFrustumInModelCoordinates();
        if (orderedGlobeBrowserBalloon.placePoint != null && (frustum.getNear().distanceTo(orderedGlobeBrowserBalloon.placePoint) < 0.0 || frustum.getFar().distanceTo(orderedGlobeBrowserBalloon.placePoint) < 0.0)) {
            return false;
        }
        return super.intersectsFrustum(drawContext, orderedBrowserBalloon);
    }

    @Override
    protected PickedObject createPickedObject(DrawContext drawContext, Color color) {
        PickedObject pickedObject = super.createPickedObject(drawContext, color);
        pickedObject.setPosition(this.position);
        return pickedObject;
    }

    protected class OrderedGlobeBrowserBalloon
    extends AbstractBrowserBalloon.OrderedBrowserBalloon {
        protected Vec4 placePoint;
        protected Vec4 screenPlacePoint;

        protected OrderedGlobeBrowserBalloon() {
        }
    }
}

