/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.TextRenderer;
import gov.nasa.worldwind.util.OGLTextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;

public class MultiLabelPointPlacemark
extends PointPlacemark {
    ArrayList<String> subLabels = new ArrayList(4);
    Font subFont = null;
    float labelHeight = 0.0f;
    float subHeight = 0.0f;
    static HashMap<Color, Color> lightColors = new HashMap();
    static Color lastColor = null;
    static Color lastLightColor = null;

    public MultiLabelPointPlacemark(Position position) {
        super(position);
    }

    public void setSubLabelFont(Font font) {
        this.subFont = font;
    }

    public void addSubLabelText(String string) {
        this.subLabels.add(string);
    }

    public void setSubLabelText(int n, String string) {
        if (string == null) {
            this.subLabels.remove(n);
        } else {
            this.subLabels.set(n, string);
        }
    }

    public void removeAllLabels() {
        this.setLabelText(null);
        this.removeSubLabels();
    }

    public void removeSubLabels() {
        this.subLabels.clear();
    }

    public void removeSubLabelText(int n) {
        this.subLabels.remove(n);
    }

    public boolean hasLabel() {
        return this.labelText != null;
    }

    public boolean hasSubLabels() {
        return !this.subLabels.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderLabelText(DrawContext drawContext, String string, float f, float f2, Font font, Color color, Color color2) {
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
        TextRenderer textRenderer2 = null;
        if (!this.subLabels.isEmpty()) {
            if (this.subFont != null) {
                textRenderer2 = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), this.subFont);
            }
            if (this.labelHeight == 0.0f) {
                this.labelHeight = this.getLineHeight(textRenderer);
            }
            if (this.subHeight == 0.0f && this.subLabels.size() > 1) {
                this.subHeight = textRenderer2 != null ? this.getLineHeight(textRenderer2) : this.labelHeight;
            }
        }
        try {
            textRenderer.begin3DRendering();
            this.drawString(string, textRenderer, f, f2, color, color2);
            if (!this.subLabels.isEmpty() && textRenderer2 == null) {
                this.drawSubLabels(textRenderer, f, f2, color, color2);
            }
        }
        finally {
            textRenderer.end3DRendering();
        }
        if (textRenderer2 != null) {
            try {
                textRenderer2.begin3DRendering();
                this.drawSubLabels(textRenderer2, f, f2, color, color2);
            }
            finally {
                textRenderer2.end3DRendering();
            }
        }
    }

    static Color lighter(Color color) {
        int n = 127;
        int n2 = Math.min(255, color.getRed() + n);
        int n3 = Math.min(255, color.getGreen() + n);
        int n4 = Math.min(255, color.getBlue() + n);
        return new Color(n2, n3, n4);
    }

    static Color getLightColor(Color color) {
        if (color == lastColor) {
            return lastLightColor;
        }
        Color color2 = lightColors.get(color);
        if (color2 == null) {
            color2 = MultiLabelPointPlacemark.lighter(color);
            lightColors.put(color, color2);
        }
        lastColor = color;
        lastLightColor = color2;
        return color2;
    }

    protected void drawString(String string, TextRenderer textRenderer, float f, float f2, Color color, Color color2) {
        textRenderer.setColor(MultiLabelPointPlacemark.getLightColor(color));
        textRenderer.draw3D(string, f - 1.0f, f2 + 1.0f, 0.0f, 1.0f);
        textRenderer.setColor(Color.BLACK);
        textRenderer.draw3D(string, f + 1.0f, f2 - 1.0f, 0.0f, 1.0f);
        textRenderer.setColor(color);
        textRenderer.draw3D(string, f, f2, 0.0f, 1.0f);
    }

    protected void drawSubLabels(TextRenderer textRenderer, float f, float f2, Color color, Color color2) {
        f2 -= this.labelHeight;
        try {
            for (int i = 0; i < this.subLabels.size(); ++i) {
                String string = this.subLabels.get(i);
                this.drawString(string, textRenderer, f, f2, color, color2);
                f2 -= this.subHeight;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected float getLineHeight(TextRenderer textRenderer) {
        Rectangle2D rectangle2D = textRenderer.getFont().getMaxCharBounds(textRenderer.getFontRenderContext());
        return (float)rectangle2D.getHeight();
    }
}

