/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallbackAdapter;
import java.nio.IntBuffer;

public class PolygonTessellator {
    protected boolean enabled = true;
    protected GLUtessellator tess;
    protected IntBuffer interiorIndices;
    protected IntBuffer boundaryIndices;
    protected boolean isBoundaryEdge;
    protected double[] vertexCoord = new double[3];

    public PolygonTessellator() {
        this.tess = GLU.gluNewTess();
        TessCallbackAdapter tessCallbackAdapter = new TessCallbackAdapter();
        GLU.gluTessCallback(this.tess, 100106, tessCallbackAdapter);
        GLU.gluTessCallback(this.tess, 100110, tessCallbackAdapter);
        GLU.gluTessCallback(this.tess, 100107, tessCallbackAdapter);
        GLU.gluTessCallback(this.tess, 100108, tessCallbackAdapter);
        GLU.gluTessCallback(this.tess, 100111, tessCallbackAdapter);
        this.interiorIndices = IntBuffer.allocate(10);
        this.boundaryIndices = IntBuffer.allocate(10);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public IntBuffer getInteriorIndices() {
        return this.interiorIndices;
    }

    public IntBuffer getBoundaryIndices() {
        return this.boundaryIndices;
    }

    public void reset() {
        if (!this.enabled) {
            return;
        }
        this.interiorIndices.clear();
        this.boundaryIndices.clear();
    }

    public void setPolygonNormal(double d, double d2, double d3) {
        if (!this.enabled) {
            return;
        }
        GLU.gluTessNormal(this.tess, d, d2, d3);
    }

    public void beginPolygon() {
        if (!this.enabled) {
            return;
        }
        GLU.gluTessBeginPolygon(this.tess, this);
    }

    public void beginContour() {
        if (!this.enabled) {
            return;
        }
        GLU.gluTessBeginContour(this.tess);
    }

    public void addVertex(double d, double d2, double d3, int n) {
        if (!this.enabled) {
            return;
        }
        this.vertexCoord[0] = d;
        this.vertexCoord[1] = d2;
        this.vertexCoord[2] = d3;
        GLU.gluTessVertex(this.tess, this.vertexCoord, 0, n);
    }

    public void endContour() {
        if (!this.enabled) {
            return;
        }
        GLU.gluTessEndContour(this.tess);
    }

    public void endPolygon() {
        if (!this.enabled) {
            return;
        }
        GLU.gluTessEndPolygon(this.tess);
    }

    protected void tessBegin(int n) {
    }

    protected void tessEdgeFlag(boolean bl) {
        this.isBoundaryEdge = bl;
    }

    protected void tessVertex(Object object) {
        int n = (Integer)object;
        this.interiorIndices = this.addIndex(this.interiorIndices, n);
        if (this.boundaryIndices.position() % 2 == 1) {
            this.boundaryIndices = this.addIndex(this.boundaryIndices, n);
        }
        if (this.isBoundaryEdge) {
            this.boundaryIndices = this.addIndex(this.boundaryIndices, n);
            int n2 = this.interiorIndices.position();
            if (n2 > 0 && n2 % 3 == 0) {
                int n3 = this.interiorIndices.get(n2 - 3);
                this.boundaryIndices = this.addIndex(this.boundaryIndices, n3);
            }
        }
    }

    protected void tessEnd() {
    }

    protected void tessCombine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
    }

    protected IntBuffer addIndex(IntBuffer intBuffer, int n) {
        if (!intBuffer.hasRemaining()) {
            int n2 = intBuffer.capacity() + intBuffer.capacity() / 2;
            IntBuffer intBuffer2 = IntBuffer.allocate(n2);
            intBuffer2.put(intBuffer.flip());
            return intBuffer2.put(n);
        }
        return intBuffer.put(n);
    }

    protected static class TessCallbackAdapter
    extends GLUtessellatorCallbackAdapter {
        protected TessCallbackAdapter() {
        }

        @Override
        public void beginData(int n, Object object) {
            ((PolygonTessellator)object).tessBegin(n);
        }

        @Override
        public void edgeFlagData(boolean bl, Object object) {
            ((PolygonTessellator)object).tessEdgeFlag(bl);
        }

        @Override
        public void vertexData(Object object, Object object2) {
            ((PolygonTessellator)object2).tessVertex(object);
        }

        @Override
        public void endData(Object object) {
            ((PolygonTessellator)object).tessEnd();
        }

        @Override
        public void combineData(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2, Object object) {
            ((PolygonTessellator)object).tessCombine(dArray, objectArray, fArray, objectArray2);
        }
    }
}

