/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.Restorable;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.drag.DragContext;
import gov.nasa.worldwind.drag.Draggable;
import gov.nasa.worldwind.drag.DraggableSupport;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.ExtentHolder;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.MeasurableLength;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Highlightable;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.measure.LengthMeasurer;
import java.awt.Color;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Polyline
extends AVListImpl
implements Renderable,
OrderedRenderable,
Movable,
Restorable,
MeasurableLength,
ExtentHolder,
PreRenderable,
Highlightable,
Draggable {
    public static final int GREAT_CIRCLE = 0;
    public static final int LINEAR = 1;
    public static final int RHUMB_LINE = 2;
    public static final int LOXODROME = 2;
    public static final int ANTIALIAS_DONT_CARE = 4352;
    public static final int ANTIALIAS_FASTEST = 4353;
    public static final int ANTIALIAS_NICEST = 4354;
    protected ArrayList<Position> positions;
    protected Vec4 referenceCenterPoint;
    protected int antiAliasHint = 4353;
    protected Color color = Color.WHITE;
    protected double lineWidth = 1.0;
    protected boolean filled = false;
    protected boolean closed = false;
    protected boolean followTerrain = false;
    protected double offset = 0.0;
    protected double terrainConformance = 10.0;
    protected int pathType = 0;
    protected List<List<Vec4>> currentSpans;
    protected short stipplePattern = (short)-21846;
    protected int stippleFactor = 0;
    protected int numSubsegments = 10;
    protected boolean highlighted = false;
    protected boolean dragEnabled = true;
    protected DraggableSupport draggableSupport = null;
    protected Color highlightColor = new Color(1.0f, 1.0f, 1.0f, 0.5f);
    protected Object delegateOwner;
    protected LengthMeasurer measurer = new LengthMeasurer();
    protected long geomGenTimeStamp = -9223372036854775807L;
    protected double geomGenVE = 1.0;
    protected double eyeDistance;
    protected PickSupport pickSupport = new PickSupport();
    protected long frameNumber = -1L;
    protected Layer pickLayer;
    protected SurfaceShape surfaceShape;
    protected HashMap<Globe, ExtentInfo> extents = new HashMap(2);

    public Polyline() {
        this.setPositions(null);
        this.measurer.setFollowTerrain(this.followTerrain);
        this.measurer.setPathType(this.pathType);
    }

    public Polyline(Iterable<? extends Position> iterable) {
        this.setPositions(iterable);
        this.measurer.setFollowTerrain(this.followTerrain);
        this.measurer.setPathType(this.pathType);
    }

    public Polyline(Iterable<? extends LatLon> iterable, double d) {
        this.setPositions(iterable, d);
        this.measurer.setFollowTerrain(this.followTerrain);
        this.measurer.setPathType(this.pathType);
    }

    private void reset() {
        if (this.currentSpans != null) {
            this.currentSpans.clear();
        }
        this.currentSpans = null;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
        if (this.surfaceShape != null) {
            ShapeAttributes shapeAttributes = this.surfaceShape.getAttributes();
            shapeAttributes.setOutlineMaterial(new Material(this.color));
            shapeAttributes.setOutlineOpacity((double)this.color.getAlpha() / 255.0);
            shapeAttributes.setInteriorMaterial(shapeAttributes.getOutlineMaterial());
            shapeAttributes.setInteriorOpacity(shapeAttributes.getOutlineOpacity());
        }
    }

    public int getAntiAliasHint() {
        return this.antiAliasHint;
    }

    public void setAntiAliasHint(int n) {
        if (n != 4352 && n != 4353 && n != 4354) {
            String string = Logging.getMessage("generic.InvalidHint");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.antiAliasHint = n;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean bl) {
        if (this.surfaceShape != null && bl != this.filled) {
            this.surfaceShape = bl ? new SurfacePolygon(this.getPositions()) : new SurfacePolyline(this.getPositions());
            this.setSurfaceShapeAttributes();
        }
        this.filled = bl;
    }

    public int getPathType() {
        return this.pathType;
    }

    public String getPathTypeString() {
        return this.getPathType() == 0 ? "gov.nasa.worldwind.avkey.GreatCircle" : (this.getPathType() == 2 ? "gov.nasa.worldwind.avkey.RhumbLine" : "gov.nasa.worldwind.avkey.Linear");
    }

    public void setPathType(int n) {
        this.reset();
        this.pathType = n;
        this.measurer.setPathType(n);
        if (this.surfaceShape != null) {
            this.surfaceShape.setPathType(this.pathType == 0 ? "gov.nasa.worldwind.avkey.GreatCircle" : (n == 2 ? "gov.nasa.worldwind.avkey.RhumbLine" : "gov.nasa.worldwind.avkey.Linear"));
        }
    }

    public void setPathType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathTypeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.setPathType(string.equals("gov.nasa.worldwind.avkey.GreatCircle") ? 0 : (string.equals("gov.nasa.worldwind.avkey.RhumbLine") || string.equals("gov.nasa.worldwind.avkey.Loxodrome") ? 2 : 1));
    }

    public boolean isFollowTerrain() {
        return this.followTerrain;
    }

    public void setFollowTerrain(boolean bl) {
        this.reset();
        this.followTerrain = bl;
        this.measurer.setFollowTerrain(bl);
        this.extents.clear();
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double d) {
        this.reset();
        this.offset = d;
        this.extents.clear();
    }

    public double getTerrainConformance() {
        return this.terrainConformance;
    }

    public void setTerrainConformance(double d) {
        this.terrainConformance = d;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double d) {
        this.lineWidth = d;
        if (this.surfaceShape != null) {
            this.surfaceShape.getAttributes().setOutlineWidth(this.getLineWidth());
        }
    }

    public double getLength() {
        Iterator<ExtentInfo> iterator = this.extents.values().iterator();
        return iterator.hasNext() ? this.measurer.getLength(iterator.next().globe) : 0.0;
    }

    @Override
    public double getLength(Globe globe) {
        return this.measurer.getLength(globe);
    }

    public LengthMeasurer getMeasurer() {
        return this.measurer;
    }

    public short getStipplePattern() {
        return this.stipplePattern;
    }

    public void setStipplePattern(short s) {
        this.stipplePattern = s;
        if (this.surfaceShape != null) {
            this.surfaceShape.getAttributes().setOutlineStipplePattern(this.stipplePattern);
        }
    }

    public int getStippleFactor() {
        return this.stippleFactor;
    }

    public void setStippleFactor(int n) {
        this.stippleFactor = n;
        if (this.surfaceShape != null) {
            this.surfaceShape.getAttributes().setOutlineStippleFactor(this.stippleFactor);
        }
    }

    public int getNumSubsegments() {
        return this.numSubsegments;
    }

    public void setNumSubsegments(int n) {
        this.reset();
        this.numSubsegments = n;
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.highlightColor = color;
        if (this.surfaceShape != null) {
            this.surfaceShape.getHighlightAttributes().setOutlineMaterial(new Material(this.highlightColor));
        }
    }

    public void setPositions(Iterable<? extends Position> iterable) {
        this.reset();
        this.positions = new ArrayList();
        this.extents.clear();
        if (iterable != null) {
            for (Position position : iterable) {
                this.positions.add(position);
            }
            this.measurer.setPositions(this.positions);
            if (this.surfaceShape != null) {
                this.setSurfaceShapeLocations();
            }
        }
        if (this.filled && this.positions.size() < 3) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    public void setPositions(Iterable<? extends LatLon> iterable, double d) {
        this.reset();
        this.positions = new ArrayList();
        this.extents.clear();
        if (iterable != null) {
            for (LatLon latLon : iterable) {
                this.positions.add(new Position(latLon, d));
            }
            this.measurer.setPositions(this.positions);
            if (this.surfaceShape != null) {
                this.setSurfaceShapeLocations();
            }
        }
        if (this.filled && this.positions.size() < 3) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    public Iterable<Position> getPositions() {
        return this.positions;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean bl) {
        this.closed = bl;
    }

    public Object getDelegateOwner() {
        return this.delegateOwner;
    }

    public void setDelegateOwner(Object object) {
        this.delegateOwner = object;
    }

    @Override
    public Extent getExtent(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computeExtent(globe, d);
    }

    public Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ExtentInfo extentInfo = this.extents.get(drawContext.getGlobe());
        if (extentInfo != null && extentInfo.isValid(drawContext)) {
            return extentInfo.extent;
        }
        extentInfo = new ExtentInfo(this.computeExtent(drawContext), drawContext);
        this.extents.put(drawContext.getGlobe(), extentInfo);
        return extentInfo.extent;
    }

    protected Extent computeExtent(Globe globe, double d) {
        Sector sector = Sector.boundingSector(this.getPositions());
        double[] dArray = this.isFollowTerrain() ? globe.getMinAndMaxElevations(sector) : Polyline.computeElevationExtremes(this.getPositions());
        dArray[0] = dArray[0] + this.getOffset();
        dArray[1] = dArray[1] + this.getOffset();
        return Sector.computeBoundingBox(globe, d, sector, dArray[0], dArray[1]);
    }

    protected Extent computeExtent(DrawContext drawContext) {
        return this.computeExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
    }

    protected static double[] computeElevationExtremes(Iterable<? extends Position> iterable) {
        double[] dArray = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        for (Position position : iterable) {
            if (dArray[0] > position.getElevation()) {
                dArray[0] = position.getElevation();
            }
            if (!(dArray[1] < position.getElevation())) continue;
            dArray[1] = position.getElevation();
        }
        return dArray;
    }

    @Override
    public double getDistanceFromEye() {
        return this.eyeDistance;
    }

    protected void setSurfaceShapeAttributes() {
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setOutlineMaterial(new Material(this.color));
        basicShapeAttributes.setOutlineOpacity((double)this.color.getAlpha() / 255.0);
        basicShapeAttributes.setInteriorMaterial(basicShapeAttributes.getOutlineMaterial());
        basicShapeAttributes.setInteriorOpacity(basicShapeAttributes.getOutlineOpacity());
        basicShapeAttributes.setOutlineWidth(this.getLineWidth());
        basicShapeAttributes.setOutlineStipplePattern(this.stipplePattern);
        basicShapeAttributes.setOutlineStippleFactor(this.stippleFactor);
        this.surfaceShape.setAttributes(basicShapeAttributes);
        basicShapeAttributes = new BasicShapeAttributes(basicShapeAttributes);
        basicShapeAttributes.setOutlineMaterial(new Material(this.highlightColor));
        basicShapeAttributes.setInteriorMaterial(basicShapeAttributes.getOutlineMaterial());
        this.surfaceShape.setHighlightAttributes(basicShapeAttributes);
    }

    protected void setSurfaceShapeLocations() {
        Iterable<Position> iterable;
        if (!this.isClosed()) {
            iterable = this.getPositions();
        } else {
            ArrayList<Position> arrayList = new ArrayList<Position>();
            Position position = null;
            for (Position position2 : this.getPositions()) {
                arrayList.add(position2);
                if (position != null) continue;
                position = position2;
            }
            arrayList.add(position);
            iterable = arrayList;
        }
        if (this.isFilled()) {
            ((SurfacePolygon)this.surfaceShape).setLocations(iterable);
        } else {
            ((SurfacePolyline)this.surfaceShape).setLocations(iterable);
        }
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (drawContext.is2DGlobe()) {
            if (this.surfaceShape == null) {
                this.surfaceShape = this.isFilled() ? new SurfacePolygon() : new SurfacePolyline();
                this.setSurfaceShapeLocations();
                this.setSurfaceShapeAttributes();
                this.surfaceShape.setPathType(this.pathType == 0 ? "gov.nasa.worldwind.avkey.GreatCircle" : (this.pathType == 2 ? "gov.nasa.worldwind.avkey.RhumbLine" : "gov.nasa.worldwind.avkey.Linear"));
            }
            this.surfaceShape.setHighlighted(this.isHighlighted());
            Object object = this.getDelegateOwner();
            this.surfaceShape.setDelegateOwner(object != null ? object : this);
            this.surfaceShape.preRender(drawContext);
        }
    }

    @Override
    public void pick(DrawContext drawContext, Point point) {
        this.pickSupport.clearPickList();
        try {
            this.pickSupport.beginPicking(drawContext);
            this.render(drawContext);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, point, this.pickLayer);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getSurfaceGeometry() == null) {
            return;
        }
        if (drawContext.is2DGlobe() && this.surfaceShape != null) {
            this.surfaceShape.render(drawContext);
            return;
        }
        this.draw(drawContext);
    }

    protected void draw(DrawContext drawContext) {
        if (drawContext.isOrderedRenderingMode()) {
            this.drawOrderedRenderable(drawContext);
            return;
        }
        if (this.positions.size() < 2) {
            return;
        }
        if (this.currentSpans == null || this.followTerrain && this.geomGenTimeStamp != drawContext.getFrameTimeStamp() || this.geomGenVE != drawContext.getVerticalExaggeration()) {
            this.computeReferenceCenter(drawContext);
            this.eyeDistance = this.referenceCenterPoint.distanceTo3(drawContext.getView().getEyePoint());
            this.makeVertices(drawContext);
            this.geomGenTimeStamp = drawContext.getFrameTimeStamp();
            this.geomGenVE = drawContext.getVerticalExaggeration();
        }
        if (this.currentSpans == null || this.currentSpans.size() < 1) {
            return;
        }
        if (this.intersectsFrustum(drawContext)) {
            if (drawContext.isPickingMode()) {
                this.pickLayer = drawContext.getCurrentLayer();
            }
            drawContext.addOrderedRenderable(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawOrderedRenderable(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        int n = 32773;
        if (!drawContext.isPickingMode() && this.color.getAlpha() != 255) {
            n |= 0x4000;
        }
        gL2.glPushAttrib(n);
        drawContext.getView().pushReferenceCenter(drawContext, this.referenceCenterPoint);
        boolean bl = false;
        try {
            if (!drawContext.isPickingMode()) {
                if (this.color.getAlpha() != 255) {
                    gL2.glEnable(3042);
                    gL2.glBlendFunc(770, 771);
                }
                gL2.glColor4ub((byte)this.color.getRed(), (byte)this.color.getGreen(), (byte)this.color.getBlue(), (byte)this.color.getAlpha());
            } else {
                Color color = drawContext.getUniquePickColor();
                Object object = this.getDelegateOwner() != null ? this.getDelegateOwner() : this;
                this.pickSupport.addPickableObject(color.getRGB(), object, null);
                gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
            }
            if (this.stippleFactor > 0) {
                gL2.glEnable(2852);
                gL2.glLineStipple(this.stippleFactor, this.stipplePattern);
            } else {
                gL2.glDisable(2852);
            }
            int n2 = 3154;
            if (this.filled) {
                n2 = 3155;
            }
            gL2.glHint(n2, this.antiAliasHint);
            int n3 = 3;
            if (this.filled) {
                n3 = 9;
            }
            if (drawContext.isPickingMode()) {
                gL2.glLineWidth((float)this.getLineWidth() + 8.0f);
            } else {
                gL2.glLineWidth((float)this.getLineWidth());
            }
            if (this.followTerrain) {
                drawContext.pushProjectionOffest(0.99);
                bl = true;
            }
            if (this.currentSpans == null) {
                return;
            }
            for (List<Vec4> list : this.currentSpans) {
                if (list == null) continue;
                gL2.glBegin(n3);
                for (Vec4 vec4 : list) {
                    gL2.glVertex3d(vec4.x, vec4.y, vec4.z);
                }
                gL2.glEnd();
            }
            if (this.isHighlighted() && !drawContext.isPickingMode()) {
                if (this.highlightColor.getAlpha() != 255) {
                    gL2.glEnable(3042);
                    gL2.glBlendFunc(770, 771);
                }
                gL2.glColor4ub((byte)this.highlightColor.getRed(), (byte)this.highlightColor.getGreen(), (byte)this.highlightColor.getBlue(), (byte)this.highlightColor.getAlpha());
                gL2.glLineWidth((float)this.getLineWidth() + 2.0f);
                for (List<Vec4> list : this.currentSpans) {
                    if (list == null) continue;
                    gL2.glBegin(n3);
                    for (Vec4 vec4 : list) {
                        gL2.glVertex3d(vec4.x, vec4.y, vec4.z);
                    }
                    gL2.glEnd();
                }
            }
        }
        finally {
            if (bl) {
                drawContext.popProjectionOffest();
            }
            gL2.glPopAttrib();
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }

    protected boolean intersectsFrustum(DrawContext drawContext) {
        Extent extent = this.getExtent(drawContext);
        if (extent == null) {
            return true;
        }
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(extent);
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersects(extent);
    }

    protected void makeVertices(DrawContext drawContext) {
        if (this.currentSpans == null) {
            this.currentSpans = new ArrayList<List<Vec4>>();
        } else {
            this.currentSpans.clear();
        }
        if (this.positions.size() < 1) {
            return;
        }
        Position position = this.positions.get(0);
        Vec4 vec4 = this.computePoint(drawContext, position, true);
        for (int i = 1; i <= this.positions.size(); ++i) {
            Position position2;
            if (i < this.positions.size()) {
                position2 = this.positions.get(i);
            } else {
                if (!this.closed) break;
                position2 = this.positions.get(0);
            }
            Vec4 vec42 = this.computePoint(drawContext, position2, true);
            if (this.followTerrain && !this.isSegmentVisible(drawContext, position, position2, vec4, vec42)) {
                position = position2;
                vec4 = vec42;
                continue;
            }
            ArrayList<Vec4> arrayList = this.makeSegment(drawContext, position, position2, vec4, vec42);
            if (arrayList != null) {
                this.addSpan(arrayList);
            }
            position = position2;
            vec4 = vec42;
        }
    }

    protected void addSpan(ArrayList<Vec4> arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            this.currentSpans.add(arrayList);
        }
    }

    protected boolean isSegmentVisible(DrawContext drawContext, Position position, Position position2, Vec4 vec4, Vec4 vec42) {
        Frustum frustum = drawContext.getView().getFrustumInModelCoordinates();
        if (frustum.contains(vec4)) {
            return true;
        }
        if (frustum.contains(vec42)) {
            return true;
        }
        if (vec4.equals(vec42)) {
            return false;
        }
        Position position3 = Position.interpolateRhumb(0.5, position, position2);
        Vec4 vec43 = this.computePoint(drawContext, position3, true);
        if (frustum.contains(vec43)) {
            return true;
        }
        double d = Line.distanceToSegment(vec4, vec42, vec43);
        Cylinder cylinder = new Cylinder(vec4, vec42, d == 0.0 ? 1.0 : d);
        return cylinder.intersects(drawContext.getView().getFrustumInModelCoordinates());
    }

    protected Vec4 computePoint(DrawContext drawContext, Position position, boolean bl) {
        if (this.followTerrain) {
            double d = !bl ? 0.0 : this.offset;
            return drawContext.computeTerrainPoint(position.getLatitude(), position.getLongitude(), d);
        }
        double d = position.getElevation() + (bl ? this.offset : 0.0);
        return drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), d * drawContext.getVerticalExaggeration());
    }

    protected double computeSegmentLength(DrawContext drawContext, Position position, Position position2) {
        LatLon latLon = new LatLon(position.getLatitude(), position.getLongitude());
        LatLon latLon2 = new LatLon(position2.getLatitude(), position2.getLongitude());
        Angle angle = LatLon.greatCircleDistance(latLon, latLon2);
        if (this.followTerrain) {
            return angle.radians * (drawContext.getGlobe().getRadius() + this.offset * drawContext.getVerticalExaggeration());
        }
        double d = this.offset + 0.5 * (position.getElevation() + position2.getElevation());
        return angle.radians * (drawContext.getGlobe().getRadius() + d * drawContext.getVerticalExaggeration());
    }

    protected ArrayList<Vec4> makeSegment(DrawContext drawContext, Position position, Position position2, Vec4 vec4, Vec4 vec42) {
        ArrayList<Vec4> arrayList = null;
        double d = this.computeSegmentLength(drawContext, position, position2);
        if (d <= 0.0) {
            arrayList = this.addPointToSpan(vec4, arrayList);
            if (!vec4.equals(vec42)) {
                arrayList = this.addPointToSpan(vec42, arrayList);
            }
            return arrayList;
        }
        Angle angle = null;
        Angle angle2 = null;
        double d2 = 0.0;
        double d3 = 0.0;
        while (d2 < 1.0) {
            LatLon latLon;
            Angle angle3;
            Position position3;
            d3 = this.followTerrain ? (d3 += this.terrainConformance * drawContext.getView().computePixelSizeAtDistance(vec4.distanceTo3(drawContext.getView().getEyePoint()))) : (d3 += d / (double)this.numSubsegments);
            d2 = d3 / d;
            if (d2 >= 1.0) {
                position3 = position2;
            } else if (this.pathType == 1) {
                if (angle == null) {
                    angle = LatLon.linearAzimuth(position, position2);
                    angle2 = LatLon.linearDistance(position, position2);
                }
                angle3 = Angle.fromRadians(d2 * angle2.radians);
                latLon = LatLon.linearEndPosition(position, angle, angle3);
                position3 = new Position(latLon, (1.0 - d2) * position.getElevation() + d2 * position2.getElevation());
            } else if (this.pathType == 2) {
                if (angle == null) {
                    angle = LatLon.rhumbAzimuth(position, position2);
                    angle2 = LatLon.rhumbDistance(position, position2);
                }
                angle3 = Angle.fromRadians(d2 * angle2.radians);
                latLon = LatLon.rhumbEndPosition((LatLon)position, angle, angle3);
                position3 = new Position(latLon, (1.0 - d2) * position.getElevation() + d2 * position2.getElevation());
            } else {
                if (angle == null) {
                    angle = LatLon.greatCircleAzimuth(position, position2);
                    angle2 = LatLon.greatCircleDistance(position, position2);
                }
                angle3 = Angle.fromRadians(d2 * angle2.radians);
                latLon = LatLon.greatCircleEndPosition((LatLon)position, angle, angle3);
                position3 = new Position(latLon, (1.0 - d2) * position.getElevation() + d2 * position2.getElevation());
            }
            vec42 = this.computePoint(drawContext, position3, true);
            arrayList = this.clipAndAdd(drawContext, vec4, vec42, arrayList);
            vec4 = vec42;
        }
        return arrayList;
    }

    protected ArrayList<Vec4> clipAndAdd(DrawContext drawContext, Vec4 vec4, Vec4 vec42, ArrayList<Vec4> arrayList) {
        if (arrayList == null) {
            arrayList = this.addPointToSpan(vec4, arrayList);
        }
        return this.addPointToSpan(vec42, arrayList);
    }

    protected ArrayList<Vec4> addPointToSpan(Vec4 vec4, ArrayList<Vec4> arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.add(vec4.subtract3(this.referenceCenterPoint));
        return arrayList;
    }

    protected void computeReferenceCenter(DrawContext drawContext) {
        Position position = this.getReferencePosition();
        if (position == null) {
            return;
        }
        this.referenceCenterPoint = drawContext.computeTerrainPoint(position.getLatitude(), position.getLongitude(), this.offset);
    }

    @Override
    public Position getReferencePosition() {
        if (this.positions.size() < 1) {
            return null;
        }
        if (this.positions.size() < 3) {
            return this.positions.get(0);
        }
        return this.positions.get(this.positions.size() / 2);
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.moveTo(position2.add(position));
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.reset();
        this.extents.clear();
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        double d = position.getElevation() - position2.getElevation();
        for (int i = 0; i < this.positions.size(); ++i) {
            Position position3 = this.positions.get(i);
            Angle angle = LatLon.greatCircleDistance(position2, position3);
            Angle angle2 = LatLon.greatCircleAzimuth(position2, position3);
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, angle2, angle);
            double d2 = position3.getElevation() + d;
            this.positions.set(i, new Position(latLon, d2));
        }
    }

    @Override
    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    @Override
    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    @Override
    public void drag(DragContext dragContext) {
        if (!this.dragEnabled) {
            return;
        }
        if (this.draggableSupport == null) {
            this.draggableSupport = new DraggableSupport(this, this.isFollowTerrain() ? 2 : 0);
        }
        this.doDrag(dragContext);
    }

    protected void doDrag(DragContext dragContext) {
        this.draggableSupport.dragGlobeSizeConstant(dragContext);
    }

    @Override
    public String getRestorableState() {
        Object object;
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        if (this.color != null && (object = RestorableSupport.encodeColor(this.color)) != null) {
            restorableSupport.addStateValueAsString("color", (String)object);
        }
        if (this.highlightColor != null && (object = RestorableSupport.encodeColor(this.highlightColor)) != null) {
            restorableSupport.addStateValueAsString("highlightColor", (String)object);
        }
        if (this.positions != null && (object = restorableSupport.addStateObject("positions")) != null) {
            for (Position object2 : this.positions) {
                RestorableSupport.StateObject stateObject;
                if (object2 == null || object2.getLatitude() == null || object2.getLongitude() == null || (stateObject = restorableSupport.addStateObject((RestorableSupport.StateObject)object, "position")) == null) continue;
                restorableSupport.addStateValueAsDouble(stateObject, "latitudeDegrees", object2.getLatitude().degrees);
                restorableSupport.addStateValueAsDouble(stateObject, "longitudeDegrees", object2.getLongitude().degrees);
                restorableSupport.addStateValueAsDouble(stateObject, "elevation", object2.getElevation());
            }
        }
        restorableSupport.addStateValueAsInteger("antiAliasHint", this.antiAliasHint);
        restorableSupport.addStateValueAsBoolean("filled", this.filled);
        restorableSupport.addStateValueAsBoolean("closed", this.closed);
        restorableSupport.addStateValueAsBoolean("highlighted", this.isHighlighted());
        restorableSupport.addStateValueAsInteger("pathType", this.pathType);
        restorableSupport.addStateValueAsBoolean("followTerrain", this.followTerrain);
        restorableSupport.addStateValueAsDouble("offset", this.offset);
        restorableSupport.addStateValueAsDouble("terrainConformance", this.terrainConformance);
        restorableSupport.addStateValueAsDouble("lineWidth", this.getLineWidth());
        restorableSupport.addStateValueAsInteger("stipplePattern", this.stipplePattern);
        restorableSupport.addStateValueAsInteger("stippleFactor", this.stippleFactor);
        restorableSupport.addStateValueAsInteger("numSubsegments", this.numSubsegments);
        object = restorableSupport.addStateObject(null, "avlist");
        for (Map.Entry entry : this.getEntries()) {
            this.getRestorableStateForAVPair((String)entry.getKey(), entry.getValue() != null ? entry.getValue() : "", restorableSupport, (RestorableSupport.StateObject)object);
        }
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport.StateObject[] stateObjectArray;
        RestorableSupport.StateObject stateObject;
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Boolean bl;
        Double d;
        Double d2;
        Double d3;
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        String string4 = restorableSupport.getStateValueAsString("color");
        if (string4 != null && (object4 = RestorableSupport.decodeColor(string4)) != null) {
            this.setColor((Color)object4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("highlightColor")) != null && (object4 = RestorableSupport.decodeColor(string4)) != null) {
            this.setHighlightColor((Color)object4);
        }
        if ((object4 = restorableSupport.getStateObject("positions")) != null) {
            serializable = new ArrayList();
            object3 = restorableSupport.getAllStateObjects((RestorableSupport.StateObject)object4, "position");
            if (object3 != null && ((RestorableSupport.StateObject[])object3).length != 0) {
                object2 = object3;
                int n5 = ((Object)object2).length;
                for (int i = 0; i < n5; ++i) {
                    object = object2[i];
                    if (object == null) continue;
                    d3 = restorableSupport.getStateValueAsDouble((RestorableSupport.StateObject)object, "latitudeDegrees");
                    d2 = restorableSupport.getStateValueAsDouble((RestorableSupport.StateObject)object, "longitudeDegrees");
                    d = restorableSupport.getStateValueAsDouble((RestorableSupport.StateObject)object, "elevation");
                    if (d3 == null || d2 == null || d == null) continue;
                    ((ArrayList)serializable).add(Position.fromDegrees(d3, d2, d));
                }
            }
            this.setPositions((Iterable<? extends Position>)((Object)serializable));
        }
        if ((serializable = restorableSupport.getStateValueAsInteger("antiAliasHint")) != null) {
            this.setAntiAliasHint((Integer)serializable);
        }
        if ((object3 = restorableSupport.getStateValueAsBoolean("filled")) != null) {
            this.setFilled((Boolean)object3);
        }
        if ((object2 = restorableSupport.getStateValueAsBoolean("closed")) != null) {
            this.setClosed((Boolean)object2);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean("highlighted")) != null) {
            this.setHighlighted(bl);
        }
        if ((n4 = restorableSupport.getStateValueAsInteger("pathType")) != null) {
            this.setPathType(n4);
        }
        if ((object = restorableSupport.getStateValueAsBoolean("followTerrain")) != null) {
            this.setFollowTerrain((Boolean)object);
        }
        if ((d3 = restorableSupport.getStateValueAsDouble("offset")) != null) {
            this.setOffset(d3);
        }
        if ((d2 = restorableSupport.getStateValueAsDouble("terrainConformance")) != null) {
            this.setTerrainConformance(d2);
        }
        if ((d = restorableSupport.getStateValueAsDouble("lineWidth")) != null) {
            this.setLineWidth(d);
        }
        if ((n3 = restorableSupport.getStateValueAsInteger("stipplePattern")) != null) {
            this.setStipplePattern(n3.shortValue());
        }
        if ((n2 = restorableSupport.getStateValueAsInteger("stippleFactor")) != null) {
            this.setStippleFactor(n2);
        }
        if ((n = restorableSupport.getStateValueAsInteger("numSubsegments")) != null) {
            this.setNumSubsegments(n);
        }
        if ((stateObject = restorableSupport.getStateObject(null, "avlist")) != null && (stateObjectArray = restorableSupport.getAllStateObjects(stateObject, "")) != null) {
            for (RestorableSupport.StateObject stateObject2 : stateObjectArray) {
                if (stateObject2 == null) continue;
                this.setValue(stateObject2.getName(), stateObject2.getValue());
            }
        }
    }

    protected static class ExtentInfo {
        protected Extent extent;
        protected double verticalExaggeration;
        protected Globe globe;
        protected Object globeStateKey;

        public ExtentInfo(Extent extent, DrawContext drawContext) {
            this.extent = extent;
            this.verticalExaggeration = drawContext.getVerticalExaggeration();
            this.globe = drawContext.getGlobe();
            this.globeStateKey = drawContext.getGlobe().getStateKey(drawContext);
        }

        protected boolean isValid(DrawContext drawContext) {
            return this.verticalExaggeration == drawContext.getVerticalExaggeration() && this.globe == drawContext.getGlobe() && this.globeStateKey.equals(drawContext.getGlobe().getStateKey(drawContext));
        }
    }
}

