/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import java.nio.IntBuffer;

public class PolylineTessellator {
    protected IntBuffer indices = IntBuffer.allocate(10);
    protected int lastIndex = -1;

    public IntBuffer getIndices() {
        return this.indices;
    }

    public void reset() {
        this.indices.clear();
    }

    public void beginPolyline() {
        this.lastIndex = -1;
    }

    public void endPolyline() {
        this.lastIndex = -1;
    }

    public void addVertex(double d, double d2, double d3, int n) {
        if (this.lastIndex >= 0) {
            this.indices = this.addIndex(this.indices, this.lastIndex);
            this.indices = this.addIndex(this.indices, n);
        }
        this.lastIndex = n;
    }

    protected IntBuffer addIndex(IntBuffer intBuffer, int n) {
        if (!intBuffer.hasRemaining()) {
            int n2 = intBuffer.capacity() + intBuffer.capacity() / 2;
            IntBuffer intBuffer2 = IntBuffer.allocate(n2);
            intBuffer2.put(intBuffer.flip());
            return intBuffer2.put(n);
        }
        return intBuffer.put(n);
    }
}

