/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Dimension;

public class Size {
    public static final String NATIVE_DIMENSION = "gov.nasa.worldwind.render.Size.NativeDimension";
    public static final String MAINTAIN_ASPECT_RATIO = "gov.nasa.worldwind.render.Size.MaintainAspectRatio";
    public static final String EXPLICIT_DIMENSION = "gov.nasa.worldwind.render.Size.ExplicitDimension";
    protected String widthMode = "gov.nasa.worldwind.render.Size.NativeDimension";
    protected String widthUnits = "gov.nasa.worldwind.avkey.Pixels";
    protected double widthParam;
    protected String heightMode = "gov.nasa.worldwind.render.Size.NativeDimension";
    protected String heightUnits = "gov.nasa.worldwind.avkey.Pixels";
    protected double heightParam;

    public Size() {
    }

    public Size(String string, double d, String string2, String string3, double d2, String string4) {
        this.setWidth(string, d, string2);
        this.setHeight(string3, d2, string4);
    }

    public static Size fromPixels(int n, int n2) {
        return new Size(EXPLICIT_DIMENSION, n, "gov.nasa.worldwind.avkey.Pixels", EXPLICIT_DIMENSION, n2, "gov.nasa.worldwind.avkey.Pixels");
    }

    public static Size fromFraction(double d, double d2) {
        return new Size(EXPLICIT_DIMENSION, d, "gov.nasa.worldwind.avkey.Fraction", EXPLICIT_DIMENSION, d2, "gov.nasa.worldwind.avkey.Fraction");
    }

    public void setWidth(String string, double d, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.SizeModeIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.widthMode = string;
        this.widthParam = d;
        this.widthUnits = string2;
    }

    public void setHeight(String string, double d, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.SizeModeIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.heightMode = string;
        this.heightParam = d;
        this.heightUnits = string2;
    }

    public String getWidthUnits() {
        return this.widthUnits;
    }

    public String getHeightUnits() {
        return this.heightUnits;
    }

    public String getWidthMode() {
        return this.widthMode;
    }

    public String getHeightMode() {
        return this.heightMode;
    }

    public double getWidth() {
        return this.widthParam;
    }

    public double getHeight() {
        return this.heightParam;
    }

    public Dimension compute(int n, int n2, int n3, int n4) {
        double d;
        double d2;
        if (n < 0) {
            String string = Logging.getMessage("generic.InvalidWidth", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.InvalidHeight", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n3 < 0) {
            String string = Logging.getMessage("generic.InvalidWidth", n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n4 < 0) {
            String string = Logging.getMessage("generic.InvalidHeight", n4);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d3 = n2 != 0 ? (double)n / (double)n2 : 0.0;
        String string = this.getWidthMode();
        String string2 = this.getHeightMode();
        if (NATIVE_DIMENSION.equals(string) && NATIVE_DIMENSION.equals(string2) || NATIVE_DIMENSION.equals(string) && MAINTAIN_ASPECT_RATIO.equals(string2) || MAINTAIN_ASPECT_RATIO.equals(string) && NATIVE_DIMENSION.equals(string2) || MAINTAIN_ASPECT_RATIO.equals(string) && MAINTAIN_ASPECT_RATIO.equals(string2)) {
            d2 = n;
            d = n2;
        } else if (MAINTAIN_ASPECT_RATIO.equals(string)) {
            d = this.computeSize(this.heightParam, this.heightUnits, n4);
            d2 = d * d3;
        } else if (MAINTAIN_ASPECT_RATIO.equals(string2)) {
            d2 = this.computeSize(this.widthParam, this.widthUnits, n3);
            d = d3 != 0.0 ? d2 / d3 : 0.0;
        } else {
            d2 = NATIVE_DIMENSION.equals(string) ? (double)n : this.computeSize(this.widthParam, this.widthUnits, n3);
            d = NATIVE_DIMENSION.equals(string2) ? (double)n2 : this.computeSize(this.heightParam, this.heightUnits, n4);
        }
        return new Dimension((int)d2, (int)d);
    }

    protected double computeSize(double d, String string, double d2) {
        if ("gov.nasa.worldwind.avkey.Fraction".equals(string)) {
            return d * d2;
        }
        return d;
    }

    public void getRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (restorableSupport == null) {
            String string = Logging.getMessage("nullValue.RestorableSupportIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, "width");
        if (stateObject2 != null) {
            restorableSupport.addStateValueAsString(stateObject2, "mode", this.getWidthMode());
            restorableSupport.addStateValueAsDouble(stateObject2, "param", this.getWidth());
            if (this.getWidthUnits() != null) {
                restorableSupport.addStateValueAsString(stateObject2, "units", this.getWidthUnits());
            }
        }
        if ((stateObject2 = restorableSupport.addStateObject(stateObject, "height")) != null) {
            restorableSupport.addStateValueAsString(stateObject2, "mode", this.getHeightMode());
            restorableSupport.addStateValueAsDouble(stateObject2, "param", this.getHeight());
            if (this.getHeightUnits() != null) {
                restorableSupport.addStateValueAsString(stateObject2, "units", this.getHeightUnits());
            }
        }
    }

    public void restoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        String string;
        Double d;
        String string2;
        if (restorableSupport == null) {
            String string3 = Logging.getMessage("nullValue.RestorableSupportIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        RestorableSupport.StateObject stateObject2 = restorableSupport.getStateObject(stateObject, "width");
        if (stateObject2 != null) {
            string2 = restorableSupport.getStateValueAsString(stateObject2, "mode");
            string2 = this.convertLegacyModeString(string2);
            d = restorableSupport.getStateValueAsDouble(stateObject2, "param");
            string = restorableSupport.getStateValueAsString(stateObject2, "units");
            if (string2 != null && d != null) {
                this.setWidth(string2, d, string);
            }
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "height")) != null) {
            string2 = restorableSupport.getStateValueAsString(stateObject2, "mode");
            string2 = this.convertLegacyModeString(string2);
            d = restorableSupport.getStateValueAsDouble(stateObject2, "param");
            string = restorableSupport.getStateValueAsString(stateObject2, "units");
            if (string2 != null && d != null) {
                this.setHeight(string2, d, string);
            }
        }
    }

    protected String convertLegacyModeString(String string) {
        if ("NativeDimension".equals(string)) {
            return NATIVE_DIMENSION;
        }
        if ("MaintainAspectRatio".equals(string)) {
            return MAINTAIN_ASPECT_RATIO;
        }
        if ("ExplicitDimension".equals(string)) {
            return EXPLICIT_DIMENSION;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Size size = (Size)object;
        if (Double.compare(this.widthParam, size.widthParam) != 0) {
            return false;
        }
        if (Double.compare(this.heightParam, size.heightParam) != 0) {
            return false;
        }
        if (this.widthUnits != null ? !this.widthUnits.equals(size.widthUnits) : size.widthUnits != null) {
            return false;
        }
        if (this.heightUnits != null ? !this.heightUnits.equals(size.heightUnits) : size.heightUnits != null) {
            return false;
        }
        if (this.widthMode != null ? !this.widthMode.equals(size.widthMode) : size.widthMode != null) {
            return false;
        }
        return !(this.heightMode != null ? !this.heightMode.equals(size.heightMode) : size.heightMode != null);
    }

    public int hashCode() {
        long l = this.widthParam != 0.0 ? Double.doubleToLongBits(this.widthParam) : 0L;
        int n = (int)(l ^ l >>> 32);
        l = this.heightParam != 0.0 ? Double.doubleToLongBits(this.heightParam) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.widthUnits != null ? this.widthUnits.hashCode() : 0);
        n = 31 * n + (this.heightUnits != null ? this.heightUnits.hashCode() : 0);
        n = 31 * n + (this.widthMode != null ? this.widthMode.hashCode() : 0);
        n = 31 * n + (this.heightMode != null ? this.heightMode.hashCode() : 0);
        return n;
    }
}

